/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.config;

import de.trustable.ca3s.core.security.AuthenticationProviderWrapper;
import de.trustable.ca3s.core.security.DomainUserDetailsService;
import de.trustable.ca3s.core.security.jwt.JWTConfigurer;
import de.trustable.ca3s.core.security.jwt.TokenProvider;
import javax.annotation.Nonnull;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.header.writers.ReferrerPolicyHeaderWriter;
import org.springframework.security.web.util.matcher.AndRequestMatcher;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.filter.CorsFilter;
import org.zalando.problem.spring.web.advice.security.SecurityProblemSupport;

@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true, securedEnabled=true)
@Import(value={SecurityProblemSupport.class})
@Order(value=2)
public class SecurityConfiguration
extends WebSecurityConfigurerAdapter {
    private final Logger LOG = LoggerFactory.getLogger(SecurityConfiguration.class);
    @Value(value="${server.port:8080}")
    int httpPort;
    @Value(value="${ca3s.tlsAccess.port:0}")
    int tlsPort;
    @Value(value="${ca3s.adminAccess.port:0}")
    int adminPort;
    @Value(value="${ca3s.raAccess.port:0}")
    int raPort;
    @Value(value="${ca3s.acmeAccess.port:0}")
    int acmePort;
    @Value(value="${ca3s.scepAccess.port:0}")
    int scepPort;
    private final TokenProvider tokenProvider;
    private final CorsFilter corsFilter;
    private final SecurityProblemSupport problemSupport;
    private final DomainUserDetailsService userDetailsService;

    public SecurityConfiguration(TokenProvider tokenProvider, CorsFilter corsFilter, SecurityProblemSupport problemSupport, DomainUserDetailsService userDetailsService) {
        this.tokenProvider = tokenProvider;
        this.corsFilter = corsFilter;
        this.problemSupport = problemSupport;
        this.userDetailsService = userDetailsService;
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    @Bean
    public AuthenticationProvider daoAuthenticationProvider() {
        this.LOG.info("SecurityConfiguration daoAuthenticationProvider()");
        DaoAuthenticationProvider daoAuthenticationProvider = new DaoAuthenticationProvider();
        daoAuthenticationProvider.setPasswordEncoder(this.passwordEncoder());
        daoAuthenticationProvider.setUserDetailsService((UserDetailsService)this.userDetailsService);
        return new AuthenticationProviderWrapper((AuthenticationProvider)daoAuthenticationProvider);
    }

    public void configure(WebSecurity web) {
        ((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)web.ignoring().antMatchers(HttpMethod.OPTIONS, new String[]{"/**"})).antMatchers(new String[]{"/app/**/*.{js,html}"})).antMatchers(new String[]{"/images/*.{jpg,png}"})).antMatchers(new String[]{"/css/*.css"})).antMatchers(new String[]{"/i18n/**"})).antMatchers(new String[]{"/content/**"})).antMatchers(new String[]{"/h2-console/**"})).antMatchers(new String[]{"/swagger-ui/index.html"})).antMatchers(new String[]{"/test/**"});
    }

    public void configure(HttpSecurity http) throws Exception {
        this.LOG.info("SecurityConfiguration.configure ");
        if (this.scepPort == 0) {
            this.scepPort = this.httpPort;
        }
        if (this.adminPort == 0) {
            this.adminPort = this.tlsPort;
        }
        if (this.raPort == 0) {
            this.raPort = this.tlsPort;
        }
        if (this.acmePort == 0) {
            this.acmePort = this.tlsPort;
        }
        ((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.csrf().disable()).addFilterBefore((Filter)this.corsFilter, UsernamePasswordAuthenticationFilter.class).exceptionHandling().accessDeniedHandler((AccessDeniedHandler)this.problemSupport).and()).headers().contentSecurityPolicy("default-src 'self'; frame-src 'self' data:; script-src 'self' 'unsafe-inline' 'unsafe-eval' https://storage.googleapis.com; style-src 'self' 'unsafe-inline'; img-src 'self' data:; font-src 'self' data:; connect-src 'self' data:").and().referrerPolicy(ReferrerPolicyHeaderWriter.ReferrerPolicy.STRICT_ORIGIN_WHEN_CROSS_ORIGIN).and().featurePolicy("geolocation 'none'; midi 'none'; sync-xhr 'none'; microphone 'none'; camera 'none'; magnetometer 'none'; gyroscope 'none'; speaker 'none'; fullscreen 'self'; payment 'none'").and().frameOptions().deny().and()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).authorizeRequests().antMatchers(new String[]{"/api/authenticate"})).permitAll().antMatchers(new String[]{"/api/register"})).permitAll().antMatchers(new String[]{"/api/activate"})).permitAll().antMatchers(new String[]{"/api/account/reset-password/init"})).permitAll().antMatchers(new String[]{"/api/account/reset-password/finish"})).permitAll().antMatchers(new String[]{"/api/profile-info"})).permitAll().antMatchers(new String[]{"/publicapi/**"})).permitAll().requestMatchers(new RequestMatcher[]{this.forPortAndPath(this.raPort, "/api/administerRequest")})).hasAuthority("ROLE_RA").antMatchers(new String[]{"/api/administerRequest"})).denyAll().requestMatchers(new RequestMatcher[]{this.forPortAndPath(this.raPort, "/api/administerCertificate")})).hasAuthority("ROLE_RA").antMatchers(new String[]{"/api/administerCertificate"})).denyAll().requestMatchers(new RequestMatcher[]{this.forPortAndPath(this.acmePort, "/acme/**")})).permitAll().antMatchers(new String[]{"/acme/**"})).denyAll().requestMatchers(new RequestMatcher[]{this.forPortAndPath(this.scepPort, "/ca3sScep/**")})).permitAll().antMatchers(new String[]{"/ca3sScep/**"})).denyAll().antMatchers(new String[]{"/api/admin/**"})).permitAll().antMatchers(new String[]{"/api/cockpit/**"})).permitAll().antMatchers(new String[]{"/api/tasklist/**"})).permitAll().antMatchers(new String[]{"/api/engine/**"})).permitAll().antMatchers(new String[]{"/api/executeProcess/**"})).permitAll().antMatchers(new String[]{"/websocket/tracker"})).hasAuthority("ROLE_ADMIN").antMatchers(new String[]{"/websocket/**"})).permitAll().antMatchers(new String[]{"/management/loggers"})).permitAll().antMatchers(new String[]{"/management/audits"})).permitAll().antMatchers(new String[]{"/management/health"})).permitAll().antMatchers(new String[]{"/management/info"})).permitAll().antMatchers(new String[]{"/management/prometheus"})).permitAll().requestMatchers(new RequestMatcher[]{this.forPortAndPath(this.adminPort, "/api/notification/**")})).hasAuthority("ROLE_ADMIN").antMatchers(new String[]{"/api/notification/**"})).denyAll().requestMatchers(new RequestMatcher[]{this.forPortAndPath(this.adminPort, "/management/**")})).hasAuthority("ROLE_ADMIN").antMatchers(new String[]{"/management/**"})).denyAll().and()).httpBasic().and()).apply((SecurityConfigurerAdapter)this.securityConfigurerAdapter());
    }

    private JWTConfigurer securityConfigurerAdapter() {
        return new JWTConfigurer(this.tokenProvider);
    }

    private RequestMatcher forPortAndPath(int port, @Nonnull String pathPattern) {
        return new AndRequestMatcher(new RequestMatcher[]{this.forPort(port), new AntPathRequestMatcher(pathPattern)});
    }

    private RequestMatcher forPort(int port) {
        return request -> {
            boolean result = port == 0 || port == request.getLocalPort();
            this.LOG.debug("checking local port {} against target port {} evaluates to {}", new Object[]{request.getLocalPort(), port, result});
            return result;
        };
    }
}

