/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.repository;

import de.trustable.ca3s.core.domain.User;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Repository;

@Repository
public interface UserRepository
extends JpaRepository<User, Long> {
    public static final String USERS_BY_LOGIN_CACHE = "usersByLogin";
    public static final String USERS_BY_EMAIL_CACHE = "usersByEmail";

    public Optional<User> findOneByActivationKey(String var1);

    public List<User> findAllByActivatedIsFalseAndActivationKeyIsNotNullAndCreatedDateBefore(Instant var1);

    public Optional<User> findOneByResetKey(String var1);

    public Optional<User> findOneByEmailIgnoreCase(String var1);

    public Optional<User> findOneByLogin(String var1);

    @EntityGraph(attributePaths={"authorities"})
    public Optional<User> findOneWithAuthoritiesById(Long var1);

    @Cacheable(cacheNames={"usersByLogin"})
    @EntityGraph(attributePaths={"authorities"})
    public Optional<User> findOneWithAuthoritiesByLogin(String var1);

    @Cacheable(cacheNames={"usersByEmail"})
    @EntityGraph(attributePaths={"authorities"})
    public Optional<User> findOneWithAuthoritiesByEmailIgnoreCase(String var1);

    public Page<User> findAllByLoginNot(Pageable var1, String var2);
}

