/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.security.provider;

import de.trustable.ca3s.cert.bundle.BundleFactory;
import de.trustable.ca3s.cert.bundle.KeyCertBundle;
import de.trustable.ca3s.core.domain.CAConnectorConfig;
import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.service.util.CaConnectorAdapter;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import de.trustable.util.CryptoUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ca3sBundleFactory
implements BundleFactory {
    private static final Logger LOG = LoggerFactory.getLogger(Ca3sBundleFactory.class);
    private final CAConnectorConfig caConfigDao;
    private final CaConnectorAdapter cacAdapt;
    private final CertificateUtil certUtil;
    private final String dnSuffix;
    private final String sans;

    public Ca3sBundleFactory(CAConnectorConfig caConfigDao, CaConnectorAdapter cacAdapt, CertificateUtil certUtil, String dnSuffix, String sans) {
        this.caConfigDao = caConfigDao;
        this.cacAdapt = cacAdapt;
        this.certUtil = certUtil;
        this.dnSuffix = dnSuffix;
        this.sans = sans;
    }

    public KeyCertBundle newKeyBundle(String bundleName, long minValiditySeconds) throws GeneralSecurityException {
        KeyPair localKeyPair = KeyPairGenerator.getInstance("RSA").generateKeyPair();
        try {
            InetAddress ip = InetAddress.getLocalHost();
            String hostname = ip.getCanonicalHostName();
            String x500Name = "CN=" + hostname;
            if (!this.dnSuffix.trim().isEmpty()) {
                x500Name = x500Name + ", " + this.dnSuffix;
            }
            X500Principal subject = new X500Principal(x500Name);
            LOG.debug("requesting certificate for subject : " + subject.getName());
            GeneralName[] sanArray = CertificateUtil.splitSANString((String)this.sans, (String)hostname);
            ArrayList extensions = new ArrayList();
            HashMap<String, Object> serverAuthMap = new HashMap<String, Object>();
            serverAuthMap.put("oid", Extension.extendedKeyUsage.getId());
            serverAuthMap.put("critical", Boolean.FALSE);
            ArrayList<String> valList = new ArrayList<String>();
            valList.add(KeyPurposeId.id_kp_serverAuth.getId());
            serverAuthMap.put("value", valList);
            extensions.add(serverAuthMap);
            PKCS10CertificationRequest req = CryptoUtil.getCsr((X500Principal)subject, (PublicKey)localKeyPair.getPublic(), (PrivateKey)localKeyPair.getPrivate(), null, extensions, (GeneralName[])sanArray);
            String csrBase64 = CryptoUtil.pkcs10RequestToPem((PKCS10CertificationRequest)req);
            Certificate cert = this.cacAdapt.signCertificateRequest(csrBase64, this.caConfigDao);
            X509Certificate[] certificateChain = this.certUtil.getX509CertificateChain(cert);
            LOG.debug("returning new certificate : " + certificateChain[0]);
            return new KeyCertBundle(bundleName, certificateChain, certificateChain[0], (Key)localKeyPair.getPrivate());
        }
        catch (IOException e) {
            throw new GeneralSecurityException(e);
        }
    }
}

