/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.dto.acme;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.trustable.ca3s.core.domain.ACMEAccount;
import de.trustable.ca3s.core.domain.AcmeContact;
import de.trustable.ca3s.core.domain.enumeration.AccountStatus;
import javax.annotation.concurrent.Immutable;
import javax.persistence.Transient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public class AccountResponse {
    @Transient
    transient Logger logger = LoggerFactory.getLogger(AccountResponse.class);
    @JsonProperty(value="id")
    private long id;
    @JsonProperty(value="status")
    private AccountStatus status;
    @JsonProperty(value="contact")
    private String[] contacts;
    @JsonProperty(value="termsOfServiceAgreed")
    private boolean termsAgreed = false;
    @JsonProperty(value="orders")
    private String orders;

    public AccountResponse(ACMEAccount accountDao) {
        this.setId(accountDao.getAccountId().longValue());
        this.setStatus(accountDao.getStatus());
        String[] contacts = new String[accountDao.getContacts().size()];
        int i = 0;
        for (AcmeContact contactDao : accountDao.getContacts()) {
            contacts[i++] = contactDao.getContactUrl();
        }
        this.setContacts(contacts);
        this.setTermsAgreed(accountDao.isTermsOfServiceAgreed().booleanValue());
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public AccountStatus getStatus() {
        return this.status;
    }

    public void setStatus(AccountStatus status) {
        this.status = status;
    }

    public String[] getContacts() {
        return this.contacts;
    }

    public void setContacts(String[] contacts) {
        this.contacts = contacts;
    }

    public boolean isTermsAgreed() {
        return this.termsAgreed;
    }

    public void setTermsAgreed(boolean termsAgreed) {
        this.termsAgreed = termsAgreed;
    }

    public String getOrders() {
        return this.orders;
    }

    public void setOrders(String orders) {
        this.orders = orders;
    }
}

