/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.util;

import de.trustable.ca3s.core.service.util.NameAndRole;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service
public class NameAndRoleUtil {
    private final Logger log = LoggerFactory.getLogger(NameAndRoleUtil.class);

    public NameAndRole getNameAndRole() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth != null) {
            String role = this.getRole(auth);
            return new NameAndRole(auth.getName(), role);
        }
        return new NameAndRole("System", "System");
    }

    String getRole(Authentication auth) {
        this.log.debug("Authorities #{} present", (Object)auth.getAuthorities().size());
        if (auth.getAuthorities().stream().anyMatch(a -> a.getAuthority().equals("ROLE_ADMIN"))) {
            return "ADMIN";
        }
        if (auth.getAuthorities().stream().anyMatch(a -> a.getAuthority().equals("ROLE_RA"))) {
            return "RA";
        }
        if (auth.getAuthorities().stream().anyMatch(a -> a.getAuthority().equals("ROLE_USER"))) {
            return "USER";
        }
        for (GrantedAuthority ga : auth.getAuthorities()) {
            this.log.debug("Authority: {}", (Object)ga.getAuthority());
        }
        return "ANON";
    }
}

