/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.core.domain.BPMNProcessInfo;
import de.trustable.ca3s.core.service.BPMNProcessInfoService;
import de.trustable.ca3s.core.web.rest.errors.BadRequestAlertException;
import io.github.jhipster.web.util.HeaderUtil;
import io.github.jhipster.web.util.ResponseUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class BPMNProcessInfoResource {
    private final Logger log = LoggerFactory.getLogger(BPMNProcessInfoResource.class);
    private static final String ENTITY_NAME = "bPMNProcessInfo";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final BPMNProcessInfoService bPMNProcessInfoService;

    public BPMNProcessInfoResource(BPMNProcessInfoService bPMNProcessInfoService) {
        this.bPMNProcessInfoService = bPMNProcessInfoService;
    }

    @PostMapping(value={"/bpmn-process-infos"})
    public ResponseEntity<BPMNProcessInfo> createBPMNProcessInfo(@Valid @RequestBody BPMNProcessInfo bPMNProcessInfo) throws URISyntaxException {
        this.log.debug("REST request to save BPMNProcessInfo : {}", (Object)bPMNProcessInfo);
        if (bPMNProcessInfo.getId() != null) {
            throw new BadRequestAlertException("A new bPMNProcessInfo cannot already have an ID", ENTITY_NAME, "idexists");
        }
        BPMNProcessInfo result = this.bPMNProcessInfoService.save(bPMNProcessInfo);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/bpmn-process-infos/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/bpmn-process-infos"})
    public ResponseEntity<BPMNProcessInfo> updateBPMNProcessInfo(@Valid @RequestBody BPMNProcessInfo bPMNProcessInfo) throws URISyntaxException {
        this.log.debug("REST request to update BPMNProcessInfo : {}", (Object)bPMNProcessInfo);
        if (bPMNProcessInfo.getId() == null) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        BPMNProcessInfo result = this.bPMNProcessInfoService.save(bPMNProcessInfo);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)bPMNProcessInfo.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/bpmn-process-infos"})
    public List<BPMNProcessInfo> getAllBPMNProcessInfos() {
        this.log.debug("REST request to get all BPMNProcessInfos");
        return this.bPMNProcessInfoService.findAll();
    }

    @GetMapping(value={"/bpmn-process-infos/{id}"})
    public ResponseEntity<BPMNProcessInfo> getBPMNProcessInfo(@PathVariable Long id) {
        this.log.debug("REST request to get BPMNProcessInfo : {}", (Object)id);
        Optional bPMNProcessInfo = this.bPMNProcessInfoService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)bPMNProcessInfo);
    }

    @DeleteMapping(value={"/bpmn-process-infos/{id}"})
    public ResponseEntity<Void> deleteBPMNProcessInfo(@PathVariable Long id) {
        this.log.debug("REST request to delete BPMNProcessInfo : {}", (Object)id);
        this.bPMNProcessInfoService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }
}

