/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.repository.AuditTraceRepository;
import de.trustable.ca3s.core.service.CertificateService;
import de.trustable.ca3s.core.service.dto.CertificateView;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class CertificateViewResource {
    private final Logger log = LoggerFactory.getLogger(CertificateViewResource.class);
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final CertificateService certificateService;
    private final AuditTraceRepository auditTraceRepository;

    public CertificateViewResource(CertificateService certificateService, AuditTraceRepository auditTraceRepository) {
        this.certificateService = certificateService;
        this.auditTraceRepository = auditTraceRepository;
    }

    @GetMapping(value={"/certificateViews/{id}"})
    public ResponseEntity<CertificateView> getCertificate(@PathVariable Long id) {
        this.log.debug("REST request to get CertificateView : {}", (Object)id);
        Optional certificateOpt = this.certificateService.findOne(id);
        if (certificateOpt.isPresent()) {
            Certificate cert = (Certificate)certificateOpt.get();
            CertificateView certView = new CertificateView(cert);
            certView.setAuditPresent(Boolean.valueOf(!this.auditTraceRepository.findByCsrAndCert(cert, cert.getCsr()).isEmpty()));
            return new ResponseEntity((Object)certView, HttpStatus.OK);
        }
        return ResponseEntity.notFound().build();
    }
}

