/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.core.domain.RDNAttribute;
import de.trustable.ca3s.core.service.RDNAttributeService;
import de.trustable.ca3s.core.web.rest.errors.BadRequestAlertException;
import io.github.jhipster.web.util.HeaderUtil;
import io.github.jhipster.web.util.ResponseUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class RDNAttributeResource {
    private final Logger log = LoggerFactory.getLogger(RDNAttributeResource.class);
    private static final String ENTITY_NAME = "rDNAttribute";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final RDNAttributeService rDNAttributeService;

    public RDNAttributeResource(RDNAttributeService rDNAttributeService) {
        this.rDNAttributeService = rDNAttributeService;
    }

    @PostMapping(value={"/rdn-attributes"})
    public ResponseEntity<RDNAttribute> createRDNAttribute(@Valid @RequestBody RDNAttribute rDNAttribute) throws URISyntaxException {
        this.log.debug("REST request to save RDNAttribute : {}", (Object)rDNAttribute);
        if (rDNAttribute.getId() != null) {
            throw new BadRequestAlertException("A new rDNAttribute cannot already have an ID", ENTITY_NAME, "idexists");
        }
        RDNAttribute result = this.rDNAttributeService.save(rDNAttribute);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/rdn-attributes/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/rdn-attributes"})
    public ResponseEntity<RDNAttribute> updateRDNAttribute(@Valid @RequestBody RDNAttribute rDNAttribute) throws URISyntaxException {
        this.log.debug("REST request to update RDNAttribute : {}", (Object)rDNAttribute);
        if (rDNAttribute.getId() == null) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        RDNAttribute result = this.rDNAttributeService.save(rDNAttribute);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)rDNAttribute.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/rdn-attributes"})
    public List<RDNAttribute> getAllRDNAttributes() {
        this.log.debug("REST request to get all RDNAttributes");
        return this.rDNAttributeService.findAll();
    }

    @GetMapping(value={"/rdn-attributes/{id}"})
    public ResponseEntity<RDNAttribute> getRDNAttribute(@PathVariable Long id) {
        this.log.debug("REST request to get RDNAttribute : {}", (Object)id);
        Optional rDNAttribute = this.rDNAttributeService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)rDNAttribute);
    }

    @DeleteMapping(value={"/rdn-attributes/{id}"})
    public ResponseEntity<Void> deleteRDNAttribute(@PathVariable Long id) {
        this.log.debug("REST request to delete RDNAttribute : {}", (Object)id);
        this.rDNAttributeService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }
}

