/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.core.domain.User;
import de.trustable.ca3s.core.repository.UserRepository;
import de.trustable.ca3s.core.service.MailService;
import de.trustable.ca3s.core.service.UserService;
import de.trustable.ca3s.core.service.dto.UserDTO;
import de.trustable.ca3s.core.web.rest.errors.BadRequestAlertException;
import de.trustable.ca3s.core.web.rest.errors.EmailAlreadyUsedException;
import de.trustable.ca3s.core.web.rest.errors.LoginAlreadyUsedException;
import io.github.jhipster.web.util.HeaderUtil;
import io.github.jhipster.web.util.PaginationUtil;
import io.github.jhipster.web.util.ResponseUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import javax.mail.MessagingException;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/api"})
public class UserResource {
    private final Logger log = LoggerFactory.getLogger(UserResource.class);
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final UserService userService;
    private final UserRepository userRepository;
    private final MailService mailService;

    public UserResource(UserService userService, UserRepository userRepository, MailService mailService) {
        this.userService = userService;
        this.userRepository = userRepository;
        this.mailService = mailService;
    }

    @PostMapping(value={"/users"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public ResponseEntity<User> createUser(@Valid @RequestBody UserDTO userDTO) throws URISyntaxException, MessagingException {
        this.log.debug("REST request to save User : {}", (Object)userDTO);
        if (userDTO.getId() != null) {
            throw new BadRequestAlertException("A new user cannot already have an ID", "userManagement", "idexists");
        }
        if (this.userRepository.findOneByLogin(userDTO.getLogin().toLowerCase()).isPresent()) {
            throw new LoginAlreadyUsedException();
        }
        if (this.userRepository.findOneByEmailIgnoreCase(userDTO.getEmail()).isPresent()) {
            throw new EmailAlreadyUsedException();
        }
        User newUser = this.userService.createUser(userDTO);
        this.mailService.sendCreationEmail(newUser);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/users/" + newUser.getLogin())).headers(HeaderUtil.createAlert((String)this.applicationName, (String)"userManagement.created", (String)newUser.getLogin()))).body((Object)newUser);
    }

    @PutMapping(value={"/users"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public ResponseEntity<UserDTO> updateUser(@Valid @RequestBody UserDTO userDTO) {
        this.log.debug("REST request to update User : {}", (Object)userDTO);
        Optional existingUser = this.userRepository.findOneByEmailIgnoreCase(userDTO.getEmail());
        if (existingUser.isPresent() && !((User)existingUser.get()).getId().equals(userDTO.getId())) {
            throw new EmailAlreadyUsedException();
        }
        existingUser = this.userRepository.findOneByLogin(userDTO.getLogin().toLowerCase());
        if (existingUser.isPresent() && !((User)existingUser.get()).getId().equals(userDTO.getId())) {
            throw new LoginAlreadyUsedException();
        }
        Optional updatedUser = this.userService.updateUser(userDTO);
        return ResponseUtil.wrapOrNotFound((Optional)updatedUser, (HttpHeaders)HeaderUtil.createAlert((String)this.applicationName, (String)"userManagement.updated", (String)userDTO.getLogin()));
    }

    @GetMapping(value={"/users"})
    public ResponseEntity<List<UserDTO>> getAllUsers(Pageable pageable) {
        Page page = this.userService.getAllManagedUsers(pageable);
        HttpHeaders headers = PaginationUtil.generatePaginationHttpHeaders((UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequest(), (Page)page);
        return new ResponseEntity((Object)page.getContent(), (MultiValueMap)headers, HttpStatus.OK);
    }

    @GetMapping(value={"/users/authorities"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public List<String> getAuthorities() {
        return this.userService.getAuthorities();
    }

    @GetMapping(value={"/users/{login:^[_.@A-Za-z0-9-]*$}"})
    public ResponseEntity<UserDTO> getUser(@PathVariable String login) {
        this.log.debug("REST request to get User : {}", (Object)login);
        return ResponseUtil.wrapOrNotFound(this.userService.getUserWithAuthoritiesByLogin(login).map(UserDTO::new));
    }

    @DeleteMapping(value={"/users/{login:^[_.@A-Za-z0-9-]*$}"})
    @PreAuthorize(value="hasRole(\"ROLE_ADMIN\")")
    public ResponseEntity<Void> deleteUser(@PathVariable String login) {
        this.log.debug("REST request to delete User: {}", (Object)login);
        this.userService.deleteUser(login);
        return ResponseEntity.noContent().headers(HeaderUtil.createAlert((String)this.applicationName, (String)"userManagement.deleted", (String)login)).build();
    }
}

