/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest.data;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.trustable.ca3s.core.service.util.CSRUtil;
import de.trustable.util.Pkcs10RequestHolder;
import java.util.Set;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.x509.GeneralName;

public class Pkcs10RequestHolderShallow {
    @JsonProperty(value="signingAlgorithmName")
    private String signingAlgorithmName;
    @JsonProperty(value="isCSRValid")
    private boolean isCSRValid;
    @JsonProperty(value="x509KeySpec")
    private String x509KeySpec;
    @JsonProperty(value="sans")
    private String[] sans;
    @JsonProperty(value="subject")
    private String subject;
    @JsonProperty(value="publicKeyAlgorithmName")
    private String publicKeyAlgorithmName;

    public Pkcs10RequestHolderShallow(Pkcs10RequestHolder p10ReqHolder) {
        this.signingAlgorithmName = p10ReqHolder.getSigningAlgorithmName();
        this.isCSRValid = p10ReqHolder.isCSRValid();
        this.x509KeySpec = p10ReqHolder.getX509KeySpec();
        this.subject = p10ReqHolder.getSubject();
        this.publicKeyAlgorithmName = p10ReqHolder.getPublicKeyAlgorithm();
        Set sanSet = CSRUtil.getSANList((Attribute[])p10ReqHolder.getReqAttributes());
        this.sans = new String[sanSet.size()];
        int i = 0;
        for (GeneralName gn : sanSet) {
            this.sans[i++] = CSRUtil.getGeneralNameDescription((GeneralName)gn);
        }
    }

    public String getSigningAlgorithmName() {
        return this.signingAlgorithmName;
    }

    public boolean isCSRValid() {
        return this.isCSRValid;
    }

    public String getX509KeySpec() {
        return this.x509KeySpec;
    }

    public String[] getSans() {
        return this.sans;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getPublicKeyAlgorithmName() {
        return this.publicKeyAlgorithmName;
    }
}

