/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest.support;

import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.domain.Pipeline;
import de.trustable.ca3s.core.domain.enumeration.ContentRelationType;
import de.trustable.ca3s.core.domain.enumeration.CsrUsage;
import de.trustable.ca3s.core.domain.enumeration.ProtectedContentType;
import de.trustable.ca3s.core.repository.CSRRepository;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.repository.PipelineRepository;
import de.trustable.ca3s.core.service.AuditService;
import de.trustable.ca3s.core.service.dto.NamedValues;
import de.trustable.ca3s.core.service.dto.PipelineView;
import de.trustable.ca3s.core.service.dto.Preferences;
import de.trustable.ca3s.core.service.util.CertificateProcessingUtil;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import de.trustable.ca3s.core.service.util.PipelineUtil;
import de.trustable.ca3s.core.service.util.PreferenceUtil;
import de.trustable.ca3s.core.service.util.ProtectedContentUtil;
import de.trustable.ca3s.core.web.rest.data.CreationMode;
import de.trustable.ca3s.core.web.rest.data.KeyAlgoLength;
import de.trustable.ca3s.core.web.rest.data.PKCSDataType;
import de.trustable.ca3s.core.web.rest.data.Pkcs10RequestHolderShallow;
import de.trustable.ca3s.core.web.rest.data.PkcsXXData;
import de.trustable.ca3s.core.web.rest.data.UploadPrecheckData;
import de.trustable.ca3s.core.web.rest.data.X509CertificateHolderShallow;
import de.trustable.util.CryptoUtil;
import de.trustable.util.Pkcs10RequestHolder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECKey;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.ExtensionsGenerator;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.DecoderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class ContentUploadProcessor {
    private final Logger LOG = LoggerFactory.getLogger(ContentUploadProcessor.class);
    @Autowired
    private CryptoUtil cryptoUtil;
    @Autowired
    private ProtectedContentUtil protUtil;
    @Autowired
    private CertificateUtil certUtil;
    @Autowired
    private CSRRepository csrRepository;
    @Autowired
    private CertificateRepository certificateRepository;
    @Autowired
    private PipelineRepository pipelineRepository;
    @Autowired
    private PipelineUtil pipelineUtil;
    @Autowired
    private PreferenceUtil preferenceUtil;
    @Autowired
    private CertificateProcessingUtil cpUtil;
    @Autowired
    private AuditService auditService;
    private static final String SIGNATURE_ALG = "SHA256withRSA";
    private static final String EC_SIGNATURE_ALG = "SHA256withECDSA";
    static HashMap<String, ASN1ObjectIdentifier> nameOIDMap = new HashMap();
    static HashMap<String, Integer> nameGeneralNameMap = new HashMap();

    @PostMapping(value={"/uploadContent"})
    @Transactional
    public ResponseEntity<PkcsXXData> uploadContent(@Valid @RequestBody UploadPrecheckData uploaded) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        String requestorName = auth.getName();
        CreationMode creationMode = uploaded.getCreationMode();
        if (CreationMode.COMMANDLINE_TOOL.equals((Object)creationMode)) {
            this.LOG.debug("not supported creation mode {}, requested by user '{}' ", (Object)creationMode, (Object)requestorName);
        } else {
            if (CreationMode.SERVERSIDE_KEY_CREATION.equals((Object)creationMode)) {
                Preferences prefs = this.preferenceUtil.getSystemPrefs();
                if (prefs.isServerSideKeyCreationAllowed()) {
                    return this.buildServerSideKeyAndRequest(uploaded, requestorName);
                }
                this.LOG.warn("creating serverside csr not allowed! Requested by user '{}'", (Object)requestorName);
                return new ResponseEntity(HttpStatus.BAD_REQUEST);
            }
            if (CreationMode.CSR_AVAILABLE.equals((Object)creationMode)) {
                return this.buildCertificateFromCSR(uploaded, requestorName);
            }
        }
        return new ResponseEntity(HttpStatus.BAD_REQUEST);
    }

    private ResponseEntity<PkcsXXData> buildCertificateFromCSR(UploadPrecheckData uploaded, String requestorName) {
        String content = uploaded.getContent();
        this.LOG.debug("Request to upload a PEM clob : {} by user {}", (Object)content, (Object)requestorName);
        PkcsXXData p10ReqData = new PkcsXXData();
        try {
            try {
                CertificateFactory factory = CertificateFactory.getInstance("X.509");
                X509Certificate cert = (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(Base64.decode((String)content)));
                content = this.cryptoUtil.x509CertToPem(cert);
                this.LOG.debug("certificate parsed from base64 (non-pem) content");
            }
            catch (IOException | GeneralSecurityException | DecoderException gse) {
                this.LOG.debug("certificate parsing from base64 (non-pem) content failed: " + gse.getMessage());
            }
            X509CertificateHolder certHolder = this.cryptoUtil.convertPemToCertificateHolder(content);
            List certList = this.findCertificateByIssuerSerial(certHolder);
            if (!certList.isEmpty()) {
                this.LOG.info("certificate already present");
                return new ResponseEntity(HttpStatus.CONFLICT);
            }
            Certificate cert = this.insertCertificate(content, requestorName);
            p10ReqData = new PkcsXXData(certHolder, content, true);
            this.certUtil.setCertAttribute(cert, "REQUESTOR_NAME", requestorName);
            return new ResponseEntity((Object)p10ReqData, HttpStatus.CREATED);
        }
        catch (DecoderException de) {
            p10ReqData.setDataType(PKCSDataType.UNKNOWN);
            this.LOG.debug("certificate parsing problem of uploaded content:" + de.getMessage());
        }
        catch (IOException | GeneralSecurityException e) {
            this.LOG.debug("not a certificate, trying to parse it as CSR ");
            try {
                Pkcs10RequestHolder p10ReqHolder = this.cryptoUtil.parseCertificateRequest(this.cryptoUtil.convertPemToPKCS10CertificationRequest(content));
                List csrList = this.csrRepository.findByPublicKeyHash(p10ReqHolder.getPublicKeyHash());
                this.LOG.debug("public key with hash '{}' used in #{} csrs, yet", (Object)p10ReqHolder.getPublicKeyHash(), (Object)csrList.size());
                Pkcs10RequestHolderShallow p10ReqHolderShallow = new Pkcs10RequestHolderShallow(p10ReqHolder);
                p10ReqData = new PkcsXXData(p10ReqHolderShallow);
                p10ReqData.setCsrPublicKeyPresentInDB(!csrList.isEmpty());
                if (csrList.isEmpty()) {
                    Certificate cert;
                    Optional optPipeline = this.pipelineRepository.findById((Object)uploaded.getPipelineId());
                    CSR csr = this.startCertificateCreationProcess(content, p10ReqData, requestorName, uploaded.getRequestorcomment(), uploaded.getArAttributes(), optPipeline);
                    if (csr != null && (cert = csr.getCertificate()) != null) {
                        X509CertificateHolder certHolder = this.cryptoUtil.convertPemToCertificateHolder(cert.getContent());
                        p10ReqData = new PkcsXXData(certHolder, cert);
                        return new ResponseEntity((Object)p10ReqData, HttpStatus.CREATED);
                    }
                }
            }
            catch (IOException | GeneralSecurityException e2) {
                this.LOG.debug("describeCSR : " + e2.getMessage());
                this.LOG.debug("not a certificate, not a CSR, trying to parse it as a P12 container");
                try {
                    KeyStore pkcs12Store = KeyStore.getInstance("PKCS12", "BC");
                    ByteArrayInputStream bais = new ByteArrayInputStream(Base64.decode((String)content));
                    char[] passphrase = new char[]{};
                    if (uploaded.getPassphrase() != null && uploaded.getPassphrase().trim().length() > 0) {
                        passphrase = uploaded.getPassphrase().toCharArray();
                    }
                    pkcs12Store.load(bais, passphrase);
                    this.LOG.debug("keystore loaded successfully!");
                    ArrayList<X509CertificateHolderShallow> certList = new ArrayList<X509CertificateHolderShallow>();
                    Enumeration<String> en = pkcs12Store.aliases();
                    while (en.hasMoreElements()) {
                        Certificate cert;
                        String alias = en.nextElement();
                        this.LOG.debug("iterating keystore, found alias {}, isCertificateEntry {}, isKeyEntry {}", new Object[]{alias, pkcs12Store.isCertificateEntry(alias), pkcs12Store.isKeyEntry(alias)});
                        if (!pkcs12Store.isCertificateEntry(alias) && !pkcs12Store.isKeyEntry(alias)) continue;
                        X509Certificate x509cert = (X509Certificate)pkcs12Store.getCertificate(alias);
                        if (x509cert == null) {
                            this.LOG.debug("alias {} does NOT refer to a certificate entry", (Object)alias);
                            continue;
                        }
                        this.LOG.debug("certificate {} found in PKCS12 for alias '{}'", (Object)x509cert.getSubjectDN().getName(), (Object)alias);
                        String b64Content = this.cryptoUtil.x509CertToPem(x509cert);
                        X509CertificateHolder certHolder = this.cryptoUtil.convertPemToCertificateHolder(b64Content);
                        X509CertificateHolderShallow x509Holder = new X509CertificateHolderShallow(certHolder);
                        x509Holder.setPemCertificate(b64Content);
                        List certListDB = this.findCertificateByIssuerSerial(certHolder);
                        this.LOG.debug("certListDB has # {} item", (Object)certListDB.size());
                        if (!certListDB.isEmpty()) {
                            cert = (Certificate)certListDB.get(0);
                            if (certListDB.size() > 1) {
                                this.LOG.info("problem: found more than one matching certificate for issuer {}, serial {}", (Object)certHolder.getIssuer().toString(), (Object)certHolder.getSerialNumber().toString());
                            }
                        } else {
                            cert = this.insertCertificate(b64Content, requestorName);
                        }
                        x509Holder.setCertificateId(cert.getId().longValue());
                        x509Holder.setCertificatePresentInDB(true);
                        if (pkcs12Store.isKeyEntry(alias)) {
                            Key key = pkcs12Store.getKey(alias, passphrase);
                            this.LOG.debug("key {} found alongside certificate in PKCS12 for alias {}", (Object)"*****", (Object)alias);
                            KeyPair keyPair = new KeyPair(x509cert.getPublicKey(), (PrivateKey)key);
                            this.certUtil.storePrivateKey(cert, keyPair);
                            x509Holder.setKeyPresent(true);
                            this.LOG.debug("key {} stored for certificate {}", (Object)"*****", (Object)cert.getId());
                        }
                        certList.add(x509Holder);
                    }
                    p10ReqData = new PkcsXXData();
                    X509CertificateHolderShallow[] chsArr = new X509CertificateHolderShallow[certList.size()];
                    certList.toArray(chsArr);
                    p10ReqData.setCertsHolder(chsArr);
                    p10ReqData.setDataType(PKCSDataType.CONTAINER);
                }
                catch (IOException ioe) {
                    p10ReqData.setPassphraseRequired(true);
                    p10ReqData.setDataType(PKCSDataType.CONTAINER_REQUIRING_PASSPHRASE);
                    this.LOG.debug("p12 missing a passphrase: " + ioe.getMessage());
                }
                catch (DecoderException de) {
                    p10ReqData.setDataType(PKCSDataType.UNKNOWN);
                    this.LOG.debug("p12 parsing problem of uploaded content: " + de.getMessage());
                }
                catch (GeneralSecurityException e3) {
                    this.LOG.debug("general problem with uploaded content: " + e3.getMessage());
                    return new ResponseEntity(HttpStatus.BAD_REQUEST);
                }
            }
        }
        return new ResponseEntity((Object)p10ReqData, HttpStatus.OK);
    }

    private ResponseEntity<PkcsXXData> buildServerSideKeyAndRequest(UploadPrecheckData uploaded, String requestorName) {
        try {
            PrivateKey pk;
            Optional optPipeline = this.pipelineRepository.findById((Object)uploaded.getPipelineId());
            KeyAlgoLength keyAlgoLength = uploaded.getKeyAlgoLength();
            KeyPair keypair = this.generateKeyPair(keyAlgoLength);
            NamedValues[] certAttr = uploaded.getCertificateAttributes();
            X500NameBuilder namebuilder = new X500NameBuilder(X500Name.getDefaultStyle());
            ArrayList<GeneralName> gnList = new ArrayList<GeneralName>();
            for (NamedValues nv : certAttr) {
                String name = nv.getName();
                if (nameOIDMap.containsKey(name)) {
                    String[] oid = (String[])nameOIDMap.get(name);
                    String[] stringArray = nv.getValues();
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String value = stringArray[i];
                        if (value == null || value.isEmpty()) continue;
                        namebuilder.addRDN((ASN1ObjectIdentifier)oid, value);
                    }
                    continue;
                }
                if ("SAN".equalsIgnoreCase(name)) {
                    for (String value : nv.getValues()) {
                        String content = value.trim();
                        if (content.isEmpty()) continue;
                        String[] sanParts = content.split(":");
                        if (sanParts.length == 1) {
                            gnList.add(new GeneralName(2, content));
                            continue;
                        }
                        if (sanParts.length > 1) {
                            if (nameGeneralNameMap.containsKey(sanParts[0].toUpperCase())) {
                                Integer type = (Integer)nameGeneralNameMap.get(sanParts[0].toUpperCase());
                                gnList.add(new GeneralName(type.intValue(), sanParts[1]));
                                continue;
                            }
                            this.LOG.warn("SAN certificate attribute has unknown type '{}'", (Object)sanParts[0]);
                            continue;
                        }
                        this.LOG.warn("unexpected SAN info value '{}'", (Object)value);
                    }
                    continue;
                }
                this.LOG.warn("certificate attribute '{}' unknown ", (Object)name);
            }
            JcaPKCS10CertificationRequestBuilder p10Builder = new JcaPKCS10CertificationRequestBuilder(namebuilder.build(), keypair.getPublic());
            if (!gnList.isEmpty()) {
                GeneralName[] gns = new GeneralName[gnList.size()];
                gnList.toArray(gns);
                GeneralNames subjectAltName = new GeneralNames(gns);
                ExtensionsGenerator extensionsGenerator = new ExtensionsGenerator();
                extensionsGenerator.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)subjectAltName);
                if (optPipeline.isPresent()) {
                    Pipeline p = (Pipeline)optPipeline.get();
                    PipelineView pv = this.pipelineUtil.from(p);
                    if (CsrUsage.TLS_SERVER.equals((Object)pv.getCsrUsage())) {
                        extensionsGenerator.addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(160));
                        extensionsGenerator.addExtension(Extension.extendedKeyUsage, false, (ASN1Encodable)new ExtendedKeyUsage(KeyPurposeId.id_kp_serverAuth));
                    } else if (CsrUsage.TLS_CLIENT.equals((Object)pv.getCsrUsage())) {
                        extensionsGenerator.addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(128));
                        extensionsGenerator.addExtension(Extension.extendedKeyUsage, false, (ASN1Encodable)new ExtendedKeyUsage(KeyPurposeId.id_kp_clientAuth));
                    } else if (CsrUsage.DOC_SIGNING.equals((Object)pv.getCsrUsage())) {
                        extensionsGenerator.addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(192));
                    } else if (CsrUsage.CODE_SIGNING.equals((Object)pv.getCsrUsage())) {
                        extensionsGenerator.addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(128));
                        extensionsGenerator.addExtension(Extension.extendedKeyUsage, false, (ASN1Encodable)new ExtendedKeyUsage(KeyPurposeId.id_kp_codeSigning));
                    } else {
                        this.LOG.warn("unexpected CsrUsage found '{}'", (Object)pv.getCsrUsage());
                    }
                }
                p10Builder.addAttribute(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest, (ASN1Encodable)extensionsGenerator.generate());
            }
            JcaContentSignerBuilder csBuilder = new JcaContentSignerBuilder((pk = keypair.getPrivate()) instanceof ECKey ? EC_SIGNATURE_ALG : SIGNATURE_ALG);
            ContentSigner signer = csBuilder.build(pk);
            PKCS10CertificationRequest p10CR = p10Builder.build(signer);
            String csrAsPem = CryptoUtil.pkcs10RequestToPem((PKCS10CertificationRequest)p10CR);
            this.LOG.debug("created csr on behalf of user '{}':\n{}", (Object)requestorName, (Object)csrAsPem);
            Pkcs10RequestHolder p10ReqHolder = this.cryptoUtil.parseCertificateRequest(p10CR);
            Pkcs10RequestHolderShallow p10ReqHolderShallow = new Pkcs10RequestHolderShallow(p10ReqHolder);
            PkcsXXData p10ReqData = new PkcsXXData(p10ReqHolderShallow);
            CSR csr = this.startCertificateCreationProcess(csrAsPem, p10ReqData, requestorName, uploaded.getRequestorcomment(), uploaded.getArAttributes(), optPipeline);
            if (csr != null) {
                csr.setServersideKeyGeneration(Boolean.valueOf(true));
                this.csrRepository.save((Object)csr);
                this.certUtil.storePrivateKey(csr, keypair);
                this.protUtil.createProtectedContent(uploaded.getSecret(), ProtectedContentType.PASSWORD, ContentRelationType.CSR, csr.getId().longValue());
                Certificate cert = csr.getCertificate();
                if (cert != null) {
                    X509CertificateHolder certHolder = this.cryptoUtil.convertPemToCertificateHolder(cert.getContent());
                    p10ReqData = new PkcsXXData(certHolder, cert);
                }
                return new ResponseEntity((Object)p10ReqData, HttpStatus.CREATED);
            }
            this.LOG.warn("problem creating serverside csr object from CSR PEM: \n{}", (Object)csrAsPem);
            return new ResponseEntity((Object)p10ReqData, HttpStatus.OK);
        }
        catch (IOException | GeneralSecurityException | OperatorCreationException ex) {
            this.LOG.warn("problem creating serverside csr: " + ex.getMessage());
            return new ResponseEntity(HttpStatus.BAD_REQUEST);
        }
    }

    private KeyPair generateKeyPair(KeyAlgoLength keyAlgoLength) throws NoSuchAlgorithmException {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance(keyAlgoLength.algoName());
        kpg.initialize(keyAlgoLength.keyLength());
        return kpg.generateKeyPair();
    }

    private Certificate insertCertificate(String content, String requestorName) throws GeneralSecurityException, IOException {
        Certificate cert = this.certUtil.createCertificate(content, null, null, false);
        this.auditService.saveAuditTrace(this.auditService.createAuditTraceCertificate("MANUAL_CERTIFICATE_IMPORTED", cert));
        this.certUtil.setCertAttribute(cert, "UPLOADED_BY", requestorName);
        this.certificateRepository.save((Object)cert);
        this.LOG.info("created new certificate entry with id {} uploaded by {}", (Object)cert.getId(), (Object)requestorName);
        return cert;
    }

    private CSR startCertificateCreationProcess(String csrAsPem, PkcsXXData p10ReqData, String requestorName, String requestorComment, NamedValues[] nvArr, Optional<Pipeline> optPipeline) {
        if (optPipeline.isPresent()) {
            Pipeline pipeline = optPipeline.get();
            if (pipeline.isActive().booleanValue()) {
                ArrayList messageList = new ArrayList();
                CSR csr = this.cpUtil.buildCSR(csrAsPem, requestorName, "WEB_CERTIFICATE_REQUESTED", requestorComment, pipeline, nvArr, messageList);
                p10ReqData.setMessages(messageList.toArray(new String[0]));
                if (csr != null) {
                    if (pipeline.isApprovalRequired().booleanValue()) {
                        this.LOG.debug("deferring certificate creation for csr #{}", (Object)csr.getId());
                        p10ReqData.setCsrPending(true);
                        p10ReqData.setCreatedCSRId(csr.getId().toString());
                    } else {
                        this.cpUtil.processCertificateRequest(csr, requestorName, "WEB_CERTIFICATE_CREATED", pipeline);
                    }
                    return csr;
                }
                this.LOG.warn("startCertificateCreationProcess: creation of CSR failed");
            } else {
                this.LOG.warn("startCertificateCreationProcess: pipeline {} not active", (Object)pipeline.getName());
            }
        } else {
            this.LOG.warn("startCertificateCreationProcess: no processing pipeline defined");
        }
        return null;
    }

    private List<Certificate> findCertificateByIssuerSerial(X509CertificateHolder certHolder) {
        return this.certificateRepository.findByIssuerSerial(certHolder.getIssuer().toString(), certHolder.getSerialNumber().toString());
    }

    static {
        nameOIDMap.put("C", BCStyle.C);
        nameOIDMap.put("CN", BCStyle.CN);
        nameOIDMap.put("O", BCStyle.O);
        nameOIDMap.put("OU", BCStyle.OU);
        nameOIDMap.put("L", BCStyle.L);
        nameOIDMap.put("ST", BCStyle.ST);
        nameGeneralNameMap.put("DNS", 2);
        nameGeneralNameMap.put("IP", 7);
    }
}

