/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest.support;

import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.web.rest.data.DataCollection;
import de.trustable.ca3s.core.web.rest.data.DataSet;
import java.math.BigInteger;
import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/publicapi"})
public class DashBoardContent {
    private final Logger LOG = LoggerFactory.getLogger(DashBoardContent.class);
    @Autowired
    private CertificateRepository certificateRepository;
    public static final String RED = "#FF0000";
    public static final String ORANGE = "#FFA500";
    public static final String GRAY = "#888888";
    public static final String[] DAY_OF_WEEK = new String[]{"So", "Mo", "Di", "Mi", "Do", "Fr", "Sa", "So"};
    static Float MAX_COLOR = Float.valueOf("16777215");

    @GetMapping(value={"/expiringCertificatesByDate"})
    public ResponseEntity<DataCollection> getExpiringCertificatesByDate() {
        int nDays = 30;
        int urgentLimitDays = 7;
        int urgentWeekendLimitDays = 10;
        Instant after = Instant.now();
        long nowSec = after.getEpochSecond();
        Instant urgent = Instant.now().plus((long)urgentLimitDays, ChronoUnit.DAYS);
        Instant urgentWeekend = Instant.now().plus((long)urgentWeekendLimitDays, ChronoUnit.DAYS);
        Instant before = Instant.now().plus((long)nDays, ChronoUnit.DAYS);
        List certList = this.certificateRepository.findByValidTo(after, before);
        DataCollection dc = new DataCollection();
        String[] labels = new String[nDays];
        dc.setLabels(labels);
        DataSet[] dataSets = new DataSet[1];
        dc.setDatasets(dataSets);
        for (int i = 0; i < nDays; ++i) {
            Instant instant = after.plus((long)i, ChronoUnit.DAYS);
            int dow = instant.atZone(ZoneId.systemDefault()).getDayOfWeek().getValue();
            labels[i] = DAY_OF_WEEK[dow];
        }
        dataSets[0] = new DataSet("Expiring soon", nDays);
        for (Certificate cert : certList) {
            if (cert.isRevoked().booleanValue()) {
                this.LOG.debug("revoked certificate ignored");
                continue;
            }
            int relativeDay = (int)((cert.getValidTo().getEpochSecond() - nowSec) / 86400L);
            DataSet ds = dataSets[0];
            String color = GRAY;
            if (cert.getValidTo().isBefore(urgent)) {
                color = RED;
            } else if (cert.getValidTo().isBefore(urgentWeekend)) {
                int dow = cert.getValidTo().atZone(ZoneId.systemDefault()).getDayOfWeek().getValue();
                color = dow >= 5 ? RED : ORANGE;
            }
            ds.getBackgroundColor()[relativeDay] = color;
            int[] nArray = ds.getData();
            int n = relativeDay;
            nArray[n] = nArray[n] + 1;
        }
        return new ResponseEntity((Object)dc, HttpStatus.OK);
    }

    @GetMapping(value={"/activeCertificatesByHashAlgo"})
    public ResponseEntity<DataCollection> getActiveCertificatesByHashAlgo() {
        List algos = this.certificateRepository.findActiveCertificatesByHashAlgo(Instant.now());
        DataCollection dc = this.fillDataCollection(algos, "Hash algorithm");
        return new ResponseEntity((Object)dc, HttpStatus.OK);
    }

    @GetMapping(value={"/activeCertificatesByKeyAlgo"})
    public ResponseEntity<DataCollection> getActiveCertificatesByKeyAlgo() {
        List algos = this.certificateRepository.findActiveCertificatesByKeyAlgo(Instant.now());
        DataCollection dc = this.fillDataCollection(algos, "Key algorithm");
        return new ResponseEntity((Object)dc, HttpStatus.OK);
    }

    @GetMapping(value={"/activeCertificatesByKeyLength"})
    public ResponseEntity<DataCollection> getActiveCertificatesByKeyLength() {
        List algos = this.certificateRepository.findActiveCertificatesByKeyLength(Instant.now());
        DataCollection dc = this.fillDataCollection(algos, "Key length");
        return new ResponseEntity((Object)dc, HttpStatus.OK);
    }

    private DataCollection fillDataCollection(List<Object[]> valuesArr, String headingText) {
        int nAlgos = valuesArr.size();
        DataCollection dc = new DataCollection();
        String[] labels = new String[nAlgos];
        dc.setLabels(labels);
        DataSet ds = new DataSet(headingText, new String[nAlgos], nAlgos);
        DataSet[] dataSets = new DataSet[]{ds};
        dc.setDatasets(dataSets);
        int i = 0;
        for (Object[] resArr : valuesArr) {
            if (resArr.length > 0 && resArr[0] != null) {
                this.LOG.debug("resArr[0].toString() : {}", resArr[0]);
                labels[i] = resArr[0].toString();
                ds.getData()[i] = ((Long)resArr[1]).intValue();
                ds.getBackgroundColor()[i] = this.getRandomColor();
            }
            ++i;
        }
        return dc;
    }

    String getRandomColor() {
        BigInteger bi = BigInteger.valueOf((long)(Math.random() * (double)MAX_COLOR.floatValue()));
        return "#" + bi.toString(16);
    }
}

