/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.websocket;

import de.trustable.ca3s.core.domain.RequestProxyConfig;
import de.trustable.ca3s.core.web.websocket.RequestProxyStompSessionHandler;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.converter.MappingJackson2MessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.simp.stomp.StompSession;
import org.springframework.messaging.simp.stomp.StompSessionHandler;
import org.springframework.stereotype.Service;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.web.socket.client.WebSocketClient;
import org.springframework.web.socket.client.standard.StandardWebSocketClient;
import org.springframework.web.socket.messaging.WebSocketStompClient;

@Service
public class WSConnectionPool {
    private static final Logger log = LoggerFactory.getLogger(WSConnectionPool.class);
    HashMap<Long, StompSession> connectionMap = new HashMap();

    public boolean hasActiveConnection(RequestProxyConfig rpConfig) {
        if (this.connectionMap.containsKey(rpConfig.getId())) {
            StompSession connection = (StompSession)this.connectionMap.get(rpConfig.getId());
            log.debug("websocket connection: isConnected {}", (Object)connection.isConnected());
            if (connection.isConnected()) {
                log.debug("websocket connection to {} active", (Object)rpConfig.getRequestProxyUrl());
                return true;
            }
            log.debug("websocket connection to {} inactive", (Object)rpConfig.getRequestProxyUrl());
        }
        return false;
    }

    public void putConnection(RequestProxyConfig rpConfig, StompSession wsConnectionStatus) {
        if (this.hasActiveConnection(rpConfig)) {
            StompSession connection = (StompSession)this.connectionMap.get(rpConfig.getId());
            connection.disconnect();
            log.debug("cancelling existing websocket connection to {}", (Object)rpConfig.getRequestProxyUrl());
        }
        this.connectionMap.put(rpConfig.getId(), wsConnectionStatus);
        log.debug("registered new websocket connection to {}", (Object)rpConfig.getRequestProxyUrl());
    }

    public void ensureWSConnected(RequestProxyConfig rpConfig) {
        if (this.hasActiveConnection(rpConfig)) {
            log.debug("stompClient already connected ...");
        } else {
            StandardWebSocketClient client = new StandardWebSocketClient();
            WebSocketStompClient stompClient = new WebSocketStompClient((WebSocketClient)client);
            stompClient.setMessageConverter((MessageConverter)new MappingJackson2MessageConverter());
            RequestProxyStompSessionHandler sessionHandler = new RequestProxyStompSessionHandler();
            ListenableFuture wsConnectionStatus = stompClient.connect(rpConfig.getRequestProxyUrl(), (StompSessionHandler)sessionHandler, new Object[0]);
            try {
                this.putConnection(rpConfig, (StompSession)wsConnectionStatus.get());
                log.debug("stompClient frehly connected ...");
            }
            catch (InterruptedException | ExecutionException e) {
                log.warn("problem connecting stompClient", (Throwable)e);
            }
        }
    }

    public void ensureWSConnectionClosed(RequestProxyConfig rpConfig) {
        if (this.hasActiveConnection(rpConfig)) {
            log.debug("stompClient connected, disconnecting ...");
            StompSession connection = (StompSession)this.connectionMap.get(rpConfig.getId());
            connection.disconnect();
            log.debug("cancelling existing websocket connection to {}", (Object)rpConfig.getRequestProxyUrl());
            this.connectionMap.remove(rpConfig.getId());
        }
    }
}

