/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.schedule;

import de.trustable.ca3s.cert.bundle.BundleFactory;
import de.trustable.ca3s.core.domain.CAConnectorConfig;
import de.trustable.ca3s.core.repository.CAConnectorConfigRepository;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.security.provider.Ca3sBundleFactory;
import de.trustable.ca3s.core.security.provider.TimedRenewalCertMapHolder;
import de.trustable.ca3s.core.service.dto.CAStatus;
import de.trustable.ca3s.core.service.util.CaConnectorAdapter;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(propagation=Propagation.REQUIRES_NEW)
public class CertBundleScheduler {
    transient Logger LOG = LoggerFactory.getLogger(CertBundleScheduler.class);
    private final CAConnectorConfigRepository caConfigRepo;
    private final CaConnectorAdapter caConnAd;
    private final CertificateUtil certUtil;
    private final CertificateRepository certificateRepository;
    private final TimedRenewalCertMapHolder timedRenewalCertMapHolder;
    private final String dnSuffix;
    private final String sans;
    private final String persist;

    public CertBundleScheduler(CAConnectorConfigRepository caConfigRepo, CaConnectorAdapter caConnAd, CertificateUtil certUtil, CertificateRepository certificateRepository, TimedRenewalCertMapHolder timedRenewalCertMapHolder, @Value(value="${ca3s.https.certificate.dnSuffix:}") String dnSuffix, @Value(value="${ca3s.https.certificate.sans:}") String sans, @Value(value="${ca3s.https.certificate.persist:NO}") String persist) {
        this.caConfigRepo = caConfigRepo;
        this.caConnAd = caConnAd;
        this.certUtil = certUtil;
        this.certificateRepository = certificateRepository;
        this.timedRenewalCertMapHolder = timedRenewalCertMapHolder;
        this.dnSuffix = dnSuffix;
        this.sans = sans;
        this.persist = persist;
    }

    @Scheduled(fixedDelay=60000L)
    public void retrieveCertificates() {
        for (CAConnectorConfig caConfigDao : this.caConfigRepo.findAll()) {
            if (!caConfigDao.isActive().booleanValue() || !caConfigDao.isDefaultCA().booleanValue()) continue;
            if (CAStatus.Active.equals((Object)this.caConnAd.getStatus(caConfigDao))) {
                if (this.timedRenewalCertMapHolder.getCertMap().getBundleFactory() != null) continue;
                this.timedRenewalCertMapHolder.getCertMap().setBundleFactory((BundleFactory)new Ca3sBundleFactory(caConfigDao, this.caConnAd, this.certUtil, this.certificateRepository, this.dnSuffix, this.sans, this.persist));
                this.LOG.info("Ca3sBundleFactory registered for TLS certificate production");
                continue;
            }
            this.LOG.info("CA default connector not active");
        }
    }
}

