/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.adcs;

import de.trustable.ca3s.adcsCertUtil.ADCSException;
import de.trustable.ca3s.adcsCertUtil.ADCSNativeImpl;
import de.trustable.ca3s.adcsCertUtil.ADCSProxyUnavailableException;
import de.trustable.ca3s.adcsCertUtil.ADCSWinNativeConnector;
import de.trustable.ca3s.adcsCertUtil.CertificateEnrollmentResponse;
import de.trustable.ca3s.adcsCertUtil.GetCertificateResponse;
import de.trustable.ca3s.adcsCertUtil.NoLocalADCSException;
import de.trustable.ca3s.adcsCertUtil.OODBConnectionsADCSException;
import de.trustable.ca3s.adcsCertUtil.SubmitStatus;
import de.trustable.ca3s.core.domain.CAConnectorConfig;
import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.domain.enumeration.CsrStatus;
import de.trustable.ca3s.core.repository.CSRRepository;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.security.provider.Ca3sTrustManager;
import de.trustable.ca3s.core.service.AuditService;
import de.trustable.ca3s.core.service.adcs.ADCSWinNativeConnectorAdapter;
import de.trustable.ca3s.core.service.adcs.EmptyADCSWinNativeConnectorAdapter;
import de.trustable.ca3s.core.service.dto.CAStatus;
import de.trustable.ca3s.core.service.util.CSRUtil;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import de.trustable.ca3s.core.service.util.CryptoService;
import de.trustable.ca3s.core.service.util.ProtectedContentUtil;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.net.ssl.TrustManager;
import org.bouncycastle.asn1.x509.CRLReason;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ADCSConnector {
    Logger LOGGER = LoggerFactory.getLogger(ADCSConnector.class);
    @Autowired
    private CryptoService cryptoUtil;
    @Autowired
    CertificateUtil certUtil;
    @Autowired
    private Ca3sTrustManager ca3sTrustManager;
    @Autowired
    CSRRepository csrRepository;
    @Autowired
    CSRUtil csrUtil;
    @Autowired
    private CertificateRepository certificateRepository;
    @Autowired
    private ProtectedContentUtil protUtil;
    @Autowired
    private AuditService auditService;

    ADCSWinNativeConnector getConnector(CAConnectorConfig config) throws ADCSProxyUnavailableException {
        block8: {
            this.LOGGER.debug("connector '" + config.getName() + "', Url configured as '" + config.getCaUrl() + "'");
            if ("inProcess".equalsIgnoreCase(config.getCaUrl())) {
                this.LOGGER.debug("ADCSConnector trying to load Windows connection classes...");
                try {
                    return new ADCSNativeImpl();
                }
                catch (UnsatisfiedLinkError ule) {
                    this.LOGGER.info("unable to load Windows connection classes, ADCS connection unavailable.");
                    break block8;
                }
                catch (ADCSException e) {
                    this.LOGGER.info("unable to load Windows connection classes, ADCS connection unavailable.", (Throwable)e);
                    break block8;
                }
            }
            if (config.getSecret() == null) {
                throw new ADCSProxyUnavailableException("passphrase missing in ca configuration for ca '" + config.getName() + "' !");
            }
            String plainSecret = this.protUtil.unprotectString(config.getSecret().getContentBase64());
            try {
                ADCSWinNativeConnectorAdapter adcsConnector = new ADCSWinNativeConnectorAdapter(config.getCaUrl(), plainSecret, (TrustManager)this.ca3sTrustManager);
                this.LOGGER.debug("ADCSConnector trying to connect to remote ADCS proxy ...");
                String info = adcsConnector.getInfo();
                this.LOGGER.debug("info call returns '{}'", (Object)info);
                return adcsConnector;
            }
            catch (ADCSProxyUnavailableException pue) {
                this.LOGGER.info("info call for ADCS proxy did not succeeded! Trying later ...");
                throw pue;
            }
            catch (ADCSException | GeneralSecurityException e) {
                this.LOGGER.warn("info call failed", e);
            }
        }
        return new EmptyADCSWinNativeConnectorAdapter();
    }

    public CAStatus getStatus(CAConnectorConfig caConfig) {
        try {
            String adcsStatus = this.getConnector(caConfig).getInfo();
            if (adcsStatus != null && adcsStatus.trim().length() > 0) {
                return CAStatus.Active;
            }
        }
        catch (ADCSException adcsEx) {
            this.LOGGER.debug("CAConnectorType ADCS at " + caConfig.getCaUrl() + " throws Exception: {} ", (Object)adcsEx.getLocalizedMessage());
        }
        return CAStatus.Deactivated;
    }

    public Certificate signCertificateRequest(CSR csr, CAConnectorConfig config) throws GeneralSecurityException {
        Certificate certDao;
        block14: {
            this.LOGGER.debug("incoming csr for ADCS");
            this.createCsrAttribute(csr, "CA_PROCESSING_STARTED_TIMESTAMP", "" + System.currentTimeMillis());
            csr.setStatus(CsrStatus.PROCESSING);
            String csrString = csr.getCsrBase64();
            this.LOGGER.debug("request : " + csrString);
            PKCS10CertificationRequest p10Req = this.cryptoUtil.convertPemToPKCS10CertificationRequest(csrString);
            certDao = null;
            try {
                String normalizedCsrString = CryptoService.pkcs10RequestToPem((PKCS10CertificationRequest)p10Req);
                if (!normalizedCsrString.trim().equalsIgnoreCase(csrString)) {
                    this.LOGGER.debug("csr normalization changes content to : " + normalizedCsrString);
                }
                HashMap<String, String> attrMap = new HashMap<String, String>();
                String template = config.getSelector();
                if (template != null && template.trim().length() > 0) {
                    this.LOGGER.debug("requesting certificate using template : " + template);
                    attrMap.put("Certificate Template", template);
                } else {
                    this.LOGGER.debug("requesting certificate without template ");
                }
                CertificateEnrollmentResponse certResponse = this.getConnector(config).submitRequest(normalizedCsrString, attrMap);
                if (SubmitStatus.ISSUED.equals((Object)certResponse.getStatus())) {
                    if (certResponse.getB64CACert() != null && !certResponse.getB64CACert().trim().isEmpty()) {
                        Certificate certCADao = this.certUtil.createCertificate(certResponse.getB64CACert(), null, null);
                        this.certificateRepository.save((Object)certCADao);
                    }
                    certDao = this.certUtil.createCertificate(certResponse.getB64Cert(), csr, null);
                    certDao.setRevocationCA(config);
                    this.certUtil.setCertAttribute(certDao, "CA_PROCESSING_ID", certResponse.getReqId());
                    this.certificateRepository.save((Object)certDao);
                    csr.setCertificate(certDao);
                    csr.setStatus(CsrStatus.ISSUED);
                    this.createCsrAttribute(csr, "CA_PROCESSING_FINISHED_TIMESTAMP", "" + System.currentTimeMillis());
                    this.createCsrAttribute(csr, "CA_PROCESSING_ID", "" + certResponse.getReqId());
                    break block14;
                }
                if (SubmitStatus.DENIED.equals((Object)certResponse.getStatus()) || SubmitStatus.INCOMPLETE.equals((Object)certResponse.getStatus()) || SubmitStatus.ERROR.equals((Object)certResponse.getStatus())) {
                    this.csrUtil.setStatusAndRejectionReason(csr, CsrStatus.REJECTED, "ADCS call failed with Status '" + certResponse.getStatus() + "'.");
                    this.createCsrAttribute(csr, "CA_PROCESSING_FINISHED_TIMESTAMP", "" + System.currentTimeMillis());
                    this.createCsrAttribute(csr, "CA_PROCESSING_ID", "" + certResponse.getReqId());
                    this.csrRepository.save((Object)csr);
                    throw new GeneralSecurityException("adcs rejected request");
                }
                if (SubmitStatus.UNDER_SUBMISSION.equals((Object)certResponse.getStatus()) || SubmitStatus.ISSUED_OUT_OF_BAND.equals((Object)certResponse.getStatus())) {
                    csr.setStatus(CsrStatus.PENDING);
                    this.createCsrAttribute(csr, "CA_PROCESSING_ID", "" + certResponse.getReqId());
                    break block14;
                }
                throw new GeneralSecurityException("adcs connector returned non-positive status '" + certResponse.getStatus() + "'");
            }
            catch (NoLocalADCSException noLocalAdcsEx) {
                csr.setStatus(CsrStatus.PENDING);
                throw new GeneralSecurityException("no local adcs connector available", noLocalAdcsEx);
            }
            catch (ADCSException adcsEx) {
                csr.setStatus(CsrStatus.PENDING);
                throw new GeneralSecurityException("adcs connector returned exception", adcsEx);
            }
            catch (IOException ioex) {
                csr.setStatus(CsrStatus.PENDING);
                throw new GeneralSecurityException("adcs connector caused IOException", ioex);
            }
            finally {
                this.csrRepository.save((Object)csr);
            }
        }
        this.LOGGER.debug("returning certDao : " + certDao.getId());
        return certDao;
    }

    private void createCsrAttribute(CSR csr, String name, String value) {
        this.csrUtil.setCsrAttribute(csr, name, value, false);
    }

    public void revokeCertificate(Certificate certDao, CRLReason crlReason, Date revocationDate, CAConnectorConfig config) throws GeneralSecurityException {
        int reasonIntValue = crlReason.getValue().intValue();
        if (8 == reasonIntValue) {
            reasonIntValue = -1;
        } else if (reasonIntValue > 6) {
            throw new GeneralSecurityException("adcs connector supports revocation reasons 0..6, not " + reasonIntValue + " !");
        }
        try {
            BigInteger serial = new BigInteger(certDao.getSerial(), 10);
            String serialAsHex = serial.toString(16);
            this.LOGGER.debug("revoking certificate {} with serial '{}' with reason {}", new Object[]{certDao.getId(), serialAsHex, reasonIntValue});
            this.getConnector(config).revokeCertifcate(serialAsHex, reasonIntValue, revocationDate);
        }
        catch (ADCSException adcsEx) {
            throw new GeneralSecurityException("adcs connector returned exception", adcsEx);
        }
    }

    public int retrieveCertificatesOffsetOnly(CAConnectorConfig config) throws OODBConnectionsADCSException, ADCSProxyUnavailableException {
        this.LOGGER.debug("in retrieveCertificates");
        int limit = 100;
        int pollingOffset = 0;
        if (config.getPollingOffset() != null) {
            pollingOffset = config.getPollingOffset();
        }
        ADCSWinNativeConnector adcsConnector = this.getConnector(config);
        try {
            String info = adcsConnector.getInfo();
            List newReqIdList = adcsConnector.getRequesIdList(limit, pollingOffset, 0L, 0L);
            if (newReqIdList.isEmpty()) {
                this.LOGGER.debug("no certificates retrieved at request offset {} at ca '{}'", (Object)pollingOffset, (Object)info);
            }
            for (String reqId : newReqIdList) {
                pollingOffset = Integer.parseInt(reqId);
                List certDaoList = this.certificateRepository.findBySearchTermNamed2("PROCESSING_CA", info, "CA_PROCESSING_ID", reqId);
                if (certDaoList.isEmpty()) {
                    this.importCertificate(adcsConnector, info, reqId, config);
                    continue;
                }
                this.LOGGER.debug("certificate with requestID '{}' from ca '{}' alreeady present", (Object)reqId, (Object)info);
            }
        }
        catch (OODBConnectionsADCSException oodbc) {
            throw oodbc;
        }
        catch (ADCSProxyUnavailableException pue) {
            throw pue;
        }
        catch (ADCSException e) {
            this.LOGGER.info("polling certificate list starting from {} with a limit of {} causes {}", new Object[]{pollingOffset, limit, e.getLocalizedMessage()});
            this.LOGGER.warn("ACDSException : ", (Throwable)e);
        }
        int nNewCerts = pollingOffset - config.getPollingOffset();
        if (nNewCerts > 0) {
            config.setPollingOffset(Integer.valueOf(pollingOffset));
        }
        return nNewCerts;
    }

    public int retrieveCertificatesByResolvedDate(CAConnectorConfig config) throws OODBConnectionsADCSException, ADCSProxyUnavailableException {
        this.LOGGER.debug("in retrieveCertificatesByResolvedDate");
        int nNewCerts = 0;
        int limit = 100;
        ADCSWinNativeConnector adcsConnector = this.getConnector(config);
        try {
            String info = adcsConnector.getInfo();
            List certWithoutResolvedList = this.certificateRepository.findTimestampNotExistForCA(info, "CA_RESOLVED_TIMESTAMP");
            if (!certWithoutResolvedList.isEmpty()) {
                for (int i = 0; i < limit; ++i) {
                    try {
                        Certificate certWOResolved = (Certificate)certWithoutResolvedList.get(i);
                        String caProcessingId = this.certUtil.getCertAttribute(certWOResolved, "CA_PROCESSING_ID");
                        if (caProcessingId == null) {
                            this.LOGGER.warn("certificate #{} retrieved for ca '{}' but without CA_PROCESSING_ID", (Object)certWOResolved.getId(), (Object)info);
                            continue;
                        }
                        GetCertificateResponse certResponse = adcsConnector.getCertificateByRequestId(caProcessingId);
                        this.certUtil.setCertAttribute(certWOResolved, "CA_RESOLVED_TIMESTAMP", CertificateUtil.getPaddedTimestamp((String)certResponse.getResolvedDate()));
                        this.LOGGER.warn("added resolved timestamp {} to certificate #{} retrieved for ca '{}' with CA_PROCESSING_ID '{}'", new Object[]{CertificateUtil.getPaddedTimestamp((String)certResponse.getResolvedDate()), certWOResolved.getId(), info, caProcessingId});
                        continue;
                    }
                    catch (IndexOutOfBoundsException certWOResolved) {
                        // empty catch block
                    }
                }
            } else {
                String maxTimestamp = this.certificateRepository.findMaxTimestampForCA(info, "CA_RESOLVED_TIMESTAMP");
                this.LOGGER.debug("findMaxResolvedForCA at ca '{}' returned {}  / {}", new Object[]{info, maxTimestamp, this.dateFromTimestampString(maxTimestamp)});
                long timestamp = Long.parseLong(maxTimestamp);
                List newReqIdList = adcsConnector.getRequesIdList(limit, 0, timestamp, 0L);
                if (newReqIdList.isEmpty()) {
                    this.LOGGER.debug("no certificates retrieved with a resolved timestamp after {} at ca '{}'", (Object)new Date(timestamp), (Object)info);
                }
                for (String reqId : newReqIdList) {
                    List certDaoList = this.certificateRepository.findBySearchTermNamed2("PROCESSING_CA", info, "CA_PROCESSING_ID", reqId);
                    if (certDaoList.isEmpty()) {
                        Certificate certImported = this.importCertificate(adcsConnector, info, reqId, config);
                        if (certImported == null) {
                            this.LOGGER.warn("import of certificate with requestID '{}' from ca '{}' failed", (Object)reqId, (Object)info);
                            continue;
                        }
                        this.LOGGER.info("certificate with requestID '{}' from ca '{}' imported, assigned to cert id {}", new Object[]{reqId, info, certImported.getId()});
                        String resolvedTimestampAttribute = this.certUtil.getCertAttribute(certImported, "CA_RESOLVED_TIMESTAMP");
                        this.LOGGER.info("certificate with requestID '{}' from ca '{}' set to resolved timestamp {} / {}", new Object[]{reqId, info, resolvedTimestampAttribute, this.dateFromTimestampString(resolvedTimestampAttribute)});
                        ++nNewCerts;
                        continue;
                    }
                    this.LOGGER.info("certificate with requestID '{}' from ca '{}' already present with cert id {}", new Object[]{reqId, info, ((Certificate)certDaoList.get(0)).getId()});
                }
            }
        }
        catch (OODBConnectionsADCSException oodbc) {
            throw oodbc;
        }
        catch (ADCSProxyUnavailableException pue) {
            throw pue;
        }
        catch (ADCSException e) {
            this.LOGGER.info("importing certificate list by resolved date with a limit of {} causes {}", (Object)limit, (Object)e.getLocalizedMessage());
            this.LOGGER.warn("ACDSException : ", (Throwable)e);
        }
        return nNewCerts;
    }

    public int retrieveCertificatesByRevokedDate(CAConnectorConfig config) throws OODBConnectionsADCSException, ADCSProxyUnavailableException {
        this.LOGGER.debug("in retrieveCertificatesByRevokedDate");
        int nNewRevokedCerts = 0;
        int limit = 100;
        ADCSWinNativeConnector adcsConnector = this.getConnector(config);
        try {
            String info = adcsConnector.getInfo();
            List certWithoutRevokedList = this.certificateRepository.findTimestampNotExistForCA(info, "CA_REVOKED_TIMESTAMP");
            if (!certWithoutRevokedList.isEmpty()) {
                for (int i = 0; i < limit; ++i) {
                    try {
                        Certificate certWORevoked = (Certificate)certWithoutRevokedList.get(i);
                        String caProcessingId = this.certUtil.getCertAttribute(certWORevoked, "CA_PROCESSING_ID");
                        if (caProcessingId == null) {
                            this.LOGGER.warn("certificate #{} retrieved for ca '{}' but without CA_PROCESSING_ID", (Object)certWORevoked.getId(), (Object)info);
                            continue;
                        }
                        GetCertificateResponse certResponse = adcsConnector.getCertificateByRequestId(caProcessingId);
                        this.certUtil.setCertAttribute(certWORevoked, "CA_REVOKED_TIMESTAMP", CertificateUtil.getPaddedTimestamp((String)certResponse.getRevokedDate()));
                        this.LOGGER.warn("added revoked timestamp {} to certificate #{} retrieved for ca '{}' with CA_PROCESSING_ID '{}'", new Object[]{CertificateUtil.getPaddedTimestamp((String)certResponse.getRevokedDate()), certWORevoked.getId(), info, caProcessingId});
                        continue;
                    }
                    catch (IndexOutOfBoundsException certWORevoked) {
                        // empty catch block
                    }
                }
            } else {
                String maxTimestamp = this.certificateRepository.findMaxTimestampForCA(info, "CA_REVOKED_TIMESTAMP");
                this.LOGGER.debug("findMaxRevokedForCA at ca '{}' returned {}", (Object)info, (Object)this.dateFromTimestampString(maxTimestamp));
                long timestamp = Long.parseLong(maxTimestamp);
                List newReqIdList = adcsConnector.getRequesIdList(limit, 0, 0L, timestamp);
                if (newReqIdList.isEmpty()) {
                    this.LOGGER.debug("no certificates retrieved with a revoked timestamp after {} at ca '{}'", (Object)new Date(timestamp), (Object)info);
                }
                for (String reqId : newReqIdList) {
                    List certDaoList = this.certificateRepository.findBySearchTermNamed2("PROCESSING_CA", info, "CA_PROCESSING_ID", reqId);
                    Certificate certRevoked = null;
                    if (certDaoList.isEmpty()) {
                        this.LOGGER.warn("certificate with revocation status to be updated with requestID '{}' from ca '{}' not present in database!", (Object)reqId, (Object)info);
                        certRevoked = this.importCertificate(adcsConnector, info, reqId, config);
                        if (certRevoked == null) {
                            this.LOGGER.warn("import of certificate with requestID '{}' from ca '{}' failed", (Object)reqId, (Object)info);
                        }
                    } else if (certDaoList.size() == 1) {
                        certRevoked = (Certificate)certDaoList.get(0);
                    } else {
                        this.LOGGER.warn("retrieved more than one ({}) certificate found for requestID '{}' from ca '{}' in database!", new Object[]{certDaoList.size(), reqId, info});
                        certRevoked = (Certificate)certDaoList.get(0);
                    }
                    if (certRevoked == null) continue;
                    GetCertificateResponse certResponse = adcsConnector.getCertificateByRequestId(reqId);
                    boolean alreadyRevoked = certRevoked.isRevoked();
                    String reason = this.cryptoUtil.crlReasonAsString(this.cryptoUtil.crlReasonFromString(certResponse.getRevokedReason()));
                    Date revocationDate = new Date(Long.parseLong(certResponse.getRevokedDate()));
                    this.certUtil.setRevocationStatus(certRevoked, reason, revocationDate);
                    this.certUtil.setCertAttribute(certRevoked, "CA_REVOKED_TIMESTAMP", CertificateUtil.getPaddedTimestamp((String)certResponse.getRevokedDate()));
                    if (alreadyRevoked) {
                        this.LOGGER.info("certificate with requestID '{}' from ca '{}' with cert id {} is already revoked", new Object[]{reqId, info, certRevoked.getId()});
                        continue;
                    }
                    this.LOGGER.info("certificate with requestID '{}' from ca '{}' with cert id {} changed to revoked", new Object[]{reqId, info, certRevoked.getId()});
                    ++nNewRevokedCerts;
                }
            }
        }
        catch (OODBConnectionsADCSException oodbc) {
            throw oodbc;
        }
        catch (ADCSProxyUnavailableException pue) {
            throw pue;
        }
        catch (ADCSException e) {
            this.LOGGER.info("importing certificate list by revoked date with a limit of {} causes {}", (Object)limit, (Object)e.getLocalizedMessage());
            this.LOGGER.warn("ACDSException : ", (Throwable)e);
        }
        return nNewRevokedCerts;
    }

    private Date dateFromTimestampString(String timestamp) {
        long timestampAsLong = Long.parseLong(timestamp);
        return new Date(timestampAsLong);
    }

    @Transactional
    public int retrieveCertificates(CAConnectorConfig config) throws OODBConnectionsADCSException, ADCSProxyUnavailableException {
        return this.retrieveCertificatesOffsetOnly(config);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    Certificate importCertificate(ADCSWinNativeConnector adcsConnector, String caName, String reqId, CAConnectorConfig config) throws ADCSException {
        GetCertificateResponse certResponse = adcsConnector.getCertificateByRequestId(reqId);
        if (certResponse.getB64Cert() == null || certResponse.getB64Cert().trim().length() == 0) {
            this.LOGGER.debug("reqId '{}' has not certificate, yet. Ignoring ...", (Object)reqId);
            return null;
        }
        try {
            Certificate certDao = this.certUtil.getCertificateByPEM(certResponse.getB64Cert());
            if (certDao == null) {
                certDao = this.certUtil.createCertificate(certResponse.getB64Cert(), null, null, false);
                this.auditService.saveAuditTrace(this.auditService.createAuditTraceCertificate("ADCS_CERTIFICATE_IMPORTED", certDao));
            }
            certDao.setRevocationCA(config);
            if (certDao.isSelfsigned().booleanValue()) {
                certDao.setTrusted(Boolean.valueOf(true));
            }
            this.certUtil.setCertAttribute(certDao, "PROCESSING_CA", caName);
            this.certUtil.setCertAttribute(certDao, "CA_PROCESSING_ID", certResponse.getReqId());
            this.certUtil.setCertAttribute(certDao, "CA_RESOLVED_TIMESTAMP", CertificateUtil.getPaddedTimestamp((String)certResponse.getResolvedDate()));
            this.certificateRepository.save((Object)certDao);
            this.LOGGER.debug("certificate with reqId '{}' imported from ca '{}'", (Object)reqId, (Object)caName);
            return certDao;
        }
        catch (IOException | GeneralSecurityException e) {
            this.LOGGER.info("retrieving and importing certificate with reqId '{}' from ca '{}' causes {}", new Object[]{reqId, caName, e.getLocalizedMessage()});
            throw new ADCSException(e.getLocalizedMessage());
        }
    }
}

