/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.impl;

import de.trustable.ca3s.core.domain.AuditTrace;
import de.trustable.ca3s.core.domain.Pipeline;
import de.trustable.ca3s.core.repository.AuditTraceRepository;
import de.trustable.ca3s.core.repository.PipelineAttributeRepository;
import de.trustable.ca3s.core.repository.PipelineRepository;
import de.trustable.ca3s.core.service.AuditService;
import de.trustable.ca3s.core.service.PipelineService;
import de.trustable.ca3s.core.service.exception.IntegrityException;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class PipelineServiceImpl
implements PipelineService {
    private final Logger log = LoggerFactory.getLogger(PipelineServiceImpl.class);
    private final PipelineRepository pipelineRepository;
    private final PipelineAttributeRepository pipelineAttributeRepository;
    private final AuditService auditService;
    private final AuditTraceRepository auditTraceRepository;

    public PipelineServiceImpl(PipelineRepository pipelineRepository, PipelineAttributeRepository pipelineAttributeRepository, AuditService auditService, AuditTraceRepository auditTraceRepository) {
        this.pipelineRepository = pipelineRepository;
        this.pipelineAttributeRepository = pipelineAttributeRepository;
        this.auditService = auditService;
        this.auditTraceRepository = auditTraceRepository;
    }

    public Pipeline save(Pipeline pipeline) {
        this.log.debug("Request to save Pipeline : {}", (Object)pipeline);
        return (Pipeline)this.pipelineRepository.save((Object)pipeline);
    }

    @Transactional(readOnly=true)
    public List<Pipeline> findAll() {
        this.log.debug("Request to get all Pipelines");
        return this.pipelineRepository.findAll();
    }

    @Transactional(readOnly=true)
    public Optional<Pipeline> findOne(Long id) {
        this.log.debug("Request to get Pipeline : {}", (Object)id);
        return this.pipelineRepository.findById((Object)id);
    }

    public void delete(Long id) {
        this.log.debug("Request to delete Pipeline : {}", (Object)id);
        Optional pipelineOpt = this.pipelineRepository.findById((Object)id);
        if (pipelineOpt.isPresent()) {
            Pipeline pipeline = (Pipeline)pipelineOpt.get();
            List auditTraceList = this.auditTraceRepository.findByPipeline(pipeline);
            boolean bWasUsed = false;
            for (AuditTrace auditTrace : auditTraceList) {
                if (auditTrace.getCertificate() != null) {
                    this.log.debug("Pipeline : {} has certificate. Delete prohibited", (Object)id);
                    bWasUsed = true;
                    break;
                }
                if (auditTrace.getCsr() == null) continue;
                this.log.debug("Pipeline : {} has CSR. Delete prohibited", (Object)id);
                bWasUsed = true;
                break;
            }
            if (bWasUsed) {
                throw new IntegrityException("Pipeline already used");
            }
            this.auditTraceRepository.deleteAll((Iterable)auditTraceList);
            this.auditService.saveAuditTrace(this.auditService.createAuditTracePipeline("PIPELINE_DELETED", null));
            this.pipelineAttributeRepository.deleteAll((Iterable)pipeline.getPipelineAttributes());
            this.pipelineRepository.deleteById((Object)id);
        }
    }
}

