/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.core.domain.ACMEAccount;
import de.trustable.ca3s.core.service.ACMEAccountService;
import de.trustable.ca3s.core.web.rest.errors.BadRequestAlertException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class ACMEAccountResource {
    private final Logger log = LoggerFactory.getLogger(ACMEAccountResource.class);
    private static final String ENTITY_NAME = "aCMEAccount";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final ACMEAccountService aCMEAccountService;

    public ACMEAccountResource(ACMEAccountService aCMEAccountService) {
        this.aCMEAccountService = aCMEAccountService;
    }

    @PostMapping(value={"/acme-accounts"})
    public ResponseEntity<ACMEAccount> createACMEAccount(@Valid @RequestBody ACMEAccount aCMEAccount) throws URISyntaxException {
        this.log.debug("REST request to save ACMEAccount : {}", (Object)aCMEAccount);
        if (aCMEAccount.getId() != null) {
            throw new BadRequestAlertException("A new aCMEAccount cannot already have an ID", ENTITY_NAME, "idexists");
        }
        ACMEAccount result = this.aCMEAccountService.save(aCMEAccount);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/acme-accounts/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/acme-accounts"})
    public ResponseEntity<ACMEAccount> updateACMEAccount(@Valid @RequestBody ACMEAccount aCMEAccount) throws URISyntaxException {
        this.log.debug("REST request to update ACMEAccount : {}", (Object)aCMEAccount);
        if (aCMEAccount.getId() == null) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        ACMEAccount result = this.aCMEAccountService.save(aCMEAccount);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)aCMEAccount.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/acme-accounts"})
    public List<ACMEAccount> getAllACMEAccounts() {
        this.log.debug("REST request to get all ACMEAccounts");
        return this.aCMEAccountService.findAll();
    }

    @GetMapping(value={"/acme-accounts/{id}"})
    public ResponseEntity<ACMEAccount> getACMEAccount(@PathVariable Long id) {
        this.log.debug("REST request to get ACMEAccount : {}", (Object)id);
        Optional aCMEAccount = this.aCMEAccountService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)aCMEAccount);
    }

    @DeleteMapping(value={"/acme-accounts/{id}"})
    public ResponseEntity<Void> deleteACMEAccount(@PathVariable Long id) {
        this.log.debug("REST request to delete ACMEAccount : {}", (Object)id);
        this.aCMEAccountService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }
}

