/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.core.domain.AcmeNonce;
import de.trustable.ca3s.core.service.AcmeNonceService;
import de.trustable.ca3s.core.web.rest.errors.BadRequestAlertException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class AcmeNonceResource {
    private final Logger log = LoggerFactory.getLogger(AcmeNonceResource.class);
    private static final String ENTITY_NAME = "acmeNonce";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final AcmeNonceService acmeNonceService;

    public AcmeNonceResource(AcmeNonceService acmeNonceService) {
        this.acmeNonceService = acmeNonceService;
    }

    @PostMapping(value={"/acme-nonces"})
    public ResponseEntity<AcmeNonce> createAcmeNonce(@RequestBody AcmeNonce acmeNonce) throws URISyntaxException {
        this.log.debug("REST request to save AcmeNonce : {}", (Object)acmeNonce);
        if (acmeNonce.getId() != null) {
            throw new BadRequestAlertException("A new acmeNonce cannot already have an ID", ENTITY_NAME, "idexists");
        }
        AcmeNonce result = this.acmeNonceService.save(acmeNonce);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/acme-nonces/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/acme-nonces"})
    public ResponseEntity<AcmeNonce> updateAcmeNonce(@RequestBody AcmeNonce acmeNonce) throws URISyntaxException {
        this.log.debug("REST request to update AcmeNonce : {}", (Object)acmeNonce);
        if (acmeNonce.getId() == null) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        AcmeNonce result = this.acmeNonceService.save(acmeNonce);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)acmeNonce.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/acme-nonces"})
    public List<AcmeNonce> getAllAcmeNonces() {
        this.log.debug("REST request to get all AcmeNonces");
        return this.acmeNonceService.findAll();
    }

    @GetMapping(value={"/acme-nonces/{id}"})
    public ResponseEntity<AcmeNonce> getAcmeNonce(@PathVariable Long id) {
        this.log.debug("REST request to get AcmeNonce : {}", (Object)id);
        Optional acmeNonce = this.acmeNonceService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)acmeNonce);
    }

    @DeleteMapping(value={"/acme-nonces/{id}"})
    public ResponseEntity<Void> deleteAcmeNonce(@PathVariable Long id) {
        this.log.debug("REST request to delete AcmeNonce : {}", (Object)id);
        this.acmeNonceService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }
}

