/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.core.domain.AuditTrace;
import de.trustable.ca3s.core.service.AuditTraceService;
import de.trustable.ca3s.core.web.rest.errors.BadRequestAlertException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class AuditTraceResource {
    private final Logger log = LoggerFactory.getLogger(AuditTraceResource.class);
    private static final String ENTITY_NAME = "auditTrace";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final AuditTraceService auditTraceService;

    public AuditTraceResource(AuditTraceService auditTraceService) {
        this.auditTraceService = auditTraceService;
    }

    @PostMapping(value={"/audit-traces"})
    public ResponseEntity<AuditTrace> createAuditTrace(@Valid @RequestBody AuditTrace auditTrace) throws URISyntaxException {
        this.log.debug("REST request to save AuditTrace : {}", (Object)auditTrace);
        if (auditTrace.getId() != null) {
            throw new BadRequestAlertException("A new auditTrace cannot already have an ID", ENTITY_NAME, "idexists");
        }
        AuditTrace result = this.auditTraceService.save(auditTrace);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/audit-traces/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/audit-traces"})
    public ResponseEntity<AuditTrace> updateAuditTrace(@Valid @RequestBody AuditTrace auditTrace) throws URISyntaxException {
        this.log.debug("REST request to update AuditTrace : {}", (Object)auditTrace);
        if (auditTrace.getId() == null) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        AuditTrace result = this.auditTraceService.save(auditTrace);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)auditTrace.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/audit-traces"})
    public Page<AuditTrace> getAllAuditTraces(Pageable pageable, @RequestParam(value="certificate", required=false) Long certificateId, @RequestParam(value="csr", required=false) Long csrId, @RequestParam(value="pipeline", required=false) Long pipelineId, @RequestParam(value="caConnector", required=false) Long caConnectorId, @RequestParam(value="processInfo", required=false) Long processInfoId) {
        this.log.debug("REST request to get AuditTraces");
        return this.auditTraceService.findBy(pageable, certificateId, csrId, pipelineId, caConnectorId, processInfoId);
    }

    @GetMapping(value={"/audit-traces/{id}"})
    public ResponseEntity<AuditTrace> getAuditTrace(@PathVariable Long id) {
        this.log.debug("REST request to get AuditTrace : {}", (Object)id);
        Optional auditTrace = this.auditTraceService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)auditTrace);
    }

    @DeleteMapping(value={"/audit-traces/{id}"})
    public ResponseEntity<Void> deleteAuditTrace(@PathVariable Long id) {
        this.log.debug("REST request to delete AuditTrace : {}", (Object)id);
        this.auditTraceService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }
}

