/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.core.domain.RDN;
import de.trustable.ca3s.core.service.RDNService;
import de.trustable.ca3s.core.web.rest.errors.BadRequestAlertException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class RDNResource {
    private final Logger log = LoggerFactory.getLogger(RDNResource.class);
    private static final String ENTITY_NAME = "rDN";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final RDNService rDNService;

    public RDNResource(RDNService rDNService) {
        this.rDNService = rDNService;
    }

    @PostMapping(value={"/rdns"})
    public ResponseEntity<RDN> createRDN(@RequestBody RDN rDN) throws URISyntaxException {
        this.log.debug("REST request to save RDN : {}", (Object)rDN);
        if (rDN.getId() != null) {
            throw new BadRequestAlertException("A new rDN cannot already have an ID", ENTITY_NAME, "idexists");
        }
        RDN result = this.rDNService.save(rDN);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/rdns/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/rdns"})
    public ResponseEntity<RDN> updateRDN(@RequestBody RDN rDN) throws URISyntaxException {
        this.log.debug("REST request to update RDN : {}", (Object)rDN);
        if (rDN.getId() == null) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        RDN result = this.rDNService.save(rDN);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)rDN.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/rdns"})
    public List<RDN> getAllRDNS() {
        this.log.debug("REST request to get all RDNS");
        return this.rDNService.findAll();
    }

    @GetMapping(value={"/rdns/{id}"})
    public ResponseEntity<RDN> getRDN(@PathVariable Long id) {
        this.log.debug("REST request to get RDN : {}", (Object)id);
        Optional rDN = this.rDNService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)rDN);
    }

    @DeleteMapping(value={"/rdns/{id}"})
    public ResponseEntity<Void> deleteRDN(@PathVariable Long id) {
        this.log.debug("REST request to delete RDN : {}", (Object)id);
        this.rDNService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }
}

