/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.core.domain.RequestAttributeValue;
import de.trustable.ca3s.core.service.RequestAttributeValueService;
import de.trustable.ca3s.core.web.rest.errors.BadRequestAlertException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class RequestAttributeValueResource {
    private final Logger log = LoggerFactory.getLogger(RequestAttributeValueResource.class);
    private static final String ENTITY_NAME = "requestAttributeValue";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final RequestAttributeValueService requestAttributeValueService;

    public RequestAttributeValueResource(RequestAttributeValueService requestAttributeValueService) {
        this.requestAttributeValueService = requestAttributeValueService;
    }

    @PostMapping(value={"/request-attribute-values"})
    public ResponseEntity<RequestAttributeValue> createRequestAttributeValue(@Valid @RequestBody RequestAttributeValue requestAttributeValue) throws URISyntaxException {
        this.log.debug("REST request to save RequestAttributeValue : {}", (Object)requestAttributeValue);
        if (requestAttributeValue.getId() != null) {
            throw new BadRequestAlertException("A new requestAttributeValue cannot already have an ID", ENTITY_NAME, "idexists");
        }
        RequestAttributeValue result = this.requestAttributeValueService.save(requestAttributeValue);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/request-attribute-values/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/request-attribute-values"})
    public ResponseEntity<RequestAttributeValue> updateRequestAttributeValue(@Valid @RequestBody RequestAttributeValue requestAttributeValue) throws URISyntaxException {
        this.log.debug("REST request to update RequestAttributeValue : {}", (Object)requestAttributeValue);
        if (requestAttributeValue.getId() == null) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        RequestAttributeValue result = this.requestAttributeValueService.save(requestAttributeValue);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)requestAttributeValue.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/request-attribute-values"})
    public List<RequestAttributeValue> getAllRequestAttributeValues() {
        this.log.debug("REST request to get all RequestAttributeValues");
        return this.requestAttributeValueService.findAll();
    }

    @GetMapping(value={"/request-attribute-values/{id}"})
    public ResponseEntity<RequestAttributeValue> getRequestAttributeValue(@PathVariable Long id) {
        this.log.debug("REST request to get RequestAttributeValue : {}", (Object)id);
        Optional requestAttributeValue = this.requestAttributeValueService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)requestAttributeValue);
    }

    @DeleteMapping(value={"/request-attribute-values/{id}"})
    public ResponseEntity<Void> deleteRequestAttributeValue(@PathVariable Long id) {
        this.log.debug("REST request to delete RequestAttributeValue : {}", (Object)id);
        this.requestAttributeValueService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }
}

