/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.core.domain.RequestProxyConfig;
import de.trustable.ca3s.core.service.RequestProxyConfigService;
import de.trustable.ca3s.core.web.rest.errors.BadRequestAlertException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class RequestProxyConfigResource {
    private final Logger log = LoggerFactory.getLogger(RequestProxyConfigResource.class);
    private static final String ENTITY_NAME = "requestProxyConfig";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final RequestProxyConfigService requestProxyConfigService;

    public RequestProxyConfigResource(RequestProxyConfigService requestProxyConfigService) {
        this.requestProxyConfigService = requestProxyConfigService;
    }

    @PostMapping(value={"/request-proxy-configs"})
    public ResponseEntity<RequestProxyConfig> createRequestProxyConfig(@Valid @RequestBody RequestProxyConfig requestProxyConfig) throws URISyntaxException {
        this.log.debug("REST request to save RequestProxyConfig : {}", (Object)requestProxyConfig);
        if (requestProxyConfig.getId() != null) {
            throw new BadRequestAlertException("A new requestProxyConfig cannot already have an ID", ENTITY_NAME, "idexists");
        }
        RequestProxyConfig result = this.requestProxyConfigService.save(requestProxyConfig);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/request-proxy-configs/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/request-proxy-configs"})
    public ResponseEntity<RequestProxyConfig> updateRequestProxyConfig(@Valid @RequestBody RequestProxyConfig requestProxyConfig) throws URISyntaxException {
        this.log.debug("REST request to update RequestProxyConfig : {}", (Object)requestProxyConfig);
        if (requestProxyConfig.getId() == null) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        RequestProxyConfig result = this.requestProxyConfigService.save(requestProxyConfig);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)requestProxyConfig.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/request-proxy-configs"})
    public List<RequestProxyConfig> getAllRequestProxyConfigs() {
        this.log.debug("REST request to get all RequestProxyConfigs");
        return this.requestProxyConfigService.findAll();
    }

    @GetMapping(value={"/request-proxy-configs/{id}"})
    public ResponseEntity<RequestProxyConfig> getRequestProxyConfig(@PathVariable Long id) {
        this.log.debug("REST request to get RequestProxyConfig : {}", (Object)id);
        Optional requestProxyConfig = this.requestProxyConfigService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)requestProxyConfig);
    }

    @DeleteMapping(value={"/request-proxy-configs/{id}"})
    public ResponseEntity<Void> deleteRequestProxyConfig(@PathVariable Long id) {
        this.log.debug("REST request to delete RequestProxyConfig : {}", (Object)id);
        this.requestProxyConfigService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }
}

