/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.core.domain.UserPreference;
import de.trustable.ca3s.core.service.UserPreferenceService;
import de.trustable.ca3s.core.web.rest.errors.BadRequestAlertException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class UserPreferenceResource {
    private final Logger log = LoggerFactory.getLogger(UserPreferenceResource.class);
    private static final String ENTITY_NAME = "userPreference";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final UserPreferenceService userPreferenceService;

    public UserPreferenceResource(UserPreferenceService userPreferenceService) {
        this.userPreferenceService = userPreferenceService;
    }

    @PostMapping(value={"/user-preferences"})
    public ResponseEntity<UserPreference> createUserPreference(@Valid @RequestBody UserPreference userPreference) throws URISyntaxException {
        this.log.debug("REST request to save UserPreference : {}", (Object)userPreference);
        if (userPreference.getId() != null) {
            throw new BadRequestAlertException("A new userPreference cannot already have an ID", ENTITY_NAME, "idexists");
        }
        UserPreference result = this.userPreferenceService.save(userPreference);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/user-preferences/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/user-preferences"})
    public ResponseEntity<UserPreference> updateUserPreference(@Valid @RequestBody UserPreference userPreference) throws URISyntaxException {
        this.log.debug("REST request to update UserPreference : {}", (Object)userPreference);
        if (userPreference.getId() == null) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        UserPreference result = this.userPreferenceService.save(userPreference);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)userPreference.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/user-preferences/{id}"})
    public ResponseEntity<UserPreference> getUserPreference(@PathVariable Long id) {
        this.log.debug("REST request to get UserPreference : {}", (Object)id);
        Optional userPreference = this.userPreferenceService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)userPreference);
    }

    @DeleteMapping(value={"/user-preferences/{id}"})
    public ResponseEntity<Void> deleteUserPreference(@PathVariable Long id) {
        this.log.debug("REST request to delete UserPreference : {}", (Object)id);
        this.userPreferenceService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }
}

