/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest.acme;

import de.trustable.ca3s.core.domain.ACMEAccount;
import de.trustable.ca3s.core.domain.enumeration.AccountStatus;
import de.trustable.ca3s.core.repository.ACMEAccountRepository;
import de.trustable.ca3s.core.repository.AcmeContactRepository;
import de.trustable.ca3s.core.service.dto.acme.AccountRequest;
import de.trustable.ca3s.core.service.dto.acme.AccountResponse;
import de.trustable.ca3s.core.service.dto.acme.problem.AcmeProblemException;
import de.trustable.ca3s.core.service.dto.acme.problem.ProblemDetail;
import de.trustable.ca3s.core.service.util.ACMEUtil;
import de.trustable.ca3s.core.web.rest.acme.ACMEController;
import java.net.URI;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.lang.JoseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;

@Transactional
@Controller
@RequestMapping(value={"/acme/{realm}/newAccount"})
public class NewAccountController
extends ACMEController {
    private static final Logger LOG = LoggerFactory.getLogger(NewAccountController.class);
    @Autowired
    private ACMEAccountRepository acctRepository;
    @Autowired
    AcmeContactRepository contactRepo;

    @RequestMapping(method={RequestMethod.POST}, consumes={"application/jose+json"})
    public ResponseEntity<?> consumingPostedJoseJson(@RequestBody String requestBody, @PathVariable String realm) {
        return this.consumeWithConverter(requestBody, realm);
    }

    @RequestMapping(method={RequestMethod.POST}, consumes={"application/jws"})
    public ResponseEntity<?> consumingPostedJws(@RequestBody String requestBody, @PathVariable String realm) {
        return this.consumeWithConverter(requestBody, realm);
    }

    @Transactional
    ResponseEntity<?> consumeWithConverter(String requestBody, String realm) {
        LOG.info("New ACCOUNT requested for realm {} using requestbody \n {}", (Object)realm, (Object)requestBody);
        HttpHeaders additionalHeaders = this.buildNonceHeader();
        try {
            ACMEAccount acctDaoReturn;
            List accListExisting;
            JwtContext context = this.jwtUtil.processFlattenedJWT(requestBody);
            AccountRequest newAcct = this.jwtUtil.getAccountRequest(context.getJwtClaims());
            LOG.debug("New ACCOUNT reads NewAccountRequest: " + newAcct);
            JsonWebStructure webStruct = this.jwtUtil.getJsonWebStructure(context);
            PublicKey pk = this.jwtUtil.getPublicKey(webStruct);
            if (pk == null) {
                accListExisting = new ArrayList<ACMEAccount>();
                accListExisting.add(this.checkJWTSignatureForAccount(context, realm));
                if (accListExisting.isEmpty()) {
                    LOG.debug("NewAccountRequest does NOT provide key, no matching account found ");
                    ProblemDetail problem = new ProblemDetail(ACMEUtil.ACCOUNT_DOES_NOT_EXIST, "Account does not exist.", HttpStatus.BAD_REQUEST, NO_DETAIL, NO_INSTANCE);
                    throw new AcmeProblemException(problem);
                }
            } else {
                LOG.debug("JWK with public key found : " + pk);
                accListExisting = this.acctRepository.findByPublicKeyHashBase64(this.jwtUtil.getJWKThumbPrint(pk));
                this.jwtUtil.verifyJWT(context, pk);
                LOG.debug("provided public key verifies given JWT: " + pk);
            }
            if (Boolean.TRUE.equals(newAcct.isOnlyReturnExisting())) {
                if (accListExisting.isEmpty()) {
                    ProblemDetail problem = new ProblemDetail(ACMEUtil.ACCOUNT_DOES_NOT_EXIST, "Account does not exist.", HttpStatus.BAD_REQUEST, NO_DETAIL, NO_INSTANCE);
                    throw new AcmeProblemException(problem);
                }
                acctDaoReturn = (ACMEAccount)accListExisting.get(0);
            } else if (accListExisting.isEmpty()) {
                ACMEAccount newAcctDao = new ACMEAccount();
                newAcctDao.setAccountId(Long.valueOf(this.generateId()));
                newAcctDao.setRealm(realm);
                String pkAsString = Base64.encodeBase64String((byte[])pk.getEncoded()).trim();
                newAcctDao.setPublicKey(pkAsString);
                String thumbPrint = this.jwtUtil.getJWKThumbPrint(pk);
                newAcctDao.setPublicKeyHash(thumbPrint);
                if (newAcct.isTermsAgreed() != null) {
                    newAcctDao.setTermsOfServiceAgreed(newAcct.isTermsAgreed());
                } else {
                    newAcctDao.setTermsOfServiceAgreed(Boolean.valueOf(false));
                }
                this.acctRepository.save((Object)newAcctDao);
                this.contactsFromRequest(newAcctDao, newAcct);
                newAcctDao.setStatus(AccountStatus.VALID);
                this.acctRepository.save((Object)newAcctDao);
                LOG.debug("New Account {} created", (Object)newAcctDao.getAccountId());
                acctDaoReturn = newAcctDao;
            } else {
                acctDaoReturn = (ACMEAccount)accListExisting.get(0);
            }
            URI locationUri = this.locationUriOf(acctDaoReturn.getAccountId().longValue(), (UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequestUri());
            String locationHeader = locationUri.toASCIIString();
            LOG.debug("location header set to " + locationHeader);
            additionalHeaders.set("Location", locationHeader);
            AccountResponse accResp = new AccountResponse(acctDaoReturn, (UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequestUri());
            accResp.setOrders(this.locationUriOfOrders(acctDaoReturn.getAccountId().longValue(), (UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequestUri()).toString());
            if (accListExisting.isEmpty()) {
                LOG.debug("returning new account response " + this.jwtUtil.getAccountResponseAsJSON(accResp));
                LOG.debug("created for locationUri '{}' ", (Object)locationUri);
                return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)locationUri).headers(additionalHeaders)).body((Object)accResp);
            }
            LOG.debug("returning existing account response " + this.jwtUtil.getAccountResponseAsJSON(accResp));
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(additionalHeaders)).body((Object)accResp);
        }
        catch (JoseException e) {
            ProblemDetail problem = new ProblemDetail(ACMEUtil.SERVER_INTERNAL, "Algorithm mismatch.", HttpStatus.BAD_REQUEST, NO_DETAIL, NO_INSTANCE);
            return this.buildProblemResponseEntity(new AcmeProblemException(problem));
        }
        catch (AcmeProblemException e) {
            return this.buildProblemResponseEntity(e);
        }
    }

    private URI locationUriOf(long accountId, UriComponentsBuilder uriBuilder) {
        return this.accountResourceUriBuilderFrom(uriBuilder.path("..")).path("/").path(Long.toString(accountId)).build().normalize().toUri();
    }

    private URI locationUriOfOrders(long accountId, UriComponentsBuilder uriBuilder) {
        return this.accountResourceUriBuilderFrom(uriBuilder.path("..")).path("/").path(Long.toString(accountId)).path("/orders").build().normalize().toUri();
    }
}

