/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest.support;

import de.trustable.ca3s.core.domain.Pipeline;
import de.trustable.ca3s.core.repository.CSRRepository;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.repository.PipelineRepository;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import de.trustable.ca3s.core.service.util.PipelineUtil;
import de.trustable.ca3s.core.web.rest.data.PKCSDataType;
import de.trustable.ca3s.core.web.rest.data.Pkcs10RequestHolderShallow;
import de.trustable.ca3s.core.web.rest.data.PkcsXXData;
import de.trustable.ca3s.core.web.rest.data.UploadPrecheckData;
import de.trustable.ca3s.core.web.rest.data.X509CertificateHolderShallow;
import de.trustable.util.CryptoUtil;
import de.trustable.util.Pkcs10RequestHolder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.DecoderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/publicapi"})
public class CSRContentProcessor {
    private final Logger LOG = LoggerFactory.getLogger(CSRContentProcessor.class);
    @Autowired
    private CryptoUtil cryptoUtil;
    @Autowired
    private CSRRepository csrRepository;
    @Autowired
    private CertificateRepository certificateRepository;
    @Autowired
    private CertificateUtil certUtil;
    @Autowired
    private PipelineRepository pipelineRepository;
    @Autowired
    private PipelineUtil pvUtil;

    @PostMapping(value={"/describeContent"})
    public ResponseEntity<PkcsXXData> describeContent(@Valid @RequestBody UploadPrecheckData uploaded) {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        String content = uploaded.getContent();
        this.LOG.debug("REST request to describe a PEM clob : {}", (Object)content);
        PkcsXXData p10ReqData = new PkcsXXData();
        if (content == null || content.trim().isEmpty()) {
            return new ResponseEntity((Object)p10ReqData, HttpStatus.OK);
        }
        try {
            List certList;
            try {
                CertificateFactory factory = CertificateFactory.getInstance("X.509");
                X509Certificate cert = (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(Base64.decode((String)content)));
                content = this.cryptoUtil.x509CertToPem(cert);
                this.LOG.debug("certificate parsed from base64 (non-pem) content");
            }
            catch (IOException | GeneralSecurityException | DecoderException gse) {
                this.LOG.debug("certificate parsing from base64 (non-pem) content failed: {}", (Object)gse.getMessage());
            }
            X509CertificateHolder certHolder = this.cryptoUtil.convertPemToCertificateHolder(content);
            p10ReqData = auth.isAuthenticated() ? new PkcsXXData(certHolder, content, !(certList = this.certificateRepository.findByIssuerSerial(certHolder.getIssuer().toString(), certHolder.getSerialNumber().toString())).isEmpty()) : new PkcsXXData(certHolder, content, false);
            this.LOG.debug("certificate parsed from uploaded PEM content : " + certHolder.getSubject());
        }
        catch (DecoderException de) {
            p10ReqData.setDataType(PKCSDataType.UNKNOWN);
            this.LOG.debug("certificate parsing problem of uploaded content: " + de.getMessage());
        }
        catch (GeneralSecurityException e) {
            this.LOG.debug("not a certificate, trying to parse it as CSR ");
            try {
                Pkcs10RequestHolder p10ReqHolder = this.cryptoUtil.parseCertificateRequest(this.cryptoUtil.convertPemToPKCS10CertificationRequest(content));
                Pkcs10RequestHolderShallow p10ReqHolderShallow = new Pkcs10RequestHolderShallow(p10ReqHolder);
                p10ReqData = new PkcsXXData(p10ReqHolderShallow);
                if (auth.isAuthenticated()) {
                    List csrList = this.csrRepository.findByPublicKeyHash(p10ReqHolder.getPublicKeyHash());
                    this.LOG.debug("public key with hash '{}' used in #{} csrs, yet", (Object)p10ReqHolder.getPublicKeyHash(), (Object)csrList.size());
                    p10ReqData.setCsrPublicKeyPresentInDB(!csrList.isEmpty());
                    Optional optPipeline = this.pipelineRepository.findById((Object)uploaded.getPipelineId());
                    if (optPipeline.isPresent()) {
                        ArrayList messageList = new ArrayList();
                        if (this.pvUtil.isPipelineRestrictionsResolved((Pipeline)optPipeline.get(), p10ReqHolder, uploaded.getArAttributes(), messageList)) {
                            this.LOG.debug("pipeline restrictions for pipeline '{}' solved", (Object)((Pipeline)optPipeline.get()).getName());
                        } else {
                            p10ReqData.setWarnings(messageList.toArray(new String[0]));
                        }
                    } else {
                        this.LOG.info("pipeline id '{}' not found", (Object)uploaded.getPipelineId());
                    }
                    List candidates = this.certUtil.findReplaceCandidates(p10ReqData.getP10Holder().getSans());
                    p10ReqData.setReplacementCandidates(candidates);
                }
            }
            catch (IOException | GeneralSecurityException e2) {
                this.LOG.debug("describeCSR : " + e2.getMessage());
                this.LOG.debug("not a certificate, not a CSR, trying to parse it as a P12 container");
                try {
                    KeyStore pkcs12Store = KeyStore.getInstance("PKCS12", "BC");
                    ByteArrayInputStream bais = new ByteArrayInputStream(Base64.decode((String)content));
                    char[] passphrase = new char[]{};
                    if (uploaded.getPassphrase() != null && uploaded.getPassphrase().trim().length() > 0) {
                        passphrase = uploaded.getPassphrase().toCharArray();
                    }
                    pkcs12Store.load(bais, passphrase);
                    this.LOG.debug("keystore loaded successfully!");
                    ArrayList<X509CertificateHolderShallow> certList = new ArrayList<X509CertificateHolderShallow>();
                    Enumeration<String> en = pkcs12Store.aliases();
                    while (en.hasMoreElements()) {
                        String alias = en.nextElement();
                        this.LOG.debug("iterating keystore, found alias {}, isCertificateEntry {}, isKeyEntry {}", new Object[]{alias, pkcs12Store.isCertificateEntry(alias), pkcs12Store.isKeyEntry(alias)});
                        if (!pkcs12Store.isCertificateEntry(alias) && !pkcs12Store.isKeyEntry(alias)) continue;
                        X509Certificate x509cert = (X509Certificate)pkcs12Store.getCertificate(alias);
                        if (x509cert == null) {
                            this.LOG.debug("alias {} does NOT refer to a certificate entry", (Object)alias);
                            continue;
                        }
                        this.LOG.debug("certificate {} found in PKCS12 for alias {}", (Object)x509cert.getSubjectX500Principal().getName(), (Object)alias);
                        String b64Content = this.cryptoUtil.x509CertToPem(x509cert);
                        X509CertificateHolder certHolder = this.cryptoUtil.convertPemToCertificateHolder(b64Content);
                        X509CertificateHolderShallow x509Holder = new X509CertificateHolderShallow(certHolder);
                        x509Holder.setPemCertificate(b64Content);
                        if (pkcs12Store.isKeyEntry(alias)) {
                            Key key = pkcs12Store.getKey(alias, passphrase);
                            x509Holder.setKeyPresent(true);
                            this.LOG.debug("key {} found alongside certificate in PKCS12 for alias {}", (Object)key, (Object)alias);
                        }
                        certList.add(x509Holder);
                    }
                    p10ReqData = new PkcsXXData();
                    X509CertificateHolderShallow[] chsArr = new X509CertificateHolderShallow[certList.size()];
                    certList.toArray(chsArr);
                    p10ReqData.setCertsHolder(chsArr);
                    p10ReqData.setDataType(PKCSDataType.CONTAINER);
                }
                catch (IOException ioe) {
                    p10ReqData.setPassphraseRequired(true);
                    p10ReqData.setDataType(PKCSDataType.CONTAINER_REQUIRING_PASSPHRASE);
                    this.LOG.debug("p12 missing a passphrase:", (Throwable)ioe);
                }
                catch (DecoderException de) {
                    p10ReqData.setDataType(PKCSDataType.UNKNOWN);
                    this.LOG.debug("p12 parsing problem of uploaded content: " + de.getMessage());
                }
                catch (GeneralSecurityException e3) {
                    this.LOG.debug("general problem with uploaded content: " + e3.getMessage());
                    return new ResponseEntity(HttpStatus.BAD_REQUEST);
                }
            }
        }
        return new ResponseEntity((Object)p10ReqData, HttpStatus.OK);
    }
}

