/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.scepservlet;

import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.domain.CsrAttribute;
import de.trustable.ca3s.core.domain.Pipeline;
import de.trustable.ca3s.core.domain.ProtectedContent;
import de.trustable.ca3s.core.domain.ScepOrder;
import de.trustable.ca3s.core.domain.enumeration.ContentRelationType;
import de.trustable.ca3s.core.domain.enumeration.ProtectedContentType;
import de.trustable.ca3s.core.domain.enumeration.ScepOrderStatus;
import de.trustable.ca3s.core.repository.CSRRepository;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.repository.ProtectedContentRepository;
import de.trustable.ca3s.core.repository.ScepOrderRepository;
import de.trustable.ca3s.core.service.util.CSRUtil;
import de.trustable.ca3s.core.service.util.CertificateProcessingUtil;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import de.trustable.ca3s.core.service.util.CryptoService;
import de.trustable.ca3s.core.service.util.PipelineUtil;
import de.trustable.ca3s.core.service.util.ProtectedContentUtil;
import de.trustable.ca3s.core.service.util.ScepOrderUtil;
import de.trustable.util.CryptoUtil;
import de.trustable.util.Pkcs10RequestHolder;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletException;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.jscep.server.ScepServlet;
import org.jscep.transaction.FailInfo;
import org.jscep.transaction.OperationFailureException;
import org.jscep.transaction.TransactionId;
import org.jscep.transport.response.Capability;
import org.jscep.util.CertificationRequestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class ScepServletImpl
extends ScepServlet {
    private static final long serialVersionUID = 7773233909179939491L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ScepServletImpl.class);
    private static final X500Name pollName = new X500Name("CN=Poll");
    @Autowired
    CertificateRepository certRepository;
    @Autowired
    CSRRepository csrRepository;
    @Autowired
    ScepOrderRepository scepOrderRepository;
    @Autowired
    private CryptoUtil cryptoUtil;
    @Autowired
    private CertificateUtil certUtil;
    @Autowired
    private CertificateProcessingUtil cpUtil;
    @Autowired
    private ScepOrderUtil scepOrderUtil;
    @Autowired
    private ProtectedContentRepository protectedContentRepository;
    @Autowired
    private ProtectedContentUtil protectedContentUtil;
    private final PipelineUtil pipelineUtil;
    public ThreadLocal<Pipeline> threadLocalPipeline = new ThreadLocal();

    public ScepServletImpl(PipelineUtil pipelineUtil) {
        this.pipelineUtil = pipelineUtil;
    }

    public void init() throws ServletException {
    }

    Certificate getCurrentRecepientCert() throws ServletException, OperationFailureException {
        Pipeline pipeline = (Pipeline)this.threadLocalPipeline.get();
        if (pipeline == null) {
            LOGGER.warn("doEnrol: no processing pipeline defined");
            throw new OperationFailureException(FailInfo.badRequest);
        }
        try {
            return this.pipelineUtil.getSCEPRecipientCertificate(pipeline);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private Certificate startCertificateCreationProcess(String csrAsPem, TransactionId transId, Pipeline pipeline, ScepOrder scepOrder) throws OperationFailureException, IOException, GeneralSecurityException {
        Pkcs10RequestHolder p10Holder = this.cryptoUtil.parseCertificateRequest(csrAsPem);
        if (!this.pipelineUtil.isPipelineRestrictionsResolved(pipeline, p10Holder, new ArrayList())) {
            throw new OperationFailureException(FailInfo.badRequest);
        }
        String pipelineName = pipeline == null ? "NoPipeline" : pipeline.getName();
        String requestorName = "SCEP client";
        LOGGER.debug("doEnrol: processing request by {} using pipeline {}", (Object)requestorName, (Object)pipelineName);
        CSR csr = this.cpUtil.buildCSR(csrAsPem, requestorName, "SCEP_CERTIFICATE_REQUESTED", "", pipeline);
        CsrAttribute csrAttributeTransId = new CsrAttribute();
        csrAttributeTransId.setName("CA3S:SCEP_TRANS_ID");
        csrAttributeTransId.setValue(transId.toString());
        csr.addCsrAttributes(csrAttributeTransId);
        this.csrRepository.save((Object)csr);
        scepOrder.setCsr(csr);
        Certificate cert = this.cpUtil.processCertificateRequest(csr, requestorName, "SCEP_CERTIFICATE_CREATED", pipeline);
        if (cert == null) {
            LOGGER.warn("creation of certificate by SCEP transaction id '{}' failed ", (Object)transId);
        } else {
            LOGGER.debug("new certificate id '{}' for SCEP transaction id '{}'", (Object)cert.getId(), (Object)transId);
            scepOrder.setCertificate(cert);
            this.certUtil.setCertAttribute(cert, "CA3S:SCEP_TRANS_ID", transId.toString());
            this.certRepository.save((Object)cert);
        }
        return cert;
    }

    protected List<X509Certificate> doEnrol(PKCS10CertificationRequest csr, X509Certificate sender, TransactionId transId) throws OperationFailureException {
        Pipeline pipeline = (Pipeline)this.threadLocalPipeline.get();
        if (pipeline == null) {
            LOGGER.warn("doEnrol: no processing pipeline defined");
            throw new OperationFailureException(FailInfo.badRequest);
        }
        LOGGER.debug("doEnrol(" + csr.toString() + ", " + transId.toString() + ") using pipeline '{}'", (Object)pipeline.getName());
        ScepOrder scepOrder = new ScepOrder();
        scepOrder.setPipeline(pipeline);
        scepOrder.setRealm(pipeline.getUrlPart());
        scepOrder.setTransId(transId.toString());
        scepOrder.setRequestedOn(Instant.now());
        scepOrder.setRequestedBy(sender.getSubjectX500Principal().getName());
        scepOrder.setStatus(ScepOrderStatus.PENDING);
        scepOrder.setPasswordAuthentication(Boolean.valueOf(false));
        scepOrder.setAsyncProcessing(Boolean.valueOf(false));
        try {
            X500Name subject = X500Name.getInstance((Object)csr.getSubject());
            LOGGER.debug(subject.toString());
            if (subject.equals((Object)pollName)) {
                List<X509Certificate> list = Collections.emptyList();
                return list;
            }
            this.scepOrderUtil.setOrderAttribute(scepOrder, "CN", csr.getSubject().toString());
            this.insertSANs(scepOrder, csr);
            this.scepOrderRepository.save((Object)scepOrder);
            String password = CertificationRequestUtils.getChallengePassword((PKCS10CertificationRequest)csr);
            if (password != null) {
                this.checkPassword(pipeline, password);
                scepOrder.setPasswordAuthentication(Boolean.valueOf(true));
            } else {
                Certificate senderCert = this.certUtil.createCertificate(sender.getEncoded(), null, null, false, "scep sender certificate");
                if (!senderCert.isActive().booleanValue()) {
                    LOGGER.warn("certificate {} not active! Revoked {}, expiring on {}", new Object[]{senderCert.getId(), senderCert.isRevoked(), senderCert.getValidTo()});
                    scepOrder.setStatus(ScepOrderStatus.INVALID);
                    throw new OperationFailureException(FailInfo.badRequest);
                }
                boolean isTrusted = false;
                List senderChain = this.certUtil.getCertificateChain(senderCert);
                for (Certificate chainCert : senderChain) {
                    if (this.certUtil.getCertAttributes(chainCert, "SCEP_TRUSTED_ISSUER").isEmpty()) continue;
                    isTrusted = true;
                    LOGGER.debug("certificate {} valid a scep issuer!", (Object)chainCert.getId());
                    scepOrder.setAuthenticatedBy(chainCert);
                    break;
                }
                if (!isTrusted) {
                    LOGGER.warn("certificate authentication, no valid issuer found!");
                    scepOrder.setStatus(ScepOrderStatus.INVALID);
                    throw new OperationFailureException(FailInfo.badRequest);
                }
            }
            String p10ReqPem = CryptoUtil.pkcs10RequestToPem((PKCS10CertificationRequest)csr);
            Certificate newCertDao = this.startCertificateCreationProcess(p10ReqPem, transId, pipeline, scepOrder);
            if (newCertDao == null) {
                LOGGER.debug("creation of certificate failed");
                scepOrder.setStatus(ScepOrderStatus.INVALID);
                throw new OperationFailureException(FailInfo.badRequest);
            }
            this.certUtil.setCertAttribute(newCertDao, "CA3S:SCEP_TRANS_ID", transId.toString());
            this.certRepository.save((Object)newCertDao);
            ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
            Certificate chainCert = newCertDao;
            for (int i = 0; i < 3; ++i) {
                if (chainCert == null) continue;
                certList.add(CryptoUtil.convertPemToCertificate((String)chainCert.getContent()));
                chainCert = chainCert.getIssuingCertificate();
            }
            for (X509Certificate x509 : certList) {
                LOGGER.debug("--- chain element: " + x509.getSubjectX500Principal().getName());
            }
            scepOrder.setStatus(ScepOrderStatus.READY);
            ArrayList<X509Certificate> arrayList = certList;
            return arrayList;
        }
        catch (Exception e) {
            LOGGER.warn("Error in enrollment", (Throwable)e);
            scepOrder.setStatus(ScepOrderStatus.INVALID);
            throw new OperationFailureException(FailInfo.badRequest);
        }
        finally {
            this.scepOrderRepository.save((Object)scepOrder);
        }
    }

    void checkPassword(Pipeline pipeline, String password) throws OperationFailureException {
        if (password == null || password.isEmpty()) {
            LOGGER.warn("password not present in SCEP request / is empty!");
            throw new OperationFailureException(FailInfo.badRequest);
        }
        List listPC = this.protectedContentRepository.findByTypeRelationId(ProtectedContentType.PASSWORD, ContentRelationType.SCEP_PW, pipeline.getId());
        for (ProtectedContent pc : listPC) {
            String expectedPassword = this.protectedContentUtil.unprotectString(pc.getContentBase64()).trim();
            if (!password.trim().equals(expectedPassword)) continue;
            LOGGER.debug("Protected Content found matching SCEP password");
            return;
        }
        LOGGER.warn("no (active) password present in pipeline '" + pipeline.getName() + "' !");
        throw new OperationFailureException(FailInfo.badRequest);
    }

    protected List<X509Certificate> doGetCaCertificate(String identifier) throws OperationFailureException {
        LOGGER.debug("doGetCaCertificate(" + identifier + ")");
        List<X509Certificate> caList = new ArrayList<X509Certificate>();
        try {
            Certificate recepCert = this.getCurrentRecepientCert();
            caList = this.certUtil.getX509CertificateChainAsList(recepCert);
        }
        catch (GeneralSecurityException | ServletException e) {
            LOGGER.warn("Failed to retrieve CA certificates", e);
        }
        return caList;
    }

    protected X509CRL doGetCrl(X500Name issuer, BigInteger serial) {
        LOGGER.debug("doGetCrl(" + issuer.toString() + ", " + serial.toString(10) + ")");
        return null;
    }

    protected Set<Capability> doCapabilities(String identifier) {
        LOGGER.debug("doCapabilities(" + identifier + ")");
        return EnumSet.of(Capability.RENEWAL, Capability.SCEP_STANDARD, Capability.SHA_256, Capability.SHA_512, Capability.POST_PKI_OPERATION);
    }

    protected List<X509Certificate> doGetCert(X500Name issuer, BigInteger serial) throws OperationFailureException {
        LOGGER.debug("doGetCert(" + issuer.toString() + ", " + serial.toString() + ")");
        List certDaoList = this.certRepository.findByIssuerSerial(issuer.toString(), serial.toString());
        if (certDaoList.isEmpty()) {
            RDN[] rdns;
            LOGGER.debug("no match for doGetCert(" + issuer + ", " + serial + ")");
            for (RDN rdn : rdns = issuer.getRDNs()) {
                AttributeTypeAndValue[] attTVArr;
                for (AttributeTypeAndValue attTV : attTVArr = rdn.getTypesAndValues()) {
                    LOGGER.debug("AttributeTypeAndValue of issuer :" + attTV.getType().toString() + " = " + attTV.getValue().toString());
                }
            }
            RDN[] rdnsIssuer = issuer.getRDNs(BCStyle.CN);
            if (rdnsIssuer.length > 0) {
                String rdnIssuerString = rdnsIssuer[0].getFirst().getValue().toString();
                String paddedSerial = CertificateUtil.getPaddedSerial((String)serial.toString());
                LOGGER.debug("looking for cert('" + rdnIssuerString + "', '" + paddedSerial + "')");
                certDaoList = this.certRepository.findBySearchTermNamed1("SERIAL_PADDED", paddedSerial);
                if (certDaoList.isEmpty()) {
                    LOGGER.warn("looking for cert by padded serial '" + paddedSerial + "' failed, nothing found");
                    throw new OperationFailureException(FailInfo.badCertId);
                }
                if (certDaoList.size() > 1) {
                    LOGGER.warn("looking for cert by padded serial '" + paddedSerial + "' failed, multiple certs found");
                    throw new OperationFailureException(FailInfo.badCertId);
                }
            }
        }
        if (certDaoList.isEmpty()) {
            throw new OperationFailureException(FailInfo.badCertId);
        }
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        for (Certificate certDao : certDaoList) {
            try {
                X509Certificate x509Cert = CryptoUtil.convertPemToCertificate((String)certDao.getContent());
                if (x509Cert.getIssuerX500Principal().getName().equals(issuer.toString())) {
                    LOGGER.debug("issuer match for doGetCert(" + issuer + ", " + serial + ")");
                }
                certList.add(x509Cert);
            }
            catch (GeneralSecurityException e) {
                LOGGER.warn("decoding certificate failed", (Throwable)e);
                throw new OperationFailureException(FailInfo.badRequest);
            }
        }
        return certList;
    }

    protected List<X509Certificate> doGetCertInitial(X500Name issuer, X500Name subject, TransactionId transId) {
        LOGGER.debug("doGetCertInitial(" + issuer.toString() + ", " + subject.toString() + ", " + transId.toString() + ")");
        if (subject.equals((Object)pollName)) {
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    protected List<X509Certificate> getNextCaCertificate(String identifier) {
        LOGGER.debug("getNextCaCertificate(" + identifier + ")");
        return Collections.emptyList();
    }

    protected PrivateKey getRecipientKey() {
        try {
            return this.certUtil.getPrivateKey(this.getCurrentRecepientCert());
        }
        catch (ServletException | OperationFailureException e) {
            LOGGER.warn("problem retrieving recipient's private key", e);
            return null;
        }
    }

    protected X509Certificate getRecipient() {
        try {
            X509Certificate ca = CryptoUtil.convertPemToCertificate((String)this.getCurrentRecepientCert().getContent());
            LOGGER.debug("getRecipient() returns " + ca.toString());
            return ca;
        }
        catch (GeneralSecurityException | ServletException | OperationFailureException e) {
            LOGGER.warn("problem retrieving recipient certificate", e);
            return null;
        }
    }

    protected PrivateKey getSignerKey() {
        LOGGER.debug("getSignerKey(), returning getRecipientKey()");
        return this.getRecipientKey();
    }

    protected X509Certificate getSigner() {
        LOGGER.debug("getSigner(), returning getRecipient()");
        return this.getRecipient();
    }

    protected X509Certificate[] getSignerCertificateChain() {
        LOGGER.debug("getSignerCertificateChain()");
        X509Certificate[] signerChainArr = new X509Certificate[]{};
        try {
            Certificate recepCert = this.getCurrentRecepientCert();
            List certList = this.certUtil.getCertificateChain(recepCert);
            int chainLength = certList.size();
            if (chainLength > 1) {
                signerChainArr = new X509Certificate[chainLength - 1];
                int j = 0;
                for (int i = 1; i < chainLength; ++i) {
                    signerChainArr[j++] = CryptoService.convertPemToCertificate((String)((Certificate)certList.get(i)).getContent());
                }
            }
        }
        catch (GeneralSecurityException | ServletException | OperationFailureException e) {
            LOGGER.warn("Failed to retrieve CA certificates", e);
        }
        return signerChainArr;
    }

    private void insertSANs(ScepOrder scepOrder, PKCS10CertificationRequest csr) {
        Set generalNameSet = CSRUtil.getSANList((Attribute[])csr.getAttributes());
        String allSans = "";
        LOGGER.debug("putting SANs into ScepOrderAttributes");
        for (GeneralName gName : generalNameSet) {
            String sanValue = gName.getName().toString();
            if (0 == gName.getTagNo()) {
                sanValue = "--other value--";
            }
            if (allSans.length() > 0) {
                allSans = allSans + ";";
            }
            allSans = allSans + sanValue;
            this.scepOrderUtil.setOrderAttribute(scepOrder, "SAN", sanValue, true);
            if (2 == gName.getTagNo()) {
                this.scepOrderUtil.setOrderAttribute(scepOrder, "TYPED_SAN", "DNS:" + sanValue, true);
                continue;
            }
            if (7 == gName.getTagNo()) {
                this.scepOrderUtil.setOrderAttribute(scepOrder, "TYPED_SAN", "IP:" + sanValue, true);
                continue;
            }
            if (5 == gName.getTagNo()) {
                this.scepOrderUtil.setOrderAttribute(scepOrder, "TYPED_SAN", "EDI:" + sanValue, true);
                continue;
            }
            if (0 == gName.getTagNo()) {
                this.scepOrderUtil.setOrderAttribute(scepOrder, "TYPED_SAN", "other:" + sanValue, true);
                continue;
            }
            if (8 == gName.getTagNo()) {
                this.scepOrderUtil.setOrderAttribute(scepOrder, "TYPED_SAN", "regID:" + sanValue, true);
                continue;
            }
            if (1 == gName.getTagNo()) {
                this.scepOrderUtil.setOrderAttribute(scepOrder, "TYPED_SAN", "rfc822:" + sanValue, true);
                continue;
            }
            if (6 == gName.getTagNo()) {
                this.scepOrderUtil.setOrderAttribute(scepOrder, "TYPED_SAN", "URI:" + sanValue, true);
                continue;
            }
            if (3 == gName.getTagNo()) {
                this.scepOrderUtil.setOrderAttribute(scepOrder, "TYPED_SAN", "X400:" + sanValue, true);
                continue;
            }
            if (4 == gName.getTagNo()) {
                this.scepOrderUtil.setOrderAttribute(scepOrder, "TYPED_SAN", "DirName:" + sanValue, true);
                continue;
            }
            LOGGER.info("unexpected name / tag '{}' in SANs", (Object)gName.getTagNo());
        }
    }
}

