/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.repository;

import de.trustable.ca3s.core.domain.Certificate_;
import de.trustable.ca3s.core.domain.Pipeline_;
import de.trustable.ca3s.core.domain.ScepOrder;
import de.trustable.ca3s.core.domain.ScepOrder_;
import de.trustable.ca3s.core.domain.enumeration.ScepOrderStatus;
import de.trustable.ca3s.core.repository.ScepOrderRepository;
import de.trustable.ca3s.core.repository.SelectionData;
import de.trustable.ca3s.core.repository.SpecificationsHelper;
import de.trustable.ca3s.core.service.dto.ScepOrderView;
import de.trustable.ca3s.core.service.dto.Selector;
import de.trustable.ca3s.core.service.util.ScepOrderUtil;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ScepOrderSpecifications {
    static Logger logger = LoggerFactory.getLogger(ScepOrderSpecifications.class);
    static final String SORT = "sort";
    static final String ORDER = "order";

    private ScepOrderSpecifications() {
    }

    public static Page<ScepOrderView> handleQueryParamsScepOrderView(EntityManager entityManager, ScepOrderRepository acmeOrderRepository, ScepOrderUtil acmeOrderUtil, CriteriaBuilder cb, Map<String, String[]> parameterMap, List<String> additionalSelectionAttributes) {
        String[] paramArr;
        CriteriaQuery query = cb.createQuery(Object[].class);
        Root root = query.from(ScepOrder.class);
        String sortCol = SpecificationsHelper.getStringValue((String[])parameterMap.get("sort"), (String)"id").trim();
        Selection orderSelection = null;
        String orderDirection = SpecificationsHelper.getStringValue((String[])parameterMap.get("order"), (String)"asc");
        int pageOffset = SpecificationsHelper.getIntValue((String[])parameterMap.get("offset"), (int)0);
        int pagesize = SpecificationsHelper.getIntValue((String[])parameterMap.get("limit"), (int)20);
        ArrayList selectionList = new ArrayList();
        ArrayList<String> colList = new ArrayList<String>();
        Map selectionMap = ScepOrderSpecifications.getSelectionMap(parameterMap);
        String[] columnArr = new String[]{};
        if (parameterMap.containsKey("filter") && (paramArr = parameterMap.get("filter")).length > 0) {
            columnArr = paramArr[0].split(",");
        }
        ArrayList<Predicate> predList = new ArrayList<Predicate>();
        for (String col : columnArr) {
            colList.add(col);
            if (selectionMap.containsKey(col)) {
                List selDataList = (List)selectionMap.get(col);
                for (SelectionData selDataItem : selDataList) {
                    logger.debug("buildPredicate for '{}', selector '{}', value '{}' ", new Object[]{col, selDataItem.selector, selDataItem.value});
                    predList.add(ScepOrderSpecifications.buildPredicate((Root)root, (CriteriaBuilder)cb, (CriteriaQuery)query, (String)col, (String)selDataItem.selector, (String)selDataItem.value, selectionList, additionalSelectionAttributes));
                }
            } else {
                logger.debug("buildPredicate for '{}' without selector ", (Object)col);
                predList.add(ScepOrderSpecifications.buildPredicate((Root)root, (CriteriaBuilder)cb, (CriteriaQuery)query, (String)col, null, (String)"", selectionList, additionalSelectionAttributes));
            }
            if (!col.equals(sortCol)) continue;
            orderSelection = (Selection)selectionList.get(selectionList.size() - 1);
        }
        Predicate pred = null;
        for (Predicate predPart : predList) {
            if (pred == null) {
                pred = predPart;
                continue;
            }
            pred = cb.and((Expression)pred, (Expression)predPart);
        }
        query.where(pred);
        Sort.Direction sortDir = Sort.Direction.ASC;
        if ("asc".equalsIgnoreCase(orderDirection)) {
            query.orderBy(new Order[]{cb.asc((Expression)orderSelection)});
        } else {
            query.orderBy(new Order[]{cb.desc((Expression)orderSelection)});
            sortDir = Sort.Direction.DESC;
        }
        query.multiselect(selectionList);
        TypedQuery typedQuery = entityManager.createQuery(query);
        typedQuery.setMaxResults(pagesize);
        typedQuery.setFirstResult(pageOffset);
        try {
            logger.debug("assembled query: " + ((Query)typedQuery.unwrap(Query.class)).getQueryString());
        }
        catch (Exception e) {
            logger.debug("failed in retrieve sql query", (Throwable)e);
        }
        List listResponse = typedQuery.getResultList();
        ArrayList<ScepOrderView> acmeOrderViewList = new ArrayList<ScepOrderView>();
        for (Object[] objArr : listResponse) {
            if (logger.isDebugEnabled() && objArr.length != colList.size()) {
                logger.debug("objArr len {}, colList len {}", (Object)objArr.length, (Object)colList.size());
            }
            ScepOrderView acmeOrderView = ScepOrderSpecifications.buildScepOrderViewFromObjArr(colList, (Object[])objArr, (ScepOrderRepository)acmeOrderRepository, (ScepOrderUtil)acmeOrderUtil);
            acmeOrderViewList.add(acmeOrderView);
        }
        PageRequest pageable = PageRequest.of((int)(pageOffset / pagesize), (int)pagesize, (Sort.Direction)sortDir, (String[])new String[]{sortCol});
        CriteriaQuery queryCount = cb.createQuery(Long.class);
        Root iRoot = queryCount.from(ScepOrder.class);
        ArrayList<Predicate> predCountList = new ArrayList<Predicate>();
        ArrayList selectionListCount = new ArrayList();
        for (String col : columnArr) {
            colList.add(col);
            if (selectionMap.containsKey(col)) {
                List selDataList = (List)selectionMap.get(col);
                for (SelectionData selDataItem : selDataList) {
                    logger.debug("buildPredicate for '{}', selector '{}', value '{}' ", new Object[]{col, selDataItem.selector, selDataItem.value});
                    predCountList.add(ScepOrderSpecifications.buildPredicate((Root)iRoot, (CriteriaBuilder)cb, (CriteriaQuery)queryCount, (String)col, (String)selDataItem.selector, (String)selDataItem.value, selectionListCount, additionalSelectionAttributes));
                }
                continue;
            }
            logger.debug("buildPredicate for '{}' without selector ", (Object)col);
            predCountList.add(ScepOrderSpecifications.buildPredicate((Root)iRoot, (CriteriaBuilder)cb, (CriteriaQuery)queryCount, (String)col, null, (String)"", selectionListCount, additionalSelectionAttributes));
        }
        Predicate predCount = null;
        for (Predicate predPart : predCountList) {
            if (predCount == null) {
                predCount = predPart;
                continue;
            }
            predCount = cb.and((Expression)predCount, (Expression)predPart);
        }
        queryCount.select((Selection)cb.count((Expression)iRoot));
        queryCount.where((Expression)predCount);
        Long nTotalElements = (Long)entityManager.createQuery(queryCount).getSingleResult();
        logger.debug("buildPredicate selects {} elements ", (Object)nTotalElements);
        return new PageImpl(acmeOrderViewList, (Pageable)pageable, nTotalElements.longValue());
    }

    private static ScepOrderView buildScepOrderViewFromObjArr(ArrayList<String> colList, Object[] objArr, ScepOrderRepository scepOrderRepository, ScepOrderUtil acmeOrderUtil) {
        ScepOrderView scepOrderView = new ScepOrderView();
        int i = 0;
        for (int n = 0; n < colList.size(); ++n) {
            Optional optionalScepOrder;
            if (!"id".equalsIgnoreCase(colList.get(n)) || !(optionalScepOrder = scepOrderRepository.findById((Object)((Long)objArr[i]))).isPresent()) continue;
            scepOrderView = acmeOrderUtil.from((ScepOrder)optionalScepOrder.get());
        }
        for (String attribute : colList) {
            if (i >= objArr.length) {
                logger.debug("attribute '{}' exceeds objArr with #{} elements ", (Object)attribute, (Object)objArr.length);
                continue;
            }
            logger.debug("attribute '{}' has value '{}'", (Object)attribute, objArr[i]);
            if ("id".equalsIgnoreCase(attribute)) {
                scepOrderView.setId((Long)objArr[i]);
            } else if ("status".equalsIgnoreCase(attribute)) {
                scepOrderView.setStatus((ScepOrderStatus)objArr[i]);
            } else if ("transId".equalsIgnoreCase(attribute)) {
                scepOrderView.setTransId((String)objArr[i]);
            } else if ("realm".equalsIgnoreCase(attribute)) {
                scepOrderView.setRealm((String)objArr[i]);
            } else if ("pipelineName".equalsIgnoreCase(attribute)) {
                scepOrderView.setPipelineName((String)objArr[i]);
            } else if ("requestedOn".equalsIgnoreCase(attribute)) {
                scepOrderView.setRequestedOn((Instant)objArr[i]);
            } else if ("requestedBy".equalsIgnoreCase(attribute)) {
                scepOrderView.setRequestedBy((String)objArr[i]);
            } else if ("subject".equalsIgnoreCase(attribute)) {
                scepOrderView.setSubject((String)objArr[i]);
            } else if ("sans".equalsIgnoreCase(attribute)) {
                scepOrderView.setSans((String)objArr[i]);
            } else {
                logger.warn("unexpected attribute '{}' from query", (Object)attribute);
            }
            ++i;
        }
        return scepOrderView;
    }

    static Map<String, List<SelectionData>> getSelectionMap(Map<String, String[]> parameterMap) {
        HashMap<String, List<SelectionData>> selectorMap = new HashMap<String, List<SelectionData>>();
        for (int n = 1; n < 20; ++n) {
            String paramNameAttribute = "attributeName_" + n;
            logger.debug("paramNameAttribute {} ", (Object)paramNameAttribute);
            if (!parameterMap.containsKey(paramNameAttribute)) break;
            String attribute = SpecificationsHelper.getStringValue((String[])parameterMap.get(paramNameAttribute));
            if (attribute.length() == 0) {
                logger.debug("paramNameAttribute {} has no value", (Object)paramNameAttribute);
                continue;
            }
            String paramNameAttributeSelector = "attributeSelector_" + n;
            String attributeSelector = SpecificationsHelper.getStringValue((String[])parameterMap.get(paramNameAttributeSelector));
            if (attributeSelector.length() == 0) {
                logger.debug("paramNameAttributeSelector {} has no value", (Object)paramNameAttributeSelector);
                continue;
            }
            String paramNameAttributeValue = "attributeValue_" + n;
            String attributeValue = SpecificationsHelper.getStringValue((String[])parameterMap.get(paramNameAttributeValue));
            if (attributeValue.length() == 0 && Selector.requiresValue((String)attributeSelector)) {
                logger.debug("paramNameAttributeValue {} has no value", (Object)paramNameAttributeValue);
                continue;
            }
            logger.debug("Attribute {} selecting by {} for value {}", new Object[]{attribute, attributeSelector, attributeValue});
            SelectionData selData = new SelectionData(attributeSelector, attributeValue);
            if (selectorMap.containsKey(attribute)) {
                logger.debug("adding selector to exiting list for '{}'", (Object)attribute);
                ((List)selectorMap.get(attribute)).add(selData);
                continue;
            }
            logger.debug("creating new selector list for '{}'", (Object)attribute);
            ArrayList<SelectionData> selectorList = new ArrayList<SelectionData>();
            selectorList.add(selData);
            selectorMap.put(attribute, selectorList);
        }
        return selectorMap;
    }

    private static Predicate buildPredicate(Root<ScepOrder> root, CriteriaBuilder cb, CriteriaQuery<?> query, String attribute, String attributeSelector, String attributeValue, List<Selection<?>> selectionList, List<String> selectionAttributes) {
        Predicate pred = cb.conjunction();
        if ("id".equals(attribute)) {
            SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(ScepOrder_.id));
            if (attributeValue.trim().length() > 0) {
                pred = SpecificationsHelper.buildPredicateLong((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(ScepOrder_.id), (String)attributeValue);
            }
        } else if ("transId".equals(attribute)) {
            SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(ScepOrder_.transId));
            if (attributeValue.trim().length() > 0) {
                pred = SpecificationsHelper.buildPredicateString((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(ScepOrder_.transId), (String)attributeValue);
            }
        } else if ("status".equals(attribute)) {
            SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(ScepOrder_.status));
            if (attributeValue.trim().length() > 0) {
                pred = ScepOrderSpecifications.buildPredicateOrderStatus((String)attributeSelector, (CriteriaBuilder)cb, (Path)root.get(ScepOrder_.status), (String)attributeValue);
            }
        } else if ("realm".equals(attribute)) {
            SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(ScepOrder_.realm));
            if (attributeValue.trim().length() > 0) {
                pred = SpecificationsHelper.buildPredicateString((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(ScepOrder_.realm), (String)attributeValue.toLowerCase());
            }
        } else if ("pipelineName".equals(attribute)) {
            Join accJoin = root.join(ScepOrder_.pipeline, JoinType.LEFT);
            SpecificationsHelper.addNewColumn(selectionList, (Selection)accJoin.get(Pipeline_.name));
            if (attributeValue.trim().length() > 0) {
                pred = SpecificationsHelper.buildPredicateString((String)attributeSelector, (CriteriaBuilder)cb, (Expression)accJoin.get(Pipeline_.name), (String)attributeValue.toLowerCase());
            }
        } else if ("requestedOn".equals(attribute)) {
            SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(ScepOrder_.requestedOn));
            if (attributeValue.trim().length() > 0) {
                pred = SpecificationsHelper.buildDatePredicate((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(ScepOrder_.requestedOn), (String)attributeValue);
            }
        } else if ("requestedBy".equals(attribute)) {
            SpecificationsHelper.addNewColumn(selectionList, (Selection)root.get(ScepOrder_.requestedBy));
            if (attributeValue.trim().length() > 0) {
                pred = SpecificationsHelper.buildPredicateString((String)attributeSelector, (CriteriaBuilder)cb, (Expression)root.get(ScepOrder_.requestedBy), (String)attributeValue.toLowerCase());
            }
        } else if ("subject".equals(attribute)) {
            Join accJoin = root.join(ScepOrder_.certificate, JoinType.LEFT);
            SpecificationsHelper.addNewColumn(selectionList, (Selection)accJoin.get(Certificate_.subject));
            if (attributeValue.trim().length() > 0) {
                pred = SpecificationsHelper.buildPredicateString((String)attributeSelector, (CriteriaBuilder)cb, (Expression)accJoin.get(Certificate_.subject), (String)attributeValue.toLowerCase());
            }
        } else if ("sans".equals(attribute)) {
            Join accJoin = root.join(ScepOrder_.certificate, JoinType.LEFT);
            SpecificationsHelper.addNewColumn(selectionList, (Selection)accJoin.get(Certificate_.sans));
            if (attributeValue.trim().length() > 0) {
                pred = SpecificationsHelper.buildPredicateString((String)attributeSelector, (CriteriaBuilder)cb, (Expression)accJoin.get(Certificate_.sans), (String)attributeValue.toLowerCase());
            }
        } else {
            logger.warn("fall-thru clause adding 'true' condition for {} ", (Object)attribute);
        }
        return pred;
    }

    private static Predicate buildPredicateOrderStatus(String attributeSelector, CriteriaBuilder cb, Path<ScepOrderStatus> path, String attributeValue) {
        ScepOrderStatus orderStatus;
        if (attributeSelector == null) {
            return cb.conjunction();
        }
        try {
            orderStatus = ScepOrderStatus.valueOf((String)attributeValue);
        }
        catch (IllegalArgumentException iae) {
            logger.debug("buildPredicateAccountStatus not an ACMEStatus ", (Throwable)iae);
            return cb.disjunction();
        }
        if (Selector.EQUAL.toString().equals(attributeSelector)) {
            logger.debug("buildPredicateAccountStatus equal ('{}') for value '{}'", (Object)attributeSelector, (Object)orderStatus);
            return cb.equal(path, (Object)orderStatus);
        }
        if (Selector.NOT_EQUAL.toString().equals(attributeSelector)) {
            logger.debug("buildPredicateAccountStatus notEqual ('{}') for value '{}'", (Object)attributeSelector, (Object)orderStatus);
            return cb.notEqual(path, (Object)orderStatus);
        }
        logger.debug("buildPredicateAccountStatus defaults to equals ('{}') for value '{}'", (Object)attributeSelector, (Object)orderStatus);
        return cb.equal(path, (Object)orderStatus);
    }
}

