/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.schedule;

import de.trustable.ca3s.core.domain.AcmeOrder;
import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.domain.Pipeline;
import de.trustable.ca3s.core.domain.enumeration.PipelineType;
import de.trustable.ca3s.core.repository.AcmeOrderRepository;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.repository.PipelineRepository;
import de.trustable.ca3s.core.service.AuditService;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import de.trustable.ca3s.core.service.util.CryptoService;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(propagation=Propagation.REQUIRES_NEW)
public class SchemaUpdateScheduler {
    transient Logger LOG = LoggerFactory.getLogger(SchemaUpdateScheduler.class);
    static final int MAX_RECORDS_PER_TRANSACTION = 10000;
    private final CertificateRepository certificateRepo;
    private final CertificateUtil certUtil;
    private final AcmeOrderRepository acmeOrderRepository;
    private final PipelineRepository pipelineRepository;
    private final AuditService auditService;

    public SchemaUpdateScheduler(CertificateRepository certificateRepo, CertificateUtil certUtil, AcmeOrderRepository acmeOrderRepository, PipelineRepository pipelineRepository, AuditService auditService) {
        this.certificateRepo = certificateRepo;
        this.certUtil = certUtil;
        this.acmeOrderRepository = acmeOrderRepository;
        this.pipelineRepository = pipelineRepository;
        this.auditService = auditService;
    }

    @Scheduled(fixedDelay=60000L)
    public void performSchemaApdates() {
        Instant now = Instant.now();
        this.updateCertificateAttributes();
        this.LOG.info("updateCertificateAttributes took {} ms", (Object)Duration.between(now, Instant.now()));
        now = Instant.now();
        this.updateACMEOrder();
        this.LOG.info("updateACMEOrder took {} ms", (Object)Duration.between(now, Instant.now()));
    }

    public void updateCertificateAttributes() {
        List updateCertificateList = this.certificateRepo.findByAttributeValueLowerThan("ATTRIBUTES_VERSION", "4");
        int count = 0;
        for (Certificate cert : updateCertificateList) {
            try {
                int currentVersion = Integer.parseInt(this.certUtil.getCertAttribute(cert, "ATTRIBUTES_VERSION"));
                X509Certificate x509Cert = CryptoService.convertPemToCertificate((String)cert.getContent());
                if (currentVersion < 4) {
                    this.certUtil.interpretBasicConstraint(x509Cert, cert);
                }
                this.certUtil.addAdditionalCertificateAttributes(x509Cert, cert);
                this.certificateRepo.save((Object)cert);
                this.LOG.info("attribute schema updated for certificate id {} ", (Object)cert.getId());
            }
            catch (IOException | GeneralSecurityException e) {
                this.LOG.error("problem with attribute schema update for certificate id " + cert.getId(), (Throwable)e);
            }
            if (count++ <= 10000) continue;
            this.LOG.info("limited certificate validity processing to {} per call", (Object)10000);
            break;
        }
        if (count > 0) {
            this.auditService.saveAuditTrace(this.auditService.createAuditTraceCertificateSchemaUpdated(count, 4));
        }
    }

    public void updateACMEOrder() {
        Instant now = Instant.now();
        List acmeOrderList = this.acmeOrderRepository.findPipelineIsNull();
        int count = 0;
        for (AcmeOrder acmeOrder : acmeOrderList) {
            String realm = acmeOrder.getAccount().getRealm();
            List pipelineList = this.pipelineRepository.findByTypeUrl(PipelineType.ACME, realm);
            if (!pipelineList.isEmpty()) {
                acmeOrder.setPipeline((Pipeline)pipelineList.get(0));
                acmeOrder.setRealm(realm);
                this.acmeOrderRepository.save((Object)acmeOrder);
                this.LOG.info("realm and pipeljne updated for acme order {} ", (Object)acmeOrder);
            }
            if (count++ <= 10000) continue;
            this.LOG.info("limited AcmeOrder processing to {} per call", (Object)10000);
            break;
        }
        if (count > 0) {
            this.auditService.saveAuditTrace(this.auditService.createAuditTraceAcmeOrderPipelineUpdated(count));
        }
    }
}

