/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.core.domain.CAConnectorConfig;
import de.trustable.ca3s.core.domain.ProtectedContent;
import de.trustable.ca3s.core.domain.enumeration.CAConnectorType;
import de.trustable.ca3s.core.domain.enumeration.ContentRelationType;
import de.trustable.ca3s.core.domain.enumeration.Interval;
import de.trustable.ca3s.core.domain.enumeration.ProtectedContentType;
import de.trustable.ca3s.core.exception.BadRequestAlertException;
import de.trustable.ca3s.core.repository.CAConnectorConfigRepository;
import de.trustable.ca3s.core.repository.ProtectedContentRepository;
import de.trustable.ca3s.core.service.AuditService;
import de.trustable.ca3s.core.service.CAConnectorConfigService;
import de.trustable.ca3s.core.service.dto.CAConnectorStatus;
import de.trustable.ca3s.core.service.util.CaConnectorAdapter;
import de.trustable.ca3s.core.service.util.ProtectedContentUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class CAConnectorConfigResource {
    public static final String PLAIN_SECRET_PLACEHOLDER = "******";
    private final Logger log = LoggerFactory.getLogger(CAConnectorConfigResource.class);
    private static final String ENTITY_NAME = "cAConnectorConfig";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final ProtectedContentUtil protUtil;
    private final ProtectedContentRepository protContentRepository;
    private final CAConnectorConfigRepository caConfigRepository;
    private final CaConnectorAdapter caConnectorAdapter;
    private final AuditService auditService;
    private final CAConnectorConfigService cAConnectorConfigService;

    public CAConnectorConfigResource(CAConnectorConfigService cAConnectorConfigService, ProtectedContentUtil protUtil, ProtectedContentRepository protContentRepository, CAConnectorConfigRepository caConfigRepository, CaConnectorAdapter caConnectorAdapter, AuditService auditService) {
        this.protUtil = protUtil;
        this.protContentRepository = protContentRepository;
        this.caConfigRepository = caConfigRepository;
        this.cAConnectorConfigService = cAConnectorConfigService;
        this.caConnectorAdapter = caConnectorAdapter;
        this.auditService = auditService;
    }

    @PostMapping(value={"/ca-connector-configs"})
    public ResponseEntity<CAConnectorConfig> createCAConnectorConfig(@Valid @RequestBody CAConnectorConfig cAConnectorConfig) throws URISyntaxException {
        this.log.debug("REST request to save CAConnectorConfig : {}", (Object)cAConnectorConfig);
        if (cAConnectorConfig.getId() != null) {
            throw new BadRequestAlertException("A new cAConnectorConfig cannot already have an ID", ENTITY_NAME, "idexists");
        }
        if (CAConnectorType.ADCS_CERTIFICATE_INVENTORY.equals((Object)cAConnectorConfig.getCaConnectorType()) && cAConnectorConfig.getPollingOffset() == null) {
            cAConnectorConfig.setPollingOffset(Integer.valueOf(0));
        }
        if (cAConnectorConfig.getPlainSecret() == null || cAConnectorConfig.getPlainSecret().trim().length() == 0) {
            this.log.debug("REST request to save CAConnectorConfig : cAConnectorConfig.getPlainSecret() == null");
            cAConnectorConfig.setSecret(null);
            cAConnectorConfig.setPlainSecret("");
        } else {
            if (this.protUtil == null) {
                this.log.warn("Autowired 'protUtil' failed ...");
            }
            ProtectedContent protSecret = this.protUtil.createProtectedContent(cAConnectorConfig.getPlainSecret(), ProtectedContentType.PASSWORD, ContentRelationType.CONNECTION, -1L);
            this.protContentRepository.save((Object)protSecret);
            cAConnectorConfig.setSecret(protSecret);
            cAConnectorConfig.setPlainSecret(PLAIN_SECRET_PLACEHOLDER);
        }
        CAConnectorConfig result = this.cAConnectorConfigService.save(cAConnectorConfig);
        this.auditService.saveAuditTrace(this.auditService.createAuditTraceCAConfigCreated(cAConnectorConfig));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/ca-connector-configs/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @Transactional
    @PutMapping(value={"/ca-connector-configs"})
    public ResponseEntity<CAConnectorConfig> updateCAConnectorConfig(@Valid @RequestBody CAConnectorConfig cAConnectorConfig) throws URISyntaxException {
        this.log.debug("REST request to update CAConnectorConfig : {}", (Object)cAConnectorConfig);
        if (cAConnectorConfig.getId() == null) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        if (cAConnectorConfig.getPlainSecret() == null || cAConnectorConfig.getPlainSecret().trim().length() == 0) {
            this.log.debug("REST request to update CAConnectorConfig : cAConnectorConfig.getPlainSecret() == null");
            if (cAConnectorConfig.getSecret() != null) {
                this.log.debug("REST request to update CAConnectorConfig : protContentRepository.delete() ");
                this.auditService.saveAuditTrace(this.auditService.createAuditTraceCAConfigSecretChanged(cAConnectorConfig));
                this.protContentRepository.delete((Object)cAConnectorConfig.getSecret());
            }
            cAConnectorConfig.setSecret(null);
            cAConnectorConfig.setPlainSecret("");
        } else if (PLAIN_SECRET_PLACEHOLDER.equals(cAConnectorConfig.getPlainSecret().trim())) {
            this.log.debug("REST request to update CAConnectorConfig : PLAIN_SECRET_PLACEHOLDER.equals(cAConnectorConfig.getPlainSecret())");
            cAConnectorConfig.setSecret(((CAConnectorConfig)this.caConfigRepository.getOne((Object)cAConnectorConfig.getId())).getSecret());
        } else {
            this.log.debug("REST request to update CAConnectorConfig : PlainSecret modified");
            this.auditService.saveAuditTrace(this.auditService.createAuditTraceCAConfigSecretChanged(cAConnectorConfig));
            if (cAConnectorConfig.getSecret() != null) {
                this.log.debug("REST request to update CAConnectorConfig : protContentRepository.delete() ");
                this.protContentRepository.delete((Object)cAConnectorConfig.getSecret());
            }
            if (this.protUtil == null) {
                this.log.warn("Autowired 'protUtil' failed ...");
            }
            ProtectedContent protSecret = this.protUtil.createProtectedContent(cAConnectorConfig.getPlainSecret(), ProtectedContentType.PASSWORD, ContentRelationType.CONNECTION, cAConnectorConfig.getId().longValue());
            this.protContentRepository.save((Object)protSecret);
            cAConnectorConfig.setSecret(protSecret);
            cAConnectorConfig.setPlainSecret(PLAIN_SECRET_PLACEHOLDER);
        }
        if (cAConnectorConfig.isDefaultCA().booleanValue()) {
            for (CAConnectorConfig other : this.caConfigRepository.findAll()) {
                if (other.getId().equals(cAConnectorConfig.getId()) || !other.isDefaultCA().booleanValue()) continue;
                this.log.debug("REST request to update CAConnectorConfig : remove 'defaultCA' flag from caConfig {} ", (Object)other.getId());
                other.setDefaultCA(Boolean.valueOf(false));
                this.caConfigRepository.save((Object)other);
            }
        }
        this.logChangesCAConnectorConfig(cAConnectorConfig);
        CAConnectorConfig result = this.cAConnectorConfigService.save(cAConnectorConfig);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)cAConnectorConfig.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/ca-connector-configs/status"})
    @PreAuthorize(value="isAuthenticated()")
    public List<CAConnectorStatus> getCAConnectorStatus() {
        return this.caConnectorAdapter.getCAConnectorStatus();
    }

    @GetMapping(value={"/ca-connector-configs"})
    public List<CAConnectorConfig> getAllCAConnectorConfigs() {
        this.log.debug("REST request to get all CAConnectorConfigs");
        return this.cAConnectorConfigService.findAll();
    }

    @GetMapping(value={"/ca-connector-configs/{id}"})
    public ResponseEntity<CAConnectorConfig> getCAConnectorConfig(@PathVariable Long id) {
        this.log.debug("REST request to get CAConnectorConfig : {}", (Object)id);
        Optional cAConnectorConfig = this.cAConnectorConfigService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)cAConnectorConfig);
    }

    @DeleteMapping(value={"/ca-connector-configs/{id}"})
    public ResponseEntity<Void> deleteCAConnectorConfig(@PathVariable Long id) {
        this.log.debug("REST request to delete CAConnectorConfig : {}", (Object)id);
        Optional optConnector = this.cAConnectorConfigService.findOne(id);
        if (optConnector.isPresent()) {
            this.auditService.saveAuditTrace(this.auditService.createAuditTraceCAConfigDeleted((CAConnectorConfig)optConnector.get()));
        }
        this.cAConnectorConfigService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }

    void logChangesCAConnectorConfig(CAConnectorConfig cAConnectorConfig) {
        Optional optConnector = this.cAConnectorConfigService.findOne(cAConnectorConfig.getId());
        if (optConnector.isPresent()) {
            CAConnectorConfig oldConnector = (CAConnectorConfig)optConnector.get();
            this.logDiff("Name", oldConnector.getName(), cAConnectorConfig.getName(), cAConnectorConfig);
            this.logDiff("CaConnectorType", oldConnector.getCaConnectorType().name(), cAConnectorConfig.getCaConnectorType().name(), cAConnectorConfig);
            this.logDiff("CaUrl", oldConnector.getCaUrl(), cAConnectorConfig.getCaUrl(), cAConnectorConfig);
            this.logDiff("Interval", oldConnector.getInterval(), cAConnectorConfig.getInterval(), cAConnectorConfig);
            this.logDiff("PollingOffset", "" + oldConnector.getPollingOffset(), "" + cAConnectorConfig.getPollingOffset(), cAConnectorConfig);
            this.logDiff("Selector", oldConnector.getSelector(), cAConnectorConfig.getSelector(), cAConnectorConfig);
            this.logDiff("TrustSelfSigned", oldConnector.getTrustSelfsignedCertificates().toString(), cAConnectorConfig.getTrustSelfsignedCertificates().toString(), cAConnectorConfig);
        }
    }

    void logDiff(String attributeName, Interval oldVal, Interval newVal, CAConnectorConfig cAConnectorConfig) {
        if (oldVal == null && newVal == null) {
            return;
        }
        String oldString = oldVal == null ? "" : oldVal.toString();
        String newString = newVal == null ? "" : newVal.toString();
        this.logDiff(attributeName, oldString, newString, cAConnectorConfig);
    }

    void logDiff(String attributeName, String oldVal, String newVal, CAConnectorConfig cAConnectorConfig) {
        if (oldVal != null) {
            if (!oldVal.equals(newVal)) {
                this.auditService.saveAuditTrace(this.auditService.createAuditTraceCAConfigCreatedChange(attributeName, oldVal, newVal, cAConnectorConfig));
            }
        } else if (newVal != null) {
            this.auditService.saveAuditTrace(this.auditService.createAuditTraceCAConfigCreatedChange(attributeName, "", newVal, cAConnectorConfig));
        }
    }
}

