/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import com.opencsv.bean.ColumnPositionMappingStrategy;
import com.opencsv.bean.StatefulBeanToCsv;
import com.opencsv.bean.StatefulBeanToCsvBuilder;
import com.opencsv.exceptions.CsvDataTypeMismatchException;
import com.opencsv.exceptions.CsvRequiredFieldEmptyException;
import de.trustable.ca3s.core.domain.User;
import de.trustable.ca3s.core.repository.CSRViewRepository;
import de.trustable.ca3s.core.repository.PipelineAttributeRepository;
import de.trustable.ca3s.core.repository.UserRepository;
import de.trustable.ca3s.core.service.dto.CSRView;
import de.trustable.ca3s.core.web.rest.CertificateListResource;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;
import tech.jhipster.web.util.PaginationUtil;

@RestController
@RequestMapping(value={"/api"})
public class CSRListResource {
    private final Logger log = LoggerFactory.getLogger(CSRListResource.class);
    private final CSRViewRepository csrViewRepository;
    private final UserRepository userRepository;
    private final PipelineAttributeRepository pipelineAttributeRepository;

    public CSRListResource(CSRViewRepository csrViewRepository, UserRepository userRepository, PipelineAttributeRepository pipelineAttributeRepository) {
        this.csrViewRepository = csrViewRepository;
        this.userRepository = userRepository;
        this.pipelineAttributeRepository = pipelineAttributeRepository;
    }

    @GetMapping(value={"/csrList"})
    public ResponseEntity<List<CSRView>> getAllCsrs(Pageable pageable, HttpServletRequest request) {
        this.log.debug("REST request to get a page of CSRViews");
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        String userName = auth.getName();
        if (userName == null) {
            this.log.warn("Current user == null!");
            return ResponseEntity.notFound().build();
        }
        Optional optCurrentUser = this.userRepository.findOneByLogin(userName);
        if (!optCurrentUser.isPresent()) {
            this.log.warn("Name of ra officer '{}' not found as user", (Object)userName);
            return ResponseEntity.notFound().build();
        }
        List pipelineIdList = this.pipelineAttributeRepository.findDistinctPipelineByNameAndValue("DOMAIN_RA_OFFICER", "" + ((User)optCurrentUser.get()).getId());
        Page page = this.csrViewRepository.findSelection(request.getParameterMap(), pipelineIdList);
        HttpHeaders headers = PaginationUtil.generatePaginationHttpHeaders((UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequest(), (Page)page);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)page.getContent());
    }

    @GetMapping(value={"/csrListCSV"})
    public ResponseEntity<String> getAllCsrAsCSV(Pageable pageable, HttpServletRequest request) {
        this.log.debug("REST request to get a page of CSRView");
        HashMap<String, String[]> paramMap = new HashMap<String, String[]>();
        for (String key : request.getParameterMap().keySet()) {
            if (key == "offset" || key == "limit") continue;
            paramMap.put(key, (String[])request.getParameterMap().get(key));
        }
        paramMap.put("offset", new String[]{"0"});
        paramMap.put("limit", new String[]{"1000"});
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        String userName = auth.getName();
        if (userName == null) {
            this.log.warn("Current user == null!");
            return ResponseEntity.notFound().build();
        }
        Optional optCurrentUser = this.userRepository.findOneByLogin(userName);
        if (!optCurrentUser.isPresent()) {
            this.log.warn("Name of ra officer '{}' not found as user", (Object)userName);
            return ResponseEntity.notFound().build();
        }
        List pipelineIdList = this.pipelineAttributeRepository.findDistinctPipelineByNameAndValue("DOMAIN_RA_OFFICER", "" + ((User)optCurrentUser.get()).getId());
        Page page = this.csrViewRepository.findSelection(paramMap, pipelineIdList);
        ArrayList<CSRView> cvList = new ArrayList<CSRView>();
        for (CSRView cv : page.getContent()) {
            Optional optionalCSRView = this.csrViewRepository.findbyCSRId(cv.getId());
            if (!optionalCSRView.isPresent()) continue;
            cvList.add((CSRView)optionalCSRView.get());
            this.log.debug("returning csr #{}", (Object)cv.getId());
        }
        StringWriter writer = new StringWriter();
        ColumnPositionMappingStrategy mappingStrategy = new ColumnPositionMappingStrategy();
        mappingStrategy.setType(CSRView.class);
        StatefulBeanToCsv beanToCsv = new StatefulBeanToCsvBuilder((Writer)writer).withSeparator(';').withApplyQuotesToAll(false).withQuotechar('\"').build();
        try {
            beanToCsv.write(cvList);
        }
        catch (CsvDataTypeMismatchException | CsvRequiredFieldEmptyException e) {
            this.log.warn("problem building csv response", e);
            return ResponseEntity.badRequest().build();
        }
        return ResponseEntity.ok().contentType(CertificateListResource.TEXT_CSV_TYPE).body((Object)((Object)writer).toString());
    }
}

