/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.core.domain.CertificateAttribute;
import de.trustable.ca3s.core.exception.BadRequestAlertException;
import de.trustable.ca3s.core.repository.CertificateAttributeRepository;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
@Transactional
public class CertificateAttributeResource {
    private final Logger log = LoggerFactory.getLogger(CertificateAttributeResource.class);
    private static final String ENTITY_NAME = "certificateAttribute";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final CertificateAttributeRepository certificateAttributeRepository;

    public CertificateAttributeResource(CertificateAttributeRepository certificateAttributeRepository) {
        this.certificateAttributeRepository = certificateAttributeRepository;
    }

    @PostMapping(value={"/certificate-attributes"})
    public ResponseEntity<CertificateAttribute> createCertificateAttribute(@Valid @RequestBody CertificateAttribute certificateAttribute) throws URISyntaxException {
        this.log.debug("REST request to save CertificateAttribute : {}", (Object)certificateAttribute);
        if (certificateAttribute.getId() != null) {
            throw new BadRequestAlertException("A new certificateAttribute cannot already have an ID", ENTITY_NAME, "idexists");
        }
        CertificateAttribute result = (CertificateAttribute)this.certificateAttributeRepository.save((Object)certificateAttribute);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/certificate-attributes/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/certificate-attributes"})
    public ResponseEntity<CertificateAttribute> updateCertificateAttribute(@Valid @RequestBody CertificateAttribute certificateAttribute) throws URISyntaxException {
        this.log.debug("REST request to update CertificateAttribute : {}", (Object)certificateAttribute);
        if (certificateAttribute.getId() == null) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        CertificateAttribute result = (CertificateAttribute)this.certificateAttributeRepository.save((Object)certificateAttribute);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)certificateAttribute.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/certificate-attributes"})
    public List<CertificateAttribute> getAllCertificateAttributes() {
        this.log.debug("REST request to get all CertificateAttributes");
        return this.certificateAttributeRepository.findAll();
    }

    @GetMapping(value={"/certificate-attributes/{id}"})
    public ResponseEntity<CertificateAttribute> getCertificateAttribute(@PathVariable Long id) {
        this.log.debug("REST request to get CertificateAttribute : {}", (Object)id);
        Optional certificateAttribute = this.certificateAttributeRepository.findById((Object)id);
        return ResponseUtil.wrapOrNotFound((Optional)certificateAttribute);
    }

    @DeleteMapping(value={"/certificate-attributes/{id}"})
    public ResponseEntity<Void> deleteCertificateAttribute(@PathVariable Long id) {
        this.log.debug("REST request to delete CertificateAttribute : {}", (Object)id);
        this.certificateAttributeRepository.deleteById((Object)id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }
}

