/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.core.domain.CsrAttribute;
import de.trustable.ca3s.core.exception.BadRequestAlertException;
import de.trustable.ca3s.core.service.CsrAttributeService;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class CsrAttributeResource {
    private final Logger log = LoggerFactory.getLogger(CsrAttributeResource.class);
    private static final String ENTITY_NAME = "csrAttribute";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final CsrAttributeService csrAttributeService;

    public CsrAttributeResource(CsrAttributeService csrAttributeService) {
        this.csrAttributeService = csrAttributeService;
    }

    @PostMapping(value={"/csr-attributes"})
    public ResponseEntity<CsrAttribute> createCsrAttribute(@Valid @RequestBody CsrAttribute csrAttribute) throws URISyntaxException {
        this.log.debug("REST request to save CsrAttribute : {}", (Object)csrAttribute);
        if (csrAttribute.getId() != null) {
            throw new BadRequestAlertException("A new csrAttribute cannot already have an ID", ENTITY_NAME, "idexists");
        }
        CsrAttribute result = this.csrAttributeService.save(csrAttribute);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/csr-attributes/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/csr-attributes"})
    public ResponseEntity<CsrAttribute> updateCsrAttribute(@Valid @RequestBody CsrAttribute csrAttribute) throws URISyntaxException {
        this.log.debug("REST request to update CsrAttribute : {}", (Object)csrAttribute);
        if (csrAttribute.getId() == null) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        CsrAttribute result = this.csrAttributeService.save(csrAttribute);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)csrAttribute.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/csr-attributes"})
    public List<CsrAttribute> getAllCsrAttributes() {
        this.log.debug("REST request to get all CsrAttributes");
        return this.csrAttributeService.findAll();
    }

    @GetMapping(value={"/csr-attributes/{id}"})
    public ResponseEntity<CsrAttribute> getCsrAttribute(@PathVariable Long id) {
        this.log.debug("REST request to get CsrAttribute : {}", (Object)id);
        Optional csrAttribute = this.csrAttributeService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)csrAttribute);
    }

    @DeleteMapping(value={"/csr-attributes/{id}"})
    public ResponseEntity<Void> deleteCsrAttribute(@PathVariable Long id) {
        this.log.debug("REST request to delete CsrAttribute : {}", (Object)id);
        this.csrAttributeService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }
}

