/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import de.trustable.ca3s.core.security.KeycloakUserDetails;
import de.trustable.ca3s.core.security.OIDCRestService;
import de.trustable.ca3s.core.security.jwt.TokenProvider;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.keycloak.TokenVerifier;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.adapters.rotation.PublicKeyLocator;
import org.keycloak.common.VerificationException;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.adapters.config.AdapterConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.openid.OpenIDAuthenticationToken;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/oidc"})
public class OIDCAuthenticationResource {
    public static final String INITIAL_URI_PARAM_NAME = "initialUri";
    public static final String REDIRECT_URI_PARAM_PATH = "path";
    public static final String PIPELINE_ID = "pipelineId";
    public static final String CERTIFICATE_ID = "certificateId";
    public static final String CSR_ID = "csrId";
    private final Logger log = LoggerFactory.getLogger(OIDCAuthenticationResource.class);
    private final TokenProvider tokenProvider;
    private final String keycloakAuthorizationUri;
    private final String flowType;
    private final OIDCRestService oidcRestService;
    private KeycloakDeployment deployment;

    public OIDCAuthenticationResource(TokenProvider tokenProvider, @Value(value="${ca3s.oidc.authorization-uri:}") String keycloakAuthorizationUri, @Value(value="${ca3s.oidc.client-id}") String clientId, @Value(value="${ca3s.oidc.flow-type:code}") String flowType, OIDCRestService OIDCRestService2) {
        this.tokenProvider = tokenProvider;
        this.keycloakAuthorizationUri = keycloakAuthorizationUri;
        this.oidcRestService = OIDCRestService2;
        this.flowType = flowType;
        if (keycloakAuthorizationUri.isEmpty()) {
            this.log.info("OIDC not configured, 'ca3s.oidc.authorization-uri' is empty!");
        } else {
            String authServerUrl = keycloakAuthorizationUri;
            try {
                String authUrl = StringUtils.substringBefore((String)authServerUrl, (String)"/realms/");
                String postRealms = StringUtils.substringAfter((String)authServerUrl, (String)"/realms/");
                String realm = StringUtils.substringBefore((String)postRealms, (int)47);
                this.log.info("authUrl : {}, realm : {}", (Object)authUrl, (Object)realm);
                AdapterConfig adapterConfig = new AdapterConfig();
                adapterConfig.setRealm(realm);
                adapterConfig.setAuthServerUrl(authUrl);
                adapterConfig.setResource(clientId);
                this.deployment = KeycloakDeploymentBuilder.build((AdapterConfig)adapterConfig);
                this.log.info("Using oidcDeployment: {}", (Object)this.deployment);
            }
            catch (Exception cause) {
                throw new RuntimeException("Failed to parse the realm name.", cause);
            }
        }
    }

    @CrossOrigin
    @GetMapping(value={"/authenticate"})
    public ResponseEntity<String> getAuthenticatedUser(HttpServletRequest request, @RequestParam Map<String, String> allParams) {
        if (this.keycloakAuthorizationUri.isEmpty()) {
            this.log.info("oidc Authentication not configured");
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        HttpHeaders httpHeaders = new HttpHeaders();
        if (request.getUserPrincipal() == null) {
            this.log.info("Not authenticated, forwarding");
            ServletUriComponentsBuilder redirectUriBuilder = ServletUriComponentsBuilder.fromRequestUri((HttpServletRequest)request);
            String redirectUrlPart = "/../code";
            if ("implicit".equalsIgnoreCase(this.flowType)) {
                redirectUrlPart = "../../..";
            }
            KeycloakUriBuilder locationUrlBuilder = this.deployment.getAuthUrl().clone().queryParam("client_id", new Object[]{this.deployment.getResourceName()}).queryParam("scope", new Object[]{"openid"});
            if ("implicit".equalsIgnoreCase(this.flowType)) {
                locationUrlBuilder.queryParam("response_type", new Object[]{"token"}).queryParam("nonce", new Object[]{"" + System.currentTimeMillis()});
            } else {
                locationUrlBuilder.queryParam("response_type", new Object[]{"code"});
            }
            String state = "";
            for (String key : allParams.keySet()) {
                if (key.equalsIgnoreCase("client_id") || key.equalsIgnoreCase("redirect_uri") || key.equalsIgnoreCase("scope") || key.equalsIgnoreCase("state") || key.equalsIgnoreCase("response_type") || key.equalsIgnoreCase("response_type") || key.equalsIgnoreCase("nonce")) continue;
                if (allParams.containsKey(INITIAL_URI_PARAM_NAME)) {
                    String intialUriValue = allParams.get(INITIAL_URI_PARAM_NAME);
                    if (intialUriValue.trim().isEmpty()) continue;
                    this.log.debug("initialUri defined as '{}'", (Object)intialUriValue);
                    try {
                        URL intialUriAsUrl = new URL(intialUriValue);
                        String path = intialUriAsUrl.getPath();
                        this.log.debug("initialUri has path '{}'", (Object)path);
                        this.log.debug("initialUri has query '{}'", (Object)intialUriAsUrl.getQuery());
                        if (path.equals("/pkcsxx") || path.equals("/requestCertificate") || path.equals("/cert-info") || path.equals("/csr-info")) {
                            if (!state.isEmpty()) {
                                state = state + "&";
                            }
                            state = state + "path=" + path;
                        }
                        MultiValueMap parameters = UriComponentsBuilder.fromUriString((String)intialUriValue).build().getQueryParams();
                        for (String paramKey : parameters.keySet()) {
                            if (!paramKey.equals(PIPELINE_ID) && !paramKey.equals(CSR_ID) && !paramKey.equals(CERTIFICATE_ID)) continue;
                            if (!state.isEmpty()) {
                                state = state + "&";
                            }
                            state = state + paramKey + "=" + (String)parameters.toSingleValueMap().get(paramKey);
                        }
                        continue;
                    }
                    catch (MalformedURLException e) {
                        this.log.info("unparsable initialUri detected", (Throwable)e);
                        continue;
                    }
                }
                this.log.debug("passing query parameter '{}' with value '{}' as redirect uri", (Object)key, (Object)allParams.get(key));
                locationUrlBuilder.queryParam(key, new Object[]{allParams.get(key)});
            }
            if (!state.isEmpty()) {
                locationUrlBuilder.queryParam("state", new Object[]{state});
                this.log.info("state : '{}'", (Object)state);
            }
            String redirectCodeUri = redirectUriBuilder.path(redirectUrlPart).build().normalize().toString();
            locationUrlBuilder.queryParam("redirect_uri", new Object[]{redirectCodeUri});
            String locationUrl = locationUrlBuilder.build(new Object[0]).toString();
            this.log.info("locationUrl : '{}'", (Object)locationUrl);
            httpHeaders.add("Access-Control-Allow-Origin", "*");
            httpHeaders.add("Access-Control-Allow-Methods", "GET, POST, PATCH, PUT, DELETE, OPTIONS");
            httpHeaders.add("Access-Control-Allow-Headers", "Origin, Content-Type, X-Auth-Token");
            httpHeaders.add("Location", locationUrl);
            return new ResponseEntity((MultiValueMap)httpHeaders, HttpStatus.OK);
        }
        this.log.info("Bearer Token created for oidc Authentication");
        return new ResponseEntity((Object)request.getRemoteUser(), (MultiValueMap)httpHeaders, HttpStatus.OK);
    }

    @GetMapping(value={"/code", "/code/"})
    public ResponseEntity<String> getCode(HttpServletRequest request, @RequestParam Map<String, String> allParams) {
        String code = allParams.get("code");
        String accessToken = allParams.get("accessToken");
        this.log.debug("getCode() code : '{}', accessToken '{}'", (Object)code, (Object)accessToken);
        if (this.keycloakAuthorizationUri.isEmpty()) {
            this.log.info("oidc Authentication not configured");
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        try {
            if (accessToken == null || accessToken.trim().isEmpty()) {
                ServletUriComponentsBuilder redirectUriBuilder = ServletUriComponentsBuilder.fromRequestUri((HttpServletRequest)request);
                String redirectUri = redirectUriBuilder.build().normalize().toString();
                this.log.debug("getCode() redirectUri is '{}'", (Object)redirectUri);
                String token = this.oidcRestService.exchangeCodeToToken(this.deployment.getTokenUrl(), code, redirectUri);
                this.log.debug("getCode() code : '{}', token was '{}'", (Object)code, (Object)token);
                String userinfoURL = this.deployment.getTokenUrl().replace("/token", "/userinfo");
                this.log.debug("connecting for user info to  '{}' with token was '{}'", (Object)userinfoURL, (Object)token);
                KeycloakUserDetails keycloakUserDetails = this.oidcRestService.getUserInfo(userinfoURL, token);
                if (keycloakUserDetails != null) {
                    ServletUriComponentsBuilder servletUriComponentsBuilder = ServletUriComponentsBuilder.fromRequestUri((HttpServletRequest)request);
                    return this.buildAndForwardJWT(servletUriComponentsBuilder, keycloakUserDetails, allParams);
                }
                this.log.info("keycloakUserDetails == null, token was '{}'", (Object)token);
            } else {
                this.log.info("ToDo : authToken = '{}'", (Object)accessToken);
            }
        }
        catch (RuntimeException re) {
            this.log.warn("problem processing OIDC code, token or authentication", (Throwable)re);
        }
        catch (JsonProcessingException | UnsupportedEncodingException e) {
            this.log.warn("problem processing OIDC code and token", e);
        }
        return new ResponseEntity(HttpStatus.UNAUTHORIZED);
    }

    @NotNull
    private ResponseEntity<String> buildAndForwardJWT(ServletUriComponentsBuilder servletUriComponentsBuilder, KeycloakUserDetails keycloakUserDetails, Map<String, String> allParams) {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        this.log.info("Current authentication in SecurityContext: " + securityContext.getAuthentication());
        ArrayList attributes = new ArrayList();
        OpenIDAuthenticationToken authentication = new OpenIDAuthenticationToken((Object)this.oidcRestService.retrieveUserName(keycloakUserDetails), (Collection)this.oidcRestService.getAuthorities(keycloakUserDetails), "identityUrl", attributes);
        SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
        securityContext.setAuthentication((Authentication)authentication);
        String jwt = this.tokenProvider.createToken((Authentication)authentication, false);
        HttpHeaders httpHeaders = new HttpHeaders();
        UriComponentsBuilder builder = servletUriComponentsBuilder.path("/../..");
        if (allParams.containsKey("state")) {
            String state = allParams.get("state");
            this.log.debug("invocation state = '{}'", (Object)state);
            for (String part : state.split("&")) {
                if (part.startsWith(REDIRECT_URI_PARAM_PATH)) {
                    builder.path(part.substring(REDIRECT_URI_PARAM_PATH.length() + 1));
                }
                if (part.startsWith(PIPELINE_ID)) {
                    builder.queryParam(PIPELINE_ID, new Object[]{part.substring(PIPELINE_ID.length() + 1)});
                }
                if (part.startsWith(CERTIFICATE_ID)) {
                    builder.queryParam(CERTIFICATE_ID, new Object[]{part.substring(CERTIFICATE_ID.length() + 1)});
                }
                if (!part.startsWith(CSR_ID)) continue;
                builder.queryParam(CSR_ID, new Object[]{part.substring(CSR_ID.length() + 1)});
            }
        }
        builder.queryParam("bearer", new Object[]{jwt});
        String startUri = builder.build().normalize().toString();
        this.log.debug("startUri : '{}'", (Object)startUri);
        httpHeaders.add("Location", startUri);
        httpHeaders.add("Authorization", "Bearer " + jwt);
        return new ResponseEntity((Object)keycloakUserDetails.getName(), (MultiValueMap)httpHeaders, HttpStatus.TEMPORARY_REDIRECT);
    }

    @GetMapping(value={"/tokenImplicit"})
    public ResponseEntity<String> getToken(HttpServletRequest request, @RequestParam(required=false, name="access_token") String access_token, @RequestParam Map<String, String> allParams) {
        this.log.debug("getToken(): retrieved token '{}'", (Object)access_token);
        if (access_token != null && !access_token.trim().isEmpty()) {
            TokenVerifier tokenVerifier = TokenVerifier.create((String)access_token, AccessToken.class);
            tokenVerifier.withDefaultChecks().realmUrl(this.deployment.getRealmInfoUrl());
            try {
                String kid = tokenVerifier.getHeader().getKeyId();
                PublicKey publicKey = this.getPublicKey(kid, this.deployment);
                tokenVerifier.publicKey(publicKey);
                AccessToken accessToken = (AccessToken)tokenVerifier.verify().getToken();
                this.log.info("accessToken Name: {}", (Object)accessToken.getName());
                KeycloakUserDetails keycloakUserDetails = this.oidcRestService.getUserInfo(accessToken);
                if (keycloakUserDetails != null) {
                    ServletUriComponentsBuilder servletUriComponentsBuilder = ServletUriComponentsBuilder.fromRequestUri((HttpServletRequest)request);
                    return this.buildAndForwardJWT(servletUriComponentsBuilder, keycloakUserDetails, allParams);
                }
                this.log.info("keycloakUserDetails == null, token was '{}'", (Object)access_token);
            }
            catch (VerificationException e) {
                this.log.warn("problem processing access token", (Throwable)e);
            }
        }
        return new ResponseEntity(HttpStatus.UNAUTHORIZED);
    }

    private PublicKey getPublicKey(String kid, KeycloakDeployment deployment) throws VerificationException {
        PublicKeyLocator pkLocator = deployment.getPublicKeyLocator();
        PublicKey publicKey = pkLocator.getPublicKey(kid, deployment);
        if (publicKey == null) {
            this.log.warn("Didn't find publicKey for kid: {}", (Object)kid);
            throw new VerificationException("Didn't find publicKey for specified kid");
        }
        return publicKey;
    }

    @CrossOrigin
    @PostMapping(value={"/logout"})
    public ResponseEntity logout(HttpServletRequest request) {
        ServletUriComponentsBuilder servletUriComponentsBuilder = ServletUriComponentsBuilder.fromRequestUri((HttpServletRequest)request);
        String redirectCodeUri = servletUriComponentsBuilder.path("/../..").build().normalize().toString();
        KeycloakUriBuilder builder = this.deployment.getLogoutUrl().clone().queryParam("redirect_uri", new Object[]{redirectCodeUri});
        String redirectUrl = builder.build(new Object[0]).toString();
        this.log.info("logout redirectUrl : '{}'", (Object)redirectUrl);
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("Access-Control-Allow-Origin", "*");
        httpHeaders.add("Access-Control-Allow-Methods", "GET, POST, PUT, DELETE, OPTIONS");
        httpHeaders.add("Access-Control-Allow-Headers", "Origin, Content-Type, X-Auth-Token");
        httpHeaders.add("Location", redirectUrl);
        return new ResponseEntity((MultiValueMap)httpHeaders, HttpStatus.OK);
    }
}

