/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.core.domain.Pipeline;
import de.trustable.ca3s.core.exception.BadRequestAlertException;
import de.trustable.ca3s.core.service.PipelineService;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class PipelineResource {
    private final Logger log = LoggerFactory.getLogger(PipelineResource.class);
    private static final String ENTITY_NAME = "pipeline";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final PipelineService pipelineService;

    public PipelineResource(PipelineService pipelineService) {
        this.pipelineService = pipelineService;
    }

    @PostMapping(value={"/pipelines"})
    public ResponseEntity<Pipeline> createPipeline(@Valid @RequestBody Pipeline pipeline) throws URISyntaxException {
        this.log.debug("REST request to save Pipeline : {}", (Object)pipeline);
        if (pipeline.getId() != null) {
            throw new BadRequestAlertException("A new pipeline cannot already have an ID", ENTITY_NAME, "idexists");
        }
        Pipeline result = this.pipelineService.save(pipeline);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/pipelines/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/pipelines"})
    public ResponseEntity<Pipeline> updatePipeline(@Valid @RequestBody Pipeline pipeline) throws URISyntaxException {
        this.log.debug("REST request to update Pipeline : {}", (Object)pipeline);
        if (pipeline.getId() == null) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        Pipeline result = this.pipelineService.save(pipeline);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)pipeline.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/pipelines"})
    public List<Pipeline> getAllPipelines() {
        this.log.debug("REST request to get all Pipelines");
        return this.pipelineService.findAll();
    }

    @GetMapping(value={"/pipelines/{id}"})
    public ResponseEntity<Pipeline> getPipeline(@PathVariable Long id) {
        this.log.debug("REST request to get Pipeline : {}", (Object)id);
        Optional pipeline = this.pipelineService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)pipeline);
    }

    @DeleteMapping(value={"/pipelines/{id}"})
    public ResponseEntity<Void> deletePipeline(@PathVariable Long id) {
        this.log.debug("REST request to delete Pipeline : {}", (Object)id);
        this.pipelineService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }
}

