/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest.acme;

import de.trustable.ca3s.core.domain.ACMEAccount;
import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.service.dto.acme.RevokeRequest;
import de.trustable.ca3s.core.service.dto.acme.problem.AcmeProblemException;
import de.trustable.ca3s.core.service.dto.acme.problem.ProblemDetail;
import de.trustable.ca3s.core.service.util.ACMEUtil;
import de.trustable.ca3s.core.service.util.BPMNUtil;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import de.trustable.ca3s.core.web.rest.acme.ACMEController;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.asn1.x509.CRLReason;
import org.cryptacular.util.CertUtil;
import org.jose4j.jwt.consumer.JwtContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@Controller
@RequestMapping(value={"/acme/{realm}/cert"})
public class ACMECertificateController
extends ACMEController {
    private static final Logger LOG = LoggerFactory.getLogger(ACMECertificateController.class);
    private boolean chainIncludeRoot = true;
    private final CertificateRepository certificateRepository;
    private final BPMNUtil bpmnUtil;
    private final CertificateUtil certUtil;
    private final boolean certificateLocationBackwardCompat;

    public ACMECertificateController(CertificateRepository certificateRepository, BPMNUtil bpmnUtil, CertificateUtil certUtil, @Value(value="${ca3s.acme.backward.certificate.location:false}") boolean certificateLocationBackwardCompat) {
        this.certificateRepository = certificateRepository;
        this.bpmnUtil = bpmnUtil;
        this.certUtil = certUtil;
        this.certificateLocationBackwardCompat = certificateLocationBackwardCompat;
    }

    @RequestMapping(value={"/{certId}"}, method={RequestMethod.GET})
    public ResponseEntity<?> getCertificatePKIX(@PathVariable long certId, @RequestHeader(name="Accept", defaultValue="application/pem-certificate-chain") String accept) {
        LOG.info("Received certificate request for id {}", (Object)certId);
        return this.buildCertResponseForId(certId, accept);
    }

    public ResponseEntity<?> buildCertResponseForId(long certId, String accept) throws HttpClientErrorException, AcmeProblemException {
        ResponseEntity resp;
        Optional certOpt = this.certificateRepository.findById((Object)certId);
        if (!certOpt.isPresent()) {
            throw new HttpClientErrorException(HttpStatus.NOT_FOUND);
        }
        Certificate certDao = (Certificate)certOpt.get();
        HttpHeaders headers = this.buildNonceHeader();
        if (this.certificateLocationBackwardCompat) {
            String certLocation = ServletUriComponentsBuilder.fromCurrentRequestUri().build().toUriString();
            headers.add("location", certLocation);
            LOG.debug("added certificate location header '{}' for backward compatibility reasons.", (Object)certLocation);
        }
        if ((resp = this.buildCertifcateResponse(accept, certDao, headers)) == null) {
            String msg = "problem returning certificate with accepting type " + accept;
            LOG.info(msg);
            ProblemDetail problem = new ProblemDetail(ACMEUtil.MALFORMED, msg, HttpStatus.UNSUPPORTED_MEDIA_TYPE, "", ACMEController.NO_INSTANCE);
            throw new AcmeProblemException(problem);
        }
        return resp;
    }

    public ResponseEntity<?> buildCertifcateResponse(String accept, Certificate certDao) {
        return this.buildCertifcateResponse(accept, certDao, new HttpHeaders());
    }

    public ResponseEntity<?> buildCertifcateResponse(String accept, Certificate certDao, HttpHeaders headers) {
        if ("*/*".equalsIgnoreCase(accept)) {
            return this.buildPEMResponse(certDao, headers);
        }
        if ("application/pkix-cert".equalsIgnoreCase(accept)) {
            return this.buildPkixCertResponse(certDao, headers);
        }
        if ("application/pem-certificate-chain".equalsIgnoreCase(accept)) {
            return this.buildPEMResponse(certDao, headers);
        }
        if ("application/pem-certificate".equalsIgnoreCase(accept)) {
            return this.buildPEMResponse(certDao, headers, false);
        }
        LOG.info("unexpected accept type {}", (Object)accept);
        return null;
    }

    @RequestMapping(value={"/revoke"}, method={RequestMethod.POST}, consumes={"application/jose+json"})
    public ResponseEntity<?> revokeCertificate(@RequestBody String requestBody, @PathVariable String realm) {
        LOG.info("Received revoke request for certificate ");
        try {
            String tbsDigestBase64;
            JwtContext context = this.jwtUtil.processFlattenedJWT(requestBody);
            ACMEAccount acctDao = this.checkJWTSignatureForAccount(context, realm);
            RevokeRequest revokeReq = this.jwtUtil.getRevokeReq(context.getJwtClaims());
            String certB64 = revokeReq.getCertificate();
            X509Certificate x509Cert = CertUtil.decodeCertificate((byte[])Base64.decodeBase64((String)certB64));
            LOG.info("Revoke request for certificate {} ", (Object)x509Cert.getSubjectX500Principal().toString());
            try {
                tbsDigestBase64 = Base64.encodeBase64String((byte[])this.cryptoUtil.getSHA256Digest(x509Cert.getTBSCertificate())).toLowerCase();
            }
            catch (NoSuchAlgorithmException | CertificateEncodingException e) {
                LOG.info("problem selecting certificate for RevokeRequest", (Throwable)e);
                ProblemDetail problem = new ProblemDetail(ACMEUtil.MALFORMED, "problem selecting certificate for RevokeRequest", HttpStatus.BAD_REQUEST, "", ACMEController.NO_INSTANCE);
                throw new AcmeProblemException(problem);
            }
            List certList = this.certificateRepository.findByTBSDigest(tbsDigestBase64);
            if (certList.isEmpty()) {
                LOG.warn("Certificate {} to be revoked not found in database", (Object)x509Cert.getSubjectX500Principal().toString());
                return ResponseEntity.notFound().build();
            }
            Certificate certDao = (Certificate)certList.get(0);
            HttpHeaders headers = this.buildNonceHeader();
            if (acctDao.getAccountId() == Long.parseLong(this.certUtil.getCertAttribute(certDao, "ACME:ACCOUNT_ID"))) {
                this.revokeCertificate(certDao, Integer.toString(revokeReq.getReason()));
                return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).build();
            }
            LOG.warn("Revoke request for certificate {} identified by account {} does not match cert's associated account {}", new Object[]{x509Cert.getSubjectX500Principal().toString(), acctDao.getAccountId(), this.certUtil.getCertAttribute(certDao, "ACME:ACCOUNT_ID")});
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.FORBIDDEN).headers(headers)).build();
        }
        catch (AcmeProblemException e) {
            return this.buildProblemResponseEntity(e);
        }
        catch (Exception e) {
            LOG.info("problem revoking certificate ", (Throwable)e);
            ProblemDetail problem = new ProblemDetail(ACMEUtil.MALFORMED, "problem revoking certificate ", HttpStatus.BAD_REQUEST, "", ACMEController.NO_INSTANCE);
            throw new AcmeProblemException(problem);
        }
    }

    @RequestMapping(value={"/{certId}"}, method={RequestMethod.POST}, consumes={"application/jose+json", "application/pkix-cert"})
    public ResponseEntity<?> retrieveCertificate(@RequestBody String requestBody, @RequestHeader(name="Accept", defaultValue="application/pem-certificate-chain") String accept, @RequestHeader(value="Content-Type") String contentType, @PathVariable long certId, @PathVariable String realm) {
        try {
            JwtContext context = this.jwtUtil.processFlattenedJWT(requestBody);
            ACMEAccount acctDao = this.checkJWTSignatureForAccount(context, realm);
            LOG.info("Received certificate request for certifacte id {} of content-type {}, identified by account id {} ", new Object[]{certId, contentType, acctDao.getAccountId()});
            return this.buildCertResponseForId(certId, accept);
        }
        catch (AcmeProblemException e) {
            return this.buildProblemResponseEntity(e);
        }
    }

    private ResponseEntity<byte[]> buildPkixCertResponse(Certificate certDao, HttpHeaders headers) {
        LOG.info("building PKIX certificate response");
        byte[] certBytes = Base64.decodeBase64((String)certDao.getContent());
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(APPLICATION_PKIX_CERT).headers(headers)).body((Object)certBytes);
    }

    private ResponseEntity<?> buildPEMResponse(Certificate certDao, HttpHeaders headers) {
        return this.buildPEMResponse(certDao, headers, true);
    }

    private ResponseEntity<?> buildPEMResponse(Certificate certDao, HttpHeaders headers, boolean includeChain) {
        LOG.info("building PEM certificate response");
        try {
            String resultPem = "";
            if (includeChain) {
                List chain = this.certUtil.getCertificateChain(certDao);
                Iterator it = chain.iterator();
                while (it.hasNext()) {
                    Certificate chainCertDao = (Certificate)it.next();
                    if (!it.hasNext() && !this.chainIncludeRoot) continue;
                    resultPem = resultPem + chainCertDao.getContent();
                }
            } else {
                resultPem = resultPem + certDao.getContent();
            }
            LOG.debug("returning cert and issuer : \n" + resultPem);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(APPLICATION_PEM_CERT_CHAIN).headers(headers)).body((Object)resultPem.getBytes());
        }
        catch (GeneralSecurityException ge) {
            String msg = "problem building certificate chain";
            LOG.info(msg, (Throwable)ge);
            ProblemDetail problem = new ProblemDetail(ACMEUtil.MALFORMED, msg, HttpStatus.INTERNAL_SERVER_ERROR, msg, ACMEController.NO_INSTANCE);
            throw new AcmeProblemException(problem);
        }
    }

    private void revokeCertificate(Certificate certDao, String reason) throws Exception {
        if (certDao.isRevoked().booleanValue()) {
            LOG.warn("failureReason: certificate with id '" + certDao.getId() + "' already revoked.");
        }
        CRLReason crlReason = this.cryptoUtil.crlReasonFromString(reason);
        String crlReasonStr = this.cryptoUtil.crlReasonAsString(crlReason);
        LOG.debug("crlReason : " + crlReasonStr);
        Date revocationDate = new Date();
        this.bpmnUtil.startCertificateRevocationProcess(certDao, crlReason, revocationDate);
        certDao.setActive(Boolean.valueOf(false));
        certDao.setRevoked(Boolean.valueOf(true));
        certDao.setRevokedSince(Instant.now());
        certDao.setRevocationReason(crlReasonStr);
        certDao.setRevocationExecutionId("39");
        this.certificateRepository.save((Object)certDao);
    }
}

