/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest.data;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.web.rest.data.CertificateNameId;
import de.trustable.ca3s.core.web.rest.data.PKCSDataType;
import de.trustable.ca3s.core.web.rest.data.Pkcs10RequestHolderShallow;
import de.trustable.ca3s.core.web.rest.data.X509CertificateHolderShallow;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.bouncycastle.cert.X509CertificateHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
@Immutable
public class PkcsXXData {
    private static final Logger LOGGER = LoggerFactory.getLogger(PkcsXXData.class);
    @JsonProperty(value="dataType")
    private PKCSDataType dataType;
    @JsonProperty(value="p10Holder")
    private Pkcs10RequestHolderShallow p10Holder;
    @JsonProperty(value="certificates")
    private X509CertificateHolderShallow[] certsHolder;
    private boolean csrPublicKeyPresentInDB = false;
    @JsonProperty(value="createdCertificateId")
    private String createdCertificateId;
    @JsonProperty(value="passphraseRequired")
    private boolean passphraseRequired = false;
    @JsonProperty(value="csrPending")
    private boolean csrPending = false;
    @JsonProperty(value="createdCSRId")
    private String createdCSRId;
    @JsonProperty(value="messages")
    private String[] messages;
    @JsonProperty(value="warnings")
    private String[] warnings;
    @JsonProperty(value="replacementCandidates")
    CertificateNameId[] replacementCandidates;

    public PkcsXXData() {
    }

    public PkcsXXData(X509CertificateHolder certHolder, Certificate cert) {
        this.setDataType(PKCSDataType.X509_CERTIFICATE_CREATED);
        X509CertificateHolderShallow[] x509HolderArr = new X509CertificateHolderShallow[]{new X509CertificateHolderShallow(certHolder)};
        x509HolderArr[0].setCertificateId(cert.getId().longValue());
        x509HolderArr[0].setCertificatePresentInDB(true);
        this.setCertsHolder(x509HolderArr);
    }

    public PkcsXXData(X509CertificateHolder certHolder, boolean isCertificatePresentInDB) {
        this(certHolder, null, isCertificatePresentInDB);
    }

    public PkcsXXData(X509CertificateHolder certHolder, String pemCertificate, boolean isCertificatePresentInDB) {
        this.setDataType(PKCSDataType.X509_CERTIFICATE);
        X509CertificateHolderShallow[] x509HolderArr = new X509CertificateHolderShallow[]{new X509CertificateHolderShallow(certHolder)};
        x509HolderArr[0].setPemCertificate(pemCertificate);
        x509HolderArr[0].setCertificatePresentInDB(isCertificatePresentInDB);
        this.setCertsHolder(x509HolderArr);
    }

    public PkcsXXData(Pkcs10RequestHolderShallow p10Holder) {
        this.setDataType(PKCSDataType.CSR);
        this.setP10Holder(p10Holder);
    }

    public PKCSDataType getDataType() {
        return this.dataType;
    }

    public void setDataType(PKCSDataType dataType) {
        this.dataType = dataType;
    }

    public X509CertificateHolderShallow[] getCertsHolder() {
        return this.certsHolder;
    }

    public void setCertsHolder(X509CertificateHolderShallow[] certsHolder) {
        this.certsHolder = certsHolder;
    }

    public Pkcs10RequestHolderShallow getP10Holder() {
        return this.p10Holder;
    }

    public void setP10Holder(Pkcs10RequestHolderShallow p10Holder) {
        this.p10Holder = p10Holder;
    }

    public boolean isPassphraseRequired() {
        return this.passphraseRequired;
    }

    public void setPassphraseRequired(boolean passphraseRequired) {
        this.passphraseRequired = passphraseRequired;
    }

    public boolean isCsrPublicKeyPresentInDB() {
        return this.csrPublicKeyPresentInDB;
    }

    public void setCsrPublicKeyPresentInDB(boolean csrPublicKeyPresentInDB) {
        this.csrPublicKeyPresentInDB = csrPublicKeyPresentInDB;
    }

    public String getCreatedCertificateId() {
        return this.createdCertificateId;
    }

    public void setCreatedCertificateId(String createdCertificateId) {
        this.createdCertificateId = createdCertificateId;
    }

    public boolean isCsrPending() {
        return this.csrPending;
    }

    public void setCsrPending(boolean csrPending) {
        this.csrPending = csrPending;
    }

    public String getCreatedCSRId() {
        return this.createdCSRId;
    }

    public void setCreatedCSRId(String createdCSRId) {
        this.createdCSRId = createdCSRId;
    }

    public String[] getWarnings() {
        return this.warnings;
    }

    public void setWarnings(String[] warnings) {
        this.warnings = warnings;
    }

    public String[] getMessages() {
        return this.messages;
    }

    public void setMessages(String[] messages) {
        this.messages = messages;
    }

    public CertificateNameId[] getReplacementCandidates() {
        return this.replacementCandidates;
    }

    public void setReplacementCandidates(CertificateNameId[] replacementCandidates) {
        this.replacementCandidates = replacementCandidates;
    }

    public void setReplacementCandidates(List<Certificate> candidates) {
        this.replacementCandidates = new CertificateNameId[candidates.size()];
        int i = 0;
        for (Certificate cert : candidates) {
            this.replacementCandidates[i++] = new CertificateNameId(cert);
        }
    }
}

