/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.schedule;

import de.trustable.ca3s.core.domain.AcmeOrder;
import de.trustable.ca3s.core.domain.enumeration.AcmeOrderStatus;
import de.trustable.ca3s.core.repository.AcmeOrderRepository;
import de.trustable.ca3s.core.service.AuditService;
import java.time.Instant;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class AcmeExpiryScheduler {
    transient Logger LOG = LoggerFactory.getLogger(AcmeExpiryScheduler.class);
    private final AcmeOrderRepository acmeOrderRepository;
    private final AuditService auditService;

    public AcmeExpiryScheduler(AcmeOrderRepository acmeOrderRepository, AuditService auditService) {
        this.acmeOrderRepository = acmeOrderRepository;
        this.auditService = auditService;
    }

    @Scheduled(fixedRateString="${ca3s.schedule.rate.acmeOrderExpiry:600000}")
    public void runMinute() {
        Instant now = Instant.now();
        List acmeOrderExpiredList = this.acmeOrderRepository.findByPendingExpiryBefore(now);
        if (!acmeOrderExpiredList.isEmpty()) {
            this.LOG.info("setting #{} expired orders to status 'invalid'", (Object)acmeOrderExpiredList.size());
            for (AcmeOrder acmeOrder : acmeOrderExpiredList) {
                acmeOrder.setStatus(AcmeOrderStatus.INVALID);
                this.auditService.createAuditTraceACMEOrderExpired(acmeOrder);
                this.acmeOrderRepository.save((Object)acmeOrder);
            }
        }
    }
}

