/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.schedule;

import de.trustable.ca3s.core.domain.AcmeAccount;
import de.trustable.ca3s.core.domain.AcmeOrder;
import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.domain.CsrAttribute;
import de.trustable.ca3s.core.domain.Pipeline;
import de.trustable.ca3s.core.domain.enumeration.PipelineType;
import de.trustable.ca3s.core.repository.AcmeAccountRepository;
import de.trustable.ca3s.core.repository.AcmeOrderRepository;
import de.trustable.ca3s.core.repository.CSRRepository;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.repository.CsrAttributeRepository;
import de.trustable.ca3s.core.repository.PipelineRepository;
import de.trustable.ca3s.core.service.AuditService;
import de.trustable.ca3s.core.service.util.CSRUtil;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import de.trustable.ca3s.core.service.util.CryptoService;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import org.bouncycastle.util.encoders.DecoderException;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(propagation=Propagation.REQUIRES_NEW)
public class SchemaUpdateScheduler {
    transient Logger LOG = LoggerFactory.getLogger(SchemaUpdateScheduler.class);
    static final int MAX_RECORDS_PER_TRANSACTION = 10000;
    private final CertificateRepository certificateRepo;
    private final CertificateUtil certUtil;
    private final CSRRepository csrRepository;
    private final CsrAttributeRepository csrAttributeRepository;
    private final CSRUtil csrUtil;
    private final AcmeOrderRepository acmeOrderRepository;
    private final AcmeAccountRepository acmeAccountRepository;
    private final PipelineRepository pipelineRepository;
    private final AuditService auditService;

    public SchemaUpdateScheduler(CertificateRepository certificateRepo, CertificateUtil certUtil, CSRRepository csrRepository, CsrAttributeRepository csrAttributeRepository, CSRUtil csrUtil, AcmeOrderRepository acmeOrderRepository, AcmeAccountRepository acmeAccountRepository, PipelineRepository pipelineRepository, AuditService auditService) {
        this.certificateRepo = certificateRepo;
        this.certUtil = certUtil;
        this.csrRepository = csrRepository;
        this.csrAttributeRepository = csrAttributeRepository;
        this.csrUtil = csrUtil;
        this.acmeOrderRepository = acmeOrderRepository;
        this.acmeAccountRepository = acmeAccountRepository;
        this.pipelineRepository = pipelineRepository;
        this.auditService = auditService;
    }

    @Scheduled(fixedDelay=60000L)
    public void performSchemaApdates() {
        Instant now = Instant.now();
        this.updateCertificateAttributes();
        this.LOG.info("updateCertificateAttributes took {} ms", (Object)Duration.between(now, Instant.now()));
        now = Instant.now();
        this.updateCSRAttributes();
        this.LOG.info("updateCSRAttributes took {} ms", (Object)Duration.between(now, Instant.now()));
        now = Instant.now();
        this.updateAcmeOrder();
        this.LOG.info("updateAcmeOrder took {} ms", (Object)Duration.between(now, Instant.now()));
        now = Instant.now();
        this.updateACMEAccount();
        this.LOG.info("updateACMEAccount took {} ms", (Object)Duration.between(now, Instant.now()));
    }

    public void updateCertificateAttributes() {
        List updateCertificateList = this.certificateRepo.findByAttributeValueLowerThan("ATTRIBUTES_VERSION", "4");
        int count = 0;
        for (Certificate cert : updateCertificateList) {
            try {
                int currentVersion = Integer.parseInt(this.certUtil.getCertAttribute(cert, "ATTRIBUTES_VERSION"));
                X509Certificate x509Cert = CryptoService.convertPemToCertificate((String)cert.getContent());
                if (currentVersion < 4) {
                    this.certUtil.interpretBasicConstraint(x509Cert, cert);
                }
                this.certUtil.addAdditionalCertificateAttributes(x509Cert, cert);
                this.certificateRepo.save((Object)cert);
                this.LOG.info("attribute schema updated for certificate id {} ", (Object)cert.getId());
            }
            catch (IOException | GeneralSecurityException e) {
                this.LOG.error("problem with attribute schema update for certificate id " + cert.getId(), (Throwable)e);
            }
            if (count++ <= 10000) continue;
            this.LOG.info("limited certificate validity processing to {} per call", (Object)10000);
            break;
        }
        if (count > 0) {
            this.auditService.saveAuditTrace(this.auditService.createAuditTraceCertificateSchemaUpdated(count, 4));
        }
    }

    public void updateCSRAttributes() {
        List updateCSRList = this.csrRepository.findWithoutAttribute("ATTRIBUTES_VERSION");
        int count = 0;
        for (CSR csr : updateCSRList) {
            try {
                this.fixIPSan(csr);
                this.csrUtil.setCSRAttributeVersion(csr);
                this.csrAttributeRepository.saveAll((Iterable)csr.getCsrAttributes());
                this.csrRepository.save((Object)csr);
                this.LOG.info("attribute schema updated for csr id {} ", (Object)csr.getId());
            }
            catch (UnknownHostException e) {
                this.LOG.error("problem with attribute schema update for csr id " + csr.getId(), (Throwable)e);
            }
            if (count++ <= 10000) continue;
            this.LOG.info("limited certificate validity processing to {} per call", (Object)10000);
            break;
        }
        if (count > 0) {
            this.auditService.saveAuditTrace(this.auditService.createAuditTraceCertificateSchemaUpdated(count, 4));
        }
    }

    private void fixIPSan(CSR csr) throws UnknownHostException {
        for (CsrAttribute attr : csr.getCsrAttributes()) {
            String value = null;
            if (attr.getName().equals("SAN") && attr.getValue().startsWith("#")) {
                value = attr.getValue().substring(1);
            }
            if (attr.getName().equals("TYPED_SAN") && attr.getValue().startsWith("IP:#")) {
                value = attr.getValue().substring(4);
            }
            if (value == null) continue;
            try {
                InetAddress inetAddress = InetAddress.getByAddress(Hex.decode((String)value));
                if (attr.getName().equals("TYPED_SAN")) {
                    attr.setValue("IP:" + inetAddress.getHostAddress());
                    this.LOG.debug("update TYPED_SAN attribute #{} to {}", (Object)attr.getId(), (Object)attr.getValue());
                    continue;
                }
                attr.setValue(inetAddress.getHostAddress());
                this.LOG.debug("update SAN attribute #{} to {}", (Object)attr.getId(), (Object)attr.getValue());
            }
            catch (DecoderException de) {
                this.LOG.info("SAN attribute #{} contains invalid IP address {}, ignoring ...", (Object)attr.getId(), (Object)value);
            }
        }
    }

    public void updateAcmeOrder() {
        Instant now = Instant.now();
        List acmeOrderList = this.acmeOrderRepository.findPipelineIsNull();
        int count = 0;
        for (AcmeOrder acmeOrder : acmeOrderList) {
            String realm = acmeOrder.getAccount().getRealm();
            List pipelineList = this.pipelineRepository.findByTypeUrl(PipelineType.ACME, realm);
            if (!pipelineList.isEmpty()) {
                acmeOrder.setPipeline((Pipeline)pipelineList.get(0));
                acmeOrder.setRealm(realm);
                this.acmeOrderRepository.save((Object)acmeOrder);
                this.LOG.info("realm and pipeljne updated for acme order {} ", (Object)acmeOrder);
            }
            if (count++ <= 10000) continue;
            this.LOG.info("limited AcmeOrder processing to {} per call", (Object)10000);
            break;
        }
        if (count > 0) {
            this.auditService.saveAuditTrace(this.auditService.createAuditTraceAcmeOrderPipelineUpdated(count));
            this.LOG.info("AcmeOrder pipeline / realm processing of {} orders", (Object)count);
        }
    }

    public void updateACMEAccount() {
        Instant now = Instant.now();
        List acmeAccountList = this.acmeAccountRepository.findByCreatedOnIsNull();
        int count = 0;
        for (AcmeAccount acmeAccount : acmeAccountList) {
            Instant oldestOrder = now;
            for (AcmeOrder acmeOrder : acmeAccount.getOrders()) {
                if (!acmeOrder.getNotBefore().isBefore(oldestOrder)) continue;
                oldestOrder = acmeOrder.getNotBefore();
            }
            acmeAccount.setCreatedOn(oldestOrder);
            this.acmeAccountRepository.save((Object)acmeAccount);
            this.LOG.info("CreatedOn date updated for acme account {} ", (Object)acmeAccount.getAccountId());
            if (count++ <= 10000) continue;
            this.LOG.info("limited AcmeAccount processing to {} per call", (Object)10000);
            break;
        }
        if (count > 0) {
            this.auditService.saveAuditTrace(this.auditService.createAuditTraceAcmeAcountCreatedOnUpdated(count));
            this.LOG.info("AcmeAccount createdOn update of {} accounts", (Object)count);
        }
    }
}

