/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.schedule.spider;

import de.trustable.ca3s.core.schedule.spider.CrawlerWorker;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Crawler {
    Logger LOGGER = LoggerFactory.getLogger(Crawler.class);
    private static final int MAX_PAGES_TO_SEARCH = 100;

    public Set<String> search(String url, String regEx) {
        HashSet<String> pagesVisited = new HashSet<String>();
        HashSet<String> certificateSet = new HashSet<String>();
        LinkedList pagesToVisit = new LinkedList();
        Pattern searchPattern = Pattern.compile(regEx);
        while (pagesVisited.size() < 100) {
            String currentUrl;
            CrawlerWorker leg = new CrawlerWorker();
            if (pagesToVisit.isEmpty()) {
                currentUrl = url;
                pagesVisited.add(url);
            } else {
                String nextUrl;
                while (pagesVisited.contains(nextUrl = (String)pagesToVisit.remove(0))) {
                }
                pagesVisited.add(nextUrl);
                currentUrl = nextUrl;
            }
            try {
                leg.crawl(currentUrl, searchPattern, certificateSet);
            }
            catch (IllegalArgumentException mue) {
                this.LOGGER.debug("unexpected URL found at url '" + url + "'", (Throwable)mue);
            }
            pagesToVisit.addAll(leg.getLinks());
        }
        this.LOGGER.debug("Visited " + pagesVisited.size() + " web page(s), found #" + certificateSet.size() + " different certificates");
        return certificateSet;
    }
}

