/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.dto;

import com.opencsv.bean.CsvBindByName;
import com.opencsv.bean.CsvIgnore;
import com.opencsv.bean.CsvRecurse;
import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.CsrAttribute;
import de.trustable.ca3s.core.domain.enumeration.CsrStatus;
import de.trustable.ca3s.core.domain.enumeration.PipelineType;
import de.trustable.ca3s.core.service.dto.AuditView;
import de.trustable.ca3s.core.service.dto.NamedValue;
import de.trustable.ca3s.core.service.util.CSRUtil;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSRView
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(CSRView.class);
    @CsvBindByName
    private Long id;
    @CsvBindByName
    private Long certificateId;
    @CsvBindByName
    private CsrStatus status;
    @CsvBindByName
    private String subject;
    @CsvBindByName
    private String sans;
    @CsvBindByName
    private String[] sanArr;
    @CsvBindByName
    private PipelineType pipelineType;
    @CsvBindByName
    private Instant rejectedOn;
    @CsvBindByName
    private String rejectionReason;
    @CsvBindByName
    private String requestedBy;
    @CsvBindByName
    private String processingCA;
    @CsvBindByName
    private String pipelineName;
    @CsvIgnore
    private Long pipelineId;
    @CsvBindByName
    private String x509KeySpec;
    @CsvBindByName
    private String hashAlgorithm;
    @CsvBindByName
    private String keyAlgorithm;
    @CsvBindByName
    private String keyLength;
    @CsvBindByName
    private String signingAlgorithm;
    @CsvBindByName
    private String publicKeyAlgorithm;
    @CsvBindByName
    private Instant requestedOn;
    @CsvBindByName
    private Boolean isCSRValid;
    @CsvBindByName
    private Boolean serversideKeyGeneration;
    @CsvBindByName
    private String processInstanceId;
    @CsvBindByName
    private String publicKeyHash;
    @CsvBindByName
    private String administeredBy;
    @CsvBindByName
    private Instant approvedOn;
    @CsvBindByName
    private String requestorComment;
    @CsvBindByName
    private String administrationComment;
    @CsvRecurse
    private NamedValue[] arArr;
    @CsvIgnore
    private String csrBase64;
    @CsvIgnore
    private AuditView[] auditViewArr;
    @CsvIgnore
    private boolean isAdministrable;

    public CSRView() {
    }

    public CSRView(CSRUtil csrUtil, CSR csr, boolean doDNSLookup) {
        this.id = csr.getId();
        this.csrBase64 = "";
        this.certificateId = csr.getCertificate() != null ? csr.getCertificate().getId() : null;
        this.subject = csr.getSubject();
        this.sans = csr.getSans();
        this.status = csr.getStatus();
        this.publicKeyAlgorithm = csr.getPublicKeyAlgorithm();
        this.signingAlgorithm = csr.getSigningAlgorithm();
        this.x509KeySpec = csr.getx509KeySpec();
        this.keyLength = csr.getKeyLength().toString();
        this.requestedOn = csr.getRequestedOn();
        this.requestedBy = csr.getRequestedBy();
        Set attributes = csr.getCsrAttributes();
        ArrayList<String> sanList = new ArrayList<String>();
        for (CsrAttribute csrAttribute : attributes) {
            if (!csrAttribute.getName().equals("TYPED_SAN")) continue;
            String value = csrAttribute.getValue();
            if (doDNSLookup) {
                try {
                    if (value.startsWith("IP:")) {
                        InetAddress[] inetAddresses;
                        String ip = value.substring(3);
                        String names = "";
                        for (InetAddress inetAddress : inetAddresses = InetAddress.getAllByName(ip)) {
                            if (ip.equals(inetAddress.getHostName())) continue;
                            if (!names.isEmpty()) {
                                names = names + ", ";
                            }
                            names = names + inetAddress.getHostName();
                        }
                        if (!names.isEmpty()) {
                            value = value + " (" + names + ")";
                        }
                    } else if (value.startsWith("DNS:")) {
                        if (InetAddress.getAllByName(value.substring(4)).length > 0) {
                            value = value + " (in DNS vorhanden)";
                        }
                    } else if (InetAddress.getAllByName(value).length > 0) {
                        value = value + " (in DNS vorhanden)";
                    }
                }
                catch (UnknownHostException e) {
                    LOG.info("DNS lookup of '" + value + "' failed.", (Throwable)e);
                }
            }
            sanList.add(value);
        }
        this.sanArr = sanList.toArray(new String[0]);
        this.hashAlgorithm = csrUtil.getCSRAttribute(csr, "HASH_ALGO");
        this.processingCA = csrUtil.getCSRAttribute(csr, "PROCESSING_CA");
        if (csr.getPipeline() != null) {
            this.pipelineName = csr.getPipeline().getName();
            this.pipelineType = csr.getPipeline().getType();
        } else {
            this.pipelineName = null;
            this.pipelineType = null;
        }
        this.isAdministrable = false;
        this.isCSRValid = csr.isIsCSRValid();
        this.serversideKeyGeneration = csr.isServersideKeyGeneration();
        this.processInstanceId = csr.getProcessInstanceId();
        this.publicKeyHash = csr.getPublicKeyHash();
        this.administeredBy = csr.getAdministeredBy();
        this.approvedOn = csr.getApprovedOn();
        this.requestorComment = csr.getRequestorComment();
        this.administrationComment = csr.getAdministrationComment();
        this.arArr = this.copyArAttributes(csr);
    }

    private NamedValue[] copyArAttributes(CSR csr) {
        ArrayList<NamedValue> nvList = new ArrayList<NamedValue>();
        for (CsrAttribute csrAttribute : csr.getCsrAttributes()) {
            if (!csrAttribute.getName().startsWith("_ARA_")) continue;
            NamedValue nv = new NamedValue();
            nv.setName(csrAttribute.getName().substring("_ARA_".length()));
            nv.setValue(csrAttribute.getValue());
            nvList.add(nv);
        }
        return nvList.toArray(new NamedValue[0]);
    }

    public Long getId() {
        return this.id;
    }

    public Long getCertificateId() {
        return this.certificateId;
    }

    public CsrStatus getStatus() {
        return this.status;
    }

    public String getProcessingCA() {
        return this.processingCA;
    }

    public String getPipelineName() {
        return this.pipelineName;
    }

    public String getX509KeySpec() {
        return this.x509KeySpec;
    }

    public String getKeyLength() {
        return this.keyLength;
    }

    public String getSigningAlgorithm() {
        return this.signingAlgorithm;
    }

    public String getPublicKeyAlgorithm() {
        return this.publicKeyAlgorithm;
    }

    public Instant getRequestedOn() {
        return this.requestedOn;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setCertificateId(Long certificateId) {
        this.certificateId = certificateId;
    }

    public void setStatus(CsrStatus status) {
        this.status = status;
    }

    public void setProcessingCA(String processingCA) {
        this.processingCA = processingCA;
    }

    public void setPipelineName(String pipelineName) {
        this.pipelineName = pipelineName;
    }

    public void setX509KeySpec(String x509KeySpec) {
        this.x509KeySpec = x509KeySpec;
    }

    public void setKeyLength(String keyLength) {
        this.keyLength = keyLength;
    }

    public void setSigningAlgorithm(String signingAlgorithm) {
        this.signingAlgorithm = signingAlgorithm;
    }

    public void setPublicKeyAlgorithm(String publicKeyAlgorithm) {
        this.publicKeyAlgorithm = publicKeyAlgorithm;
    }

    public void setRequestedOn(Instant requestedOn) {
        this.requestedOn = requestedOn;
    }

    public PipelineType getPipelineType() {
        return this.pipelineType;
    }

    public Instant getRejectedOn() {
        return this.rejectedOn;
    }

    public String getRejectionReason() {
        return this.rejectionReason;
    }

    public void setPipelineType(PipelineType pipelineType) {
        this.pipelineType = pipelineType;
    }

    public void setRejectedOn(Instant rejectedOn) {
        this.rejectedOn = rejectedOn;
    }

    public void setRejectionReason(String rejectionReason) {
        this.rejectionReason = rejectionReason;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getRequestedBy() {
        return this.requestedBy;
    }

    public void setRequestedBy(String requestedBy) {
        this.requestedBy = requestedBy;
    }

    public String getSans() {
        return this.sans;
    }

    public void setSans(String sans) {
        this.sans = sans;
    }

    public String[] getSanArr() {
        return this.sanArr;
    }

    public void setSanArr(String[] sanArr) {
        this.sanArr = sanArr;
    }

    public AuditView[] getAuditViewArr() {
        return this.auditViewArr;
    }

    public void setAuditViewArr(AuditView[] auditViewArr) {
        this.auditViewArr = auditViewArr;
    }

    public String getCsrBase64() {
        return this.csrBase64;
    }

    public void setCsrBase64(String csrBase64) {
        this.csrBase64 = csrBase64;
    }

    public String getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    public void setKeyAlgorithm(String keyAlgorithm) {
        this.keyAlgorithm = keyAlgorithm;
    }

    public Boolean getCSRValid() {
        return this.isCSRValid;
    }

    public void setCSRValid(Boolean CSRValid) {
        this.isCSRValid = CSRValid;
    }

    public Boolean getServersideKeyGeneration() {
        return this.serversideKeyGeneration;
    }

    public void setServersideKeyGeneration(Boolean serversideKeyGeneration) {
        this.serversideKeyGeneration = serversideKeyGeneration;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public String getPublicKeyHash() {
        return this.publicKeyHash;
    }

    public void setPublicKeyHash(String publicKeyHash) {
        this.publicKeyHash = publicKeyHash;
    }

    public String getAdministeredBy() {
        return this.administeredBy;
    }

    public void setAdministeredBy(String administeredBy) {
        this.administeredBy = administeredBy;
    }

    public Instant getApprovedOn() {
        return this.approvedOn;
    }

    public void setApprovedOn(Instant approvedOn) {
        this.approvedOn = approvedOn;
    }

    public String getRequestorComment() {
        return this.requestorComment;
    }

    public void setRequestorComment(String requestorComment) {
        this.requestorComment = requestorComment;
    }

    public String getAdministrationComment() {
        return this.administrationComment;
    }

    public void setAdministrationComment(String administrationComment) {
        this.administrationComment = administrationComment;
    }

    public boolean getIsAdministrable() {
        return this.isAdministrable;
    }

    public void setAdministrable(boolean administrable) {
        this.isAdministrable = administrable;
    }

    public Long getPipelineId() {
        return this.pipelineId;
    }

    public void setPipelineId(Long pipelineId) {
        this.pipelineId = pipelineId;
    }

    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public void setHashAlgorithm(String hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
    }

    public boolean isAdministrable() {
        return this.isAdministrable;
    }

    public NamedValue[] getArArr() {
        return this.arArr;
    }

    public void setArArr(NamedValue[] arArr) {
        this.arArr = arArr;
    }
}

