/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.service.util;

import de.trustable.ca3s.core.domain.AuditTrace;
import de.trustable.ca3s.core.domain.BPMNProcessInfo;
import de.trustable.ca3s.core.domain.CAConnectorConfig;
import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.Certificate;
import de.trustable.ca3s.core.domain.Pipeline;
import de.trustable.ca3s.core.domain.PipelineAttribute;
import de.trustable.ca3s.core.domain.ProtectedContent;
import de.trustable.ca3s.core.domain.User;
import de.trustable.ca3s.core.domain.enumeration.ContentRelationType;
import de.trustable.ca3s.core.domain.enumeration.CsrUsage;
import de.trustable.ca3s.core.domain.enumeration.PipelineType;
import de.trustable.ca3s.core.domain.enumeration.ProtectedContentType;
import de.trustable.ca3s.core.domain.enumeration.RDNCardinalityRestriction;
import de.trustable.ca3s.core.exception.BadRequestAlertException;
import de.trustable.ca3s.core.repository.AuditTraceRepository;
import de.trustable.ca3s.core.repository.BPMNProcessInfoRepository;
import de.trustable.ca3s.core.repository.CAConnectorConfigRepository;
import de.trustable.ca3s.core.repository.CSRRepository;
import de.trustable.ca3s.core.repository.CertificateRepository;
import de.trustable.ca3s.core.repository.PipelineAttributeRepository;
import de.trustable.ca3s.core.repository.PipelineRepository;
import de.trustable.ca3s.core.repository.ProtectedContentRepository;
import de.trustable.ca3s.core.service.AuditService;
import de.trustable.ca3s.core.service.dto.ARARestriction;
import de.trustable.ca3s.core.service.dto.AcmeConfigItems;
import de.trustable.ca3s.core.service.dto.KeyAlgoLength;
import de.trustable.ca3s.core.service.dto.NamedValues;
import de.trustable.ca3s.core.service.dto.PipelineView;
import de.trustable.ca3s.core.service.dto.Preferences;
import de.trustable.ca3s.core.service.dto.RDNRestriction;
import de.trustable.ca3s.core.service.dto.SCEPConfigItems;
import de.trustable.ca3s.core.service.dto.TypedValue;
import de.trustable.ca3s.core.service.dto.WebConfigItems;
import de.trustable.ca3s.core.service.util.CSRUtil;
import de.trustable.ca3s.core.service.util.CertificateProcessingUtil;
import de.trustable.ca3s.core.service.util.CertificateUtil;
import de.trustable.ca3s.core.service.util.ConfigUtil;
import de.trustable.ca3s.core.service.util.PreferenceUtil;
import de.trustable.ca3s.core.service.util.ProtectedContentUtil;
import de.trustable.util.CryptoUtil;
import de.trustable.util.OidNameMapper;
import de.trustable.util.Pkcs10RequestHolder;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.GeneralName;
import org.jasypt.exceptions.EncryptionOperationNotPossibleException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PipelineUtil {
    public static final String RESTR_C_CARDINALITY = "RESTR_C_CARDINALITY";
    public static final String RESTR_C_TEMPLATE = "RESTR_C_TEMPLATE";
    public static final String RESTR_C_REGEXMATCH = "RESTR_C_REGEXMATCH";
    public static final String RESTR_C_REGEX = "RESTR_C_REGEX";
    public static final String RESTR_CN_CARDINALITY = "RESTR_CN_CARDINALITY";
    public static final String RESTR_CN_TEMPLATE = "RESTR_CN_TEMPLATE";
    public static final String RESTR_CN_REGEXMATCH = "RESTR_CN_REGEXMATCH";
    public static final String RESTR_CN_REGEX = "RESTR_CN_REGEX";
    public static final String RESTR_O_CARDINALITY = "RESTR_O_CARDINALITY";
    public static final String RESTR_O_TEMPLATE = "RESTR_O_TEMPLATE";
    public static final String RESTR_O_REGEXMATCH = "RESTR_O_REGEXMATCH";
    public static final String RESTR_O_REGEX = "RESTR_O_REGEX";
    public static final String RESTR_OU_CARDINALITY = "RESTR_OU_CARDINALITY";
    public static final String RESTR_OU_TEMPLATE = "RESTR_OU_TEMPLATE";
    public static final String RESTR_OU_REGEXMATCH = "RESTR_OU_REGEXMATCH";
    public static final String RESTR_OU_REGEX = "RESTR_OU_REGEX";
    public static final String RESTR_L_CARDINALITY = "RESTR_L_CARDINALITY";
    public static final String RESTR_L_TEMPLATE = "RESTR_L_TEMPLATE";
    public static final String RESTR_L_REGEXMATCH = "RESTR_L_REGEXMATCH";
    public static final String RESTR_L_REGEX = "RESTR_L_REGEX";
    public static final String RESTR_S_CARDINALITY = "RESTR_S_CARDINALITY";
    public static final String RESTR_S_TEMPLATE = "RESTR_S_TEMPLATE";
    public static final String RESTR_S_REGEXMATCH = "RESTR_S_REGEXMATCH";
    public static final String RESTR_S_REGEX = "RESTR_S_REGEX";
    public static final String RESTR_E_CARDINALITY = "RESTR_E_CARDINALITY";
    public static final String RESTR_E_TEMPLATE = "RESTR_E_TEMPLATE";
    public static final String RESTR_E_REGEXMATCH = "RESTR_E_REGEXMATCH";
    public static final String RESTR_E_REGEX = "RESTR_E_REGEX";
    public static final String RESTR_SAN_CARDINALITY = "RESTR_SAN_CARDINALITY";
    public static final String RESTR_SAN_TEMPLATE = "RESTR_SAN_TEMPLATE";
    public static final String RESTR_SAN_REGEXMATCH = "RESTR_SAN_REGEXMATCH";
    public static final String RESTR_SAN_REGEX = "RESTR_SAN_REGEX";
    public static final String RESTR_ARA_PREFIX = "RESTR_ARA_";
    public static final String RESTR_ARA_PATTERN = "RESTR_ARA_(.*)_(.*)";
    public static final String RESTR_ARA_NAME = "NAME";
    public static final String RESTR_ARA_TEMPLATE = "TEMPLATE";
    public static final String RESTR_ARA_REGEXMATCH = "REGEXMATCH";
    public static final String RESTR_ARA_REQUIRED = "REQUIRED";
    public static final String RESTR_ARA_COMMENT = "COMMENT";
    public static final String ALLOW_IP_AS_SUBJECT = "ALLOW_IP_AS_SUBJECT";
    public static final String ALLOW_IP_AS_SAN = "ALLOW_IP_AS_SAN";
    public static final String TO_PENDIND_ON_FAILED_RESTRICTIONS = "TO_PENDIND_ON_FAILED_RESTRICTIONS";
    public static final String DOMAIN_RA_OFFICER = "DOMAIN_RA_OFFICER";
    public static final String NOTIFY_RA_OFFICER_ON_PENDING = "NOTIFY_RA_OFFICER_ON_PENDING";
    public static final String ADDITIONAL_EMAIL_RECIPIENTS = "ADDITIONAL_EMAIL_RECIPIENTS";
    public static final String ACME_ALLOW_CHALLENGE_HTTP01 = "ACME_ALLOW_CHALLENGE_HTTP01";
    public static final String ACME_ALLOW_CHALLENGE_DNS = "ACME_ALLOW_CHALLENGE_DNS";
    public static final String ACME_ALLOW_CHALLENGE_WILDCARDS = "ACME_ALLOW_WILDCARDS";
    public static final String ACME_CHECK_CAA = "ACME_CHECK_CAA";
    public static final String ACME_NAME_CAA = "ACME_NAME_CAA";
    public static final String CSR_USAGE = "CSR_USAGE";
    public static final String LIST_ORDER = "LIST_ORDER";
    public static final String ACME_PROCESS_ACCOUNT_VALIDATION = "ACME_PROCESS_ACCOUNT_VALIDATION";
    public static final String ACME_PROCESS_ORDER_VALIDATION = "ACME_PROCESS_ORDER_VALIDATION";
    public static final String ACME_PROCESS_CHALLENGE_VALIDATION = "ACME_PROCESS_CHALLENGE_VALIDATION";
    public static final String ACME_ORDER_VALIDITY_SECONDS = "ACME_ORDER_VALIDITY_SECONDS";
    public static final String SCEP_CAPABILITY_RENEWAL = "SCEP_CAPABILITY_RENEWAL";
    public static final String SCEP_CAPABILITY_POST = "SCEP_CAPABILITY_POST";
    public static final String SCEP_SECRET = "SCEP_SECRET";
    public static final String SCEP_SECRET_VALID_TO = "SCEP_SECRET_VALID_TO";
    public static final String SCEP_SECRET_PC_ID = "SCEP_SECRET_PC_ID";
    public static final String SCEP_RECIPIENT_DN = "SCEP_RECIPIENT_DN";
    public static final String SCEP_RECIPIENT_KEY_TYPE_LEN = "SCEP_RECIPIENT_KEY_TYPE_LEN";
    public static final String SCEP_CA_CONNECTOR_RECIPIENT_NAME = "SCEP_CA_CONNECTOR_RECIPIENT_NAME";
    Logger LOG = LoggerFactory.getLogger(PipelineUtil.class);
    private final CertificateRepository certRepository;
    private final CSRRepository csrRepository;
    private final CAConnectorConfigRepository caConnRepository;
    private final PipelineRepository pipelineRepository;
    private final PipelineAttributeRepository pipelineAttRepository;
    private final BPMNProcessInfoRepository bpmnPIRepository;
    private final ProtectedContentRepository protectedContentRepository;
    private final ProtectedContentUtil protectedContentUtil;
    private final PreferenceUtil preferenceUtil;
    private final CertificateUtil certUtil;
    private final ConfigUtil configUtil;
    private final AuditService auditService;
    private final AuditTraceRepository auditTraceRepository;

    public PipelineUtil(CertificateRepository certRepository, CSRRepository csrRepository, CAConnectorConfigRepository caConnRepository, PipelineRepository pipelineRepository, PipelineAttributeRepository pipelineAttRepository, BPMNProcessInfoRepository bpmnPIRepository, ProtectedContentRepository protectedContentRepository, ProtectedContentUtil protectedContentUtil, PreferenceUtil preferenceUtil, CertificateUtil certUtil, ConfigUtil configUtil, AuditService auditService, AuditTraceRepository auditTraceRepository) {
        this.certRepository = certRepository;
        this.csrRepository = csrRepository;
        this.caConnRepository = caConnRepository;
        this.pipelineRepository = pipelineRepository;
        this.pipelineAttRepository = pipelineAttRepository;
        this.bpmnPIRepository = bpmnPIRepository;
        this.protectedContentRepository = protectedContentRepository;
        this.protectedContentUtil = protectedContentUtil;
        this.preferenceUtil = preferenceUtil;
        this.certUtil = certUtil;
        this.configUtil = configUtil;
        this.auditService = auditService;
        this.auditTraceRepository = auditTraceRepository;
    }

    public PipelineView from(Pipeline pipeline) {
        PipelineView pv = new PipelineView();
        pv.setId(pipeline.getId());
        pv.setName(pipeline.getName());
        pv.setType(pipeline.getType());
        pv.setActive(pipeline.isActive());
        pv.setDescription(pipeline.getDescription());
        pv.setApprovalRequired(pipeline.isApprovalRequired());
        pv.setUrlPart(pipeline.getUrlPart());
        if (pipeline.getCaConnector() != null) {
            pv.setCaConnectorName(pipeline.getCaConnector().getName());
        }
        if (pipeline.getProcessInfo() != null) {
            pv.setProcessInfoName(pipeline.getProcessInfo().getName());
        }
        RDNRestriction[] rdnRestrictArr = this.initRdnRestrictions(pv, pipeline);
        pv.setRdnRestrictions(rdnRestrictArr);
        pv.setAraRestrictions(new ARARestriction[0]);
        AcmeConfigItems acmeConfigItems = new AcmeConfigItems();
        SCEPConfigItems scepConfigItems = new SCEPConfigItems();
        WebConfigItems webConfigItems = new WebConfigItems();
        pv.setCsrUsage(CsrUsage.TLS_SERVER);
        ArrayList<String> domainRaOfficerList = new ArrayList<String>();
        for (PipelineAttribute plAtt : pipeline.getPipelineAttributes()) {
            if (ACME_ALLOW_CHALLENGE_HTTP01.equals(plAtt.getName())) {
                acmeConfigItems.setAllowChallengeHTTP01(Boolean.parseBoolean(plAtt.getValue()));
                continue;
            }
            if (ACME_ALLOW_CHALLENGE_DNS.equals(plAtt.getName())) {
                acmeConfigItems.setAllowChallengeDNS(Boolean.parseBoolean(plAtt.getValue()));
                continue;
            }
            if (ACME_ALLOW_CHALLENGE_WILDCARDS.equals(plAtt.getName())) {
                acmeConfigItems.setAllowWildcards(Boolean.parseBoolean(plAtt.getValue()));
                continue;
            }
            if (ACME_CHECK_CAA.equals(plAtt.getName())) {
                acmeConfigItems.setCheckCAA(Boolean.parseBoolean(plAtt.getValue()));
                continue;
            }
            if (ACME_NAME_CAA.equals(plAtt.getName())) {
                acmeConfigItems.setCaNameCAA(plAtt.getValue());
                continue;
            }
            if (DOMAIN_RA_OFFICER.equals(plAtt.getName())) {
                domainRaOfficerList.add(plAtt.getValue());
                continue;
            }
            if (NOTIFY_RA_OFFICER_ON_PENDING.equals(plAtt.getName())) {
                webConfigItems.setNotifyRAOfficerOnPendingRequest(Boolean.parseBoolean(plAtt.getValue()));
                continue;
            }
            if (ADDITIONAL_EMAIL_RECIPIENTS.equals(plAtt.getName())) {
                webConfigItems.setAdditionalEMailRecipients(plAtt.getValue());
                continue;
            }
            if (SCEP_RECIPIENT_DN.equals(plAtt.getName())) {
                scepConfigItems.setScepRecipientDN(plAtt.getValue());
                continue;
            }
            if (SCEP_RECIPIENT_KEY_TYPE_LEN.equals(plAtt.getName())) {
                KeyAlgoLength keyAlgoLength = KeyAlgoLength.valueOf((String)plAtt.getValue());
                scepConfigItems.setKeyAlgoLength(keyAlgoLength);
                continue;
            }
            if (SCEP_CA_CONNECTOR_RECIPIENT_NAME.equals(plAtt.getName())) {
                scepConfigItems.setCaConnectorRecipientName(plAtt.getValue());
                continue;
            }
            if (!SCEP_SECRET_PC_ID.equals(plAtt.getName())) continue;
            Optional optPC = this.protectedContentRepository.findById((Object)Long.parseLong(plAtt.getValue()));
            if (optPC.isPresent()) {
                ProtectedContent pc = (ProtectedContent)optPC.get();
                try {
                    String clearContent = this.protectedContentUtil.unprotectString(pc.getContentBase64());
                    scepConfigItems.setScepSecret(clearContent);
                    scepConfigItems.setScepSecretPCId(pc.getId().toString());
                    this.LOG.debug("pc id : " + pc.getId() + ", clearContent retrieved");
                    if (pc.getValidTo() == null) {
                        scepConfigItems.setScepSecretValidTo(Instant.now().truncatedTo(ChronoUnit.DAYS).plus(1L, ChronoUnit.DAYS));
                        continue;
                    }
                    scepConfigItems.setScepSecretValidTo(pc.getValidTo());
                }
                catch (EncryptionOperationNotPossibleException eonpe) {
                    this.LOG.error("pc id : " + pc.getId() + ", clearContent retrieval failed: " + eonpe.getMessage());
                }
                continue;
            }
            scepConfigItems.setScepSecret("-- expired --");
            this.LOG.debug("no protected content for pc id : " + plAtt.getValue());
        }
        pv.setDomainRaOfficerList(domainRaOfficerList.toArray(new String[0]));
        pv.setAcmeConfigItems(acmeConfigItems);
        pv.setScepConfigItems(scepConfigItems);
        pv.setWebConfigItems(webConfigItems);
        ARARestriction[] araRestrictions = this.initAraRestrictions(pipeline);
        pv.setAraRestrictions(araRestrictions);
        return pv;
    }

    @NotNull
    private RDNRestriction[] initRdnRestrictions(PipelineView pv, Pipeline pipeline) {
        RDNRestriction[] rdnRestrictArr = new RDNRestriction[8];
        RDNRestriction rdnRestrict = new RDNRestriction();
        rdnRestrict.setRdnName("C");
        rdnRestrict.setCardinalityRestriction(RDNCardinalityRestriction.ZERO_OR_ONE);
        pv.setRestriction_C(rdnRestrict);
        rdnRestrictArr[0] = rdnRestrict;
        rdnRestrict = new RDNRestriction();
        rdnRestrict.setRdnName("CN");
        rdnRestrict.setCardinalityRestriction(RDNCardinalityRestriction.ZERO_OR_ONE);
        pv.setRestriction_CN(rdnRestrict);
        rdnRestrictArr[1] = rdnRestrict;
        rdnRestrict = new RDNRestriction();
        rdnRestrict.setRdnName("O");
        rdnRestrict.setCardinalityRestriction(RDNCardinalityRestriction.ZERO_OR_ONE);
        pv.setRestriction_O(rdnRestrict);
        rdnRestrictArr[2] = rdnRestrict;
        rdnRestrict = new RDNRestriction();
        rdnRestrict.setRdnName("OU");
        rdnRestrict.setCardinalityRestriction(RDNCardinalityRestriction.ZERO_OR_MANY);
        pv.setRestriction_OU(rdnRestrict);
        rdnRestrictArr[3] = rdnRestrict;
        rdnRestrict = new RDNRestriction();
        rdnRestrict.setRdnName("L");
        rdnRestrict.setCardinalityRestriction(RDNCardinalityRestriction.ZERO_OR_ONE);
        pv.setRestriction_L(rdnRestrict);
        rdnRestrictArr[4] = rdnRestrict;
        rdnRestrict = new RDNRestriction();
        rdnRestrict.setRdnName("ST");
        rdnRestrict.setCardinalityRestriction(RDNCardinalityRestriction.ZERO_OR_ONE);
        pv.setRestriction_S(rdnRestrict);
        rdnRestrictArr[5] = rdnRestrict;
        rdnRestrict = new RDNRestriction();
        rdnRestrict.setRdnName("E");
        rdnRestrict.setCardinalityRestriction(RDNCardinalityRestriction.ZERO_OR_ONE);
        pv.setRestriction_E(rdnRestrict);
        rdnRestrictArr[6] = rdnRestrict;
        rdnRestrict = new RDNRestriction();
        rdnRestrict.setRdnName("SAN");
        rdnRestrict.setCardinalityRestriction(RDNCardinalityRestriction.ZERO_OR_MANY);
        pv.setRestriction_SAN(rdnRestrict);
        rdnRestrictArr[7] = rdnRestrict;
        for (PipelineAttribute plAtt : pipeline.getPipelineAttributes()) {
            if (ALLOW_IP_AS_SUBJECT.equals(plAtt.getName())) {
                pv.setIpAsSubjectAllowed(Boolean.parseBoolean(plAtt.getValue()));
                continue;
            }
            if (ALLOW_IP_AS_SAN.equals(plAtt.getName())) {
                pv.setIpAsSANAllowed(Boolean.parseBoolean(plAtt.getValue()));
                continue;
            }
            if (RESTR_C_CARDINALITY.equals(plAtt.getName())) {
                pv.getRestriction_C().setCardinalityRestriction(RDNCardinalityRestriction.valueOf((String)plAtt.getValue()));
                continue;
            }
            if (RESTR_C_TEMPLATE.equals(plAtt.getName())) {
                pv.getRestriction_C().setContentTemplate(plAtt.getValue());
                continue;
            }
            if (RESTR_C_REGEXMATCH.equals(plAtt.getName())) {
                pv.getRestriction_C().setRegExMatch(Boolean.parseBoolean(plAtt.getValue()));
                continue;
            }
            if (RESTR_C_REGEX.equals(plAtt.getName())) {
                pv.getRestriction_C().setRegEx(plAtt.getValue());
                continue;
            }
            if (RESTR_CN_CARDINALITY.equals(plAtt.getName())) {
                pv.getRestriction_CN().setCardinalityRestriction(RDNCardinalityRestriction.valueOf((String)plAtt.getValue()));
                continue;
            }
            if (RESTR_CN_TEMPLATE.equals(plAtt.getName())) {
                pv.getRestriction_CN().setContentTemplate(plAtt.getValue());
                continue;
            }
            if (RESTR_CN_REGEXMATCH.equals(plAtt.getName())) {
                pv.getRestriction_CN().setRegExMatch(Boolean.parseBoolean(plAtt.getValue()));
                continue;
            }
            if (RESTR_CN_REGEX.equals(plAtt.getName())) {
                pv.getRestriction_CN().setRegEx(plAtt.getValue());
                continue;
            }
            if (RESTR_O_CARDINALITY.equals(plAtt.getName())) {
                pv.getRestriction_O().setCardinalityRestriction(RDNCardinalityRestriction.valueOf((String)plAtt.getValue()));
                continue;
            }
            if (RESTR_O_TEMPLATE.equals(plAtt.getName())) {
                pv.getRestriction_O().setContentTemplate(plAtt.getValue());
                continue;
            }
            if (RESTR_O_REGEXMATCH.equals(plAtt.getName())) {
                pv.getRestriction_O().setRegExMatch(Boolean.parseBoolean(plAtt.getValue()));
                continue;
            }
            if (RESTR_O_REGEX.equals(plAtt.getName())) {
                pv.getRestriction_O().setRegEx(plAtt.getValue());
                continue;
            }
            if (RESTR_OU_CARDINALITY.equals(plAtt.getName())) {
                pv.getRestriction_OU().setCardinalityRestriction(RDNCardinalityRestriction.valueOf((String)plAtt.getValue()));
                continue;
            }
            if (RESTR_OU_TEMPLATE.equals(plAtt.getName())) {
                pv.getRestriction_OU().setContentTemplate(plAtt.getValue());
                continue;
            }
            if (RESTR_OU_REGEXMATCH.equals(plAtt.getName())) {
                pv.getRestriction_OU().setRegExMatch(Boolean.parseBoolean(plAtt.getValue()));
                continue;
            }
            if (RESTR_OU_REGEX.equals(plAtt.getName())) {
                pv.getRestriction_OU().setRegEx(plAtt.getValue());
                continue;
            }
            if (RESTR_L_CARDINALITY.equals(plAtt.getName())) {
                pv.getRestriction_L().setCardinalityRestriction(RDNCardinalityRestriction.valueOf((String)plAtt.getValue()));
                continue;
            }
            if (RESTR_L_TEMPLATE.equals(plAtt.getName())) {
                pv.getRestriction_L().setContentTemplate(plAtt.getValue());
                continue;
            }
            if (RESTR_L_REGEXMATCH.equals(plAtt.getName())) {
                pv.getRestriction_L().setRegExMatch(Boolean.parseBoolean(plAtt.getValue()));
                continue;
            }
            if (RESTR_L_REGEX.equals(plAtt.getName())) {
                pv.getRestriction_L().setRegEx(plAtt.getValue());
                continue;
            }
            if (RESTR_S_CARDINALITY.equals(plAtt.getName())) {
                pv.getRestriction_S().setCardinalityRestriction(RDNCardinalityRestriction.valueOf((String)plAtt.getValue()));
                continue;
            }
            if (RESTR_S_TEMPLATE.equals(plAtt.getName())) {
                pv.getRestriction_S().setContentTemplate(plAtt.getValue());
                continue;
            }
            if (RESTR_S_REGEXMATCH.equals(plAtt.getName())) {
                pv.getRestriction_S().setRegExMatch(Boolean.parseBoolean(plAtt.getValue()));
                continue;
            }
            if (RESTR_S_REGEX.equals(plAtt.getName())) {
                pv.getRestriction_S().setRegEx(plAtt.getValue());
                continue;
            }
            if (RESTR_E_CARDINALITY.equals(plAtt.getName())) {
                pv.getRestriction_E().setCardinalityRestriction(RDNCardinalityRestriction.valueOf((String)plAtt.getValue()));
                continue;
            }
            if (RESTR_E_TEMPLATE.equals(plAtt.getName())) {
                pv.getRestriction_E().setContentTemplate(plAtt.getValue());
                continue;
            }
            if (RESTR_E_REGEXMATCH.equals(plAtt.getName())) {
                pv.getRestriction_E().setRegExMatch(Boolean.parseBoolean(plAtt.getValue()));
                continue;
            }
            if (RESTR_E_REGEX.equals(plAtt.getName())) {
                pv.getRestriction_E().setRegEx(plAtt.getValue());
                continue;
            }
            if (RESTR_SAN_CARDINALITY.equals(plAtt.getName())) {
                pv.getRestriction_SAN().setCardinalityRestriction(RDNCardinalityRestriction.valueOf((String)plAtt.getValue()));
                continue;
            }
            if (RESTR_SAN_TEMPLATE.equals(plAtt.getName())) {
                pv.getRestriction_SAN().setContentTemplate(plAtt.getValue());
                continue;
            }
            if (RESTR_SAN_REGEXMATCH.equals(plAtt.getName())) {
                pv.getRestriction_SAN().setRegExMatch(Boolean.parseBoolean(plAtt.getValue()));
                continue;
            }
            if (RESTR_SAN_REGEX.equals(plAtt.getName())) {
                pv.getRestriction_SAN().setRegEx(plAtt.getValue());
                continue;
            }
            if (CSR_USAGE.equals(plAtt.getName())) {
                pv.setCsrUsage(CsrUsage.valueOf((String)plAtt.getValue()));
                continue;
            }
            if (LIST_ORDER.equals(plAtt.getName())) {
                pv.setListOrder(Integer.parseInt(plAtt.getValue()));
                continue;
            }
            if (!TO_PENDIND_ON_FAILED_RESTRICTIONS.equals(plAtt.getName())) continue;
            pv.setToPendingOnFailedRestrictions(Boolean.parseBoolean(plAtt.getValue()));
        }
        return rdnRestrictArr;
    }

    @NotNull
    public ARARestriction[] initAraRestrictions(Pipeline pipeline) {
        Pattern araPattern = Pattern.compile(RESTR_ARA_PATTERN);
        int nARA = 0;
        for (PipelineAttribute plAtt : pipeline.getPipelineAttributes()) {
            int araIdx;
            Matcher m;
            if (!plAtt.getName().startsWith(RESTR_ARA_PREFIX) || !(m = araPattern.matcher(plAtt.getName())).find() || (araIdx = Integer.parseInt(m.group(1))) + 1 <= nARA) continue;
            nARA = araIdx + 1;
        }
        this.LOG.debug("#{} ARA itmes found", (Object)nARA);
        ARARestriction[] araRestrictions = new ARARestriction[nARA];
        for (PipelineAttribute plAtt : pipeline.getPipelineAttributes()) {
            if (!plAtt.getName().startsWith(RESTR_ARA_PREFIX)) continue;
            this.LOG.debug("ARA itmes : {}", (Object)plAtt.getName());
            Matcher m = araPattern.matcher(plAtt.getName());
            if (!m.find()) continue;
            int araIdx = Integer.parseInt(m.group(1));
            this.LOG.debug("araIdx: {}", (Object)araIdx);
            if (araRestrictions[araIdx] == null) {
                araRestrictions[araIdx] = new ARARestriction();
            }
            ARARestriction araRestriction = araRestrictions[araIdx];
            String namePart = m.group(2);
            this.LOG.debug("ARA namePart : {}", (Object)namePart);
            if (RESTR_ARA_NAME.equals(namePart)) {
                araRestriction.setName(plAtt.getValue());
                continue;
            }
            if (RESTR_ARA_REQUIRED.equals(namePart)) {
                araRestriction.setRequired(Boolean.parseBoolean(plAtt.getValue()));
                continue;
            }
            if (RESTR_ARA_TEMPLATE.equals(namePart)) {
                araRestriction.setContentTemplate(plAtt.getValue());
                continue;
            }
            if (RESTR_ARA_COMMENT.equals(namePart)) {
                araRestriction.setComment(plAtt.getValue());
                continue;
            }
            if (!RESTR_ARA_REGEXMATCH.equals(namePart)) continue;
            araRestriction.setRegExMatch(Boolean.parseBoolean(plAtt.getValue()));
        }
        return araRestrictions;
    }

    public Pipeline toPipeline(PipelineView pv) {
        ProtectedContent pc;
        List listPC;
        Optional bpiOpt;
        List ccc;
        Pipeline p;
        ArrayList<AuditTrace> auditList = new ArrayList<AuditTrace>();
        List pipelineList = this.pipelineRepository.findByName(pv.getName());
        if (pv.getId() != null) {
            Optional optP = this.pipelineRepository.findById((Object)pv.getId());
            if (optP.isPresent()) {
                p = (Pipeline)optP.get();
                if (!pipelineList.isEmpty() && !((Pipeline)pipelineList.get(0)).getId().equals(p.getId())) {
                    throw new BadRequestAlertException("Name '" + pv.getName() + "' already assigned", "pipeline", "name already used");
                }
                this.pipelineAttRepository.deleteAll((Iterable)p.getPipelineAttributes());
            } else {
                if (!pipelineList.isEmpty()) {
                    throw new BadRequestAlertException("Name '" + pv.getName() + "' already assigned", "pipeline", "name already used");
                }
                p = new Pipeline();
                this.pipelineRepository.save((Object)p);
                auditList.add(this.auditService.createAuditTracePipeline("PIPELINE_CREATED", p));
            }
        } else {
            if (!pipelineList.isEmpty()) {
                throw new BadRequestAlertException("Name '" + pv.getName() + "' already assigned", "pipeline", "name already used");
            }
            Pipeline pipelineByName = this.getPipelineByRealm(pv.getType(), pv.getUrlPart());
            if (pipelineByName != null) {
                throw new BadRequestAlertException("Realm '" + pv.getUrlPart() + "' already exists with pipeline " + pipelineByName.getName() + " / " + pipelineByName.getUrlPart(), "pipeline", "realmexists");
            }
            p = new Pipeline();
            p.setName(pv.getName());
            p.setType(pv.getType());
            this.pipelineRepository.save((Object)p);
            auditList.add(this.auditService.createAuditTracePipeline("PIPELINE_COPIED", p));
        }
        if (!Objects.equals(pv.getName(), p.getName())) {
            auditList.add(this.auditService.createAuditTracePipeline("PIPELINE_NAME_CHANGED", p.getName(), pv.getName(), p));
            p.setName(pv.getName());
        }
        if (!Objects.equals(pv.getDescription(), p.getDescription())) {
            auditList.add(this.auditService.createAuditTracePipeline("PIPELINE_DESCRIPTION_CHANGED", p.getDescription(), pv.getDescription(), p));
            p.setDescription(pv.getDescription());
        }
        if (!pv.getType().equals((Object)p.getType())) {
            String oldType = "";
            if (p.getType() != null) {
                oldType = p.getType().toString();
            }
            auditList.add(this.auditService.createAuditTracePipeline("PIPELINE_TYPE_CHANGED", oldType, pv.getType().toString(), p));
            p.setType(pv.getType());
        }
        if (!Objects.equals(pv.getUrlPart(), p.getUrlPart())) {
            auditList.add(this.auditService.createAuditTracePipeline("PIPELINE_URLPART_CHANGED", p.getUrlPart(), pv.getUrlPart(), p));
            p.setUrlPart(pv.getUrlPart());
        }
        if (pv.getApprovalRequired() != p.isApprovalRequired()) {
            String isApprovalRequired = "";
            if (p.isApprovalRequired() != null) {
                isApprovalRequired = p.isApprovalRequired().toString();
            }
            auditList.add(this.auditService.createAuditTracePipeline("PIPELINE_APPROVAL_REQUIRED_CHANGED", isApprovalRequired, pv.getApprovalRequired().toString(), p));
            p.setApprovalRequired(pv.getApprovalRequired());
        }
        if (pv.getActive() != p.isActive()) {
            String isActive = "";
            if (p.isActive() != null) {
                isActive = p.isActive().toString();
            }
            auditList.add(this.auditService.createAuditTracePipeline("PIPELINE_ACTIVE_CHANGED", isActive, pv.getActive().toString(), p));
            p.setActive(pv.getActive());
        }
        if (p.isActive() == null) {
            auditList.add(this.auditService.createAuditTracePipeline("PIPELINE_ACTIVE_CHANGED", null, Boolean.FALSE.toString(), p));
            p.setActive(Boolean.FALSE);
        }
        String oldCaConnectorName = "";
        if (p.getCaConnector() != null) {
            oldCaConnectorName = p.getCaConnector().getName();
        }
        if ((ccc = this.caConnRepository.findByName(pv.getCaConnectorName())).isEmpty()) {
            p.setCaConnector(null);
            auditList.add(this.auditService.createAuditTracePipelineAttribute("CA_CONNECTOR", oldCaConnectorName, "", p));
        } else {
            p.setCaConnector((CAConnectorConfig)ccc.get(0));
            if (!((CAConnectorConfig)ccc.get(0)).getName().equals(oldCaConnectorName)) {
                auditList.add(this.auditService.createAuditTracePipelineAttribute("CA_CONNECTOR", oldCaConnectorName, ((CAConnectorConfig)ccc.get(0)).getName(), p));
            }
        }
        String oldProcessName = "";
        if (p.getProcessInfo() != null) {
            oldProcessName = p.getProcessInfo().getName();
        }
        if ((bpiOpt = this.bpmnPIRepository.findByName(pv.getProcessInfoName())).isPresent()) {
            BPMNProcessInfo bpi = (BPMNProcessInfo)bpiOpt.get();
            p.setProcessInfo(bpi);
            if (!bpi.getName().equals(oldProcessName)) {
                auditList.add(this.auditService.createAuditTracePipelineAttribute("ISSUANCE_PROCESS", oldProcessName, bpi.getName(), p));
            }
        } else {
            p.setProcessInfo(null);
            if (!oldProcessName.equals("")) {
                auditList.add(this.auditService.createAuditTracePipelineAttribute("ISSUANCE_PROCESS", oldProcessName, "", p));
            }
        }
        HashSet pipelineOldAttributes = new HashSet(p.getPipelineAttributes());
        this.LOG.debug("PipelineAttributes : cloned old #{}, new {}", (Object)pipelineOldAttributes.size(), (Object)p.getPipelineAttributes().size());
        HashSet pipelineAttributes = new HashSet();
        this.addPipelineAttribute(pipelineAttributes, p, auditList, RESTR_C_CARDINALITY, pv.getRestriction_C().getCardinalityRestriction().name());
        this.addPipelineAttribute(pipelineAttributes, p, auditList, RESTR_C_TEMPLATE, pv.getRestriction_C().getContentTemplate());
        this.addPipelineAttribute(pipelineAttributes, p, auditList, RESTR_C_REGEXMATCH, Boolean.valueOf(pv.getRestriction_C().isRegExMatch()));
        this.addPipelineAttribute(pipelineAttributes, p, auditList, RESTR_C_REGEX, pv.getRestriction_C().getRegEx());
        this.addPipelineAttribute(pipelineAttributes, p, auditList, RESTR_CN_CARDINALITY, pv.getRestriction_CN().getCardinalityRestriction().name());
        this.addPipelineAttribute(pipelineAttributes, p, auditList, RESTR_CN_TEMPLATE, pv.getRestriction_CN().getContentTemplate());
        this.addPipelineAttribute(pipelineAttributes, p, auditList, RESTR_CN_REGEXMATCH, Boolean.valueOf(pv.getRestriction_CN().isRegExMatch()));
        this.addPipelineAttribute(pipelineAttributes, p, auditList, RESTR_CN_REGEX, pv.getRestriction_CN().getRegEx());
        this.addPipelineAttribute(pipelineAttributes, p, auditList, RESTR_O_CARDINALITY, pv.getRestriction_O().getCardinalityRestriction().name());
        this.addPipelineAttribute(pipelineAttributes, p, auditList, RESTR_O_TEMPLATE, pv.getRestriction_O().getContentTemplate());
        this.addPipelineAttribute(pipelineAttributes, p, auditList, RESTR_O_REGEXMATCH, Boolean.valueOf(pv.getRestriction_O().isRegExMatch()));
        this.addPipelineAttribute(pipelineAttributes, p, auditList, RESTR_O_REGEX, pv.getRestriction_O().getRegEx());
        this.addPipelineAttribute(pipelineAttributes, p, auditList, RESTR_OU_CARDINALITY, pv.getRestriction_OU().getCardinalityRestriction().name());
        this.addPipelineAttribute(pipelineAttributes, p, auditList, RESTR_OU_TEMPLATE, pv.getRestriction_OU().getContentTemplate());
        this.addPipelineAttribute(pipelineAttributes, p, auditList, RESTR_OU_REGEXMATCH, Boolean.valueOf(pv.getRestriction_OU().isRegExMatch()));
        this.addPipelineAttribute(pipelineAttributes, p, auditList, RESTR_OU_REGEX, pv.getRestriction_OU().getRegEx());
        this.addPipelineAttribute(pipelineAttributes, p, auditList, RESTR_L_CARDINALITY, pv.getRestriction_L().getCardinalityRestriction().name());
        this.addPipelineAttribute(pipelineAttributes, p, auditList, RESTR_L_TEMPLATE, pv.getRestriction_L().getContentTemplate());
        this.addPipelineAttribute(pipelineAttributes, p, auditList, RESTR_L_REGEXMATCH, Boolean.valueOf(pv.getRestriction_L().isRegExMatch()));
        this.addPipelineAttribute(pipelineAttributes, p, auditList, RESTR_L_REGEX, pv.getRestriction_L().getRegEx());
        this.addPipelineAttribute(pipelineAttributes, p, auditList, RESTR_S_CARDINALITY, pv.getRestriction_S().getCardinalityRestriction().name());
        this.addPipelineAttribute(pipelineAttributes, p, auditList, RESTR_S_TEMPLATE, pv.getRestriction_S().getContentTemplate());
        this.addPipelineAttribute(pipelineAttributes, p, auditList, RESTR_S_REGEXMATCH, Boolean.valueOf(pv.getRestriction_S().isRegExMatch()));
        this.addPipelineAttribute(pipelineAttributes, p, auditList, RESTR_S_REGEX, pv.getRestriction_S().getRegEx());
        this.addPipelineAttribute(pipelineAttributes, p, auditList, RESTR_E_CARDINALITY, pv.getRestriction_E().getCardinalityRestriction().name());
        this.addPipelineAttribute(pipelineAttributes, p, auditList, RESTR_E_TEMPLATE, pv.getRestriction_E().getContentTemplate());
        this.addPipelineAttribute(pipelineAttributes, p, auditList, RESTR_E_REGEXMATCH, Boolean.valueOf(pv.getRestriction_E().isRegExMatch()));
        this.addPipelineAttribute(pipelineAttributes, p, auditList, RESTR_E_REGEX, pv.getRestriction_E().getRegEx());
        this.addPipelineAttribute(pipelineAttributes, p, auditList, RESTR_SAN_CARDINALITY, pv.getRestriction_SAN().getCardinalityRestriction().name());
        this.addPipelineAttribute(pipelineAttributes, p, auditList, RESTR_SAN_TEMPLATE, pv.getRestriction_SAN().getContentTemplate());
        this.addPipelineAttribute(pipelineAttributes, p, auditList, RESTR_SAN_REGEXMATCH, Boolean.valueOf(pv.getRestriction_SAN().isRegExMatch()));
        this.addPipelineAttribute(pipelineAttributes, p, auditList, RESTR_SAN_REGEX, pv.getRestriction_SAN().getRegEx());
        this.addPipelineAttribute(pipelineAttributes, p, auditList, ALLOW_IP_AS_SUBJECT, Boolean.valueOf(pv.isIpAsSubjectAllowed()));
        this.addPipelineAttribute(pipelineAttributes, p, auditList, ALLOW_IP_AS_SAN, Boolean.valueOf(pv.isIpAsSANAllowed()));
        this.LOG.debug("PipelineAttributes : ALLOW_IP_AS_SAN set to {}", (Object)pv.isIpAsSANAllowed());
        this.addPipelineAttribute(pipelineAttributes, p, auditList, TO_PENDIND_ON_FAILED_RESTRICTIONS, Boolean.valueOf(pv.isToPendingOnFailedRestrictions()));
        if (pv.getAcmeConfigItems() == null) {
            AcmeConfigItems acmeConfigItems = new AcmeConfigItems();
            pv.setAcmeConfigItems(acmeConfigItems);
        }
        if (PipelineType.ACME.equals((Object)pv.getType())) {
            if (!pv.getAcmeConfigItems().isAllowChallengeDNS()) {
                pv.getAcmeConfigItems().setAllowChallengeHTTP01(true);
                pv.getAcmeConfigItems().setAllowWildcards(false);
            }
            this.addPipelineAttribute(pipelineAttributes, p, auditList, ACME_ALLOW_CHALLENGE_HTTP01, Boolean.valueOf(pv.getAcmeConfigItems().isAllowChallengeHTTP01()));
            this.addPipelineAttribute(pipelineAttributes, p, auditList, ACME_ALLOW_CHALLENGE_DNS, Boolean.valueOf(pv.getAcmeConfigItems().isAllowChallengeDNS()));
            this.addPipelineAttribute(pipelineAttributes, p, auditList, ACME_ALLOW_CHALLENGE_WILDCARDS, Boolean.valueOf(pv.getAcmeConfigItems().isAllowWildcards()));
            this.addPipelineAttribute(pipelineAttributes, p, auditList, ACME_CHECK_CAA, Boolean.valueOf(pv.getAcmeConfigItems().isCheckCAA()));
            this.addPipelineAttribute(pipelineAttributes, p, auditList, ACME_NAME_CAA, pv.getAcmeConfigItems().getCaNameCAA());
        }
        this.addPipelineAttribute(pipelineAttributes, p, auditList, CSR_USAGE, pv.getCsrUsage().toString());
        if (PipelineType.WEB.equals((Object)pv.getType())) {
            this.addPipelineAttribute(pipelineAttributes, p, auditList, LIST_ORDER, "" + pv.getListOrder());
        }
        if (pv.getScepConfigItems() == null) {
            String[] scepConfigItems = new SCEPConfigItems();
            pv.setScepConfigItems((SCEPConfigItems)scepConfigItems);
        }
        if (PipelineType.SCEP.equals((Object)pv.getType())) {
            this.addPipelineAttribute(pipelineAttributes, p, auditList, SCEP_CAPABILITY_RENEWAL, Boolean.valueOf(pv.getScepConfigItems().isCapabilityRenewal()));
            this.addPipelineAttribute(pipelineAttributes, p, auditList, SCEP_CAPABILITY_POST, Boolean.valueOf(pv.getScepConfigItems().isCapabilityPostPKIOperation()));
            this.addPipelineAttribute(pipelineAttributes, p, auditList, SCEP_RECIPIENT_DN, pv.getScepConfigItems().getScepRecipientDN());
            this.addPipelineAttribute(pipelineAttributes, p, auditList, SCEP_RECIPIENT_KEY_TYPE_LEN, pv.getScepConfigItems().getKeyAlgoLength().toString());
            this.addPipelineAttribute(pipelineAttributes, p, auditList, SCEP_CA_CONNECTOR_RECIPIENT_NAME, pv.getScepConfigItems().getCaConnectorRecipientName());
        }
        if (pv.getWebConfigItems() != null) {
            this.addPipelineAttribute(pipelineAttributes, p, auditList, NOTIFY_RA_OFFICER_ON_PENDING, Boolean.valueOf(pv.getWebConfigItems().isNotifyRAOfficerOnPendingRequest()));
            this.addPipelineAttribute(pipelineAttributes, p, auditList, ADDITIONAL_EMAIL_RECIPIENTS, pv.getWebConfigItems().getAdditionalEMailRecipients());
        }
        if (pv.getDomainRaOfficerList() != null) {
            for (String domainOfficer : pv.getDomainRaOfficerList()) {
                this.addPipelineAttribute(pipelineAttributes, p, auditList, DOMAIN_RA_OFFICER, domainOfficer);
            }
        }
        if ((listPC = this.protectedContentRepository.findByTypeRelationId(ProtectedContentType.PASSWORD, ContentRelationType.SCEP_PW, p.getId())).isEmpty()) {
            pc = new ProtectedContent();
            pc.setType(ProtectedContentType.PASSWORD);
            pc.setRelationType(ContentRelationType.SCEP_PW);
            pc.setRelatedId(p.getId());
            pc.setLeftUsages(Integer.valueOf(-1));
            pc.setValidTo(ProtectedContentUtil.MAX_INSTANT);
            pc.setDeleteAfter(ProtectedContentUtil.MAX_INSTANT);
            this.LOG.debug("Protected Content created for SCEP password");
        } else {
            pc = (ProtectedContent)listPC.get(0);
            this.LOG.debug("Protected Content found for SCEP password");
        }
        String oldContent = this.protectedContentUtil.unprotectString(pc.getContentBase64());
        Instant validTo = pv.getScepConfigItems().getScepSecretValidTo();
        if (oldContent == null || !oldContent.equals(pv.getScepConfigItems().getScepSecret()) || pc.getValidTo() == null || !pc.getValidTo().equals(validTo)) {
            pc.setContentBase64(this.protectedContentUtil.protectString(pv.getScepConfigItems().getScepSecret()));
            pc.setValidTo(validTo);
            pc.setDeleteAfter(validTo.plus(1L, ChronoUnit.DAYS));
            this.protectedContentRepository.save((Object)pc);
            this.LOG.debug("SCEP password updated {} -> {}, {} -> {}", new Object[]{oldContent, pv.getScepConfigItems().getScepSecret(), validTo, pc.getValidTo()});
            auditList.add(this.auditService.createAuditTracePipelineAttribute(SCEP_SECRET, "#######", "******", p));
        }
        this.addPipelineAttribute(pipelineAttributes, p, auditList, SCEP_SECRET_PC_ID, pc.getId().toString());
        p.setPipelineAttributes(pipelineAttributes);
        ARARestriction[] araRestrictions = pv.getAraRestrictions();
        if (araRestrictions != null) {
            int j = 0;
            for (ARARestriction araRestriction : araRestrictions) {
                String araName = araRestriction.getName();
                if (araName == null || araName.trim().isEmpty()) continue;
                this.addPipelineAttribute(pipelineAttributes, p, auditList, RESTR_ARA_PREFIX + j + "_" + RESTR_ARA_NAME, araName.trim());
                this.addPipelineAttribute(pipelineAttributes, p, auditList, RESTR_ARA_PREFIX + j + "_" + RESTR_ARA_REQUIRED, Boolean.valueOf(araRestriction.isRequired()));
                this.addPipelineAttribute(pipelineAttributes, p, auditList, RESTR_ARA_PREFIX + j + "_" + RESTR_ARA_TEMPLATE, araRestriction.getContentTemplate());
                this.addPipelineAttribute(pipelineAttributes, p, auditList, RESTR_ARA_PREFIX + j + "_" + RESTR_ARA_COMMENT, araRestriction.getComment());
                this.addPipelineAttribute(pipelineAttributes, p, auditList, RESTR_ARA_PREFIX + j + "_" + RESTR_ARA_REGEXMATCH, Boolean.valueOf(araRestriction.isRegExMatch()));
                ++j;
            }
        }
        this.auditTraceForAttributes(p, auditList, pipelineOldAttributes);
        p.setPipelineAttributes(pipelineAttributes);
        this.pipelineAttRepository.saveAll((Iterable)p.getPipelineAttributes());
        this.pipelineRepository.save((Object)p);
        this.auditTraceRepository.saveAll(auditList);
        return p;
    }

    private void auditTraceForAttributes(Pipeline p, List<AuditTrace> auditList, Set<PipelineAttribute> pipelineOldAttributes) {
        boolean bFound;
        this.LOG.debug("matching PipelineAttributes : old #{}, new {}", (Object)pipelineOldAttributes.size(), (Object)p.getPipelineAttributes().size());
        for (PipelineAttribute pOld : pipelineOldAttributes) {
            bFound = false;
            for (PipelineAttribute pNew : p.getPipelineAttributes()) {
                if (!pNew.getName().equals(pOld.getName())) continue;
                if (!Objects.equals(pNew.getValue(), pOld.getValue())) {
                    auditList.add(this.auditService.createAuditTracePipelineAttribute(pOld.getName(), pOld.getValue(), pNew.getValue(), p));
                }
                bFound = true;
                break;
            }
            if (bFound) continue;
            auditList.add(this.auditService.createAuditTracePipelineAttribute(pOld.getName(), pOld.getValue(), "", p));
        }
        for (PipelineAttribute pNew : p.getPipelineAttributes()) {
            bFound = false;
            for (PipelineAttribute pOld : pipelineOldAttributes) {
                if (!pNew.getName().equals(pOld.getName())) continue;
                bFound = true;
                break;
            }
            if (bFound) continue;
            auditList.add(this.auditService.createAuditTracePipelineAttribute(pNew.getName(), "", pNew.getValue(), p));
            this.LOG.debug("matching PipelineAttributes : new name {} not found in old list", (Object)pNew.getName());
        }
    }

    public void addPipelineAttribute(Set<PipelineAttribute> pipelineAttributes, Pipeline p, List<AuditTrace> auditList, String name, Boolean value) {
        this.addPipelineAttribute(pipelineAttributes, p, auditList, name, value.toString());
    }

    public void addPipelineAttribute(Set<PipelineAttribute> pipelineAttributes, Pipeline p, List<AuditTrace> auditList, String name, String value) {
        if (name == null || name.trim().isEmpty()) {
            new Exception("name == null").printStackTrace();
            return;
        }
        if (value == null || value.trim().isEmpty()) {
            return;
        }
        PipelineAttribute pAtt = new PipelineAttribute();
        pAtt.setPipeline(p);
        pAtt.setName(name);
        pAtt.setValue(value);
        pipelineAttributes.add(pAtt);
        auditList.add(this.auditService.createAuditTracePipelineAttribute(name, "", value, p));
        this.LOG.debug("matching PipelineAttributes : new attribute with name '{}' and value  '{}' added", (Object)name, (Object)value);
    }

    public boolean isPipelineRestrictionsResolved(Pipeline p, Pkcs10RequestHolder p10ReqHolder, NamedValues[] nvARArr, List<String> messageList) {
        if (p == null) {
            return true;
        }
        if (!this.isPipelineAdditionalRestrictionsResolved(this.initAraRestrictions(p), nvARArr, messageList)) {
            return false;
        }
        return this.isPipelineRestrictionsResolved(p, p10ReqHolder, messageList);
    }

    public boolean isPipelineRestrictionsResolved(Pipeline p, Pkcs10RequestHolder p10ReqHolder, List<String> messageList) {
        if (p == null) {
            return true;
        }
        PipelineView pv = new PipelineView();
        this.initRdnRestrictions(pv, p);
        return this.isPipelineRestrictionsResolved(pv, p10ReqHolder, messageList);
    }

    public boolean isPipelineAdditionalRestrictionsResolved(ARARestriction[] araRestrictions, NamedValues[] nvARArr, List<String> messageList) {
        boolean outcome = true;
        for (NamedValues namedValues : nvARArr) {
            for (ARARestriction araRestriction : araRestrictions) {
                if (!araRestriction.getName().equals(namedValues.getName()) || this.checkAdditionalRestrictions(araRestriction, namedValues, messageList)) continue;
                outcome = false;
            }
        }
        for (NamedValues namedValues : araRestrictions) {
            if (!namedValues.isRequired() || !Arrays.stream(nvARArr).noneMatch(arg_0 -> PipelineUtil.lambda$isPipelineAdditionalRestrictionsResolved$0((ARARestriction)namedValues, arg_0))) continue;
            String msg = "additional restriction mismatch: An value for '" + namedValues.getName() + "' MUST be present!";
            messageList.add(msg);
            this.LOG.debug(msg);
            outcome = false;
        }
        return outcome;
    }

    public boolean isPipelineRestrictionsResolved(PipelineView pv, Pkcs10RequestHolder p10ReqHolder, List<String> messageList) {
        String msg;
        boolean outcome = this.isAlgorithmRestrictionsResolved(pv, p10ReqHolder, messageList);
        Set gNameSet = CSRUtil.getSANList((Attribute[])p10ReqHolder.getReqAttributes());
        this.LOG.debug("#" + gNameSet.size() + " SANs present");
        RDN[] rdnArr = p10ReqHolder.getSubjectRDNs();
        if (!this.checkRestrictions(BCStyle.C, pv.getRestriction_C(), rdnArr, messageList)) {
            outcome = false;
        }
        if (!this.checkRestrictions(BCStyle.CN, pv.getRestriction_CN(), rdnArr, gNameSet, messageList)) {
            outcome = false;
        }
        if (!this.checkRestrictions(BCStyle.O, pv.getRestriction_O(), rdnArr, messageList)) {
            outcome = false;
        }
        if (!this.checkRestrictions(BCStyle.OU, pv.getRestriction_OU(), rdnArr, messageList)) {
            outcome = false;
        }
        if (!this.checkRestrictions(BCStyle.L, pv.getRestriction_L(), rdnArr, messageList)) {
            outcome = false;
        }
        if (!this.checkRestrictions(BCStyle.ST, pv.getRestriction_S(), rdnArr, messageList)) {
            outcome = false;
        }
        if (!this.checkRestrictions(BCStyle.E, pv.getRestriction_E(), rdnArr, messageList)) {
            outcome = false;
        }
        if (!this.checkRestrictions(pv.getRestriction_SAN(), gNameSet, messageList)) {
            outcome = false;
        }
        this.LOG.debug("pv.isIpAsSubjectAllowed() is {} ", (Object)pv.isIpAsSubjectAllowed());
        if (!pv.isIpAsSubjectAllowed() && this.isSubjectIP(rdnArr, messageList)) {
            msg = "IP not allowed as subject";
            messageList.add(0, msg);
            this.LOG.info(msg);
            outcome = false;
        }
        this.LOG.debug("pv.isIpAsSANAllowed() is {} ", (Object)pv.isIpAsSANAllowed());
        if (!pv.isIpAsSANAllowed() && this.hasIPinSANList(gNameSet, messageList)) {
            msg = "IP not allowed as SAN";
            messageList.add(0, msg);
            this.LOG.info(msg);
            outcome = false;
        }
        return outcome;
    }

    public boolean isAlgorithmRestrictionsResolved(PipelineView pv, Pkcs10RequestHolder p10ReqHolder, List<String> messageList) {
        boolean outcome = true;
        Preferences preferences = this.preferenceUtil.getPrefs(PreferenceUtil.SYSTEM_PREFERENCE_ID);
        String hashAlgName = p10ReqHolder.getAlgorithmInfo().getHashAlgName();
        if (Arrays.stream(preferences.getSelectedHashes()).noneMatch(a -> a.equalsIgnoreCase(hashAlgName))) {
            String msg = "restriction mismatch: hash algo '" + hashAlgName + "' does not match expected set!";
            messageList.add(msg);
            this.LOG.debug(msg);
            outcome = false;
        }
        String signingAlgo = "rsa";
        int keyLength = CertificateUtil.getAlignedKeyLength((PublicKey)p10ReqHolder.getPublicSigningKey());
        if (Arrays.stream(preferences.getSelectedSigningAlgos()).noneMatch(a -> this.matchesAlgo(a, signingAlgo, keyLength))) {
            String msg = "restriction mismatch: signature algo / length '" + signingAlgo + "/" + keyLength + "' does not match expected set!";
            messageList.add(msg);
            this.LOG.info(msg);
            outcome = false;
        }
        return outcome;
    }

    private boolean matchesAlgo(String a, String signingAlgo, int keyLength) {
        String[] parts = a.split("-");
        if (parts.length != 2) {
            this.LOG.warn("unexpected keyLength / type descriptor: '{}'", (Object)a);
            return false;
        }
        if (!parts[0].equalsIgnoreCase(signingAlgo)) {
            this.LOG.debug("type check  mismatch: '{}' / '{}'", (Object)parts[0], (Object)signingAlgo);
            return false;
        }
        try {
            int keyLengthRestriction = Integer.parseInt(parts[1]);
            return keyLengthRestriction == keyLength;
        }
        catch (NumberFormatException nfe) {
            this.LOG.warn("unexpected number in keyLengthdescriptor: '" + a + "'", (Throwable)nfe);
            return false;
        }
    }

    private boolean hasIPinSANList(Set<GeneralName> gNameSet, List<String> messageList) {
        boolean outcome = false;
        for (GeneralName gn : gNameSet) {
            if (7 != gn.getTagNo()) continue;
            String sanValue = CertificateUtil.getTypedSAN((GeneralName)gn);
            messageList.add("SAN '" + sanValue + "' is an IP address, not allowed.");
            outcome = true;
        }
        return outcome;
    }

    private boolean checkRestrictions(RDNRestriction restriction, Set<GeneralName> gNameSet, List<String> messageList) {
        String msg;
        if (restriction == null) {
            return true;
        }
        boolean outcome = true;
        String regEx = "";
        this.LOG.debug("checking SANs");
        boolean hasRegEx = false;
        if (restriction.getRegEx() != null) {
            regEx = restriction.getRegEx().trim();
            hasRegEx = !regEx.isEmpty();
        }
        int n = 0;
        for (GeneralName gn : gNameSet) {
            ++n;
            if (!hasRegEx) continue;
            String value = CertificateUtil.getTypedSAN((GeneralName)gn);
            if (restriction.isRegExMatch()) {
                boolean evalResult = false;
                try {
                    evalResult = value.matches(regEx);
                }
                catch (PatternSyntaxException pse) {
                    this.LOG.warn("pattern '" + regEx + "' is not valid");
                }
                if (evalResult) continue;
                String msg2 = "restriction mismatch: SAN '" + value + "' does not match regular expression '" + regEx + "' !";
                messageList.add(msg2);
                this.LOG.debug(msg2);
                outcome = false;
                continue;
            }
            if (regEx.equalsIgnoreCase(value)) continue;
            String msg3 = "restriction mismatch: SAN '" + value + "' does not match expected value '" + regEx + "' !";
            messageList.add(msg3);
            this.LOG.debug(msg3);
            outcome = false;
        }
        RDNCardinalityRestriction cardinality = restriction.getCardinalityRestriction();
        if (RDNCardinalityRestriction.NOT_ALLOWED.equals((Object)cardinality)) {
            if (n > 0) {
                msg = "restriction mismatch: A SAN MUST NOT occur!";
                messageList.add(msg);
                this.LOG.debug(msg);
                outcome = false;
            }
        } else if (RDNCardinalityRestriction.ONE.equals((Object)cardinality)) {
            if (n == 0) {
                msg = "restriction mismatch: SAN MUST occur once, missing here!";
                messageList.add(msg);
                this.LOG.debug(msg);
                outcome = false;
            }
            if (n != 1) {
                msg = "restriction mismatch: SAN MUST occur exactly once, found " + n + " times!";
                messageList.add(msg);
                this.LOG.debug(msg);
                outcome = false;
            }
        } else if (RDNCardinalityRestriction.ONE_OR_MANY.equals((Object)cardinality)) {
            if (n == 0) {
                msg = "restriction mismatch: SAns MUST occur once or more, missing here!";
                messageList.add(msg);
                this.LOG.debug(msg);
                outcome = false;
            }
        } else if (RDNCardinalityRestriction.ZERO_OR_ONE.equals((Object)cardinality) && n > 1) {
            msg = "restriction mismatch: SANs MUST occur zero or once, found " + n + " times!";
            messageList.add(msg);
            this.LOG.debug(msg);
            outcome = false;
        }
        return outcome;
    }

    private boolean checkAdditionalRestrictions(ARARestriction araRestriction, NamedValues nvAR, List<String> messageList) {
        if (araRestriction == null) {
            return true;
        }
        boolean outcome = true;
        this.LOG.debug("checking AdditionalRestrictions");
        boolean hasRegEx = false;
        if (araRestriction.getRegEx() != null) {
            String regEx = araRestriction.getRegEx().trim();
            boolean bl = hasRegEx = !regEx.isEmpty();
        }
        if (araRestriction.isRequired()) {
            if (nvAR.getValues().length == 0) {
                String msg = "additional restriction mismatch: An value for '" + nvAR.getName() + "' MUST be present!";
                messageList.add(msg);
                this.LOG.debug(msg);
                outcome = false;
            } else {
                for (TypedValue typedValue : nvAR.getValues()) {
                    if (typedValue.getValue().isEmpty()) {
                        String msg = "additional restriction mismatch: An value for '" + nvAR.getName() + "' MUST be present!";
                        messageList.add(msg);
                        this.LOG.debug(msg);
                        outcome = false;
                    }
                    if (!hasRegEx || this.checkRegEx(araRestriction, typedValue.getValue(), messageList)) continue;
                    outcome = false;
                }
            }
        }
        return outcome;
    }

    private boolean checkRestrictions(ASN1ObjectIdentifier restricted, RDNRestriction restriction, RDN[] rdnArr, List<String> messageList) {
        return this.checkRestrictions(restricted, restriction, rdnArr, new HashSet(), messageList);
    }

    private boolean checkRestrictions(ASN1ObjectIdentifier restricted, RDNRestriction restriction, RDN[] rdnArr, Set<GeneralName> gNameSet, List<String> messageList) {
        if (restriction == null) {
            return true;
        }
        boolean outcome = true;
        String restrictedName = OidNameMapper.lookupOid((String)restricted.toString());
        this.LOG.debug("checking element '{}'", (Object)restrictedName);
        boolean hasTemplate = false;
        if (restriction.getContentTemplate() != null) {
            String template = restriction.getContentTemplate().trim();
            hasTemplate = !template.isEmpty();
        }
        String regEx = "";
        boolean hasRegEx = false;
        if (restriction.getRegEx() != null) {
            regEx = restriction.getRegEx().trim();
            hasRegEx = !regEx.isEmpty();
        }
        int n = 0;
        for (RDN rdn : rdnArr) {
            AttributeTypeAndValue atv = rdn.getFirst();
            if (!restricted.equals((ASN1Primitive)atv.getType())) continue;
            ++n;
            String value = atv.getValue().toString().trim();
            if (!hasRegEx || !restriction.isRegExMatch()) continue;
            boolean evalResult = false;
            try {
                evalResult = value.matches(regEx);
            }
            catch (PatternSyntaxException pse) {
                this.LOG.warn("pattern '" + regEx + "' is not valid");
            }
            if (evalResult) continue;
            String msg = "restriction mismatch: '" + value + "' does not match regular expression '" + regEx + "' !";
            messageList.add(msg);
            this.LOG.debug(msg);
            outcome = false;
        }
        RDNCardinalityRestriction cardinality = restriction.getCardinalityRestriction();
        if (RDNCardinalityRestriction.NOT_ALLOWED.equals((Object)cardinality)) {
            if (n > 0) {
                String msg = "restricition mismatch: '" + restrictedName + "' MUST NOT occur!";
                messageList.add(msg);
                this.LOG.debug(msg);
                outcome = false;
            }
        } else if (RDNCardinalityRestriction.ONE.equals((Object)cardinality)) {
            if (n == 0) {
                String msg = "restricition mismatch: '" + restrictedName + "' MUST occur once, missing here!";
                messageList.add(msg);
                this.LOG.debug(msg);
                outcome = false;
            }
            if (n != 1) {
                String msg = "restricition mismatch: '" + restrictedName + "' MUST occur exactly once, found " + n + " times!";
                messageList.add(msg);
                this.LOG.debug(msg);
                outcome = false;
            }
        } else if (RDNCardinalityRestriction.ONE_OR_SAN.equals((Object)cardinality)) {
            if (n == 0 && gNameSet.isEmpty()) {
                String msg = "restricition mismatch: '" + restrictedName + "' MUST occur once or a SAN entry MUST be present!!";
                messageList.add(msg);
                this.LOG.debug(msg);
                outcome = false;
            }
            if (n != 1) {
                String msg = "restricition mismatch: '" + restrictedName + "' MUST occur exactly once, found " + n + " times!";
                messageList.add(msg);
                this.LOG.debug(msg);
                outcome = false;
            }
        } else if (RDNCardinalityRestriction.ONE_OR_MANY.equals((Object)cardinality)) {
            if (n == 0) {
                String msg = "restricition mismatch: '" + restrictedName + "' MUST occur once or more, missing here!";
                messageList.add(msg);
                this.LOG.debug(msg);
                outcome = false;
            }
        } else if (RDNCardinalityRestriction.ZERO_OR_ONE.equals((Object)cardinality) && n > 1) {
            String msg = "restricition mismatch: '" + restrictedName + "' MUST occur zero or once, found " + n + " times!";
            messageList.add(msg);
            this.LOG.debug(msg);
            outcome = false;
        }
        return outcome;
    }

    private boolean checkRegEx(ARARestriction araRestriction, String value, List<String> messageList) {
        boolean outcome = true;
        String regEx = araRestriction.getRegEx().trim();
        if (araRestriction.isRegExMatch()) {
            boolean evalResult = false;
            try {
                evalResult = value.matches(regEx);
            }
            catch (PatternSyntaxException pse) {
                this.LOG.warn("pattern '" + regEx + "' is not valid");
            }
            if (!evalResult) {
                String msg = "restriction mismatch: '" + value + "' does not match regular expression '" + regEx + "' !";
                messageList.add(msg);
                this.LOG.debug(msg);
                outcome = false;
            }
        } else if (!regEx.equalsIgnoreCase(value)) {
            String msg = "restriction mismatch: '" + value + "' does not match expected value '" + regEx + "' !";
            messageList.add(msg);
            this.LOG.debug(msg);
            outcome = false;
        }
        return outcome;
    }

    private boolean isSubjectIP(RDN[] rdnArr, List<String> messageList) {
        for (RDN rdn : rdnArr) {
            AttributeTypeAndValue atv = rdn.getFirst();
            if (!BCStyle.CN.equals((ASN1Primitive)atv.getType())) continue;
            String value = atv.getValue().toString().trim();
            InetAddressValidator inv = InetAddressValidator.getInstance();
            if (inv.isValidInet4Address(value)) {
                messageList.add("CommonName '" + value + "' is a valid IP4 address");
                return true;
            }
            if (!inv.isValidInet6Address(value)) continue;
            messageList.add("CommonName '" + value + "' is a valid IP6 address");
            return true;
        }
        return false;
    }

    public void setPipelineAttribute(Pipeline pipeline, String name, String value) {
        for (PipelineAttribute plAtt : pipeline.getPipelineAttributes()) {
            if (!name.equals(plAtt.getName())) continue;
            if (!plAtt.getValue().equals(value)) {
                plAtt.setValue(value);
                this.pipelineAttRepository.save((Object)plAtt);
            }
            return;
        }
        PipelineAttribute pAtt = new PipelineAttribute();
        pAtt.setPipeline(pipeline);
        pAtt.setName(name);
        pAtt.setValue(value);
        pipeline.getPipelineAttributes().add(pAtt);
        this.pipelineAttRepository.save((Object)pAtt);
        this.pipelineRepository.save((Object)pipeline);
    }

    public String getPipelineAttribute(Pipeline pipeline, String name, String defaultValue) {
        for (PipelineAttribute plAtt : pipeline.getPipelineAttributes()) {
            if (!name.equals(plAtt.getName())) continue;
            return plAtt.getValue();
        }
        return defaultValue;
    }

    public int getPipelineAttribute(Pipeline pipeline, String name, int defaultValue) {
        for (PipelineAttribute plAtt : pipeline.getPipelineAttributes()) {
            if (!name.equals(plAtt.getName())) continue;
            try {
                return Integer.parseInt(plAtt.getValue());
            }
            catch (NumberFormatException nfe) {
                this.LOG.warn("unexpected value for attribute '" + name + "'", (Throwable)nfe);
            }
        }
        return defaultValue;
    }

    public Certificate getSCEPRecipientCertificate(Pipeline pipeline, CertificateProcessingUtil cpUtil) throws IOException, GeneralSecurityException {
        if (pipeline == null) {
            throw new GeneralSecurityException("pipeline argument == null!");
        }
        Certificate currentRecepientCert = this.certUtil.getCurrentSCEPRecipient(pipeline);
        if (currentRecepientCert != null) {
            this.LOG.debug("found active certificate as scep recipient with id {}", (Object)currentRecepientCert.getId());
            return currentRecepientCert;
        }
        if (Boolean.TRUE.equals(pipeline.isActive())) {
            Certificate recipientCert = this.createSCEPRecipientCertificate(pipeline, cpUtil);
            if (recipientCert == null) {
                this.LOG.info("creation of scep recipient certificate for pipeline {} failed", (Object)pipeline.getId());
            } else {
                this.LOG.debug("new scep recipient certificate {} created for pipeline {}", (Object)recipientCert.getId(), (Object)pipeline.getId());
            }
            return recipientCert;
        }
        this.LOG.debug("pipeline {} NOT active, no recipient certificate created", (Object)pipeline.getId());
        return null;
    }

    private Certificate createSCEPRecipientCertificate(Pipeline pipeline, CertificateProcessingUtil cpUtil) throws IOException, GeneralSecurityException {
        CAConnectorConfig caConfig;
        String scepRecipientDN = this.getPipelineAttribute(pipeline, SCEP_RECIPIENT_DN, "CN=SCEPRecepient_" + pipeline.getId());
        X500Principal subject = new X500Principal(scepRecipientDN);
        String caConnectorName = this.getPipelineAttribute(pipeline, SCEP_CA_CONNECTOR_RECIPIENT_NAME, "");
        List caConfigList = this.caConnRepository.findByName(caConnectorName);
        if (caConfigList.isEmpty()) {
            this.LOG.warn("creation of SCEP recipient certificate failed, connector {} missing, using default!", (Object)caConnectorName);
            caConfig = this.configUtil.getDefaultConfig();
        } else {
            caConfig = (CAConnectorConfig)caConfigList.get(0);
        }
        String scepRecipientKeyLength = this.getPipelineAttribute(pipeline, SCEP_RECIPIENT_KEY_TYPE_LEN, "RSA_2048");
        KeyAlgoLength kal = KeyAlgoLength.valueOf((String)scepRecipientKeyLength);
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(kal.algoName());
        keyPairGenerator.initialize(kal.keyLength());
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        String p10ReqPem = CryptoUtil.getCsrAsPEM((X500Principal)subject, (PublicKey)keyPair.getPublic(), (PrivateKey)keyPair.getPrivate(), null);
        String requestorName = "system";
        CSR csr = cpUtil.buildCSR(p10ReqPem, requestorName, "SCEP_CERTIFICATE_REQUESTED", "", null);
        this.csrRepository.save((Object)csr);
        Certificate cert = cpUtil.processCertificateRequest(csr, requestorName, "SCEP_CERTIFICATE_CREATED", caConfig);
        if (cert == null) {
            this.LOG.warn("creation of SCEP recipient certificate with DN '{}' failed ", (Object)scepRecipientDN);
        } else {
            this.LOG.debug("new certificate id '{}' for SCEP recipient", (Object)cert.getId());
            this.certUtil.storePrivateKey(cert, keyPair, cert.getValidTo());
            this.certUtil.setCertAttribute(cert, "CA3S:SCEP_RECIPIENT", "" + pipeline.getId());
            this.certRepository.save((Object)cert);
        }
        return cert;
    }

    public Pipeline getPipelineByRealm(PipelineType pipelineType, String realm) {
        List pipelineList = this.pipelineRepository.findActiveByTypeUrl(pipelineType, realm);
        if (pipelineList.isEmpty()) {
            this.LOG.info("no matching pipeline for type '{}' request realm {}", (Object)pipelineType, (Object)realm);
            return null;
        }
        for (Pipeline pipeline : pipelineList) {
            this.LOG.info("matching pipeline for type '{}' and request realm {} found: {}", new Object[]{pipeline.getType(), pipeline.getUrlPart(), pipeline.getName()});
        }
        return (Pipeline)pipelineList.get(0);
    }

    public boolean isUserValidAsRA(Pipeline pipeline, User user) {
        if (user.getAuthorities().stream().anyMatch(a -> "ROLE_RA".equals(a.getName()))) {
            this.LOG.debug("user '{}' has role 'RA_OFFICER'", (Object)user.getLogin());
            return true;
        }
        if (user.getAuthorities().stream().anyMatch(a -> "ROLE_RA_DOMAIN".equals(a.getName()))) {
            this.LOG.debug("user '{}' has role 'DOMAIN_RA_OFFICER'", (Object)user.getLogin());
            for (PipelineAttribute pipelineAttribute : pipeline.getPipelineAttributes()) {
                if (!DOMAIN_RA_OFFICER.equals(pipelineAttribute.getName()) || Long.parseLong(pipelineAttribute.getValue()) != user.getId()) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ boolean lambda$isPipelineAdditionalRestrictionsResolved$0(ARARestriction araRestriction, NamedValues nv) {
        return araRestriction.getName().equals(nv.getName());
    }
}

