/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.core.domain.CSR;
import de.trustable.ca3s.core.domain.User;
import de.trustable.ca3s.core.repository.UserRepository;
import de.trustable.ca3s.core.service.CSRService;
import de.trustable.ca3s.core.service.dto.CSRView;
import de.trustable.ca3s.core.service.util.CSRUtil;
import de.trustable.ca3s.core.service.util.PipelineUtil;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class CSRResource {
    private final Logger log = LoggerFactory.getLogger(CSRResource.class);
    private static final String ENTITY_NAME = "cSR";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final CSRService cSRService;
    private final CSRUtil csrUtil;
    private final PipelineUtil pipelineUtil;
    private final UserRepository userRepository;
    private final boolean doDNSLookup;

    public CSRResource(CSRService cSRService, CSRUtil csrUtil, PipelineUtil pipelineUtil, UserRepository userRepository, @Value(value="${ca3s.ui.csr.dnslookup:false}") boolean doDNSLookup) {
        this.cSRService = cSRService;
        this.csrUtil = csrUtil;
        this.pipelineUtil = pipelineUtil;
        this.userRepository = userRepository;
        this.doDNSLookup = doDNSLookup;
    }

    @PostMapping(value={"/csrs"})
    public ResponseEntity<CSR> createCSR(@Valid @RequestBody CSR cSR) throws URISyntaxException {
        return (ResponseEntity)ResponseEntity.badRequest();
    }

    @PutMapping(value={"/csrs"})
    public ResponseEntity<CSR> updateCSR(@Valid @RequestBody CSR cSR) throws URISyntaxException {
        this.log.debug("REST request to update CSR : {}", (Object)cSR);
        return (ResponseEntity)ResponseEntity.badRequest();
    }

    @GetMapping(value={"/csrs"})
    public List<CSR> getAllCSRS(@RequestParam(required=false) String filter) {
        return (List)ResponseEntity.badRequest();
    }

    @GetMapping(value={"/csrView/{id}"})
    @Transactional(readOnly=true)
    public ResponseEntity<CSRView> getCSRView(@PathVariable Long id) {
        this.log.debug("REST request to get CSRView for CSR id : {}", (Object)id);
        Optional cSROptional = this.cSRService.findOne(id);
        if (cSROptional.isPresent()) {
            Authentication auth = SecurityContextHolder.getContext().getAuthentication();
            String userName = auth.getName();
            CSR csr = (CSR)cSROptional.get();
            CSRView csrView = new CSRView(this.csrUtil, csr, this.doDNSLookup);
            Optional optCurrentUser = this.userRepository.findOneByLogin(userName);
            if (!optCurrentUser.isPresent()) {
                this.log.warn("Name of ra officer '{}' not found as user", (Object)userName);
                return ResponseEntity.notFound().build();
            }
            csrView.setAdministrable(this.pipelineUtil.isUserValidAsRA(csr.getPipeline(), (User)optCurrentUser.get()));
            if (csr.getRequestedBy().equals(userName) || csrView.getIsAdministrable()) {
                csrView.setCsrBase64(csr.getCsrBase64());
            }
            this.log.debug("returning CSRView for id : {} -> {}", (Object)id, (Object)csrView);
            return ResponseEntity.ok((Object)csrView);
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/csrs/{id}"})
    public ResponseEntity<CSR> getCSR(@PathVariable Long id) {
        this.log.debug("REST request to get CSR : {}", (Object)id);
        return (ResponseEntity)ResponseEntity.badRequest();
    }

    @DeleteMapping(value={"/csrs/{id}"})
    public ResponseEntity<Void> deleteCSR(@PathVariable Long id) {
        this.log.debug("REST request to delete CSR : {}", (Object)id);
        return (ResponseEntity)ResponseEntity.badRequest();
    }
}

