/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest;

import de.trustable.ca3s.core.domain.RequestAttribute;
import de.trustable.ca3s.core.exception.BadRequestAlertException;
import de.trustable.ca3s.core.service.RequestAttributeService;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import tech.jhipster.web.util.HeaderUtil;
import tech.jhipster.web.util.ResponseUtil;

@RestController
@RequestMapping(value={"/api"})
public class RequestAttributeResource {
    private final Logger log = LoggerFactory.getLogger(RequestAttributeResource.class);
    private static final String ENTITY_NAME = "requestAttribute";
    @Value(value="${jhipster.clientApp.name}")
    private String applicationName;
    private final RequestAttributeService requestAttributeService;

    public RequestAttributeResource(RequestAttributeService requestAttributeService) {
        this.requestAttributeService = requestAttributeService;
    }

    @PostMapping(value={"/request-attributes"})
    public ResponseEntity<RequestAttribute> createRequestAttribute(@Valid @RequestBody RequestAttribute requestAttribute) throws URISyntaxException {
        this.log.debug("REST request to save RequestAttribute : {}", (Object)requestAttribute);
        if (requestAttribute.getId() != null) {
            throw new BadRequestAlertException("A new requestAttribute cannot already have an ID", ENTITY_NAME, "idexists");
        }
        RequestAttribute result = this.requestAttributeService.save(requestAttribute);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)new URI("/api/request-attributes/" + result.getId())).headers(HeaderUtil.createEntityCreationAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)result.getId().toString()))).body((Object)result);
    }

    @PutMapping(value={"/request-attributes"})
    public ResponseEntity<RequestAttribute> updateRequestAttribute(@Valid @RequestBody RequestAttribute requestAttribute) throws URISyntaxException {
        this.log.debug("REST request to update RequestAttribute : {}", (Object)requestAttribute);
        if (requestAttribute.getId() == null) {
            throw new BadRequestAlertException("Invalid id", ENTITY_NAME, "idnull");
        }
        RequestAttribute result = this.requestAttributeService.save(requestAttribute);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(HeaderUtil.createEntityUpdateAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)requestAttribute.getId().toString()))).body((Object)result);
    }

    @GetMapping(value={"/request-attributes"})
    public List<RequestAttribute> getAllRequestAttributes() {
        this.log.debug("REST request to get all RequestAttributes");
        return this.requestAttributeService.findAll();
    }

    @GetMapping(value={"/request-attributes/{id}"})
    public ResponseEntity<RequestAttribute> getRequestAttribute(@PathVariable Long id) {
        this.log.debug("REST request to get RequestAttribute : {}", (Object)id);
        Optional requestAttribute = this.requestAttributeService.findOne(id);
        return ResponseUtil.wrapOrNotFound((Optional)requestAttribute);
    }

    @DeleteMapping(value={"/request-attributes/{id}"})
    public ResponseEntity<Void> deleteRequestAttribute(@PathVariable Long id) {
        this.log.debug("REST request to delete RequestAttribute : {}", (Object)id);
        this.requestAttributeService.delete(id);
        return ResponseEntity.noContent().headers(HeaderUtil.createEntityDeletionAlert((String)this.applicationName, (boolean)true, (String)ENTITY_NAME, (String)id.toString())).build();
    }
}

