/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest.acme;

import de.trustable.ca3s.core.domain.AcmeAccount;
import de.trustable.ca3s.core.domain.AcmeAuthorization;
import de.trustable.ca3s.core.domain.AcmeChallenge;
import de.trustable.ca3s.core.domain.AcmeOrder;
import de.trustable.ca3s.core.domain.enumeration.AcmeOrderStatus;
import de.trustable.ca3s.core.domain.enumeration.ChallengeStatus;
import de.trustable.ca3s.core.repository.AcmeChallengeRepository;
import de.trustable.ca3s.core.repository.AcmeOrderRepository;
import de.trustable.ca3s.core.service.AuditService;
import de.trustable.ca3s.core.service.dto.acme.ChallengeResponse;
import de.trustable.ca3s.core.service.dto.acme.problem.AcmeProblemException;
import de.trustable.ca3s.core.service.dto.acme.problem.ProblemDetail;
import de.trustable.ca3s.core.service.util.AcmeUtil;
import de.trustable.ca3s.core.service.util.PreferenceUtil;
import de.trustable.ca3s.core.web.rest.acme.AcmeController;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.validation.constraints.NotNull;
import org.bouncycastle.asn1.ASN1OctetString;
import org.jose4j.jwt.consumer.JwtContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Name;
import org.xbill.DNS.NameTooLongException;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.SimpleResolver;
import org.xbill.DNS.TXTRecord;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Type;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
@RequestMapping(value={"/acme/{realm}/challenge"})
public class ChallengeController
extends AcmeController {
    private static final Logger LOG = LoggerFactory.getLogger(ChallengeController.class);
    public static final Name ACME_CHALLENGE_PREFIX = Name.fromConstantString((String)"_acme-challenge");
    public static final String ACME_VALIDATION_OID = "1.3.6.1.5.5.7.1.31";
    public static final String ACME_TLS_1_PROTOCOL = "acme-tls/1";
    @Value(value="${ca3s.acme.reject.get:true}")
    boolean rejectGet;
    private final AcmeChallengeRepository challengeRepository;
    private final AcmeOrderRepository orderRepository;
    private final PreferenceUtil preferenceUtil;
    private final SimpleResolver dnsResolver;
    private final AuditService auditService;

    public ChallengeController(AcmeChallengeRepository challengeRepository, AcmeOrderRepository orderRepository, PreferenceUtil preferenceUtil, @Value(value="${ca3s.dns.server:}") String resolverHost, @Value(value="${ca3s.dns.port:53}") int resolverPort, AuditService auditService) throws UnknownHostException {
        this.challengeRepository = challengeRepository;
        this.orderRepository = orderRepository;
        this.preferenceUtil = preferenceUtil;
        this.dnsResolver = new SimpleResolver(resolverHost);
        this.auditService = auditService;
        this.dnsResolver.setPort(resolverPort);
        LOG.info("Applying default DNS resolver {}", (Object)this.dnsResolver.getAddress());
    }

    @RequestMapping(value={"/{challengeId}"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<?> getChallenge(@PathVariable long challengeId) {
        LOG.debug("Received Challenge request ");
        HttpHeaders additionalHeaders = this.buildNonceHeader();
        if (this.rejectGet) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.METHOD_NOT_ALLOWED).headers(additionalHeaders)).build();
        }
        Optional challengeOpt = this.challengeRepository.findById((Object)challengeId);
        if (!challengeOpt.isPresent()) {
            return ResponseEntity.notFound().headers(additionalHeaders).build();
        }
        AcmeChallenge challengeDao = (AcmeChallenge)challengeOpt.get();
        LOG.debug("returning challenge {}", (Object)challengeDao.getId());
        ChallengeResponse challenge = this.buildChallengeResponse(challengeDao);
        if (challengeDao.getStatus() == ChallengeStatus.VALID) {
            URI authUri = this.locationUriOfAuthorization(challengeDao.getAcmeAuthorization().getAcmeAuthorizationId().longValue(), (UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequestUri());
            additionalHeaders.set("Link", "<" + authUri.toASCIIString() + ">;rel=\"up\"");
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(additionalHeaders)).body((Object)challenge);
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(additionalHeaders)).body((Object)challenge);
    }

    @RequestMapping(value={"/{challengeId}"}, method={RequestMethod.POST}, produces={"application/json"}, consumes={"application/jose+json"})
    public ResponseEntity<?> postChallenge(@RequestBody String requestBody, @PathVariable long challengeId, @PathVariable String realm) {
        LOG.debug("Received Challenge request ");
        try {
            JwtContext context = this.jwtUtil.processFlattenedJWT(requestBody);
            AcmeAccount acctDao = this.checkJWTSignatureForAccount(context, realm);
            HttpHeaders additionalHeaders = this.buildNonceHeader();
            Optional challengeOpt = this.challengeRepository.findById((Object)challengeId);
            if (!challengeOpt.isPresent()) {
                return ResponseEntity.notFound().headers(additionalHeaders).build();
            }
            AcmeChallenge challengeDao = (AcmeChallenge)challengeOpt.get();
            AcmeOrder order = challengeDao.getAcmeAuthorization().getOrder();
            if (!order.getAccount().getAccountId().equals(acctDao.getAccountId())) {
                LOG.warn("Account of signing key {} does not match account id {} associated to given challenge{}", new Object[]{acctDao.getAccountId(), challengeDao.getAcmeAuthorization().getOrder().getAccount().getAccountId(), challengeId});
                ProblemDetail problem = new ProblemDetail(AcmeUtil.MALFORMED, "Account / Auth mismatch", HttpStatus.BAD_REQUEST, "", AcmeController.NO_INSTANCE);
                throw new AcmeProblemException(problem);
            }
            boolean solved = this.isChallengeSolved(challengeDao);
            ChallengeResponse challenge = this.buildChallengeResponse(challengeDao);
            if (solved) {
                LOG.debug("validation of challenge{} of type '{}' succeeded", (Object)challengeId, (Object)challengeDao.getType());
            } else {
                LOG.warn("validation of challenge{} of type '{}' failed", (Object)challengeId, (Object)challengeDao.getType());
            }
            URI authUri = this.locationUriOfAuthorization(challengeDao.getAcmeAuthorization().getAcmeAuthorizationId().longValue(), (UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequestUri());
            additionalHeaders.set("Link", "<" + authUri.toASCIIString() + ">;rel=\"up\"");
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(additionalHeaders)).body((Object)challenge);
        }
        catch (AcmeProblemException e) {
            return this.buildProblemResponseEntity(e);
        }
    }

    public boolean isChallengeSolved(AcmeChallenge challengeDao) {
        ChallengeStatus oldChallengeState;
        LOG.debug("checking challenge {}", (Object)challengeDao.getId());
        boolean solved = false;
        ChallengeStatus newChallengeState = null;
        if ("http-01".equals(challengeDao.getType())) {
            if (this.checkChallengeHttp(challengeDao)) {
                newChallengeState = ChallengeStatus.VALID;
                solved = true;
            } else {
                newChallengeState = ChallengeStatus.PENDING;
            }
        } else if ("dns-01".equals(challengeDao.getType())) {
            if (this.checkChallengeDNS(challengeDao)) {
                newChallengeState = ChallengeStatus.VALID;
                solved = true;
            } else {
                newChallengeState = ChallengeStatus.PENDING;
            }
        } else if ("tls-alpn-01".equals(challengeDao.getType())) {
            if (this.checkChallengeALPN(challengeDao)) {
                newChallengeState = ChallengeStatus.VALID;
                solved = true;
            } else {
                newChallengeState = ChallengeStatus.PENDING;
            }
        } else {
            LOG.warn("Unexpected type '{}' of challenge{}", (Object)challengeDao.getType(), (Object)challengeDao.getId());
        }
        if (newChallengeState != null && !(oldChallengeState = challengeDao.getStatus()).equals((Object)newChallengeState)) {
            challengeDao.setStatus(newChallengeState);
            challengeDao.setValidated(Instant.now());
            this.challengeRepository.save((Object)challengeDao);
            LOG.debug("{} challengeDao set to '{}' at {}", new Object[]{challengeDao.getType(), challengeDao.getStatus().toString(), challengeDao.getValidated()});
        }
        this.alignOrderState(challengeDao.getAcmeAuthorization().getOrder());
        return solved;
    }

    void alignOrderState(AcmeOrder orderDao) {
        if (orderDao.getStatus().equals((Object)AcmeOrderStatus.READY)) {
            LOG.info("order status already '{}', no re-check after challenge state change required", (Object)orderDao.getStatus());
            return;
        }
        if (orderDao.getStatus() != AcmeOrderStatus.PENDING) {
            LOG.warn("unexpected order status '{}' (!= Pending), no re-check after challenge state change required", (Object)orderDao.getStatus());
            return;
        }
        boolean orderReady = true;
        for (AcmeAuthorization authDao : orderDao.getAcmeAuthorizations()) {
            boolean authReady = false;
            for (AcmeChallenge challDao : authDao.getChallenges()) {
                if (challDao.getStatus() != ChallengeStatus.VALID) continue;
                LOG.debug("challenge {} of type {} is valid ", (Object)challDao.getChallengeId(), (Object)challDao.getType());
                authReady = true;
                break;
            }
            if (authReady) {
                LOG.debug("found valid challenge, authorization id {} is valid ", (Object)authDao.getAcmeAuthorizationId());
                continue;
            }
            LOG.debug("no valid challenge, authorization id {} and order {} still pending", (Object)authDao.getAcmeAuthorizationId(), (Object)orderDao.getOrderId());
            orderReady = false;
            break;
        }
        if (orderReady) {
            LOG.debug("order status set to READY");
            this.auditService.saveAuditTrace(this.auditService.createAuditTraceAcmeOrderSucceeded(orderDao.getAccount(), orderDao));
            orderDao.setStatus(AcmeOrderStatus.READY);
            this.orderRepository.save((Object)orderDao);
        }
    }

    private boolean checkChallengeDNS(AcmeChallenge challengeDao) {
        Name nameToLookup;
        String identifierValue = challengeDao.getValue();
        String token = challengeDao.getToken();
        try {
            Name nameOfIdentifier = Name.fromString((String)identifierValue, (Name)Name.root);
            nameToLookup = Name.concatenate((Name)ACME_CHALLENGE_PREFIX, (Name)nameOfIdentifier);
        }
        catch (NameTooLongException | TextParseException e) {
            throw new RuntimeException(identifierValue + " invalid", e);
        }
        Lookup lookupOperation = new Lookup(nameToLookup, 16);
        lookupOperation.setResolver((Resolver)this.dnsResolver);
        lookupOperation.setCache(null);
        LOG.info("DNS lookup: {} records of '{}' (via resolver '{}')", new Object[]{Type.string((int)16), nameToLookup, this.dnsResolver.getAddress()});
        Instant startedAt = Instant.now();
        Object[] lookupResult = lookupOperation.run();
        Duration lookupDuration = Duration.between(startedAt, Instant.now());
        LOG.info("DNS lookup yields: {} (took {})", (Object)Arrays.toString(lookupResult), (Object)lookupDuration);
        List retrievedToken = this.extractTokenFrom((Record[])lookupResult);
        if (retrievedToken.isEmpty()) {
            LOG.info("Found no DNS entry solving '{}'", (Object)identifierValue);
            return false;
        }
        boolean matchingDnsEntryFound = retrievedToken.stream().anyMatch(token::equals);
        if (matchingDnsEntryFound) {
            return true;
        }
        LOG.info("Did not find matching token '{}' in TXT record DNS response", (Object)token);
        return false;
    }

    @NotNull
    private List<String> extractTokenFrom(Record[] lookupResult) {
        ArrayList<String> tokenList = new ArrayList<String>();
        if (lookupResult != null) {
            for (Record record : lookupResult) {
                LOG.debug("Found DNS entry solving '{}'", (Object)record);
                tokenList.addAll(((TXTRecord)record).getStrings());
            }
        }
        return tokenList;
    }

    private boolean checkChallengeHttp(AcmeChallenge challengeDao) {
        int[] ports = new int[]{80, 5544, 8800};
        long timeoutMilliSec = this.preferenceUtil.getAcmeHTTP01TimeoutMilliSec();
        String portList = this.preferenceUtil.getAcmeHTTP01CallbackPorts();
        if (portList != null && !portList.trim().isEmpty()) {
            String[] parts = portList.split(",");
            ports = new int[parts.length];
            for (int i = 0; i < parts.length; ++i) {
                ports[i] = -1;
                try {
                    ports[i] = Integer.parseInt(parts[i].trim());
                    LOG.debug("checkChallengeHttp port number '" + ports[i] + "' configured for HTTP callback");
                    continue;
                }
                catch (NumberFormatException nfe) {
                    LOG.warn("checkChallengeHttp port number parsing fails for '" + ports[i] + "', ignoring", (Throwable)nfe);
                }
            }
        }
        AcmeOrder acmeOrder = challengeDao.getAcmeAuthorization().getOrder();
        String token = challengeDao.getToken();
        String expectedContent = this.buildKeyAuthorization(challengeDao);
        String fileNamePath = "/.well-known/acme-challenge/" + token;
        String host = challengeDao.getAcmeAuthorization().getValue();
        String ioExceptionMsg = "";
        for (int port : ports) {
            try {
                URL url = new URL("http", host, port, fileNamePath);
                LOG.debug("Opening connection to  : " + url);
                HttpURLConnection con = (HttpURLConnection)url.openConnection();
                con.setConnectTimeout((int)timeoutMilliSec);
                con.setReadTimeout((int)timeoutMilliSec);
                con.setRequestMethod("GET");
                con.setRequestProperty("User-Agent", "CA3S_ACME");
                int responseCode = con.getResponseCode();
                LOG.debug("\nSending 'GET' request to URL : " + url);
                LOG.debug("Response Code : " + responseCode);
                if (responseCode == 200) {
                    String inputLine;
                    BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
                    StringBuffer response = new StringBuffer();
                    while ((inputLine = in.readLine()) != null) {
                        response.append(inputLine);
                    }
                    in.close();
                    String actualContent = response.toString().trim();
                    if (actualContent.length() > 100) {
                        LOG.debug("read challenge response (truncated): " + actualContent.substring(0, 100) + " ...");
                    } else {
                        LOG.debug("read challenge response: " + actualContent);
                    }
                    LOG.debug("expected content: '{}'", (Object)expectedContent);
                    boolean matches = expectedContent.equals(actualContent);
                    if (matches) {
                        this.auditService.saveAuditTrace(this.auditService.createAuditTraceAcmeChallengeSucceeded(acmeOrder.getAccount(), acmeOrder, "challenge response matches at host '" + host + ":" + port + "'"));
                    } else {
                        this.auditService.saveAuditTrace(this.auditService.createAuditTraceAcmeChallengeFailed(acmeOrder.getAccount(), acmeOrder, "challenge response mismatch at host '" + host + ":" + port + "'"));
                    }
                    return matches;
                }
                LOG.info("read challenge responded with unexpected code : " + responseCode);
            }
            catch (UnknownHostException uhe) {
                LOG.debug("unable to resolve hostname ", (Throwable)uhe);
                this.auditService.saveAuditTrace(this.auditService.createAuditTraceAcmeChallengeFailed(acmeOrder.getAccount(), acmeOrder, "unable to resolve hostname '" + host + "'"));
                return false;
            }
            catch (IOException ioe) {
                ioExceptionMsg = ioExceptionMsg + "unable to read challenge response on '" + host + ":" + port + "' ";
                LOG.info("problem reading challenge response on {}:{} for challenge id {} : {}", new Object[]{host, port, challengeDao.getId(), ioe.getMessage()});
                LOG.debug("exception occurred reading challenge response", (Throwable)ioe);
            }
        }
        return false;
    }

    private boolean checkChallengeALPN(AcmeChallenge challengeDao) {
        int[] ports = new int[]{443, 8443};
        AcmeOrder acmeOrder = challengeDao.getAcmeAuthorization().getOrder();
        String expectedContent = Base64.getEncoder().encodeToString(this.buildKeyAuthorizationHash(challengeDao));
        String host = challengeDao.getAcmeAuthorization().getValue();
        TrustManager[] trustAllCerts = new TrustManager[]{new /* Unavailable Anonymous Inner Class!! */};
        String ioExceptionMsg = "";
        for (int port : ports) {
            try {
                if (!this.validateALPNChallenge(acmeOrder, expectedContent, host, trustAllCerts, port)) continue;
                LOG.debug("alpn challenge validation successful on '" + host + ":" + port + "' ");
                return true;
            }
            catch (UnknownHostException uhe) {
                LOG.debug("unable to resolve hostname ", (Throwable)uhe);
                this.auditService.saveAuditTrace(this.auditService.createAuditTraceAcmeChallengeFailed(acmeOrder.getAccount(), acmeOrder, "unable to resolve hostname '" + host + "'"));
                return false;
            }
            catch (IOException ioe) {
                ioExceptionMsg = ioExceptionMsg + "unable to read challenge response on '" + host + ":" + port + "' ";
                LOG.info("problem reading challenge response on {}:{} for challenge id {} : {}", new Object[]{host, port, challengeDao.getId(), ioe.getMessage()});
                LOG.debug("exception occurred reading challenge response", (Throwable)ioe);
            }
            catch (CertificateException ce) {
                ioExceptionMsg = ioExceptionMsg + "unable to read alpn challenge response in certificate provided by '" + host + ":" + port + "' ";
                LOG.info("problem reading alpn challenge response in certificate provided by {}:{} for challenge id {} : {}", new Object[]{host, port, challengeDao.getId(), ce.getMessage()});
                LOG.debug("exception occurred reading alpn challenge response certificate", (Throwable)ce);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateALPNChallenge(AcmeOrder acmeOrder, String expectedContent, String host, TrustManager[] trustAllCerts, int port) throws IOException, CertificateException {
        ByteArrayInputStream in;
        LOG.debug("Opening ALPN connection to {}:{} ", (Object)host, (Object)port);
        Certificate[] serverCerts = new Certificate[]{};
        try (Socket sslSocket = null;){
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            SSLSocketFactory sslsf = sslContext.getSocketFactory();
            sslSocket = (SSLSocket)sslsf.createSocket(host, port);
            SSLParameters sslp = ((SSLSocket)sslSocket).getSSLParameters();
            SNIHostName serverName = new SNIHostName(host);
            sslp.setServerNames(Collections.singletonList(serverName));
            String[] clientAPs = new String[]{"acme-tls/1"};
            sslp.setApplicationProtocols(clientAPs);
            ((SSLSocket)sslSocket).setSSLParameters(sslp);
            ((SSLSocket)sslSocket).startHandshake();
            String ap = ((SSLSocket)sslSocket).getApplicationProtocol();
            LOG.debug("Application Protocol server side: \"" + ap + "\"");
            serverCerts = ((SSLSocket)sslSocket).getSession().getPeerCertificates();
        }
        if (serverCerts.length == 0) {
            LOG.warn("no certificate available after connection with {}:{}", (Object)host, (Object)port);
            return false;
        }
        if (serverCerts.length > 1) {
            LOG.warn("more than one (#{}) certificate returned {}:{}, expecting a single selfsigned certificate", new Object[]{serverCerts.length, host, port});
            return false;
        }
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        X509Certificate cert = (X509Certificate)certFactory.generateCertificate(in = new ByteArrayInputStream(serverCerts[0].getEncoded()));
        if (ChallengeController.checkALPNCertificate((String)host, (int)port, (X509Certificate)cert)) {
            return false;
        }
        byte[] acmeValidationExtBytes = cert.getExtensionValue("1.3.6.1.5.5.7.1.31");
        ASN1OctetString octetString = (ASN1OctetString)ASN1OctetString.fromByteArray((byte[])acmeValidationExtBytes);
        ASN1OctetString rfc8737OctetString = (ASN1OctetString)ASN1OctetString.fromByteArray((byte[])octetString.getOctets());
        String actualContent = Base64.getEncoder().encodeToString(rfc8737OctetString.getOctets());
        if (rfc8737OctetString.getOctets().length > 32) {
            LOG.debug("actualContent has unexpected length: {}", (Object)rfc8737OctetString.getOctets().length);
            return false;
        }
        LOG.debug("read challenge response: " + actualContent);
        LOG.debug("expected content: '{}'", (Object)expectedContent);
        boolean matches = expectedContent.equals(actualContent);
        if (matches) {
            this.auditService.saveAuditTrace(this.auditService.createAuditTraceAcmeChallengeSucceeded(acmeOrder.getAccount(), acmeOrder, "alpn challenge response matches at host '" + host + ":" + port + "'"));
        } else {
            this.auditService.saveAuditTrace(this.auditService.createAuditTraceAcmeChallengeFailed(acmeOrder.getAccount(), acmeOrder, "alpn challenge response mismatch at host '" + host + ":" + port + "'"));
        }
        return matches;
    }

    public static boolean checkALPNCertificate(String host, int port, X509Certificate cert) throws CertificateParsingException {
        if (LOG.isDebugEnabled()) {
            try {
                LOG.debug("alpn certificate : {}", (Object)Base64.getEncoder().encodeToString(cert.getEncoded()));
            }
            catch (CertificateEncodingException e) {
                e.printStackTrace();
            }
        }
        if (cert.getSubjectAlternativeNames().isEmpty()) {
            LOG.warn("no SAN entry available in certificate provided by {}:{}", (Object)host, (Object)port);
            return true;
        }
        if (cert.getSubjectAlternativeNames().size() > 1) {
            LOG.warn("more than one SAN entry (#{}) included in certificate provided by {}:{}", new Object[]{cert.getSubjectAlternativeNames().size(), host, port});
            return true;
        }
        Collection<List<?>> altNames = cert.getSubjectAlternativeNames();
        if (altNames != null) {
            for (List<?> altName : altNames) {
                int altNameType = (Integer)altName.get(0);
                if (2 == altNameType) {
                    String sanValue = "";
                    if (altName.get(1) instanceof String) {
                        sanValue = ((String)altName.get(1)).toLowerCase();
                    } else if (altName.get(1) instanceof byte[]) {
                        sanValue = new String((byte[])altName.get(1)).toLowerCase();
                    }
                    if (host.equalsIgnoreCase(sanValue)) {
                        LOG.debug("SAN entry '{}' machtes expected host '{}'", (Object)sanValue, (Object)host);
                        continue;
                    }
                    LOG.warn("SAN entry value ({}) in certificate provided by {}:{}, does not match expected  host '{}'", new Object[]{sanValue, host, port, host});
                    return true;
                }
                LOG.warn("unexpected SAN entry type ({}) included in certificate provided by {}:{}, 'DNS' (2) expected.", new Object[]{altNameType, host, port});
                return true;
            }
        }
        if (!cert.getCriticalExtensionOIDs().contains("1.3.6.1.5.5.7.1.31")) {
            LOG.warn("ACME validation oid is NOT present and NOT marked as critical in certificate provided by  {}:{}", (Object)host, (Object)port);
            return true;
        }
        LOG.debug("ACME validation oid is present and marked as critical!");
        return false;
    }

    private byte[] buildKeyAuthorizationHash(AcmeChallenge challengeDao) {
        try {
            return this.cryptoUtil.getSHA256Digest(this.buildKeyAuthorization(challengeDao).getBytes());
        }
        catch (NoSuchAlgorithmException e) {
            LOG.warn("Hashing challenge data failed", (Throwable)e);
            return new byte[0];
        }
    }

    private String buildKeyAuthorization(AcmeChallenge challengeDao) {
        String token = challengeDao.getToken();
        String pkThumbprint = challengeDao.getAcmeAuthorization().getOrder().getAccount().getPublicKeyHash();
        String authorization = token + '.' + pkThumbprint;
        LOG.debug("authorization: {}", (Object)authorization);
        return authorization;
    }

    ChallengeResponse buildChallengeResponse(AcmeChallenge challengeDao) {
        return new ChallengeResponse(challengeDao, this.locationUriOfChallenge(challengeDao.getId().longValue(), (UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequestUri()).toString());
    }

    private URI locationUriOfChallenge(long challengeId, UriComponentsBuilder uriBuilder) {
        return this.challengeResourceUriBuilderFrom(uriBuilder.path("../..")).path("/").path(Long.toString(challengeId)).build().normalize().toUri();
    }

    private URI locationUriOfAuthorization(long authorizationId, UriComponentsBuilder uriBuilder) {
        return this.authorizationResourceUriBuilderFrom(uriBuilder.path("../..")).path("/").path("..").path("/").path(Long.toString(authorizationId)).build().normalize().toUri();
    }
}

