/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest.acme;

import de.trustable.ca3s.core.service.dto.acme.DirectoryResponse;
import de.trustable.ca3s.core.web.rest.acme.AcmeController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;

@Controller
@RequestMapping(value={"/acme/{realm}/directory"})
public class DirectoryController
extends AcmeController {
    private static final Logger LOG = LoggerFactory.getLogger(DirectoryController.class);

    @RequestMapping(method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public DirectoryResponse getDirectory(@PathVariable String realm) {
        this.getPipelineForRealm(realm);
        DirectoryResponse resp = new DirectoryResponse();
        resp.setNewNonceUri(this.newNonceResourceUriBuilderFrom((UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequestUri()).build().normalize().toUri());
        resp.setNewAccountUri(this.newAccountResourceUriBuilderFrom((UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequestUri()).build().normalize().toUri());
        resp.setNewOrderUri(this.newOrderResourceUriBuilderFrom((UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequestUri()).build().normalize().toUri());
        resp.setNewAuthzUri(this.newAuthorizationResourceUriBuilderFrom((UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequestUri()).build().normalize().toUri());
        resp.setRevokeUri(this.revokeResourceUriBuilderFrom((UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequestUri()).build().normalize().toUri());
        resp.setKeyChangeUri(this.keyChangeResourceUriBuilderFrom((UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequestUri()).build().normalize().toUri());
        LOG.info("directory request, returning {}", (Object)resp);
        return resp;
    }
}

