/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.web.rest.acme;

import de.trustable.ca3s.core.domain.AcmeAccount;
import de.trustable.ca3s.core.domain.AcmeAuthorization;
import de.trustable.ca3s.core.domain.AcmeChallenge;
import de.trustable.ca3s.core.domain.AcmeIdentifier;
import de.trustable.ca3s.core.domain.AcmeOrder;
import de.trustable.ca3s.core.domain.AcmeOrderAttribute;
import de.trustable.ca3s.core.domain.Pipeline;
import de.trustable.ca3s.core.domain.enumeration.AcmeOrderStatus;
import de.trustable.ca3s.core.domain.enumeration.ChallengeStatus;
import de.trustable.ca3s.core.repository.AcmeAuthorizationRepository;
import de.trustable.ca3s.core.repository.AcmeChallengeRepository;
import de.trustable.ca3s.core.repository.AcmeIdentifierRepository;
import de.trustable.ca3s.core.repository.AcmeOrderAttributeRepository;
import de.trustable.ca3s.core.repository.AcmeOrderRepository;
import de.trustable.ca3s.core.service.dto.AcmeConfigItems;
import de.trustable.ca3s.core.service.dto.PipelineView;
import de.trustable.ca3s.core.service.dto.acme.IdentifierResponse;
import de.trustable.ca3s.core.service.dto.acme.IdentifiersResponse;
import de.trustable.ca3s.core.service.dto.acme.NewOrderResponse;
import de.trustable.ca3s.core.service.dto.acme.problem.AcmeProblemException;
import de.trustable.ca3s.core.service.dto.acme.problem.ProblemDetail;
import de.trustable.ca3s.core.service.util.AcmeUtil;
import de.trustable.ca3s.core.service.util.PipelineUtil;
import de.trustable.ca3s.core.web.rest.acme.AcmeController;
import java.net.IDN;
import java.net.URI;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashSet;
import java.util.Set;
import org.jose4j.jwt.consumer.JwtContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponentsBuilder;
import org.xbill.DNS.Name;
import org.xbill.DNS.TextParseException;

@Transactional
@Controller
@RequestMapping(value={"/acme/{realm}/newOrder"})
public class NewOrderController
extends AcmeController {
    private static final Logger LOG = LoggerFactory.getLogger(NewOrderController.class);
    private static final long DEFAULT_ORDER_VALID_DAYS = 5L;
    private final AcmeOrderRepository orderRepository;
    private final AcmeOrderAttributeRepository orderAttributeRepository;
    private final AcmeAuthorizationRepository authorizationRepository;
    private final AcmeChallengeRepository challengeRepository;
    private final AcmeIdentifierRepository identRepository;
    private final PipelineUtil pipelineUtil;
    private final String resolverHost;

    public NewOrderController(AcmeOrderRepository orderRepository, AcmeOrderAttributeRepository orderAttributeRepository, AcmeAuthorizationRepository authorizationRepository, AcmeChallengeRepository challengeRepository, AcmeIdentifierRepository identRepository, PipelineUtil pipelineUtil, @Value(value="${ca3s.dns.server:}") String resolverHost) {
        this.orderRepository = orderRepository;
        this.orderAttributeRepository = orderAttributeRepository;
        this.authorizationRepository = authorizationRepository;
        this.challengeRepository = challengeRepository;
        this.identRepository = identRepository;
        this.pipelineUtil = pipelineUtil;
        this.resolverHost = resolverHost;
    }

    @RequestMapping(method={RequestMethod.POST}, consumes={"application/jose+json"})
    public ResponseEntity<?> consumingPostedJoseJson(@RequestBody String requestBody, @PathVariable String realm) {
        LOG.info("Received consumingPostedJoseJson request ");
        return this.consumeWithConverter(requestBody, realm);
    }

    @RequestMapping(method={RequestMethod.POST}, consumes={"application/jws"})
    public ResponseEntity<?> consumingPostedJws(@RequestBody String requestBody, @PathVariable String realm) {
        LOG.info("Received consumingPostedJws request ");
        return this.consumeWithConverter(requestBody, realm);
    }

    public ResponseEntity<?> consumeWithConverter(@RequestBody String requestBody, String realm) {
        LOG.info("Received NewOrder request for realm {}", (Object)realm);
        try {
            JwtContext context = this.jwtUtil.processFlattenedJWT(requestBody);
            IdentifiersResponse newIdentifiers = this.jwtUtil.getIdentifiers(context.getJwtClaims());
            LOG.debug("New Order reads Identifiers: " + newIdentifiers);
            Pipeline pipeline = this.getPipelineForRealm(realm);
            LOG.debug("ACME pipeline '{}' found for request realm '{}'", (Object)pipeline.getName(), (Object)realm);
            AcmeAccount acctDao = this.checkJWTSignatureForAccount(context, realm);
            AcmeOrder orderDao = new AcmeOrder();
            orderDao.setOrderId(Long.valueOf(this.generateId()));
            orderDao.setAccount(acctDao);
            orderDao.setRealm(realm);
            orderDao.setPipeline(pipeline);
            orderDao.setStatus(AcmeOrderStatus.PENDING);
            Instant now = Instant.now();
            int orderValiditySeconds = this.pipelineUtil.getPipelineAttribute(pipeline, "ACME_ORDER_VALIDITY_SECONDS", 600);
            orderDao.setExpires(now.plus((long)orderValiditySeconds, ChronoUnit.SECONDS));
            orderDao.setNotBefore(now);
            orderDao.setNotAfter(orderDao.getExpires());
            this.orderRepository.save((Object)orderDao);
            HashSet<AcmeIdentifier> identifiers = new HashSet<AcmeIdentifier>();
            for (IdentifierResponse ident : newIdentifiers.getIdentifiers()) {
                AcmeIdentifier identDao = new AcmeIdentifier();
                identDao.setAcmeIdentifierId(Long.valueOf(this.generateId()));
                identDao.setOrder(orderDao);
                identDao.setType(ident.getType());
                identDao.setValue(ident.getValue());
                identifiers.add(identDao);
            }
            this.identRepository.saveAll(identifiers);
            orderDao.setAcmeIdentifiers(identifiers);
            this.orderRepository.save((Object)orderDao);
            HashSet<AcmeAuthorization> authorizations = new HashSet<AcmeAuthorization>();
            HashSet<String> authorizationsResp = new HashSet<String>();
            PipelineView pipelineView = this.pipelineUtil.from(pipeline);
            AcmeConfigItems acmeConfigItems = pipelineView.getAcmeConfigItems();
            HashSet acmeOrderAttributeSet = new HashSet();
            HashSet<String> challengeTypeSet = new HashSet<String>();
            boolean hasWildcardRequest = false;
            for (AcmeIdentifier identDao : identifiers) {
                AcmeAuthorization authorizationDao = new AcmeAuthorization();
                authorizationDao.setAcmeAuthorizationId(Long.valueOf(this.generateId()));
                authorizationDao.setOrder(orderDao);
                boolean isWildcardRequest = this.isWildcardRequest(identDao.getValue());
                hasWildcardRequest |= isWildcardRequest;
                if (isWildcardRequest && !acmeConfigItems.isAllowWildcards()) {
                    LOG.info("Wildcard requested, but no allowed for pipeline '{}'!", (Object)pipeline.getName());
                    ProblemDetail problemDetail = new ProblemDetail(AcmeUtil.MALFORMED, "Wildcard request not supported", HttpStatus.BAD_REQUEST, "Wildcard requested, but no allowed.", AcmeController.NO_INSTANCE);
                    throw new AcmeProblemException(problemDetail);
                }
                authorizationDao.setType(identDao.getType());
                authorizationDao.setValue(identDao.getValue());
                this.authorizationRepository.save((Object)authorizationDao);
                HashSet<AcmeChallenge> challenges = new HashSet<AcmeChallenge>();
                if (isWildcardRequest) {
                    LOG.debug("Wildcard requested, HTTP-01 and ALPN disabled!");
                } else {
                    if (acmeConfigItems.isAllowChallengeHTTP01()) {
                        LOG.debug("Offering HTTP-01 challenge");
                        challenges.add(this.createChallenge("http-01", identDao.getValue(), authorizationDao));
                        challengeTypeSet.add("http-01");
                    }
                    if (acmeConfigItems.isAllowChallengeHTTP01()) {
                        LOG.debug("Offering ALPN-01 challenge");
                        challenges.add(this.createChallenge("tls-alpn-01", identDao.getValue(), authorizationDao));
                        challengeTypeSet.add("tls-alpn-01");
                    }
                }
                if (this.resolverHost != null && !this.resolverHost.isEmpty()) {
                    if (acmeConfigItems.isAllowChallengeDNS()) {
                        LOG.debug("Offering DNS-01 challenge");
                        challenges.add(this.createChallenge("dns-01", identDao.getValue(), authorizationDao));
                        challengeTypeSet.add("dns-01");
                    }
                } else {
                    LOG.debug("DNS-01 challenge skipped, no dns resolver configured.");
                    if (isWildcardRequest) {
                        LOG.info("Wildcard requested, but no dns resolver configured!");
                        ProblemDetail problemDetail = new ProblemDetail(AcmeUtil.MALFORMED, "DNS auth not supported", HttpStatus.BAD_REQUEST, "DNS-01 challenge skipped, no dns resolver configured.", AcmeController.NO_INSTANCE);
                        throw new AcmeProblemException(problemDetail);
                    }
                }
                if (challenges.isEmpty()) {
                    LOG.info("No challenge available for the given configuration of pipeline '{}'", (Object)pipeline.getName());
                    ProblemDetail problemDetail = new ProblemDetail(AcmeUtil.MALFORMED, "No challenge available", HttpStatus.BAD_REQUEST, "No challenge available for the given configuration.", AcmeController.NO_INSTANCE);
                    throw new AcmeProblemException(problemDetail);
                }
                authorizationDao.setChallenges(challenges);
                this.authorizationRepository.save((Object)authorizationDao);
                authorizations.add(authorizationDao);
                this.addOrderAttribute(orderDao, "AUTHORIZATION", identDao.getValue(), acmeOrderAttributeSet);
                authorizationsResp.add(this.locationUriOfAuth(authorizationDao.getAcmeAuthorizationId().longValue(), (UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequestUri()).toString());
            }
            this.addOrderAttribute(orderDao, "WILDCARD_REQUEST", String.valueOf(hasWildcardRequest), acmeOrderAttributeSet);
            for (String type : challengeTypeSet) {
                this.addOrderAttribute(orderDao, "CHALLENGE_TYPE", type, acmeOrderAttributeSet);
            }
            orderDao.setAttributes(acmeOrderAttributeSet);
            this.orderAttributeRepository.saveAll(acmeOrderAttributeSet);
            orderDao.setAcmeAuthorizations(authorizations);
            this.orderRepository.save((Object)orderDao);
            String finalizeUrl = this.locationUriOfOrderFinalize(orderDao.getOrderId().longValue(), (UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequestUri()).toString();
            NewOrderResponse newOrderResp = new NewOrderResponse(orderDao, authorizationsResp, finalizeUrl);
            URI locationUri = this.locationUriOfOrder(orderDao.getOrderId().longValue(), (UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequestUri());
            HttpHeaders additionalHeaders = this.buildNonceHeader();
            additionalHeaders.set("Link", "<" + this.directoryResourceUriBuilderFrom((UriComponentsBuilder)ServletUriComponentsBuilder.fromCurrentRequestUri()).build().normalize() + ">;rel=\"index\"");
            LOG.debug("returning new order response " + this.jwtUtil.getOrderResponseAsJSON(newOrderResp));
            return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)locationUri).headers(additionalHeaders)).body((Object)newOrderResp);
        }
        catch (AcmeProblemException e) {
            return this.buildProblemResponseEntity(e);
        }
    }

    private void addOrderAttribute(AcmeOrder orderDao, String challengeType, String type, Set<AcmeOrderAttribute> acmeOrderAttributeSet) {
        AcmeOrderAttribute acmeOrderAttribute = new AcmeOrderAttribute();
        acmeOrderAttribute.setOrder(orderDao);
        acmeOrderAttribute.setName(challengeType);
        acmeOrderAttribute.setValue(type);
        acmeOrderAttributeSet.add(acmeOrderAttribute);
    }

    private boolean isWildcardRequest(String ident) {
        Name name;
        try {
            Name tempName = Name.fromString((String)ident, (Name)Name.root);
            name = Name.fromString((String)IDN.toASCII(tempName.toString(), 2));
        }
        catch (TextParseException e) {
            throw new IllegalArgumentException("DNS identifier value '" + ident + "'", e);
        }
        boolean isWildcardRequest = name.isWild();
        return isWildcardRequest;
    }

    private AcmeChallenge createChallenge(String type, String value, AcmeAuthorization authorizationDao) {
        AcmeChallenge challengeDao = new AcmeChallenge();
        challengeDao.setChallengeId(Long.valueOf(this.generateId()));
        challengeDao.setAcmeAuthorization(authorizationDao);
        challengeDao.setType(type);
        challengeDao.setValue(value);
        challengeDao.setToken(this.getRandomChallenge());
        challengeDao.setStatus(ChallengeStatus.PENDING);
        this.challengeRepository.save((Object)challengeDao);
        return challengeDao;
    }
}

