(window["webpackJsonp"] = window["webpackJsonp"] || []).push([[22],{

/***/ "./node_modules/ts-loader/index.js?!./src/main/webapp/app/core/cert-list/cert-info.component.ts?vue&type=script&lang=ts&":
/*!*******************************************************************************************************************************!*\
  !*** ./node_modules/ts-loader??ref--1-0!./src/main/webapp/app/core/cert-list/cert-info.component.ts?vue&type=script&lang=ts& ***!
  \*******************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ \"./node_modules/tslib/tslib.es6.js\");\n/* harmony import */ var vue_property_decorator__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! vue-property-decorator */ \"./node_modules/vue-property-decorator/lib/vue-property-decorator.js\");\n/* harmony import */ var vue_fragment__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! vue-fragment */ \"./node_modules/vue-fragment/dist/vue-fragment.esm.js\");\n/* harmony import */ var vue_class_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! vue-class-component */ \"./node_modules/vue-class-component/dist/vue-class-component.common.js\");\n/* harmony import */ var vue_class_component__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(vue_class_component__WEBPACK_IMPORTED_MODULE_3__);\n/* harmony import */ var _shared_data_data_utils_service__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @/shared/data/data-utils.service */ \"./src/main/webapp/app/shared/data/data-utils.service.ts\");\n/* harmony import */ var _shared_alert_alert_mixin__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @/shared/alert/alert.mixin */ \"./src/main/webapp/app/shared/alert/alert.mixin.ts\");\n/* harmony import */ var _shared_clipboard_clipboard_vue__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @/shared/clipboard/clipboard.vue */ \"./src/main/webapp/app/shared/clipboard/clipboard.vue\");\n/* harmony import */ var _core_help_help_tag_vue__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @/core/help/help-tag.vue */ \"./src/main/webapp/app/core/help/help-tag.vue\");\n/* harmony import */ var _core_audit_audit_tag_vue__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @/core/audit/audit-tag.vue */ \"./src/main/webapp/app/core/audit/audit-tag.vue\");\n/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! axios */ \"./node_modules/axios/index.js\");\n/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(axios__WEBPACK_IMPORTED_MODULE_9__);\n\n\n\n\n\n\n\n\n\n\nvar CertificateDetails = /** @class */ (function (_super) {\n    tslib__WEBPACK_IMPORTED_MODULE_0__[\"__extends\"](CertificateDetails, _super);\n    function CertificateDetails() {\n        var _this = _super !== null && _super.apply(this, arguments) || this;\n        _this.certificateView = {};\n        _this.certificateAdminData = {};\n        _this.p12Alias = 'alias';\n        _this.p12Pbe = 'aes-sha256';\n        _this.p12KeyEx = false;\n        _this.downloadFormat = 'pkix';\n        _this.collapsed = true;\n        return _this;\n    }\n    CertificateDetails.prototype.setCollapsed = function (collapsed) {\n        this.collapsed = collapsed;\n    };\n    CertificateDetails.prototype.getRevocationStyle = function (revoked) {\n        return revoked ? 'text-decoration:line-through;' : 'font-weight:bold;';\n    };\n    CertificateDetails.prototype.getP12Pbe = function () {\n        if (this.$store.state.uiConfigStore.config.cryptoConfigView !== undefined &&\n            this.$store.state.uiConfigStore.config.cryptoConfigView.defaultPBEAlgo !== undefined) {\n            return this.$store.state.uiConfigStore.config.cryptoConfigView.defaultPBEAlgo;\n        }\n        return 'aes-sha256';\n    };\n    CertificateDetails.prototype.getP12PbeAlgoArr = function () {\n        return this.$store.state.uiConfigStore.config.cryptoConfigView.validPBEAlgoArr;\n    };\n    CertificateDetails.prototype.getDownloadFilename = function () {\n        var extension = '.crt';\n        if (this.downloadFormat === 'pem') {\n            extension = '.pem';\n        }\n        else if (this.downloadFormat === 'pemPart') {\n            extension = '.part.pem';\n        }\n        else if (this.downloadFormat === 'pemFull') {\n            extension = '.full.pem';\n        }\n        return this.certificateView.downloadFilename + extension;\n    };\n    CertificateDetails.prototype.downloadItem = function () {\n        var filename = this.getDownloadFilename();\n        var url = '/publicapi/certPKIX/' + this.certificateView.id + '/' + filename;\n        var mimetype = 'application/pkix-cert';\n        if (this.downloadFormat === 'pem') {\n            url = '/publicapi/certPEM/' + this.certificateView.id + '/' + filename;\n            mimetype = 'application/pem-certificate';\n        }\n        else if (this.downloadFormat === 'pemPart') {\n            url = '/publicapi/certPEMPart/' + this.certificateView.id + '/' + filename;\n            mimetype = 'application/x-pem-certificate-chain';\n        }\n        else if (this.downloadFormat === 'pemFull') {\n            url = '/publicapi/certPEMFull/' + this.certificateView.id + '/' + filename;\n            mimetype = 'application/pem-certificate-chain';\n        }\n        var headers = { Accept: mimetype };\n        this.download(url, filename, mimetype, headers);\n    };\n    CertificateDetails.prototype.downloadKeystore = function (extension, mimetype) {\n        var filename = this.certificateView.downloadFilename + extension;\n        var url = '/publicapi/keystore/' + this.certificateView.id + '/' + encodeURIComponent(filename) + '/' + encodeURIComponent(this.p12Alias);\n        var headers = {\n            Accept: mimetype,\n            X_pbeAlgo: this.getP12Pbe(),\n            X_keyEx: this.p12KeyEx\n        };\n        this.download(url, filename, mimetype, headers);\n    };\n    CertificateDetails.prototype.download = function (url, filename, mimetype, headers) {\n        var self = this;\n        var config = new Object();\n        config['responseType'] = 'blob';\n        config['headers'] = headers;\n        axios__WEBPACK_IMPORTED_MODULE_9___default.a\n            //      .get(url, { responseType: 'blob', headers: headers })\n            .get(url, config)\n            .then(function (response) {\n            var blob = new Blob([response.data], { type: mimetype, endings: 'transparent' });\n            var link = document.createElement('a');\n            link.href = URL.createObjectURL(blob);\n            link.download = filename;\n            link.type = mimetype;\n            window.console.info('tmp download lnk : ' + link.download);\n            link.click();\n            URL.revokeObjectURL(link.href);\n        })\n            .catch(function (error) {\n            console.log(error);\n            var message = self.$t('problem processing request: ' + error);\n            var err = error;\n            if (err.response) {\n                console.log(err.response.status);\n                console.log(err.response.data);\n                if (err.response.status === 401) {\n                    self.alertService().showAlert('Action not allowed', 'warn');\n                }\n                else {\n                    self.alertService().showAlert(message, 'info');\n                }\n            }\n            else {\n                self.alertService().showAlert(message, 'info');\n            }\n            self.getAlertFromStore();\n        });\n    };\n    CertificateDetails.prototype.beforeRouteEnter = function (to, from, next) {\n        next(function (vm) {\n            window.console.info('################ to.params : ' + to.params.certificateId);\n            if (to.params.certificateId) {\n                vm.retrieveCertificate(to.params.certificateId);\n            }\n        });\n    };\n    CertificateDetails.prototype.mounted = function () {\n        window.console.info('++++++++++++++++++ route.query : ' + this.$route.query.certificateId);\n        if (this.$route.query.certificateId) {\n            this.retrieveCertificate(this.$route.query.certificateId);\n        }\n        this.p12Pbe = this.getP12Pbe();\n    };\n    CertificateDetails.prototype.retrieveCertificate = function (certificateId) {\n        var _this = this;\n        var self = this;\n        this.certificateViewService()\n            .find(certificateId)\n            .then(function (res) {\n            self.certificateView = res;\n            if (self.certificateAdminData === undefined) {\n                self.certificateAdminData = {};\n            }\n            self.certificateAdminData.arAttributes = _this.certificateView.arArr;\n            self.certificateAdminData.comment = _this.certificateView.comment;\n            self.certificateAdminData.trusted = _this.certificateView.trusted;\n            window.console.info('certificate loaded successfully : ' + self.certificateView.id);\n        });\n    };\n    CertificateDetails.prototype.previousState = function () {\n        this.$router.go(-1);\n    };\n    Object.defineProperty(CertificateDetails.prototype, \"roles\", {\n        get: function () {\n            return this.$store.getters.account ? this.$store.getters.account.authorities[0] : '';\n        },\n        enumerable: true,\n        configurable: true\n    });\n    CertificateDetails.prototype.getUsername = function () {\n        return this.$store.getters.account ? this.$store.getters.account.login : '';\n    };\n    CertificateDetails.prototype.isTrustable = function () {\n        return this.isRAOrAdmin() && !this.certificateView.revoked && this.certificateView.selfsigned;\n    };\n    CertificateDetails.prototype.isEditable = function () {\n        return this.isRAOfficer() || this.isOwnCertificate();\n    };\n    CertificateDetails.prototype.isRevocable = function () {\n        return (!this.certificateView.revoked &&\n            this.certificateView.validTo &&\n            //      ( this.certificate.validTo.getMilliseconds() < Date.now()) &&\n            (this.isRAOfficer() || this.isOwnCertificate()));\n    };\n    CertificateDetails.prototype.isRemovableFromCRL = function () {\n        return (this.certificateView.revocationReason === 'certificateHold' &&\n            this.certificateView.validTo &&\n            //      ( this.certificate.validTo.getMilliseconds() < Date.now()) &&\n            (this.isRAOfficer() || this.isOwnCertificate()));\n    };\n    CertificateDetails.prototype.isRAOfficer = function () {\n        return this.hasRole('ROLE_RA') || this.hasRole('ROLE_RA_DOMAIN');\n    };\n    CertificateDetails.prototype.isAdmin = function () {\n        return this.hasRole('ROLE_ADMIN');\n    };\n    CertificateDetails.prototype.isRAOrAdmin = function () {\n        return this.isRAOfficer() || this.isAdmin();\n    };\n    CertificateDetails.prototype.hasRole = function (targetRole) {\n        if (this.$store.getters.account === null || this.$store.getters.account.authorities === null) {\n            return false;\n        }\n        for (var _i = 0, _a = this.$store.getters.account.authorities; _i < _a.length; _i++) {\n            var role = _a[_i];\n            if (targetRole === role) {\n                return true;\n            }\n        }\n        return false;\n    };\n    CertificateDetails.prototype.isOwnCertificate = function () {\n        return this.getUsername() === this.certificateView.requestedBy;\n    };\n    CertificateDetails.prototype.updateCertificate = function () {\n        this.certificateAdminData.certificateId = this.certificateView.id;\n        this.certificateAdminData.administrationType = 'UPDATE';\n        this.certificateAdminData.trusted = this.certificateView.trusted;\n        this.sendAdministrationAction('api/administerCertificate');\n    };\n    CertificateDetails.prototype.updateCRL = function () {\n        this.certificateAdminData.certificateId = this.certificateView.id;\n        this.certificateAdminData.administrationType = 'UPDATE_CRL';\n        this.sendAdministrationAction('api/administerCertificate');\n    };\n    CertificateDetails.prototype.removeCertificateFromCRL = function () {\n        this.certificateAdminData.certificateId = this.certificateView.id;\n        this.certificateAdminData.revocationReason = 'removeFromCRL';\n        this.certificateAdminData.administrationType = 'REVOKE';\n        this.certificateAdminData.trusted = this.certificateView.trusted;\n        this.sendAdministrationAction('api/administerCertificate');\n    };\n    CertificateDetails.prototype.revokeCertificate = function () {\n        this.certificateAdminData.certificateId = this.certificateView.id;\n        this.certificateAdminData.administrationType = 'REVOKE';\n        this.certificateAdminData.trusted = this.certificateView.trusted;\n        this.sendAdministrationAction('api/administerCertificate');\n    };\n    CertificateDetails.prototype.selfAdministerCertificate = function () {\n        this.certificateAdminData.certificateId = this.certificateView.id;\n        this.certificateAdminData.administrationType = 'UPDATE';\n        this.certificateAdminData.trusted = this.certificateView.trusted;\n        this.sendAdministrationAction('api/selfAdministerCertificate');\n    };\n    CertificateDetails.prototype.withdrawCertificate = function () {\n        this.certificateAdminData.certificateId = this.certificateView.id;\n        this.certificateAdminData.administrationType = 'REVOKE';\n        this.certificateAdminData.trusted = this.certificateView.trusted;\n        this.sendAdministrationAction('api/withdrawOwnCertificate');\n    };\n    CertificateDetails.prototype.sendAdministrationAction = function (adminUrl) {\n        document.body.style.cursor = 'wait';\n        var self = this;\n        if (this.certificateAdminData.trusted === null) {\n            this.certificateAdminData.trusted = false;\n        }\n        axios__WEBPACK_IMPORTED_MODULE_9___default()({\n            method: 'post',\n            url: adminUrl,\n            data: this.certificateAdminData,\n            responseType: 'stream'\n        })\n            .then(function (response) {\n            console.log(response.status);\n            if (response.status === 201) {\n                self.$router.push({ name: 'CertInfo', params: { certificateId: response.data.toString() } });\n            }\n            else {\n                self.previousState();\n            }\n        })\n            .catch(function (error) {\n            console.log(error);\n            self.previousState();\n            var message = self.$t('problem processing request: ' + error);\n            self.alertService().showAlert(message, 'info');\n        })\n            .then(function () {\n            // always executed\n            document.body.style.cursor = 'default';\n        });\n    };\n    tslib__WEBPACK_IMPORTED_MODULE_0__[\"__decorate\"]([\n        Object(vue_property_decorator__WEBPACK_IMPORTED_MODULE_1__[\"Inject\"])('certificateViewService'),\n        tslib__WEBPACK_IMPORTED_MODULE_0__[\"__metadata\"](\"design:type\", Function)\n    ], CertificateDetails.prototype, \"certificateViewService\", void 0);\n    CertificateDetails = tslib__WEBPACK_IMPORTED_MODULE_0__[\"__decorate\"]([\n        Object(vue_property_decorator__WEBPACK_IMPORTED_MODULE_1__[\"Component\"])({\n            components: {\n                Fragment: vue_fragment__WEBPACK_IMPORTED_MODULE_2__[\"Fragment\"],\n                CopyClipboardButton: _shared_clipboard_clipboard_vue__WEBPACK_IMPORTED_MODULE_6__[\"default\"],\n                HelpTag: _core_help_help_tag_vue__WEBPACK_IMPORTED_MODULE_7__[\"default\"],\n                AuditTag: _core_audit_audit_tag_vue__WEBPACK_IMPORTED_MODULE_8__[\"default\"]\n            }\n        })\n    ], CertificateDetails);\n    return CertificateDetails;\n}(Object(vue_class_component__WEBPACK_IMPORTED_MODULE_3__[\"mixins\"])(_shared_alert_alert_mixin__WEBPACK_IMPORTED_MODULE_5__[\"default\"], _shared_data_data_utils_service__WEBPACK_IMPORTED_MODULE_4__[\"default\"])));\n/* harmony default export */ __webpack_exports__[\"default\"] = (CertificateDetails);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/ts-loader/index.js?!./src/main/webapp/app/core/cert-list/cert-info.component.ts?vue&type=script&lang=ts&\n");

/***/ }),

/***/ "./node_modules/vue-fragment/dist/vue-fragment.esm.js":
/*!************************************************************!*\
  !*** ./node_modules/vue-fragment/dist/vue-fragment.esm.js ***!
  \************************************************************/
/*! exports provided: default, Fragment, SSR, Plugin */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"Fragment\", function() { return Fragment; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"SSR\", function() { return SSR; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"Plugin\", function() { return Plugin; });\nfunction _defineProperty(e,n,t){return n in e?Object.defineProperty(e,n,{value:t,enumerable:!0,configurable:!0,writable:!0}):e[n]=t,e}function _objectSpread(e){for(var n=1;n<arguments.length;n++){var t=null!=arguments[n]?arguments[n]:{},r=Object.keys(t);\"function\"==typeof Object.getOwnPropertySymbols&&(r=r.concat(Object.getOwnPropertySymbols(t).filter(function(e){return Object.getOwnPropertyDescriptor(t,e).enumerable}))),r.forEach(function(n){_defineProperty(e,n,t[n])})}return e}var freeze=function(e,n,t){Object.defineProperty(e,n,{configurable:!0,get:function(){return t},set:function(e){console.warn(\"tried to set frozen property \".concat(n,\" with \").concat(e))}})},unfreeze=function(e,n){var t=arguments.length>2&&void 0!==arguments[2]?arguments[2]:null;Object.defineProperty(e,n,{configurable:!0,writable:!0,value:t})},component={abstract:!0,name:\"Fragment\",props:{name:{type:String,default:function(){return Math.floor(Date.now()*Math.random()).toString(16)}}},mounted:function(){var e=this.$el,n=e.parentNode,t=document.createComment(\"fragment#\".concat(this.name,\"#head\")),r=document.createComment(\"fragment#\".concat(this.name,\"#tail\"));n.insertBefore(t,e),n.insertBefore(r,e),e.appendChild=function(t){n.insertBefore(t,r),freeze(t,\"parentNode\",e)},e.insertBefore=function(t,r){n.insertBefore(t,r),freeze(t,\"parentNode\",e)},e.removeChild=function(e){n.removeChild(e),unfreeze(e,\"parentNode\")},Array.from(e.childNodes).forEach(function(n){return e.appendChild(n)}),n.removeChild(e),freeze(e,\"parentNode\",n),freeze(e,\"nextSibling\",r.nextSibling);var o=n.insertBefore;n.insertBefore=function(r,i){o.call(n,r,i!==e?i:t)};var i=n.removeChild;n.removeChild=function(a){if(a===e){for(;t.nextSibling!==r;)e.removeChild(t.nextSibling);n.removeChild(t),n.removeChild(r),unfreeze(e,\"parentNode\"),n.insertBefore=o,n.removeChild=i}else i.call(n,a)}},render:function(e){var n=this,t=this.$slots.default;return t&&t.length&&t.forEach(function(e){return e.data=_objectSpread({},e.data,{attrs:_objectSpread({fragment:n.name},(e.data||{}).attrs)})}),e(\"div\",{attrs:{fragment:this.name}},t)}};function ssr(e,n){ true&&console.warn(\"v-fragment SSR is not implemented yet.\")}var Fragment=component,SSR=ssr,Plugin={install:function(e){e.component(\"fragment\",component)}},index={Fragment:component,Plugin:Plugin,SSR:ssr};/* harmony default export */ __webpack_exports__[\"default\"] = (index);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/vue-fragment/dist/vue-fragment.esm.js\n");

/***/ }),

/***/ "./node_modules/vue-loader/lib/loaders/templateLoader.js?!./node_modules/vue-loader/lib/index.js?!./src/main/webapp/app/core/cert-list/cert-info.vue?vue&type=template&id=0ba0f292&scoped=true&":
/*!***********************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/vue-loader/lib/loaders/templateLoader.js??vue-loader-options!./node_modules/vue-loader/lib??vue-loader-options!./src/main/webapp/app/core/cert-list/cert-info.vue?vue&type=template&id=0ba0f292&scoped=true& ***!
  \***********************************************************************************************************************************************************************************************************************************/
/*! exports provided: render, staticRenderFns */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"render\", function() { return render; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"staticRenderFns\", function() { return staticRenderFns; });\nvar render = function() {\n  var _vm = this\n  var _h = _vm.$createElement\n  var _c = _vm._self._c || _h\n  return _c(\n    \"div\",\n    [\n      _c(\n        \"b-alert\",\n        {\n          attrs: {\n            show: _vm.dismissCountDown,\n            dismissible: \"\",\n            variant: _vm.alertType\n          },\n          on: {\n            dismissed: function($event) {\n              _vm.dismissCountDown = 0\n            },\n            \"dismiss-count-down\": _vm.countDownChanged\n          }\n        },\n        [_vm._v(\"\\n        \" + _vm._s(_vm.alertMessage) + \"\\n    \")]\n      ),\n      _vm._v(\" \"),\n      _c(\"div\", { staticClass: \"row justify-content-center\" }, [\n        _c(\"div\", { staticClass: \"col-8\" }, [\n          _vm.certificateView\n            ? _c(\n                \"div\",\n                [\n                  _c(\"h2\", { staticClass: \"jh-entity-heading\" }, [\n                    _c(\n                      \"span\",\n                      {\n                        domProps: {\n                          textContent: _vm._s(\n                            _vm.$t(\"ca3SApp.certificate.detail.title\")\n                          )\n                        }\n                      },\n                      [_vm._v(\"Certificate\")]\n                    ),\n                    _vm._v(\" \" + _vm._s(_vm.certificateView.id))\n                  ]),\n                  _vm._v(\" \"),\n                  _c(\n                    \"dl\",\n                    { staticClass: \"row jh-entity-details\" },\n                    [\n                      _c(\"dt\", [\n                        _c(\n                          \"span\",\n                          {\n                            domProps: {\n                              textContent: _vm._s(\n                                _vm.$t(\"ca3SApp.certificate.subject\")\n                              )\n                            }\n                          },\n                          [_vm._v(\"Subject\")]\n                        )\n                      ]),\n                      _vm._v(\" \"),\n                      _c(\n                        \"dd\",\n                        {\n                          style: _vm.getRevocationStyle(\n                            _vm.certificateView.revoked\n                          )\n                        },\n                        [\n                          _c(\"span\", [\n                            _vm._v(_vm._s(_vm.certificateView.subject))\n                          ])\n                        ]\n                      ),\n                      _vm._v(\" \"),\n                      _vm.certificateView.revoked\n                        ? _c(\"dt\", [\n                            _c(\n                              \"span\",\n                              {\n                                domProps: {\n                                  textContent: _vm._s(\n                                    _vm.$t(\"ca3SApp.certificate.revokedSince\")\n                                  )\n                                }\n                              },\n                              [_vm._v(\"Revoked Since\")]\n                            )\n                          ])\n                        : _vm._e(),\n                      _vm._v(\" \"),\n                      _vm.certificateView.revoked\n                        ? _c(\"dd\", [\n                            _vm.certificateView.revokedSince\n                              ? _c(\"span\", [\n                                  _vm._v(\n                                    _vm._s(\n                                      _vm.$d(\n                                        Date.parse(\n                                          _vm.certificateView.revokedSince\n                                        ),\n                                        \"long\"\n                                      )\n                                    )\n                                  )\n                                ])\n                              : _vm._e()\n                          ])\n                        : _vm._e(),\n                      _vm._v(\" \"),\n                      _vm.certificateView.revoked\n                        ? _c(\"dt\", [\n                            _c(\n                              \"span\",\n                              {\n                                domProps: {\n                                  textContent: _vm._s(\n                                    _vm.$t(\n                                      \"ca3SApp.certificate.revocationReason\"\n                                    )\n                                  )\n                                }\n                              },\n                              [_vm._v(\"Revocation Reason\")]\n                            )\n                          ])\n                        : _vm._e(),\n                      _vm._v(\" \"),\n                      _vm.certificateView.revoked\n                        ? _c(\"dd\", [\n                            _c(\n                              \"span\",\n                              { attrs: { name: \"revocationReason\" } },\n                              [\n                                _vm._v(\n                                  _vm._s(_vm.certificateView.revocationReason)\n                                )\n                              ]\n                            )\n                          ])\n                        : _vm._e(),\n                      _vm._v(\" \"),\n                      _vm.certificateView.sanArr &&\n                      _vm.certificateView.sanArr.length > 0\n                        ? _c(\"dt\", [\n                            _c(\n                              \"span\",\n                              {\n                                domProps: {\n                                  textContent: _vm._s(\n                                    _vm.$t(\"ca3SApp.certificate.sans\")\n                                  )\n                                }\n                              },\n                              [_vm._v(\"Subject alternative names\")]\n                            )\n                          ])\n                        : _vm._e(),\n                      _vm._v(\" \"),\n                      _vm.certificateView.sanArr &&\n                      _vm.certificateView.sanArr.length > 0\n                        ? _c(\"dd\", [\n                            _c(\n                              \"ul\",\n                              _vm._l(_vm.certificateView.sanArr, function(san) {\n                                return _c(\"li\", { key: san }, [\n                                  _vm._v(_vm._s(san))\n                                ])\n                              }),\n                              0\n                            )\n                          ])\n                        : _vm._e(),\n                      _vm._v(\" \"),\n                      _c(\"dt\", [\n                        _c(\n                          \"span\",\n                          {\n                            domProps: {\n                              textContent: _vm._s(\n                                _vm.$t(\"ca3SApp.certificate.issuer\")\n                              )\n                            }\n                          },\n                          [_vm._v(\"Issuer\")]\n                        )\n                      ]),\n                      _vm._v(\" \"),\n                      _c(\"dd\", [\n                        _vm.certificateView.selfsigned\n                          ? _c(\n                              \"span\",\n                              {\n                                domProps: {\n                                  textContent: _vm._s(\n                                    _vm.$t(\"ca3SApp.certificate.selfsigned\")\n                                  )\n                                }\n                              },\n                              [_vm._v(\"Selfsigned\")]\n                            )\n                          : _vm.certificateView.issuerId\n                          ? _c(\n                              \"a\",\n                              {\n                                attrs: { href: \"issuer\" },\n                                on: {\n                                  click: function($event) {\n                                    $event.preventDefault()\n                                    return _vm.retrieveCertificate(\n                                      _vm.certificateView.issuerId\n                                    )\n                                  }\n                                }\n                              },\n                              [_vm._v(_vm._s(_vm.certificateView.issuer))]\n                            )\n                          : _c(\"span\", [\n                              _vm._v(_vm._s(_vm.certificateView.issuer))\n                            ])\n                      ]),\n                      _vm._v(\" \"),\n                      !_vm.certificateView.selfsigned &&\n                      _vm.certificateView.root\n                        ? _c(\"dt\", [\n                            _c(\n                              \"span\",\n                              {\n                                domProps: {\n                                  textContent: _vm._s(\n                                    _vm.$t(\"ca3SApp.certificate.root\")\n                                  )\n                                }\n                              },\n                              [_vm._v(\"Root\")]\n                            )\n                          ])\n                        : _vm._e(),\n                      _vm._v(\" \"),\n                      !_vm.certificateView.selfsigned &&\n                      _vm.certificateView.root\n                        ? _c(\"dd\", [\n                            _c(\"span\", [\n                              _vm._v(_vm._s(_vm.certificateView.root))\n                            ])\n                          ])\n                        : _vm._e(),\n                      _vm._v(\" \"),\n                      _c(\"dt\", [\n                        _c(\n                          \"span\",\n                          {\n                            domProps: {\n                              textContent: _vm._s(\n                                _vm.$t(\"ca3SApp.certificate.type\")\n                              )\n                            }\n                          },\n                          [_vm._v(\"Type\")]\n                        )\n                      ]),\n                      _vm._v(\" \"),\n                      _c(\"dd\", [\n                        _c(\"span\", [_vm._v(_vm._s(_vm.certificateView.type))]),\n                        _vm._v(\" \"),\n                        _vm.certificateView.ca\n                          ? _c(\"span\", [_c(\"b\", [_vm._v(\"CA\")])])\n                          : _vm._e(),\n                        _vm._v(\" \"),\n                        _vm.certificateView.selfsigned\n                          ? _c(\"span\", [_c(\"b\", [_vm._v(\"Selfsigned\")])])\n                          : _vm._e(),\n                        _vm._v(\" \"),\n                        _vm.certificateView.trusted\n                          ? _c(\"span\", [_c(\"b\", [_vm._v(\"Trusted\")])])\n                          : _vm._e()\n                      ]),\n                      _vm._v(\" \"),\n                      _c(\"dt\", [\n                        _c(\n                          \"span\",\n                          {\n                            domProps: {\n                              textContent: _vm._s(\n                                _vm.$t(\"ca3SApp.certificate.serial\")\n                              )\n                            }\n                          },\n                          [_vm._v(\"Serial\")]\n                        )\n                      ]),\n                      _vm._v(\" \"),\n                      _c(\"dd\", [\n                        _c(\"ul\", [\n                          _c(\"li\", [\n                            _vm._v(_vm._s(_vm.certificateView.serialHex))\n                          ]),\n                          _vm._v(\" \"),\n                          _c(\"li\", [_vm._v(_vm._s(_vm.certificateView.serial))])\n                        ])\n                      ]),\n                      _vm._v(\" \"),\n                      _c(\"dt\", [\n                        _c(\n                          \"span\",\n                          {\n                            domProps: {\n                              textContent: _vm._s(\n                                _vm.$t(\"ca3SApp.certificate.validFrom\")\n                              )\n                            }\n                          },\n                          [_vm._v(\"Valid From\")]\n                        )\n                      ]),\n                      _vm._v(\" \"),\n                      _c(\"dd\", [\n                        _vm.certificateView.validFrom\n                          ? _c(\"span\", [\n                              _vm._v(\n                                _vm._s(\n                                  _vm.$d(\n                                    Date.parse(_vm.certificateView.validFrom),\n                                    \"long\"\n                                  )\n                                )\n                              )\n                            ])\n                          : _vm._e()\n                      ]),\n                      _vm._v(\" \"),\n                      _c(\"dt\", [\n                        _c(\n                          \"span\",\n                          {\n                            domProps: {\n                              textContent: _vm._s(\n                                _vm.$t(\"ca3SApp.certificate.validTo\")\n                              )\n                            }\n                          },\n                          [_vm._v(\"Valid To\")]\n                        )\n                      ]),\n                      _vm._v(\" \"),\n                      _c(\"dd\", [\n                        _vm.certificateView.validTo\n                          ? _c(\"span\", [\n                              _vm._v(\n                                _vm._s(\n                                  _vm.$d(\n                                    Date.parse(_vm.certificateView.validTo),\n                                    \"long\"\n                                  )\n                                )\n                              )\n                            ])\n                          : _vm._e()\n                      ]),\n                      _vm._v(\" \"),\n                      _c(\"dt\", [\n                        _c(\n                          \"span\",\n                          {\n                            domProps: {\n                              textContent: _vm._s(\n                                _vm.$t(\"ca3SApp.certificate.keyDetails\")\n                              )\n                            }\n                          },\n                          [_vm._v(\"Key Details\")]\n                        )\n                      ]),\n                      _vm._v(\" \"),\n                      _c(\"dd\", [\n                        _c(\"span\", [\n                          _vm._v(\n                            _vm._s(_vm.certificateView.keyAlgorithm) +\n                              \" / \" +\n                              _vm._s(_vm.certificateView.keyLength) +\n                              \" bits\"\n                          )\n                        ])\n                      ]),\n                      _vm._v(\" \"),\n                      _vm.certificateView.curveName &&\n                      _vm.certificateView.curveName.length > 0\n                        ? _c(\"dt\", [\n                            _c(\n                              \"span\",\n                              {\n                                domProps: {\n                                  textContent: _vm._s(\n                                    _vm.$t(\"ca3SApp.certificate.curveName\")\n                                  )\n                                }\n                              },\n                              [_vm._v(\"Curve Name\")]\n                            )\n                          ])\n                        : _vm._e(),\n                      _vm._v(\" \"),\n                      _vm.certificateView.curveName &&\n                      _vm.certificateView.curveName.length > 0\n                        ? _c(\"dd\", [\n                            _c(\"span\", [\n                              _vm._v(_vm._s(_vm.certificateView.curveName))\n                            ])\n                          ])\n                        : _vm._e(),\n                      _vm._v(\" \"),\n                      _c(\"dt\", [\n                        _c(\n                          \"span\",\n                          {\n                            domProps: {\n                              textContent: _vm._s(\n                                _vm.$t(\"ca3SApp.certificate.signingAlgorithm\")\n                              )\n                            }\n                          },\n                          [_vm._v(\"Signing Algorithm\")]\n                        )\n                      ]),\n                      _vm._v(\" \"),\n                      _c(\"dd\", [\n                        _c(\"span\", [\n                          _vm._v(\n                            _vm._s(_vm.certificateView.signingAlgorithm) +\n                              \" / \" +\n                              _vm._s(_vm.certificateView.hashAlgorithm) +\n                              \" / \" +\n                              _vm._s(_vm.certificateView.paddingAlgorithm)\n                          )\n                        ])\n                      ]),\n                      _vm._v(\" \"),\n                      _c(\"dt\", [\n                        _c(\n                          \"span\",\n                          {\n                            domProps: {\n                              textContent: _vm._s(\n                                _vm.$t(\"ca3SApp.certificate.usage\")\n                              )\n                            }\n                          },\n                          [_vm._v(\"Usage\")]\n                        )\n                      ]),\n                      _vm._v(\" \"),\n                      _c(\"dd\", [\n                        _vm.certificateView.usage &&\n                        _vm.certificateView.usage.length > 0\n                          ? _c(\n                              \"ul\",\n                              _vm._l(_vm.certificateView.usage, function(usg) {\n                                return _c(\"li\", { key: usg }, [\n                                  _vm._v(_vm._s(usg))\n                                ])\n                              }),\n                              0\n                            )\n                          : _vm._e()\n                      ]),\n                      _vm._v(\" \"),\n                      _vm.certificateView.extUsage &&\n                      _vm.certificateView.extUsage.length > 0\n                        ? _c(\"dt\", [\n                            _c(\n                              \"span\",\n                              {\n                                domProps: {\n                                  textContent: _vm._s(\n                                    _vm.$t(\"ca3SApp.certificate.extended.usage\")\n                                  )\n                                }\n                              },\n                              [_vm._v(\"Usage\")]\n                            )\n                          ])\n                        : _vm._e(),\n                      _vm._v(\" \"),\n                      _vm.certificateView.extUsage &&\n                      _vm.certificateView.extUsage.length > 0\n                        ? _c(\"dd\", [\n                            _c(\n                              \"ul\",\n                              _vm._l(_vm.certificateView.extUsage, function(\n                                extUsage\n                              ) {\n                                return _c(\"li\", { key: extUsage }, [\n                                  _vm._v(_vm._s(extUsage))\n                                ])\n                              }),\n                              0\n                            )\n                          ])\n                        : _vm._e(),\n                      _vm._v(\" \"),\n                      _c(\"dt\", [\n                        _c(\n                          \"span\",\n                          {\n                            domProps: {\n                              textContent: _vm._s(\n                                _vm.$t(\"ca3SApp.certificate.contentAddedAt\")\n                              )\n                            }\n                          },\n                          [_vm._v(\"Content Added At\")]\n                        )\n                      ]),\n                      _vm._v(\" \"),\n                      _c(\"dd\", [\n                        _vm.certificateView.contentAddedAt\n                          ? _c(\"span\", [\n                              _vm._v(\n                                _vm._s(\n                                  _vm.$d(\n                                    Date.parse(\n                                      _vm.certificateView.contentAddedAt\n                                    ),\n                                    \"long\"\n                                  )\n                                )\n                              )\n                            ])\n                          : _vm._e()\n                      ]),\n                      _vm._v(\" \"),\n                      _vm.certificateView.crlUrl\n                        ? _c(\"dt\", [\n                            _c(\n                              \"span\",\n                              {\n                                domProps: {\n                                  textContent: _vm._s(\n                                    _vm.$t(\"ca3SApp.certificate.crlUrl\")\n                                  )\n                                }\n                              },\n                              [_vm._v(\"CRL Uri\")]\n                            )\n                          ])\n                        : _vm._e(),\n                      _vm._v(\" \"),\n                      _vm.certificateView.crlUrl\n                        ? _c(\"dd\", [\n                            _c(\"span\", { attrs: { name: \"crlUrl\" } }, [\n                              _vm._v(_vm._s(_vm.certificateView.crlUrl))\n                            ])\n                          ])\n                        : _vm._e(),\n                      _vm._v(\" \"),\n                      _c(\"dt\", [\n                        _c(\n                          \"span\",\n                          {\n                            domProps: {\n                              textContent: _vm._s(\n                                _vm.$t(\"ca3SApp.certificate.fingerprint\")\n                              )\n                            }\n                          },\n                          [_vm._v(\"Fingerprint\")]\n                        )\n                      ]),\n                      _vm._v(\" \"),\n                      _c(\"dd\", [\n                        _c(\"ul\", [\n                          _c(\"li\", [\n                            _c(\"span\", [\n                              _vm._v(\n                                _vm._s(_vm.certificateView.fingerprintSha1)\n                              )\n                            ])\n                          ]),\n                          _vm._v(\" \"),\n                          _c(\"li\", [\n                            _c(\"span\", [\n                              _vm._v(\n                                _vm._s(_vm.certificateView.fingerprintSha256)\n                              )\n                            ])\n                          ])\n                        ])\n                      ]),\n                      _vm._v(\" \"),\n                      _vm.certificateView.csrId\n                        ? _c(\"dt\", [\n                            _c(\n                              \"span\",\n                              {\n                                domProps: {\n                                  textContent: _vm._s(\n                                    _vm.$t(\"ca3SApp.certificate.csr\")\n                                  )\n                                }\n                              },\n                              [_vm._v(\"Csr\")]\n                            )\n                          ])\n                        : _vm._e(),\n                      _vm._v(\" \"),\n                      _vm.certificateView.csrId\n                        ? _c(\"dd\", [\n                            _c(\n                              \"div\",\n                              [\n                                _c(\n                                  \"router-link\",\n                                  {\n                                    attrs: {\n                                      to: {\n                                        name: \"CsrInfo\",\n                                        params: {\n                                          csrId: _vm.certificateView.csrId\n                                        }\n                                      }\n                                    }\n                                  },\n                                  [_vm._v(_vm._s(_vm.certificateView.csrId))]\n                                )\n                              ],\n                              1\n                            )\n                          ])\n                        : _vm._e(),\n                      _vm._v(\" \"),\n                      _vm.certificateView.requestedBy\n                        ? _c(\"dt\", [\n                            _c(\n                              \"span\",\n                              {\n                                domProps: {\n                                  textContent: _vm._s(\n                                    _vm.$t(\"ca3SApp.certificate.requestedBy\")\n                                  )\n                                }\n                              },\n                              [_vm._v(\"Requested by\")]\n                            )\n                          ])\n                        : _vm._e(),\n                      _vm._v(\" \"),\n                      _vm.certificateView.requestedBy\n                        ? _c(\"dd\", [\n                            _c(\"span\", [\n                              _vm._v(_vm._s(_vm.certificateView.requestedBy))\n                            ])\n                          ])\n                        : _vm._e(),\n                      _vm._v(\" \"),\n                      _vm.certificateView.requestedOn\n                        ? _c(\"dt\", [\n                            _c(\n                              \"span\",\n                              {\n                                domProps: {\n                                  textContent: _vm._s(\n                                    _vm.$t(\"ca3SApp.certificate.requestedOn\")\n                                  )\n                                }\n                              },\n                              [_vm._v(\"Requested on\")]\n                            )\n                          ])\n                        : _vm._e(),\n                      _vm._v(\" \"),\n                      _vm.certificateView.requestedOn\n                        ? _c(\"dd\", [\n                            _c(\"span\", [\n                              _vm._v(_vm._s(_vm.certificateView.requestedOn))\n                            ])\n                          ])\n                        : _vm._e(),\n                      _vm._v(\" \"),\n                      _vm._l(_vm.certificateView.arArr, function(attr) {\n                        return !_vm.isEditable()\n                          ? _c(\"Fragment\", { key: attr.name }, [\n                              _c(\"dt\", [\n                                _c(\"span\", [_vm._v(_vm._s(attr.name))])\n                              ]),\n                              _vm._v(\" \"),\n                              _c(\"dd\", [\n                                _c(\"span\", [_vm._v(_vm._s(attr.value))])\n                              ])\n                            ])\n                          : _vm._e()\n                      }),\n                      _vm._v(\" \"),\n                      _vm.certificateView.isServersideKeyGeneration &&\n                      _vm.isEditable()\n                        ? _c(\n                            \"dt\",\n                            [\n                              _c(\n                                \"span\",\n                                {\n                                  domProps: {\n                                    textContent: _vm._s(\n                                      _vm.$t(\n                                        \"ca3SApp.certificate.download.PKCS12\"\n                                      )\n                                    )\n                                  }\n                                },\n                                [_vm._v(\"PKCS12 keystore\")]\n                              ),\n                              _vm._v(\" \"),\n                              _c(\"help-tag\", {\n                                attrs: {\n                                  target: \"ca3SApp.certificate.download.PKCS12\"\n                                }\n                              })\n                            ],\n                            1\n                          )\n                        : _vm._e(),\n                      _vm._v(\" \"),\n                      _vm.certificateView.isServersideKeyGeneration &&\n                      _vm.isEditable()\n                        ? _c(\"dd\", [\n                            _c(\"div\", { staticClass: \"row\" }, [\n                              _c(\"div\", { staticClass: \"col\" }, [\n                                _c(\n                                  \"label\",\n                                  {\n                                    staticClass: \"form-control-label\",\n                                    attrs: { for: \"p12Alias\" },\n                                    domProps: {\n                                      textContent: _vm._s(\n                                        _vm.$t(\n                                          \"ca3SApp.certificate.download.p12Alias\"\n                                        )\n                                      )\n                                    }\n                                  },\n                                  [_vm._v(\"Alias\")]\n                                ),\n                                _vm._v(\" \"),\n                                _c(\"input\", {\n                                  directives: [\n                                    {\n                                      name: \"model\",\n                                      rawName: \"v-model\",\n                                      value: _vm.p12Alias,\n                                      expression: \"p12Alias\"\n                                    }\n                                  ],\n                                  staticClass: \"form-check-inline\",\n                                  attrs: {\n                                    type: \"text\",\n                                    name: \"p12Alias\",\n                                    id: \"p12Alias\"\n                                  },\n                                  domProps: { value: _vm.p12Alias },\n                                  on: {\n                                    input: function($event) {\n                                      if ($event.target.composing) {\n                                        return\n                                      }\n                                      _vm.p12Alias = $event.target.value\n                                    }\n                                  }\n                                })\n                              ]),\n                              _vm._v(\" \"),\n                              _c(\"div\", { staticClass: \"col colContent\" }, [\n                                _c(\n                                  \"a\",\n                                  {\n                                    attrs: { href: \"downloadUrl\" },\n                                    on: {\n                                      click: function($event) {\n                                        $event.preventDefault()\n                                        return _vm.downloadKeystore(\n                                          \".p12\",\n                                          \"application/x-pkcs12\"\n                                        )\n                                      }\n                                    }\n                                  },\n                                  [\n                                    _vm._v(\n                                      _vm._s(\n                                        _vm.certificateView.downloadFilename\n                                      ) + \".p12\"\n                                    )\n                                  ]\n                                )\n                              ])\n                            ]),\n                            _vm._v(\" \"),\n                            _vm.getP12PbeAlgoArr().length > 1\n                              ? _c(\"div\", { staticClass: \"row\" }, [\n                                  _c(\n                                    \"div\",\n                                    { staticClass: \"col\" },\n                                    [\n                                      _vm.collapsed\n                                        ? _c(\"Fragment\", [\n                                            _c(\n                                              \"button\",\n                                              {\n                                                staticClass:\n                                                  \"addRemoveSelector\",\n                                                attrs: { type: \"button\" },\n                                                on: {\n                                                  click: function($event) {\n                                                    return _vm.setCollapsed(\n                                                      false\n                                                    )\n                                                  }\n                                                }\n                                              },\n                                              [\n                                                _c(\"font-awesome-icon\", {\n                                                  attrs: { icon: \"plus\" }\n                                                })\n                                              ],\n                                              1\n                                            )\n                                          ])\n                                        : _vm._e(),\n                                      _vm._v(\" \"),\n                                      !_vm.collapsed\n                                        ? _c(\"Fragment\", [\n                                            _c(\n                                              \"button\",\n                                              {\n                                                staticClass:\n                                                  \"addRemoveSelector\",\n                                                attrs: { type: \"button\" },\n                                                on: {\n                                                  click: function($event) {\n                                                    return _vm.setCollapsed(\n                                                      true\n                                                    )\n                                                  }\n                                                }\n                                              },\n                                              [\n                                                _c(\"font-awesome-icon\", {\n                                                  attrs: { icon: \"minus\" }\n                                                })\n                                              ],\n                                              1\n                                            ),\n                                            _vm._v(\" \"),\n                                            _c(\n                                              \"label\",\n                                              {\n                                                staticClass:\n                                                  \"form-control-label\",\n                                                attrs: { for: \"p12Pbe\" },\n                                                domProps: {\n                                                  textContent: _vm._s(\n                                                    _vm.$t(\n                                                      \"ca3SApp.certificate.download.p12pbe\"\n                                                    )\n                                                  )\n                                                }\n                                              },\n                                              [_vm._v(\"PBE\")]\n                                            ),\n                                            _vm._v(\" \"),\n                                            _c(\n                                              \"select\",\n                                              {\n                                                directives: [\n                                                  {\n                                                    name: \"model\",\n                                                    rawName: \"v-model\",\n                                                    value: _vm.p12Pbe,\n                                                    expression: \"p12Pbe\"\n                                                  }\n                                                ],\n                                                staticClass: \"form-control\",\n                                                attrs: {\n                                                  id: \"p12Pbe\",\n                                                  name: \"p12Pbe\"\n                                                },\n                                                on: {\n                                                  change: function($event) {\n                                                    var $$selectedVal = Array.prototype.filter\n                                                      .call(\n                                                        $event.target.options,\n                                                        function(o) {\n                                                          return o.selected\n                                                        }\n                                                      )\n                                                      .map(function(o) {\n                                                        var val =\n                                                          \"_value\" in o\n                                                            ? o._value\n                                                            : o.value\n                                                        return val\n                                                      })\n                                                    _vm.p12Pbe = $event.target\n                                                      .multiple\n                                                      ? $$selectedVal\n                                                      : $$selectedVal[0]\n                                                  }\n                                                }\n                                              },\n                                              _vm._l(\n                                                _vm.getP12PbeAlgoArr(),\n                                                function(algo) {\n                                                  return _c(\n                                                    \"option\",\n                                                    {\n                                                      key: algo,\n                                                      domProps: { value: algo }\n                                                    },\n                                                    [_vm._v(_vm._s(algo))]\n                                                  )\n                                                }\n                                              ),\n                                              0\n                                            )\n                                          ])\n                                        : _vm._e()\n                                    ],\n                                    1\n                                  )\n                                ])\n                              : _vm._e()\n                          ])\n                        : _vm._e(),\n                      _vm._v(\" \"),\n                      _vm.certificateView.downloadFilename\n                        ? _c(\n                            \"dt\",\n                            [\n                              _c(\n                                \"span\",\n                                {\n                                  domProps: {\n                                    textContent: _vm._s(\n                                      _vm.$t(\n                                        \"ca3SApp.certificate.download.pkix\"\n                                      )\n                                    )\n                                  }\n                                },\n                                [_vm._v(\"Pkix\")]\n                              ),\n                              _vm._v(\" \"),\n                              _c(\"help-tag\", {\n                                attrs: {\n                                  target: \"ca3SApp.certificate.download.PKIX\"\n                                }\n                              })\n                            ],\n                            1\n                          )\n                        : _vm._e(),\n                      _vm._v(\" \"),\n                      _vm.certificateView.downloadFilename\n                        ? _c(\"dd\", [\n                            _c(\"div\", { staticClass: \"container\" }, [\n                              _c(\"div\", { staticClass: \"row\" }, [\n                                _c(\"div\", { staticClass: \"col\" }, [\n                                  _c(\n                                    \"select\",\n                                    {\n                                      directives: [\n                                        {\n                                          name: \"model\",\n                                          rawName: \"v-model\",\n                                          value: _vm.downloadFormat,\n                                          expression: \"downloadFormat\"\n                                        }\n                                      ],\n                                      staticClass: \"form-control\",\n                                      attrs: {\n                                        id: \"download-format\",\n                                        name: \"download-format\"\n                                      },\n                                      on: {\n                                        change: function($event) {\n                                          var $$selectedVal = Array.prototype.filter\n                                            .call(\n                                              $event.target.options,\n                                              function(o) {\n                                                return o.selected\n                                              }\n                                            )\n                                            .map(function(o) {\n                                              var val =\n                                                \"_value\" in o\n                                                  ? o._value\n                                                  : o.value\n                                              return val\n                                            })\n                                          _vm.downloadFormat = $event.target\n                                            .multiple\n                                            ? $$selectedVal\n                                            : $$selectedVal[0]\n                                        }\n                                      }\n                                    },\n                                    [\n                                      _c(\n                                        \"option\",\n                                        {\n                                          attrs: {\n                                            value: \"pkix\",\n                                            selected: \"selected\"\n                                          },\n                                          domProps: {\n                                            textContent: _vm._s(\n                                              _vm.$t(\n                                                \"ca3SApp.certificate.download.PKIX\"\n                                              )\n                                            )\n                                          }\n                                        },\n                                        [_vm._v(\"PKIX\")]\n                                      ),\n                                      _vm._v(\" \"),\n                                      _c(\n                                        \"option\",\n                                        {\n                                          attrs: { value: \"pem\" },\n                                          domProps: {\n                                            textContent: _vm._s(\n                                              _vm.$t(\n                                                \"ca3SApp.certificate.download.PEM\"\n                                              )\n                                            )\n                                          }\n                                        },\n                                        [_vm._v(\"PEM\")]\n                                      ),\n                                      _vm._v(\" \"),\n                                      _vm.certificateView.endEntity &&\n                                      _vm.certificateView.issuerId !== undefined\n                                        ? _c(\n                                            \"option\",\n                                            {\n                                              attrs: { value: \"pemPart\" },\n                                              domProps: {\n                                                textContent: _vm._s(\n                                                  _vm.$t(\n                                                    \"ca3SApp.certificate.download.pemPartChain\"\n                                                  )\n                                                )\n                                              }\n                                            },\n                                            [_vm._v(\"PEMPartChain\")]\n                                          )\n                                        : _vm._e(),\n                                      _vm._v(\" \"),\n                                      _vm.certificateView.endEntity &&\n                                      _vm.certificateView.issuerId !== undefined\n                                        ? _c(\n                                            \"option\",\n                                            {\n                                              attrs: { value: \"pemFull\" },\n                                              domProps: {\n                                                textContent: _vm._s(\n                                                  _vm.$t(\n                                                    \"ca3SApp.certificate.download.pemFullChain\"\n                                                  )\n                                                )\n                                              }\n                                            },\n                                            [_vm._v(\"PEMFullChain\")]\n                                          )\n                                        : _vm._e()\n                                    ]\n                                  )\n                                ]),\n                                _vm._v(\" \"),\n                                _c(\"div\", { staticClass: \"col\" }, [\n                                  _c(\n                                    \"a\",\n                                    {\n                                      attrs: { href: \"downloadUrl\" },\n                                      on: {\n                                        click: function($event) {\n                                          $event.preventDefault()\n                                          return _vm.downloadItem()\n                                        }\n                                      }\n                                    },\n                                    [_vm._v(_vm._s(_vm.getDownloadFilename()))]\n                                  )\n                                ])\n                              ])\n                            ])\n                          ])\n                        : _vm._e()\n                    ],\n                    2\n                  ),\n                  _vm._v(\" \"),\n                  _vm.certificateView.auditPresent\n                    ? _c(\"Fragment\", [\n                        _c(\n                          \"div\",\n                          [\n                            _c(\"audit-tag\", {\n                              attrs: {\n                                certificateId: _vm.certificateView.id,\n                                csrId: _vm.certificateView.csrId,\n                                showLinks: \"false\",\n                                title: _vm.$t(\"ca3SApp.certificate.audit\")\n                              }\n                            })\n                          ],\n                          1\n                        )\n                      ])\n                    : _vm._e()\n                ],\n                1\n              )\n            : _vm._e(),\n          _vm._v(\" \"),\n          _c(\n            \"form\",\n            { attrs: { name: \"editForm\", role: \"form\", novalidate: \"\" } },\n            [\n              _c(\n                \"div\",\n                [\n                  _vm.isTrustable() && _vm.isRAOfficer()\n                    ? _c(\"div\", { staticClass: \"form-group\" }, [\n                        _c(\n                          \"label\",\n                          {\n                            staticClass: \"form-control-label\",\n                            attrs: { for: \"certificate-trusted\" },\n                            domProps: {\n                              textContent: _vm._s(\n                                _vm.$t(\"ca3SApp.pipeline.trusted\")\n                              )\n                            }\n                          },\n                          [_vm._v(\"Trusted\")]\n                        ),\n                        _vm._v(\" \"),\n                        _c(\"input\", {\n                          directives: [\n                            {\n                              name: \"model\",\n                              rawName: \"v-model\",\n                              value: _vm.certificateAdminData.trusted,\n                              expression: \"certificateAdminData.trusted\"\n                            }\n                          ],\n                          staticClass: \"form-check-inline\",\n                          attrs: {\n                            type: \"checkbox\",\n                            name: \"trusted\",\n                            id: \"certificate-trusted\"\n                          },\n                          domProps: {\n                            checked: Array.isArray(\n                              _vm.certificateAdminData.trusted\n                            )\n                              ? _vm._i(_vm.certificateAdminData.trusted, null) >\n                                -1\n                              : _vm.certificateAdminData.trusted\n                          },\n                          on: {\n                            change: function($event) {\n                              var $$a = _vm.certificateAdminData.trusted,\n                                $$el = $event.target,\n                                $$c = $$el.checked ? true : false\n                              if (Array.isArray($$a)) {\n                                var $$v = null,\n                                  $$i = _vm._i($$a, $$v)\n                                if ($$el.checked) {\n                                  $$i < 0 &&\n                                    _vm.$set(\n                                      _vm.certificateAdminData,\n                                      \"trusted\",\n                                      $$a.concat([$$v])\n                                    )\n                                } else {\n                                  $$i > -1 &&\n                                    _vm.$set(\n                                      _vm.certificateAdminData,\n                                      \"trusted\",\n                                      $$a\n                                        .slice(0, $$i)\n                                        .concat($$a.slice($$i + 1))\n                                    )\n                                }\n                              } else {\n                                _vm.$set(\n                                  _vm.certificateAdminData,\n                                  \"trusted\",\n                                  $$c\n                                )\n                              }\n                            }\n                          }\n                        })\n                      ])\n                    : _vm._e(),\n                  _vm._v(\" \"),\n                  _vm.isEditable()\n                    ? _c(\n                        \"Fragment\",\n                        _vm._l(_vm.certificateView.arArr, function(attr) {\n                          return _c(\n                            \"div\",\n                            { key: attr.name, staticClass: \"form-group\" },\n                            [\n                              _c(\n                                \"label\",\n                                {\n                                  staticClass: \"form-control-label\",\n                                  attrs: { for: \"cert-ar-\" + attr.name }\n                                },\n                                [_vm._v(_vm._s(attr.name))]\n                              ),\n                              _vm._v(\" \"),\n                              _c(\"input\", {\n                                directives: [\n                                  {\n                                    name: \"model\",\n                                    rawName: \"v-model\",\n                                    value: attr.value,\n                                    expression: \"attr.value\"\n                                  }\n                                ],\n                                staticClass: \"form-control\",\n                                attrs: {\n                                  type: \"text\",\n                                  name: \"cert-ar-\" + attr.name,\n                                  id: \"cert-ar-\" + attr.name\n                                },\n                                domProps: { value: attr.value },\n                                on: {\n                                  input: function($event) {\n                                    if ($event.target.composing) {\n                                      return\n                                    }\n                                    _vm.$set(attr, \"value\", $event.target.value)\n                                  }\n                                }\n                              })\n                            ]\n                          )\n                        }),\n                        0\n                      )\n                    : _vm._e(),\n                  _vm._v(\" \"),\n                  _vm.isRevocable()\n                    ? _c(\n                        \"div\",\n                        { staticClass: \"form-group\" },\n                        [\n                          _c(\n                            \"label\",\n                            {\n                              staticClass: \"form-control-label\",\n                              attrs: { for: \"cert-revocationReason\" },\n                              domProps: {\n                                textContent: _vm._s(\n                                  _vm.$t(\"ca3SApp.certificate.revocationReason\")\n                                )\n                              }\n                            },\n                            [_vm._v(\"Revocation reason\")]\n                          ),\n                          _vm._v(\" \"),\n                          _c(\"help-tag\", {\n                            attrs: {\n                              target:\n                                \"ca3SApp.certificate.download.revocationReason\"\n                            }\n                          }),\n                          _vm._v(\" \"),\n                          _c(\n                            \"select\",\n                            {\n                              directives: [\n                                {\n                                  name: \"model\",\n                                  rawName: \"v-model\",\n                                  value:\n                                    _vm.certificateAdminData.revocationReason,\n                                  expression:\n                                    \"certificateAdminData.revocationReason\"\n                                }\n                              ],\n                              staticClass: \"form-control\",\n                              attrs: {\n                                id: \"cert-revocationReason\",\n                                name: \"revocationReason\"\n                              },\n                              on: {\n                                change: function($event) {\n                                  var $$selectedVal = Array.prototype.filter\n                                    .call($event.target.options, function(o) {\n                                      return o.selected\n                                    })\n                                    .map(function(o) {\n                                      var val =\n                                        \"_value\" in o ? o._value : o.value\n                                      return val\n                                    })\n                                  _vm.$set(\n                                    _vm.certificateAdminData,\n                                    \"revocationReason\",\n                                    $event.target.multiple\n                                      ? $$selectedVal\n                                      : $$selectedVal[0]\n                                  )\n                                }\n                              }\n                            },\n                            [\n                              _c(\n                                \"option\",\n                                { domProps: { value: \"certificateHold\" } },\n                                [_vm._v(\"certificateHold\")]\n                              ),\n                              _vm._v(\" \"),\n                              _c(\n                                \"option\",\n                                { domProps: { value: \"keyCompromise\" } },\n                                [_vm._v(\"keyCompromise\")]\n                              ),\n                              _vm._v(\" \"),\n                              _c(\n                                \"option\",\n                                { domProps: { value: \"cACompromise\" } },\n                                [_vm._v(\"cACompromise\")]\n                              ),\n                              _vm._v(\" \"),\n                              _c(\n                                \"option\",\n                                { domProps: { value: \"affiliationChanged\" } },\n                                [_vm._v(\"affiliationChanged\")]\n                              ),\n                              _vm._v(\" \"),\n                              _c(\n                                \"option\",\n                                { domProps: { value: \"superseded\" } },\n                                [_vm._v(\"superseded\")]\n                              ),\n                              _vm._v(\" \"),\n                              _c(\n                                \"option\",\n                                { domProps: { value: \"cessationOfOperation\" } },\n                                [_vm._v(\"cessationOfOperation\")]\n                              ),\n                              _vm._v(\" \"),\n                              _c(\n                                \"option\",\n                                { domProps: { value: \"privilegeWithdrawn\" } },\n                                [_vm._v(\"privilegeWithdrawn\")]\n                              ),\n                              _vm._v(\" \"),\n                              _c(\n                                \"option\",\n                                { domProps: { value: \"unspecified\" } },\n                                [_vm._v(\"unspecified\")]\n                              )\n                            ]\n                          )\n                        ],\n                        1\n                      )\n                    : _vm._e(),\n                  _vm._v(\" \"),\n                  _vm.isRevocable()\n                    ? _c(\n                        \"div\",\n                        { staticClass: \"form-group\" },\n                        [\n                          _c(\n                            \"label\",\n                            {\n                              staticClass: \"form-control-label\",\n                              attrs: { for: \"comment\" },\n                              domProps: {\n                                textContent: _vm._s(\n                                  _vm.$t(\"ca3SApp.certificate.comment\")\n                                )\n                              }\n                            },\n                            [_vm._v(\"Comment\")]\n                          ),\n                          _vm._v(\" \"),\n                          _c(\"help-tag\", {\n                            attrs: { target: \"ca3SApp.certificate.comment\" }\n                          }),\n                          _vm._v(\" \"),\n                          _c(\"textarea\", {\n                            directives: [\n                              {\n                                name: \"model\",\n                                rawName: \"v-model\",\n                                value: _vm.certificateAdminData.comment,\n                                expression: \"certificateAdminData.comment\"\n                              }\n                            ],\n                            staticClass: \"form-control\",\n                            attrs: {\n                              name: \"content\",\n                              id: \"comment\",\n                              autocomplete: \"off\",\n                              autocorrect: \"off\",\n                              autocapitalize: \"off\",\n                              spellcheck: \"false\"\n                            },\n                            domProps: {\n                              value: _vm.certificateAdminData.comment\n                            },\n                            on: {\n                              input: function($event) {\n                                if ($event.target.composing) {\n                                  return\n                                }\n                                _vm.$set(\n                                  _vm.certificateAdminData,\n                                  \"comment\",\n                                  $event.target.value\n                                )\n                              }\n                            }\n                          })\n                        ],\n                        1\n                      )\n                    : _vm._e(),\n                  _vm._v(\" \"),\n                  _c(\n                    \"button\",\n                    {\n                      staticClass: \"btn btn-info\",\n                      attrs: { type: \"submit\" },\n                      on: {\n                        click: function($event) {\n                          $event.preventDefault()\n                          return _vm.previousState()\n                        }\n                      }\n                    },\n                    [\n                      _c(\"font-awesome-icon\", {\n                        attrs: { icon: \"arrow-left\" }\n                      }),\n                      _vm._v(\" \"),\n                      _c(\n                        \"span\",\n                        {\n                          domProps: {\n                            textContent: _vm._s(_vm.$t(\"entity.action.back\"))\n                          }\n                        },\n                        [_vm._v(\" Back\")]\n                      )\n                    ],\n                    1\n                  ),\n                  _vm._v(\" \"),\n                  _vm.isOwnCertificate()\n                    ? _c(\n                        \"button\",\n                        {\n                          staticClass: \"btn btn-secondary\",\n                          attrs: { type: \"button\", id: \"edit\" },\n                          on: {\n                            click: function($event) {\n                              return _vm.selfAdministerCertificate()\n                            }\n                          }\n                        },\n                        [\n                          _c(\"font-awesome-icon\", {\n                            attrs: { icon: \"pencil-alt\" }\n                          }),\n                          _vm._v(\" \"),\n                          _c(\n                            \"span\",\n                            {\n                              domProps: {\n                                textContent: _vm._s(\n                                  _vm.$t(\"entity.action.edit\")\n                                )\n                              }\n                            },\n                            [_vm._v(\"Update\")]\n                          )\n                        ],\n                        1\n                      )\n                    : _vm._e(),\n                  _vm._v(\" \"),\n                  _vm.isRAOfficer()\n                    ? _c(\n                        \"button\",\n                        {\n                          staticClass: \"btn btn-secondary\",\n                          attrs: { type: \"button\", id: \"update\" },\n                          on: {\n                            click: function($event) {\n                              return _vm.updateCertificate()\n                            }\n                          }\n                        },\n                        [\n                          _c(\"font-awesome-icon\", {\n                            attrs: { icon: \"pencil-alt\" }\n                          }),\n                          _vm._v(\" \"),\n                          _c(\n                            \"span\",\n                            {\n                              domProps: {\n                                textContent: _vm._s(\n                                  _vm.$t(\"entity.action.update\")\n                                )\n                              }\n                            },\n                            [_vm._v(\"Update\")]\n                          )\n                        ],\n                        1\n                      )\n                    : _vm._e(),\n                  _vm._v(\" \"),\n                  _vm.isRAOfficer()\n                    ? _c(\n                        \"button\",\n                        {\n                          staticClass: \"btn btn-secondary\",\n                          attrs: { type: \"button\", id: \"updateCrl\" },\n                          on: {\n                            click: function($event) {\n                              return _vm.updateCRL()\n                            }\n                          }\n                        },\n                        [\n                          _c(\"font-awesome-icon\", {\n                            attrs: { icon: \"pencil-alt\" }\n                          }),\n                          _vm._v(\" \"),\n                          _c(\n                            \"span\",\n                            {\n                              domProps: {\n                                textContent: _vm._s(\n                                  _vm.$t(\"entity.action.updateCrl\")\n                                )\n                              }\n                            },\n                            [_vm._v(\"Update CRL\")]\n                          )\n                        ],\n                        1\n                      )\n                    : _vm._e(),\n                  _vm._v(\" \"),\n                  _vm.isRemovableFromCRL()\n                    ? _c(\n                        \"button\",\n                        {\n                          staticClass: \"btn btn-secondary\",\n                          attrs: { type: \"button\", id: \"removeFromCRL\" },\n                          on: {\n                            click: function($event) {\n                              return _vm.removeCertificateFromCRL()\n                            }\n                          }\n                        },\n                        [\n                          _c(\"font-awesome-icon\", { attrs: { icon: \"ban\" } }),\n                          _vm._v(\" \"),\n                          _c(\n                            \"span\",\n                            {\n                              domProps: {\n                                textContent: _vm._s(\n                                  _vm.$t(\n                                    \"entity.action.removeCertificateFromCRL\"\n                                  )\n                                )\n                              }\n                            },\n                            [_vm._v(\"Remove from CRL\")]\n                          )\n                        ],\n                        1\n                      )\n                    : _vm._e(),\n                  _vm._v(\" \"),\n                  _vm.isRAOfficer() &&\n                  !_vm.isOwnCertificate() &&\n                  _vm.isRevocable()\n                    ? _c(\n                        \"button\",\n                        {\n                          staticClass: \"btn btn-secondary\",\n                          attrs: { type: \"button\", id: \"revoke\" },\n                          on: {\n                            click: function($event) {\n                              return _vm.revokeCertificate()\n                            }\n                          }\n                        },\n                        [\n                          _c(\"font-awesome-icon\", { attrs: { icon: \"ban\" } }),\n                          _vm._v(\" \"),\n                          _c(\n                            \"span\",\n                            {\n                              domProps: {\n                                textContent: _vm._s(\n                                  _vm.$t(\"entity.action.revoke\")\n                                )\n                              }\n                            },\n                            [_vm._v(\"Revoke\")]\n                          )\n                        ],\n                        1\n                      )\n                    : _vm._e(),\n                  _vm._v(\" \"),\n                  _vm.isOwnCertificate() && _vm.isRevocable()\n                    ? _c(\n                        \"button\",\n                        {\n                          staticClass: \"btn btn-secondary\",\n                          attrs: { type: \"button\", id: \"withdraw\" },\n                          on: {\n                            click: function($event) {\n                              return _vm.withdrawCertificate()\n                            }\n                          }\n                        },\n                        [\n                          _c(\"font-awesome-icon\", { attrs: { icon: \"ban\" } }),\n                          _vm._v(\" \"),\n                          _c(\n                            \"span\",\n                            {\n                              domProps: {\n                                textContent: _vm._s(\n                                  _vm.$t(\"entity.action.withdraw\")\n                                )\n                              }\n                            },\n                            [_vm._v(\"Withdraw\")]\n                          )\n                        ],\n                        1\n                      )\n                    : _vm._e()\n                ],\n                1\n              )\n            ]\n          )\n        ])\n      ])\n    ],\n    1\n  )\n}\nvar staticRenderFns = []\nrender._withStripped = true\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/vue-loader/lib/loaders/templateLoader.js?!./node_modules/vue-loader/lib/index.js?!./src/main/webapp/app/core/cert-list/cert-info.vue?vue&type=template&id=0ba0f292&scoped=true&\n");

/***/ }),

/***/ "./src/main/webapp/app/core/cert-list/cert-info.component.ts?vue&type=script&lang=ts&":
/*!********************************************************************************************!*\
  !*** ./src/main/webapp/app/core/cert-list/cert-info.component.ts?vue&type=script&lang=ts& ***!
  \********************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _node_modules_ts_loader_index_js_ref_1_0_cert_info_component_ts_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/ts-loader??ref--1-0!./cert-info.component.ts?vue&type=script&lang=ts& */ \"./node_modules/ts-loader/index.js?!./src/main/webapp/app/core/cert-list/cert-info.component.ts?vue&type=script&lang=ts&\");\n/* empty/unused harmony star reexport */ /* harmony default export */ __webpack_exports__[\"default\"] = (_node_modules_ts_loader_index_js_ref_1_0_cert_info_component_ts_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_0__[\"default\"]); //# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9zcmMvbWFpbi93ZWJhcHAvYXBwL2NvcmUvY2VydC1saXN0L2NlcnQtaW5mby5jb21wb25lbnQudHM/dnVlJnR5cGU9c2NyaXB0Jmxhbmc9dHMmLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vc3JjL21haW4vd2ViYXBwL2FwcC9jb3JlL2NlcnQtbGlzdC9jZXJ0LWluZm8uY29tcG9uZW50LnRzPzc5NTEiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IG1vZCBmcm9tIFwiLSEuLi8uLi8uLi8uLi8uLi8uLi9ub2RlX21vZHVsZXMvdHMtbG9hZGVyL2luZGV4LmpzPz9yZWYtLTEtMCEuL2NlcnQtaW5mby5jb21wb25lbnQudHM/dnVlJnR5cGU9c2NyaXB0Jmxhbmc9dHMmXCI7IGV4cG9ydCBkZWZhdWx0IG1vZDsgZXhwb3J0ICogZnJvbSBcIi0hLi4vLi4vLi4vLi4vLi4vLi4vbm9kZV9tb2R1bGVzL3RzLWxvYWRlci9pbmRleC5qcz8/cmVmLS0xLTAhLi9jZXJ0LWluZm8uY29tcG9uZW50LnRzP3Z1ZSZ0eXBlPXNjcmlwdCZsYW5nPXRzJlwiIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQUEiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./src/main/webapp/app/core/cert-list/cert-info.component.ts?vue&type=script&lang=ts&\n");

/***/ }),

/***/ "./src/main/webapp/app/core/cert-list/cert-info.vue":
/*!**********************************************************!*\
  !*** ./src/main/webapp/app/core/cert-list/cert-info.vue ***!
  \**********************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _cert_info_vue_vue_type_template_id_0ba0f292_scoped_true___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./cert-info.vue?vue&type=template&id=0ba0f292&scoped=true& */ \"./src/main/webapp/app/core/cert-list/cert-info.vue?vue&type=template&id=0ba0f292&scoped=true&\");\n/* harmony import */ var _cert_info_component_ts_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./cert-info.component.ts?vue&type=script&lang=ts& */ \"./src/main/webapp/app/core/cert-list/cert-info.component.ts?vue&type=script&lang=ts&\");\n/* empty/unused harmony star reexport *//* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../../../node_modules/vue-loader/lib/runtime/componentNormalizer.js */ \"./node_modules/vue-loader/lib/runtime/componentNormalizer.js\");\n\n\n\n\n\n/* normalize component */\n\nvar component = Object(_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"])(\n  _cert_info_component_ts_vue_type_script_lang_ts___WEBPACK_IMPORTED_MODULE_1__[\"default\"],\n  _cert_info_vue_vue_type_template_id_0ba0f292_scoped_true___WEBPACK_IMPORTED_MODULE_0__[\"render\"],\n  _cert_info_vue_vue_type_template_id_0ba0f292_scoped_true___WEBPACK_IMPORTED_MODULE_0__[\"staticRenderFns\"],\n  false,\n  null,\n  \"0ba0f292\",\n  null\n  \n)\n\n/* hot reload */\nif (true) {\n  var api = __webpack_require__(/*! ./node_modules/vue-hot-reload-api/dist/index.js */ \"./node_modules/vue-hot-reload-api/dist/index.js\")\n  api.install(__webpack_require__(/*! vue */ \"./node_modules/vue/dist/vue.esm.js\"))\n  if (api.compatible) {\n    module.hot.accept()\n    if (!module.hot.data) {\n      api.createRecord('0ba0f292', component.options)\n    } else {\n      api.reload('0ba0f292', component.options)\n    }\n    module.hot.accept(/*! ./cert-info.vue?vue&type=template&id=0ba0f292&scoped=true& */ \"./src/main/webapp/app/core/cert-list/cert-info.vue?vue&type=template&id=0ba0f292&scoped=true&\", function(__WEBPACK_OUTDATED_DEPENDENCIES__) { /* harmony import */ _cert_info_vue_vue_type_template_id_0ba0f292_scoped_true___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./cert-info.vue?vue&type=template&id=0ba0f292&scoped=true& */ \"./src/main/webapp/app/core/cert-list/cert-info.vue?vue&type=template&id=0ba0f292&scoped=true&\");\n(function () {\n      api.rerender('0ba0f292', {\n        render: _cert_info_vue_vue_type_template_id_0ba0f292_scoped_true___WEBPACK_IMPORTED_MODULE_0__[\"render\"],\n        staticRenderFns: _cert_info_vue_vue_type_template_id_0ba0f292_scoped_true___WEBPACK_IMPORTED_MODULE_0__[\"staticRenderFns\"]\n      })\n    })(__WEBPACK_OUTDATED_DEPENDENCIES__); })\n  }\n}\ncomponent.options.__file = \"src/main/webapp/app/core/cert-list/cert-info.vue\"\n/* harmony default export */ __webpack_exports__[\"default\"] = (component.exports);//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./src/main/webapp/app/core/cert-list/cert-info.vue\n");

/***/ }),

/***/ "./src/main/webapp/app/core/cert-list/cert-info.vue?vue&type=template&id=0ba0f292&scoped=true&":
/*!*****************************************************************************************************!*\
  !*** ./src/main/webapp/app/core/cert-list/cert-info.vue?vue&type=template&id=0ba0f292&scoped=true& ***!
  \*****************************************************************************************************/
/*! exports provided: render, staticRenderFns */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _node_modules_vue_loader_lib_loaders_templateLoader_js_vue_loader_options_node_modules_vue_loader_lib_index_js_vue_loader_options_cert_info_vue_vue_type_template_id_0ba0f292_scoped_true___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../../node_modules/vue-loader/lib/loaders/templateLoader.js??vue-loader-options!../../../../../../node_modules/vue-loader/lib??vue-loader-options!./cert-info.vue?vue&type=template&id=0ba0f292&scoped=true& */ \"./node_modules/vue-loader/lib/loaders/templateLoader.js?!./node_modules/vue-loader/lib/index.js?!./src/main/webapp/app/core/cert-list/cert-info.vue?vue&type=template&id=0ba0f292&scoped=true&\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"render\", function() { return _node_modules_vue_loader_lib_loaders_templateLoader_js_vue_loader_options_node_modules_vue_loader_lib_index_js_vue_loader_options_cert_info_vue_vue_type_template_id_0ba0f292_scoped_true___WEBPACK_IMPORTED_MODULE_0__[\"render\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"staticRenderFns\", function() { return _node_modules_vue_loader_lib_loaders_templateLoader_js_vue_loader_options_node_modules_vue_loader_lib_index_js_vue_loader_options_cert_info_vue_vue_type_template_id_0ba0f292_scoped_true___WEBPACK_IMPORTED_MODULE_0__[\"staticRenderFns\"]; });\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9zcmMvbWFpbi93ZWJhcHAvYXBwL2NvcmUvY2VydC1saXN0L2NlcnQtaW5mby52dWU/dnVlJnR5cGU9dGVtcGxhdGUmaWQ9MGJhMGYyOTImc2NvcGVkPXRydWUmLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vc3JjL21haW4vd2ViYXBwL2FwcC9jb3JlL2NlcnQtbGlzdC9jZXJ0LWluZm8udnVlPzgzZTMiXSwic291cmNlc0NvbnRlbnQiOlsiZXhwb3J0ICogZnJvbSBcIi0hLi4vLi4vLi4vLi4vLi4vLi4vbm9kZV9tb2R1bGVzL3Z1ZS1sb2FkZXIvbGliL2xvYWRlcnMvdGVtcGxhdGVMb2FkZXIuanM/P3Z1ZS1sb2FkZXItb3B0aW9ucyEuLi8uLi8uLi8uLi8uLi8uLi9ub2RlX21vZHVsZXMvdnVlLWxvYWRlci9saWIvaW5kZXguanM/P3Z1ZS1sb2FkZXItb3B0aW9ucyEuL2NlcnQtaW5mby52dWU/dnVlJnR5cGU9dGVtcGxhdGUmaWQ9MGJhMGYyOTImc2NvcGVkPXRydWUmXCIiXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTsiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./src/main/webapp/app/core/cert-list/cert-info.vue?vue&type=template&id=0ba0f292&scoped=true&\n");

/***/ }),

/***/ "./src/main/webapp/app/shared/data/data-utils.service.ts":
/*!***************************************************************!*\
  !*** ./src/main/webapp/app/shared/data/data-utils.service.ts ***!
  \***************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ \"./node_modules/tslib/tslib.es6.js\");\n/* harmony import */ var vue_property_decorator__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! vue-property-decorator */ \"./node_modules/vue-property-decorator/lib/vue-property-decorator.js\");\n\n/*\nCopyright 2013-2017 the original author or authors from the JHipster project.\nThis file is part of the JHipster project, see https://jhipster.github.io/\nfor more information.\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\nhttp://www.apache.org/licenses/LICENSE-2.0\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n*/\n\n/**\n * An utility service for data.\n */\nvar JhiDataUtils = /** @class */ (function (_super) {\n    tslib__WEBPACK_IMPORTED_MODULE_0__[\"__extends\"](JhiDataUtils, _super);\n    function JhiDataUtils() {\n        return _super !== null && _super.apply(this, arguments) || this;\n    }\n    /**\n     * Method to abbreviate the text given\n     */\n    JhiDataUtils.prototype.abbreviate = function (text, append) {\n        if (append === void 0) { append = '...'; }\n        if (text.length < 30) {\n            return text;\n        }\n        return text ? text.substring(0, 15) + append + text.slice(-10) : '';\n    };\n    /**\n     * Method to find the byte size of the string provides\n     */\n    JhiDataUtils.prototype.byteSize = function (base64String) {\n        return this.formatAsBytes(this.size(base64String));\n    };\n    /**\n     * Method to open file\n     */\n    JhiDataUtils.prototype.openFile = function (contentType, data) {\n        if (window.navigator && window.navigator.msSaveOrOpenBlob) {\n            // To support IE and Edge\n            var byteCharacters = atob(data);\n            var byteNumbers = new Array(byteCharacters.length);\n            for (var i = 0; i < byteCharacters.length; i++) {\n                byteNumbers[i] = byteCharacters.charCodeAt(i);\n            }\n            var byteArray = new Uint8Array(byteNumbers);\n            var blob = new Blob([byteArray], {\n                type: contentType\n            });\n            window.navigator.msSaveOrOpenBlob(blob);\n        }\n        else {\n            // Other browsers\n            var fileURL = \"data:\" + contentType + \";base64,\" + data;\n            var win = window.open();\n            win.document.write('<iframe src=\"' +\n                fileURL +\n                '\" frameborder=\"0\" style=\"border:0; top:0px; left:0px; bottom:0px; right:0px; width:100%; height:100%;\" allowfullscreen></iframe>');\n        }\n    };\n    /**\n     * Method to convert the file to base64\n     */\n    JhiDataUtils.prototype.toBase64 = function (file, cb) {\n        var fileReader = new FileReader();\n        fileReader.readAsDataURL(file);\n        fileReader.onload = function (e) {\n            var base64Data = e.target.result.substr(e.target.result.indexOf('base64,') + 'base64,'.length);\n            cb(base64Data);\n        };\n    };\n    /**\n     * Method to clear the input\n     */\n    JhiDataUtils.prototype.clearInputImage = function (entity, elementRef, field, fieldContentType, idInput) {\n        if (entity && field && fieldContentType) {\n            if (entity.hasOwnProperty(field)) {\n                entity[field] = null;\n            }\n            if (entity.hasOwnProperty(fieldContentType)) {\n                entity[fieldContentType] = null;\n            }\n            if (elementRef && idInput && elementRef.nativeElement.querySelector('#' + idInput)) {\n                elementRef.nativeElement.querySelector('#' + idInput).value = null;\n            }\n        }\n    };\n    JhiDataUtils.prototype.endsWith = function (suffix, str) {\n        return str.indexOf(suffix, str.length - suffix.length) !== -1;\n    };\n    JhiDataUtils.prototype.paddingSize = function (value) {\n        if (this.endsWith('==', value)) {\n            return 2;\n        }\n        if (this.endsWith('=', value)) {\n            return 1;\n        }\n        return 0;\n    };\n    JhiDataUtils.prototype.size = function (value) {\n        return (value.length / 4) * 3 - this.paddingSize(value);\n    };\n    JhiDataUtils.prototype.formatAsBytes = function (size) {\n        return size.toString().replace(/\\B(?=(\\d{3})+(?!\\d))/g, ' ') + ' bytes';\n    };\n    JhiDataUtils.prototype.setFileData = function (event, entity, field, isImage) {\n        if (event && event.target.files && event.target.files[0]) {\n            var file_1 = event.target.files[0];\n            if (isImage && !/^image\\//.test(file_1.type)) {\n                return;\n            }\n            this.toBase64(file_1, function (base64Data) {\n                entity[field] = base64Data;\n                entity[field + \"ContentType\"] = file_1.type;\n            });\n        }\n    };\n    /**\n     * Method to download file\n     */\n    JhiDataUtils.prototype.downloadFile = function (contentType, data, fileName) {\n        var byteCharacters = atob(data);\n        var byteNumbers = new Array(byteCharacters.length);\n        for (var i = 0; i < byteCharacters.length; i++) {\n            byteNumbers[i] = byteCharacters.charCodeAt(i);\n        }\n        var byteArray = new Uint8Array(byteNumbers);\n        var blob = new Blob([byteArray], {\n            type: contentType\n        });\n        var tempLink = document.createElement('a');\n        tempLink.href = window.URL.createObjectURL(blob);\n        tempLink.download = fileName;\n        tempLink.target = '_blank';\n        tempLink.click();\n    };\n    JhiDataUtils = tslib__WEBPACK_IMPORTED_MODULE_0__[\"__decorate\"]([\n        vue_property_decorator__WEBPACK_IMPORTED_MODULE_1__[\"Component\"]\n    ], JhiDataUtils);\n    return JhiDataUtils;\n}(vue_property_decorator__WEBPACK_IMPORTED_MODULE_1__[\"Vue\"]));\n/* harmony default export */ __webpack_exports__[\"default\"] = (JhiDataUtils);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./src/main/webapp/app/shared/data/data-utils.service.ts\n");

/***/ })

}]);