/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.config;

import de.trustable.ca3s.core.service.dto.CryptoConfigView;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CryptoConfiguration {
    private final String[] validPBEAlgoArr;

    public CryptoConfiguration(@Value(value="${ca3s.pkcs12.pbe.algos:PBEWithHmacSHA256AndAES_256}") String[] validPBEAlgoArr) {
        this.validPBEAlgoArr = validPBEAlgoArr;
    }

    public CryptoConfigView getCryptoConfigView() {
        return new CryptoConfigView(this.validPBEAlgoArr, this.getDefaultPBEAlgo());
    }

    public String getDefaultPBEAlgo() {
        String passwordProtectionAlgo = "PBEWithHmacSHA256AndAES_256";
        if (this.validPBEAlgoArr.length > 0) {
            passwordProtectionAlgo = this.validPBEAlgoArr[0];
        }
        return passwordProtectionAlgo;
    }

    public boolean isPBEAlgoAllowed(String reqAlgo) {
        return ArrayUtils.contains((Object[])this.validPBEAlgoArr, (Object)reqAlgo.trim());
    }
}

