/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.security.provider;

import de.trustable.ca3s.cert.bundle.BundleFactory;
import de.trustable.ca3s.cert.bundle.KeyCertBundle;
import de.trustable.util.CryptoUtil;
import de.trustable.util.PKILevel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ca3sFallbackBundleFactory
implements BundleFactory {
    private static final Logger LOG = LoggerFactory.getLogger(Ca3sFallbackBundleFactory.class);
    private KeyPair rootKeyPair = null;
    private X509Certificate issuingCertificate = null;
    private final String dnSuffix;
    private X500Name x500Issuer;
    private CryptoUtil cryptoUtil = new CryptoUtil();

    public Ca3sFallbackBundleFactory(String dnSuffix) {
        this.dnSuffix = dnSuffix;
        try {
            this.x500Issuer = new X500Name("CN=RootOn" + InetAddress.getLocalHost().getCanonicalHostName() + ", OU=temporary bootstrap root " + System.currentTimeMillis() + ", O=trustable solutions, C=DE");
        }
        catch (UnknownHostException uhe) {
            LOG.debug("problem retrieving hostname", (Throwable)uhe);
            this.x500Issuer = new X500Name("CN=CA3SHost, OU=temporary bootstrap root " + System.currentTimeMillis() + ", O=trustable solutions, C=DE");
        }
    }

    private synchronized KeyPair getRootKeyPair() throws GeneralSecurityException {
        if (this.rootKeyPair == null) {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
            kpg.initialize(2048);
            this.rootKeyPair = kpg.generateKeyPair();
            LOG.debug("created new root keypair : {}", (Object)this.rootKeyPair.toString());
        }
        return this.rootKeyPair;
    }

    private synchronized X509Certificate getRootCertificate() throws GeneralSecurityException, IOException {
        if (this.issuingCertificate == null) {
            KeyPair kp = this.getRootKeyPair();
            this.issuingCertificate = this.cryptoUtil.issueCertificate(this.x500Issuer, kp, this.x500Issuer, kp.getPublic().getEncoded(), 2, 1, PKILevel.ROOT);
            LOG.debug("created temp. root certificate with subject : {}", (Object)this.issuingCertificate.getSubjectX500Principal().getName());
            File rootCertFile = File.createTempFile("ca3sTempRoot", ".cer");
            try (FileOutputStream fos = new FileOutputStream(rootCertFile);){
                fos.write(this.issuingCertificate.getEncoded());
            }
            LOG.debug("written temp. root certificate to file : '{}'", (Object)rootCertFile.getAbsolutePath());
        }
        return this.issuingCertificate;
    }

    public KeyCertBundle newKeyBundle(String bundleName, long minValiditySeconds) throws GeneralSecurityException {
        KeyPair localKeyPair = KeyPairGenerator.getInstance("RSA").generateKeyPair();
        try {
            InetAddress ip = InetAddress.getLocalHost();
            String hostname = ip.getHostName();
            LOG.debug("requesting certificate for host : " + hostname);
            String x500Name = "CN=" + hostname;
            if (!this.dnSuffix.trim().isEmpty()) {
                x500Name = x500Name + ", " + this.dnSuffix;
            }
            X500Name subject = new X500Name(x500Name);
            GeneralName[] sanArray = new GeneralName[]{new GeneralName(2, hostname)};
            GeneralNames gns = new GeneralNames(sanArray);
            ArrayList extensions = new ArrayList();
            HashMap<String, Object> serverAuthMap = new HashMap<String, Object>();
            serverAuthMap.put("oid", Extension.extendedKeyUsage.getId());
            serverAuthMap.put("critical", Boolean.FALSE);
            ArrayList<String> valList = new ArrayList<String>();
            valList.add(KeyPurposeId.id_kp_serverAuth.getId());
            serverAuthMap.put("value", valList);
            extensions.add(serverAuthMap);
            LOG.debug("building certificate for SAN '{}' and EKU {}", (Object)hostname, (Object)Extension.extendedKeyUsage.getId());
            X509Certificate issuedCertificate = this.cryptoUtil.issueCertificate(this.x500Issuer, this.getRootKeyPair(), subject, SubjectPublicKeyInfo.getInstance((Object)localKeyPair.getPublic().getEncoded()), 10, 1, gns, extensions, PKILevel.END_ENTITY);
            X509Certificate[] certificateChain = new X509Certificate[]{issuedCertificate, this.getRootCertificate()};
            LOG.debug("returning temp. certificate : " + issuedCertificate);
            return new KeyCertBundle(bundleName, certificateChain, issuedCertificate, (Key)localKeyPair.getPrivate());
        }
        catch (IOException e) {
            throw new GeneralSecurityException(e);
        }
    }
}

