/*
 * Decompiled with CFR 0.152.
 */
package de.trustable.ca3s.core.security.provider;

import de.trustable.ca3s.cert.bundle.KeyStoreImpl;
import de.trustable.ca3s.cert.bundle.TimedRenewalCertMap;
import de.trustable.ca3s.core.security.provider.Ca3sKeyStoreProvider;
import java.security.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ca3sKeyStoreProvider
extends Provider {
    public static final String SERVICE_NAME = "ca3s";
    private static final String STORE_TYPE_KEYSTORE = "Keystore";
    private static final long serialVersionUID = -2476288508778039686L;
    private static final Logger LOG = LoggerFactory.getLogger(Ca3sKeyStoreProvider.class);
    private static KeyStoreImpl keystoreImpl;

    public Ca3sKeyStoreProvider(TimedRenewalCertMap certMap, String alias) {
        super("Ca3sKeyStoreProvider", 1.0, "Certificate provider implemented by ca3s");
        keystoreImpl = new KeyStoreImpl(certMap, alias);
        keystoreImpl.engineGetCertificate(alias);
        this.putService((Provider.Service)new ProviderService((Provider)this, STORE_TYPE_KEYSTORE, SERVICE_NAME, KeyStoreImpl.class.getName()));
        LOG.debug("registered KeyStoreImpl in Ca3sKeyStoreProvider");
        for (String prop : super.stringPropertyNames()) {
            LOG.debug("provider attribute {} : '{}'", (Object)prop, (Object)this.getProperty(prop));
        }
    }

    public static KeyStoreImpl getKeystoreImpl() {
        return keystoreImpl;
    }

    static /* synthetic */ Logger access$000() {
        return LOG;
    }

    static /* synthetic */ KeyStoreImpl access$100() {
        return keystoreImpl;
    }
}

